/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.fias.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.AddressObj;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.FiasCity;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.FiasStreet;
import ru.bitel.bgbilling.plugins.fias.server.bean.BaseLoadManager;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class AddressLoadManager
extends BaseLoadManager {
    public AddressLoadManager(Connection con) {
        super(con);
    }

    public void updateCity(FiasCity city) throws BGException {
        this.updateFiasAddressTable(FIAS_CITY_MAP, (AddressObj)city);
        for (AddressObj parent : city.getParents()) {
            this.updateFiasAddressTable(FIAS_CITY_MAP, parent);
        }
    }

    public void updateStreet(FiasStreet street) throws BGException {
        this.updateFiasAddressTable(FIAS_STREET_MAP, (AddressObj)street);
        try {
            Statement st = this.con.createStatement();
            st.executeUpdate("DELETE FROM " + FIAS_STREET_TEMP + "  WHERE aoguid='" + street.getAoguid() + "'");
            st.close();
        }
        catch (SQLException e) {
            this.exceptionLog(e);
        }
    }

    public String addAllTempStreet(FiasCity city) throws BGException, SQLException {
        this.getLogger().info("addAllTempStreet...");
        long start = System.currentTimeMillis();
        try {
            PreparedStatement psStreetInsert = this.con.prepareStatement("INSERT INTO address_street SET title = ? , cityid= ?", 1);
            psStreetInsert.setInt(2, city.getId());
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT tmp.*, s.id from fias_street_temp AS tmp  LEFT JOIN fias_street_map AS t ON tmp.aoguid=t.aoguid JOIN fias_city_map as s ON s.aoguid = tmp.parentguid   WHERE t.id IS NULL AND tmp.parentguid='" + city.getAoguid() + "'");
            int count = 0;
            while (rs.next()) {
                FiasStreet street = this.loadAddressObjFromRs(new FiasStreet(), rs);
                psStreetInsert.setString(1, street.getFiasTitle());
                psStreetInsert.executeUpdate();
                street.setId(ServerUtils.lastInsertId((PreparedStatement)psStreetInsert));
                this.updateStreet(street);
                ++count;
            }
            rs.close();
            st.close();
            psStreetInsert.close();
            long delta = System.currentTimeMillis() - start;
            this.getLogger().info("addAllTempStreet..." + count + "=>" + delta + " ms");
        }
        catch (SQLException e) {
            this.exceptionLog(e);
        }
        return "dfgfdgdfg";
    }

    private void updateFiasAddressTable(String tableName, AddressObj addrObj) throws BGException {
        try {
            String query = "INSERT INTO " + tableName + " SET id=?, code=?, aoguid=?,level=?, shortname=?,offname=?, postalcode=?,region=?,parentguid=?  ON DUPLICATE KEY UPDATE id=?,code=?,aoguid=?,level=?,shortname=?,offname=?, postalcode=?, region=?,parentguid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            int index = 1;
            ps.setInt(index++, addrObj.getId());
            ps.setString(index++, addrObj.getCode());
            ps.setString(index++, addrObj.getAoguid());
            ps.setString(index++, addrObj.getLevel());
            ps.setString(index++, addrObj.getShortname());
            ps.setString(index++, addrObj.getOffname());
            ps.setString(index++, addrObj.getPostalcode());
            ps.setString(index++, addrObj.getRegion());
            ps.setString(index++, addrObj.getParentguid());
            ps.setInt(index++, addrObj.getId());
            ps.setString(index++, addrObj.getCode());
            ps.setString(index++, addrObj.getAoguid());
            ps.setString(index++, addrObj.getLevel());
            ps.setString(index++, addrObj.getShortname());
            ps.setString(index++, addrObj.getOffname());
            ps.setString(index++, addrObj.getPostalcode());
            ps.setString(index++, addrObj.getRegion());
            ps.setString(index++, addrObj.getParentguid());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            this.exceptionLog(e);
        }
    }

    public void createTempStreetTable(List<FiasStreet> streets) throws BGException {
        try {
            this.getLogger().info("createTempStreetTable...");
            long start = System.currentTimeMillis();
            Statement st = this.con.createStatement();
            st.executeUpdate("DROP TABLE IF EXISTS " + FIAS_STREET_TEMP);
            st.executeUpdate("CREATE TABLE " + FIAS_STREET_TEMP + " ( `id` INT(11) NOT NULL ,`code` VARCHAR(100) NOT NULL,`aoguid` VARCHAR(100) NOT NULL,`parentguid` VARCHAR(100) NOT NULL,`level` VARCHAR(100) NOT NULL,`shortname` VARCHAR(100) NOT NULL,`offname` VARCHAR(100) NOT NULL,`postalcode` VARCHAR(100) NOT NULL,`region` VARCHAR(2) NOT NULL, INDEX aoguid (aoguid), INDEX parentguid (parentguid), INDEX offname (offname))");
            String query = "INSERT INTO " + FIAS_STREET_TEMP + " SET id=?,code=?,aoguid=?,level=?,shortname=?,offname=?, postalcode=?,region=?,parentguid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            int count = 0;
            for (FiasStreet street : streets) {
                int index = 1;
                ps.setInt(index++, street.getId());
                ps.setString(index++, street.getCode());
                ps.setString(index++, street.getAoguid());
                ps.setString(index++, street.getLevel());
                ps.setString(index++, street.getShortname());
                ps.setString(index++, street.getOffname());
                ps.setString(index++, street.getPostalcode());
                ps.setString(index++, street.getRegion());
                ps.setString(index++, street.getParentguid());
                ps.executeUpdate();
                ++count;
            }
            ps.close();
            st.close();
            long delta = System.currentTimeMillis() - start;
            this.getLogger().info("createTempStreetTable..." + count + "=>" + delta + " ms");
        }
        catch (SQLException e) {
            this.exceptionLog(e);
        }
    }

    public FiasStreet getNextEmptyBillingStreet(int cityId) throws SQLException {
        FiasStreet result = null;
        Statement st = this.con.createStatement();
        ResultSet rs = this.executeQuery(st, "SELECT t1.id,t1.title,t2.code FROM " + ADDRESS_STREET + " AS t1 LEFT JOIN " + FIAS_STREET_MAP + " AS t2 ON t1.id=t2.id WHERE t2.code IS NULL AND t1.cityid = " + cityId + " ORDER BY t1.title LIMIT 1");
        if (rs.next()) {
            result = new FiasStreet();
            result.setId(rs.getInt(1));
            result.setBgTitle(rs.getString(2));
        }
        rs.close();
        st.close();
        return result;
    }

    public List<FiasStreet> findStreetInFias(FiasStreet street) throws SQLException {
        ArrayList<FiasStreet> result = new ArrayList<FiasStreet>();
        PreparedStatement st = this.con.prepareStatement("SELECT id,code,aoguid,level,shortname,offname,postalcode,region,parentguid FROM " + FIAS_STREET_TEMP + " WHERE offname LIKE ? ORDER BY offname");
        st.setString(1, "%" + street.getBgTitle() + "%");
        ResultSet rs = this.executeQuery(st);
        while (rs.next()) {
            result.add(this.loadAddressObjFromRs(new FiasStreet(), rs));
        }
        rs.close();
        st.close();
        if (result.size() > 0) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        for (String word : street.getBgTitle().split(" ")) {
            if ((word = word.trim()).length() <= 0) continue;
            sb.append(" OR offname LIKE ?");
        }
        PreparedStatement st2 = this.con.prepareStatement("SELECT id,code,aoguid,level,shortname,offname,postalcode,region,parentguid  FROM " + FIAS_STREET_TEMP + " WHERE offname LIKE '0000000' " + sb.toString() + " ORDER BY offname");
        int index = 1;
        for (String word : street.getBgTitle().split(" ")) {
            if ((word = word.trim()).length() <= 0) continue;
            st2.setString(index++, "%" + this.wordToCononicalFormat(word) + "%");
        }
        rs = this.executeQuery(st2);
        while (rs.next()) {
            result.add(this.loadAddressObjFromRs(new FiasStreet(), rs));
        }
        rs.close();
        st.close();
        return result;
    }

    public boolean loadInProcess() throws BGException {
        try {
            ResultSet rs = this.con.createStatement().executeQuery("show tables  like '" + FIAS_STREET_TEMP + "'");
            if (!rs.next()) {
                return false;
            }
            rs.close();
            rs = this.con.createStatement().executeQuery("SELECT count(*) FROM " + FIAS_STREET_TEMP);
            if (rs.next()) {
                return rs.getInt(1) > 0;
            }
            return false;
        }
        catch (SQLException e) {
            this.exceptionLog(e);
            return false;
        }
    }

    public List<FiasCity> getCityFromBG() throws BGException {
        ArrayList<FiasCity> cityList = new ArrayList<FiasCity>();
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT id, title FROM " + ADDRESS_CITY + " ORDER BY title");
            while (rs.next()) {
                FiasCity city = new FiasCity();
                city.setId(rs.getInt(1));
                city.setBgTitle(rs.getString(2));
                cityList.add(city);
            }
            rs.close();
            st.close();
        }
        catch (SQLException e) {
            this.exceptionLog(e);
        }
        return cityList;
    }

    private String wordToCononicalFormat(String word) {
        if (word.length() <= 0) {
            return word;
        }
        StringBuilder res = new StringBuilder();
        res.append(word.toLowerCase());
        res.replace(0, 1, res.substring(0, 1).toUpperCase());
        return res.toString();
    }

    public List<FiasCity> getCityList() throws BGException {
        ArrayList<FiasCity> cityList = new ArrayList<FiasCity>();
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT t_addr.id,t.code,t.aoguid,t.level,t.shortname,t.offname,t.postalcode,t.region,t.parentguid, t_addr.title FROM " + ADDRESS_CITY + " AS t_addr  LEFT JOIN " + FIAS_CITY_MAP + " AS t ON t.id = t_addr.id");
            while (rs.next()) {
                FiasCity city = this.loadCityFromRs(rs);
                city.setBgTitle(rs.getString("t_addr.title"));
                cityList.add(city);
            }
            rs.close();
            st.close();
        }
        catch (SQLException e) {
            this.exceptionLog(e);
        }
        return cityList;
    }

    public List<FiasStreet> getStreetList(FiasCity city) throws BGException {
        ArrayList<FiasStreet> cityList = new ArrayList<FiasStreet>();
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT t_addr.id,t.code,t.aoguid,t.level,t.shortname,t.offname,t.postalcode,t.region,t.parentguid, t_addr.title FROM " + ADDRESS_STREET + " AS t_addr  LEFT JOIN " + FIAS_STREET_MAP + " AS t ON t.id = t_addr.id WHERE t_addr.cityId = '" + city.getId() + "'");
            while (rs.next()) {
                FiasStreet street = this.loadAddressObjFromRs(new FiasStreet(), rs);
                street.setBgTitle(rs.getString("t_addr.title"));
                cityList.add(street);
            }
            rs.close();
            st.close();
        }
        catch (SQLException e) {
            this.exceptionLog(e);
        }
        return cityList;
    }

    public void updateCityBgTitle(int cityId, String name) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + ADDRESS_CITY + " SET title=? WHERE id=?");
            int index = 1;
            ps.setString(index++, name);
            ps.setInt(index++, cityId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            this.exceptionLog(e);
        }
    }

    public void updateStreetBgTitle(List<FiasStreet> streets) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + ADDRESS_STREET + " SET title=? WHERE id=?");
            int index = 1;
            for (FiasStreet street : streets) {
                ps.setString(index++, street.getFiasName());
                ps.setInt(index++, street.getId());
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (SQLException e) {
            this.exceptionLog(e);
        }
    }
}

