/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bvcom.server.bean;

import java.text.DecimalFormat;
import ru.bitel.bgbilling.server.util.ModuleSetup;

public class BVParams {
    private String key;
    private String client;
    private DecimalFormat transactionFormat;
    private int paymentTypeId;
    private String comment;
    private String resultUrl;
    private int protocolVersion;
    private int endPointId;
    private String merchantControl;
    private String callbackUrl;
    private String currency;
    private int chargeTypeId;
    private String serverUrl;
    private static int OLD_PROTOCOL_CURRENCY = 643;

    public BVParams(ModuleSetup moduleSetup) {
        this.protocolVersion = moduleSetup.getInt("bvcom.protocol.version", 1);
        this.transactionFormat = new DecimalFormat(moduleSetup.get("bvcom.trans.format", "BG00000000"));
        this.paymentTypeId = moduleSetup.getInt("bvcom.payment.type", -1);
        this.comment = moduleSetup.get("bvcom.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443");
        this.client = moduleSetup.get("bvcom.client", "");
        this.resultUrl = moduleSetup.get("bvcom.url.result", "");
        this.key = moduleSetup.get("bvcom.key", "");
        this.endPointId = moduleSetup.getInt("bvcom.endpointid", -1);
        this.merchantControl = moduleSetup.get("bvcom.merchant.control", "");
        this.callbackUrl = moduleSetup.get("bvcom.callback.url", "");
        this.currency = moduleSetup.get("bvcom.currency", "RUR");
        this.chargeTypeId = moduleSetup.getInt("bvcom.charge.type", -1);
        this.serverUrl = moduleSetup.get("bvcom.server.url", "https://sandbox.ariuspay.ru/paynet/api/v2/");
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public DecimalFormat getTransactionFormat() {
        return this.transactionFormat;
    }

    public void setTransactionFormat(DecimalFormat format) {
        this.transactionFormat = format;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setPaymentTypeId(int paymentTypeId) {
        this.paymentTypeId = paymentTypeId;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getKey() {
        return this.key;
    }

    public int getPaymentTypeId() {
        return this.paymentTypeId;
    }

    public String getComment() {
        return this.comment;
    }

    public static int getOldProtocolCurrency() {
        return OLD_PROTOCOL_CURRENCY;
    }

    public String getResultUrl() {
        return this.resultUrl;
    }

    public void setResultUrl(String urlResult) {
        this.resultUrl = urlResult;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(int version) {
        this.protocolVersion = version;
    }

    public int getEndPointId() {
        return this.endPointId;
    }

    public void setEndPointId(int endPointId) {
        this.endPointId = endPointId;
    }

    public String getMerchantControl() {
        return this.merchantControl;
    }

    public void setMerchantControl(String merchantControl) {
        this.merchantControl = merchantControl;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public int getChargeTypeId() {
        return this.chargeTypeId;
    }

    public void setChargeTypeId(int chargeTypeId) {
        this.chargeTypeId = chargeTypeId;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }
}

