/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.access;

import bitel.billing.server.radius.Antispam;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.AccessDeviceManager;
import ru.bitel.bgbilling.apps.inet.access.DeletedConnectionsRemover;
import ru.bitel.bgbilling.apps.inet.access.InetAuthErrorWorker;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionManager;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.access.OldConnectionsRemover;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.ExtendedLifecycle;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServOption;
import ru.bitel.bgbilling.modules.inet.common.event.access.InetAllTariffMaxTraffAndRangeUpdate;
import ru.bitel.bgbilling.modules.inet.common.event.access.InetAuthorizationRequestEvent;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServOptionDao;
import ru.bitel.bgbilling.modules.inet.server.event.InetReloadLocalEvent;
import ru.bitel.bgbilling.modules.inet.server.runtime.AuthResult;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.jmx.MBeanOperation;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.WorkerThreadFactory;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpResourceDynSubscriptionDao;

public class Access
extends InetApplication
implements EventListener<Event>,
ExtendedLifecycle {
    private static final Logger logger = LogManager.getLogger();
    public Set<Integer> accountingDeviceTypes;
    public Set<Integer> accountingRootDeviceIds;
    public String accountingRootDeviceIdsQuery;
    private Map<Integer, Integer> accountingRootDeviceIdMap;
    public final ContractRuntimeMap contractRuntimeMap;
    public final InetServRuntimeMap inetServRuntimeMap;
    public volatile InetConnectionManager connectionManager;
    public volatile boolean authErrorUpdate = true;
    public volatile InetAuthErrorWorker authErrorWorker;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new WorkerThreadFactory("access", null, null));
    private AccessDeviceManager accessDeviceManager;

    @ConstructorProperties(value={"setup"})
    public Access(Setup setup) throws Exception {
        super(true, setup, SetupParam.getApplicationId((ParameterMap)setup), SetupParam.getModuleId((ParameterMap)setup), true);
        EventProcessor.getInstance().addListener((EventListener)this, InetReloadLocalEvent.class, this.moduleId, null);
        Connection con = setup.getDBConnectionFromPool();
        try {
            this.contractRuntimeMap = new ContractRuntimeMap(this.initialDate);
            this.inetServRuntimeMap = new InetServRuntimeMap(this, this.contractRuntimeMap, con, new Date(), null);
            EventProcessor.getInstance().addListener((EventListener)this, InetAllTariffMaxTraffAndRangeUpdate.class, this.moduleId, null);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public AccessDeviceManager getAccessDeviceManager() {
        return this.accessDeviceManager;
    }

    @Override
    public synchronized void init() throws Exception {
        super.init();
        ServerContext ctx = (ServerContext)ThreadContext.get();
        IpResourceDynSubscriptionDao.checkTables((Connection)ctx.getConnection(), (int)this.moduleId);
        this.load(this.setup, ctx.getConnection(), false);
        ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(this.moduleId));
        long saLoadWait = moduleSetup != null ? this.setup.getLong("sa.load.wait", moduleSetup.getLong("sa.load.wait", 180L)) * 1000L : this.setup.getLong("sa.load.wait", 180L) * 1000L;
        ExecutorService executorService = Executors.newCachedThreadPool();
        Callable<AccessDeviceManager> accessDeviceManager = new Callable<AccessDeviceManager>(){

            @Override
            public AccessDeviceManager call() {
                try {
                    AccessDeviceManager accessDeviceManager;
                    Access.this.accessDeviceManager = accessDeviceManager = new AccessDeviceManager(Access.this);
                    return accessDeviceManager;
                }
                catch (BGException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            }
        };
        Future<AccessDeviceManager> accessDeviceManagerFuture = null;
        if (saLoadWait < 0L) {
            accessDeviceManagerFuture = executorService.submit(accessDeviceManager);
        }
        this.inetServRuntimeMap.load();
        this.loadConnections(ctx.getConnection());
        InetDeviceRuntime rootDevice = this.deviceMap != null ? this.deviceMap.get(this.rootDeviceId) : null;
        ModuleSetup rootConf = rootDevice != null ? rootDevice.config : moduleSetup;
        Antispam.initAntispam((ParameterMap)rootConf);
        if (accessDeviceManagerFuture == null) {
            accessDeviceManagerFuture = executorService.submit(accessDeviceManager);
        }
        final Future<AccessDeviceManager> accessDeviceManagerFutureInstance = accessDeviceManagerFuture;
        accessDeviceManagerFuture = executorService.submit(new Callable<AccessDeviceManager>(){

            @Override
            public AccessDeviceManager call() throws Exception {
                while (true) {
                    try {
                        AccessDeviceManager accessDeviceManager = (AccessDeviceManager)((Object)accessDeviceManagerFutureInstance.get());
                        if (accessDeviceManager == null) {
                            logger.error("AccessDeviceManager is null!");
                        }
                        accessDeviceManager.start();
                        logger.info("Call AccessDeviceManager.start() OK.");
                        return accessDeviceManager;
                    }
                    catch (InterruptedException ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                        continue;
                    }
                    break;
                }
            }
        });
        if (saLoadWait > 0L) {
            try {
                accessDeviceManagerFuture.get(saLoadWait, TimeUnit.MILLISECONDS);
            }
            catch (Exception ex) {
                logger.error("Possible AccessDeviceManager start error!!! Find in log \"SA and DM listeners started.\"");
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        executorService.shutdown();
        Random r = new Random();
        this.scheduledExecutorService.scheduleWithFixedDelay(new OldConnectionsRemover(this), r.nextInt(10) + 8, 31L, TimeUnit.MINUTES);
        if (rootConf.getInt("access.connectionManager.check", 0) > 0) {
            int interval = rootConf.getInt("access.connectionManager.check.interval", 88);
            this.scheduledExecutorService.scheduleWithFixedDelay(new DeletedConnectionsRemover(this), 18L, interval, TimeUnit.MINUTES);
        }
        if (InetUtils.checkAccountingRootDeviceId(this.setup, this.moduleId)) {
            EventProcessor.getInstance().addListener((EventListener)this, InetAuthorizationRequestEvent.class, this.moduleId, "accountingRootDeviceId=" + this.rootDeviceId);
        }
    }

    public void destroy() throws Exception {
    }

    public int getAccountingRootDeviceId(int deviceId) {
        Integer accountingRootDeviceId = this.accountingRootDeviceIdMap.get(deviceId);
        if (accountingRootDeviceId != null) {
            return accountingRootDeviceId;
        }
        return this.rootDeviceId;
    }

    @Override
    public ContractRuntimeMap getContractRuntimeMap() {
        return this.contractRuntimeMap;
    }

    @Override
    public InetServRuntimeMap getInetServRuntimeMap() {
        return this.inetServRuntimeMap;
    }

    public synchronized void load(Setup setup, Connection con, boolean loadConnections) throws BGException {
        ModuleSetup moduleSetup = setup.getModuleSetup(Integer.valueOf(this.moduleId));
        this.accountingDeviceTypes = moduleSetup != null ? Utils.toIntegerSet((String)setup.get("accounting.deviceTypeIds", moduleSetup.get("accounting.deviceTypeIds", ""))) : Utils.toIntegerSet((String)setup.get("accounting.deviceTypeIds", ""));
        HashSet<Integer> childrenDeviceIds = new HashSet<Integer>();
        HashSet<Integer> accountingRootDeviceIds = new HashSet<Integer>();
        for (InetDeviceRuntime inetDeviceRuntime : this.deviceMap.values()) {
            childrenDeviceIds.add(inetDeviceRuntime.inetDevice.getId());
            if (!this.accountingDeviceTypes.contains(inetDeviceRuntime.inetDevice.getDeviceTypeId())) continue;
            accountingRootDeviceIds.add(inetDeviceRuntime.inetDevice.getId());
        }
        this.childrenDeviceIds = childrenDeviceIds;
        logger.info("childrenDeviceIds=" + String.valueOf(childrenDeviceIds));
        this.accountingRootDeviceIds = accountingRootDeviceIds;
        if (this.accountingRootDeviceIds.size() > 0) {
            StringBuilder sb = new StringBuilder(20).append('(');
            for (Integer id : this.accountingRootDeviceIds) {
                sb.append("rootDeviceId=").append(id).append(" OR ");
            }
            sb.setLength(sb.length() - 4);
            sb.append(')');
            this.accountingRootDeviceIdsQuery = sb.toString();
        } else {
            this.accountingRootDeviceIdsQuery = null;
        }
        HashMap<Integer, Integer> accountingRootDeviceIdMap = new HashMap<Integer, Integer>();
        for (Integer deviceId : this.childrenDeviceIds) {
            Object deviceRuntime = this.deviceMap.get(deviceId);
            if (deviceRuntime == null || (deviceRuntime = ((InetDeviceRuntime)deviceRuntime).getParent(this.accountingRootDeviceIds)) == null) continue;
            accountingRootDeviceIdMap.put(deviceId, ((InetDeviceRuntime)deviceRuntime).inetDeviceId);
        }
        this.accountingRootDeviceIdMap = accountingRootDeviceIdMap;
        if (loadConnections) {
            this.loadConnections(con);
        }
        InetDeviceRuntime inetDeviceRuntime = this.deviceMap.get(this.rootDeviceId);
        this.ipResourceManager.initPools(inetDeviceRuntime.config);
        HashSet<String> singlesignonRealmSet = new HashSet<String>();
        for (Map.Entry entry : inetDeviceRuntime.config.subKeyed("radius.realm.").entrySet()) {
            if (((ParameterMap)entry.getValue()).getInt("singlesignon", 0) <= 0) continue;
            singlesignonRealmSet.add(InetUtils.internRealm((String)entry.getKey()));
        }
        this.singlesignonRealmSet = singlesignonRealmSet.size() > 0 ? singlesignonRealmSet : null;
        this.authErrorUpdate = inetDeviceRuntime.config.getInt("authError.update", 1) > 0;
        boolean authErrorAsync = inetDeviceRuntime.config.getInt("authError.async", 1) > 0;
        InetAuthErrorWorker inetAuthErrorWorker = this.authErrorWorker;
        if (authErrorAsync) {
            int authErrorAsyncCapacity = inetDeviceRuntime.config.getInt("authError.async.maxQueueSize", 5000);
            long authErrorAsyncTimeout = inetDeviceRuntime.config.getInt("authError.async.timeout", 50);
            this.authErrorWorker = new InetAuthErrorWorker(this.setup, this.moduleId, authErrorAsyncCapacity, authErrorAsyncTimeout, this.authErrorUpdate);
        } else {
            this.authErrorWorker = null;
        }
        if (inetAuthErrorWorker != null) {
            inetAuthErrorWorker.shutdown();
        }
        this.disableServIds = Access.loadDisableServIds(this.deviceMap);
    }

    private synchronized void loadConnections(Connection con) throws BGException {
        ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(this.moduleId));
        if (moduleSetup == null) {
            moduleSetup = this.setup;
        }
        this.loadConnections(con, moduleSetup.getInt("access.inetReload.reloadConnections", 0));
    }

    private synchronized void loadConnections(Connection con, int mode) throws BGException {
        ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(this.moduleId));
        if (moduleSetup == null) {
            moduleSetup = this.setup;
        }
        switch (mode) {
            case 1: {
                InetConnectionManager connectionManager;
                InetConnectionManager oldConnectionManager = this.connectionManager;
                if (oldConnectionManager != null) {
                    oldConnectionManager.removeListeners();
                }
                this.connectionManager = connectionManager = new InetConnectionManager(this, con);
                if (oldConnectionManager == null) break;
                oldConnectionManager.destroy();
                break;
            }
            case 2: {
                InetConnectionManager oldConnectionManager = this.connectionManager;
                this.connectionManager = new InetConnectionManager(this, con);
                if (oldConnectionManager == null) break;
                oldConnectionManager.removeListeners();
                oldConnectionManager.destroy();
                break;
            }
            default: {
                if (this.connectionManager != null) break;
                this.connectionManager = new InetConnectionManager(this, con);
            }
        }
    }

    public static byte[] reserveAddress(InetServRuntime serv, List<InetConnection> existSessions) {
        byte[] result = null;
        HashSet<IpAddress> usedAddress = new HashSet<IpAddress>();
        for (InetConnection session : existSessions) {
            usedAddress.add(new IpAddress(session.getInetAddressBytes()));
        }
        byte[] addressFrom = serv.getInetServ().getAddressFrom();
        byte[] addressTo = serv.getInetServ().getAddressTo();
        if (addressFrom != null) {
            IpAddress address = new IpAddress(addressFrom);
            if (addressTo != null) {
                while (IpAddress.compare((byte[])address.address, (byte[])addressTo) <= 0) {
                    if (!usedAddress.contains(address)) {
                        result = address.address;
                        break;
                    }
                    IpAddress.increment((byte[])address.address);
                }
            } else if (!usedAddress.contains(address)) {
                result = address.address;
            }
        }
        return result;
    }

    public void notify(Event e, EventListenerContext ctx) throws BGException {
        if (e instanceof InetAllTariffMaxTraffAndRangeUpdate) {
            this.tariffContext.maxTrafficManager.updateCache(ctx.getConnectionSet(), true);
            this.tariffContext.rangedTrafficManager.updateCache(ctx.getConnectionSet(), true);
        } else if (e instanceof InetReloadLocalEvent) {
            try {
                this.load(this.setup, ctx.getConnection(), true);
                ctx.commit();
                InetDeviceRuntime rootDevice = this.deviceMap != null ? this.deviceMap.get(this.rootDeviceId) : null;
                ParameterMap conf = rootDevice != null ? rootDevice.config : this.setup.getModuleSetup(Integer.valueOf(this.moduleId));
                Antispam.initAntispam((ParameterMap)conf);
                ctx.commit();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        } else if (e instanceof InetAuthorizationRequestEvent) {
            this.authorizationRequest((InetAuthorizationRequestEvent)e, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authorizationRequest(InetAuthorizationRequestEvent e, EventListenerContext ctx) throws BGException {
        logger.info("authorizationRequest contractId: " + e.getContractId() + ", servId: " + e.getServId() + ", apActivate: " + e.isAccountingPeriodActivate());
        e.setAccessCode(-1);
        int inetServId = e.getServId();
        InetServRuntime inetServRuntime = this.inetServRuntimeMap.get(inetServId);
        if (inetServRuntime == null) {
            InetServ inetServ;
            try (InetServDao servDao = new InetServDao(ctx.getConnection(), this.moduleId);){
                inetServ = (InetServ)servDao.get(inetServId);
            }
            if (inetServ == null) {
                logger.error("InetServ not found");
                return;
            }
            if (!TimeUtils.dateInRange((Date)new Date(), (Date)inetServ.getDateFrom(), (Date)inetServ.getDateTo())) {
                logger.error("InetServ period closed");
                return;
            }
            try (InetServOptionDao inetServOptionDao = new InetServOptionDao(ctx.getConnection(), this.moduleId);){
                List<InetServOption> inetOptionList = inetServOptionDao.list(inetServ.getId());
                inetServRuntime = this.inetServRuntimeMap.addRuntime(ctx.getConnectionSet(), inetServ, inetOptionList);
            }
        }
        if (inetServRuntime.getInetServ().getParentId() > 0) {
            logger.error("InetServ is child " + inetServId);
            return;
        }
        inetServRuntime.lock();
        try {
            AuthResult authResult = this.authorization(inetServRuntime, inetServRuntime, true, inetServRuntime.getInetServ().getDeviceId(), inetServRuntime.getInetServ().getDeviceId(), null, null, 0, null, 0, 0, false, null, null, false, BigDecimal.ZERO, e.isAccountingPeriodActivate());
            e.setAccessCode(authResult.accessCode);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            inetServRuntime.unlock();
        }
    }

    @Override
    protected BigDecimal getSessionCostDelta(InetServRuntime servRuntime) throws BGException {
        return BigDecimal.ZERO;
    }

    public Boolean checkSessionCount(ConnectionSet connectionSet, InetServRuntime parentInetServRuntime, InetServRuntime inetServRuntime, int connectionType, int checkDuplicateSessionOnSessionLimit, boolean checkDuplicateUsername, String username, String realm, String callingStationId, boolean wantToAdd) throws BGException {
        String sessionIdentifier;
        List[] connectionListRef;
        Set singlesignonRealmSet;
        boolean result;
        int limit = parentInetServRuntime != inetServRuntime ? InetUtils.getSessionCountLimit(inetServRuntime.inetServTypeRef.get().inetServType, inetServRuntime.getInetServ()) : 0;
        if (limit <= 0) {
            limit = InetUtils.getSessionCountLimit(parentInetServRuntime.inetServTypeRef.get().inetServType, parentInetServRuntime.getInetServ());
            inetServRuntime = parentInetServRuntime;
        }
        if (!(result = this.checkSessionCount(connectionSet, inetServRuntime, connectionType, limit, singlesignonRealmSet = this.singlesignonRealmSet, realm, connectionListRef = new List[1], wantToAdd)) && this.connectionManager.checkChanged(connectionSet, connectionListRef[0])) {
            logger.info("Found sessions changed in DB. Check count again.");
            result = this.checkSessionCount(connectionSet, inetServRuntime, connectionType, limit, singlesignonRealmSet, realm, connectionListRef, wantToAdd);
        }
        List connectionList = connectionListRef[0];
        String string = sessionIdentifier = checkDuplicateUsername ? username : callingStationId;
        if (checkDuplicateSessionOnSessionLimit <= 0) {
            return result ? null : Boolean.FALSE;
        }
        if (Utils.isEmptyString((String)sessionIdentifier) && (checkDuplicateSessionOnSessionLimit = checkDuplicateSessionOnSessionLimit / 10 % 10 * 10) <= 0) {
            return result ? null : Boolean.FALSE;
        }
        if (!result) {
            logger.info("Session count error. Check for duplicate session " + sessionIdentifier);
            return this.connectionManager.checkDuplicateSession(parentInetServRuntime.contractRuntime.contractId, connectionList, sessionIdentifier, checkDuplicateUsername, checkDuplicateSessionOnSessionLimit);
        }
        assert (result);
        if ((checkDuplicateSessionOnSessionLimit = checkDuplicateSessionOnSessionLimit / 100 % 10) > 0) {
            logger.info("Check for duplicate session " + sessionIdentifier);
            return this.connectionManager.checkDuplicateSession(parentInetServRuntime.contractRuntime.contractId, connectionList, sessionIdentifier, checkDuplicateUsername, checkDuplicateSessionOnSessionLimit) ? Boolean.TRUE : null;
        }
        return result ? null : Boolean.FALSE;
    }

    private boolean checkSessionCount(ConnectionSet connectionSet, InetServRuntime inetServRuntime, int connectionType, int limit, Set<String> singlesignonRealmSet, String realm, List<InetConnectionRuntime>[] connectionListRef, boolean wantToAdd) {
        List<InetServRuntime> children;
        boolean singlesignonRealm = singlesignonRealmSet != null && singlesignonRealmSet.contains(realm);
        ArrayList<InetConnectionRuntime> allConnectionList = new ArrayList<InetConnectionRuntime>();
        boolean singlesignonRealmConnectionExist = wantToAdd;
        ArrayList<InetConnectionRuntime> singlesignonConnectionList = singlesignonRealm ? new ArrayList<InetConnectionRuntime>(4) : null;
        List<InetConnectionRuntime> connectionList = this.connectionManager.getByServId(inetServRuntime.inetServId);
        if (connectionList != null) {
            for (InetConnectionRuntime connectionRuntime : connectionList) {
                if (!InetUtils.checkAliveAndType(connectionRuntime.connection, true, connectionType)) continue;
                if (singlesignonRealm && realm.equals(InetUtils.getRealm(connectionRuntime.connection.getUsername()))) {
                    if (singlesignonRealmConnectionExist) {
                        logger.info("Session count >1 for this realm.");
                        connectionListRef[0] = singlesignonConnectionList;
                        return false;
                    }
                    singlesignonConnectionList.add(connectionRuntime);
                    singlesignonRealmConnectionExist = true;
                }
                allConnectionList.add(connectionRuntime);
            }
        }
        if ((children = this.inetServRuntimeMap.listChildren(inetServRuntime.inetServId)) != null && children.size() > 0) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                List<InetConnectionRuntime> childConnectionList;
                InetServRuntime child = children.get(i);
                if (child.inetServTypeRef.get().inetServType.getSessionCountLimit() > 0 || (childConnectionList = this.connectionManager.getByServId(child.inetServId)) == null || childConnectionList.size() == 0) continue;
                for (InetConnectionRuntime connectionRuntime : childConnectionList) {
                    if (!InetUtils.checkAliveAndType(connectionRuntime.connection, true, connectionType)) continue;
                    if (singlesignonRealm && realm.equals(InetUtils.getRealm(connectionRuntime.connection.getUsername()))) {
                        if (singlesignonRealmConnectionExist) {
                            logger.info("Session count >1 for this realm.");
                            connectionListRef[0] = singlesignonConnectionList;
                            return false;
                        }
                        singlesignonConnectionList.add(connectionRuntime);
                        singlesignonRealmConnectionExist = true;
                    }
                    allConnectionList.add(connectionRuntime);
                }
            }
        }
        connectionListRef[0] = allConnectionList;
        if (limit <= 0) {
            return true;
        }
        if (wantToAdd) {
            int count = allConnectionList.size();
            if (count + 1 > limit) {
                logger.info("Session count (" + count + "+1)>" + limit + ".");
                return false;
            }
        } else {
            int count = allConnectionList.size();
            if (count > limit) {
                logger.info("Session count " + count + ">" + limit + ".");
                return false;
            }
        }
        return true;
    }

    @MBeanOperation(description="reload connections from DB")
    public void reloadConnections() throws SQLException, BGException {
        try (Connection con = this.setup.getDBConnectionFromPool();){
            this.loadConnections(con, 2);
        }
    }
}

