/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client;

import bitel.billing.module.common.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDeviceType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetInterface;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class InetInterfacePanel
extends BGUPanel {
    private InetInterfaceTableModel model = new InetInterfaceTableModel();
    private JCheckBox uniqueInterfaces;
    private final AtomicReference<InetDeviceType> currentTypeRef;
    BGUTable table;
    private PanelAction panelAction = new PanelAction();

    public InetInterfacePanel(AtomicReference<InetDeviceType> currentRef) {
        super((LayoutManager)new BorderLayout());
        this.currentTypeRef = currentRef;
    }

    protected void jbInit() {
        this.uniqueInterfaces = new JCheckBox("\u0418\u043d\u0434\u0438\u0432\u0438\u0434\u0443\u0430\u043b\u044c\u043d\u044b\u0435 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u044b");
        this.table = new BGUTable((TableModel)((Object)this.model));
        this.panelAction.initActions();
        BGDialogToolBar dialogToolBar = new BGDialogToolBar();
        BGSwingUtilites.buildToolBar((BGDialogToolBar)dialogToolBar, (JComponent)((Object)this.panelAction));
        dialogToolBar.compact();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)dialogToolBar, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapEmptyBorder((JComponent)this.uniqueInterfaces), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0));
        this.add(panel, "North");
        this.add(BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)this.table)), "Center");
        this.table.setEnabled(false);
        BGSwingUtilites.handleEdit((JTable)this.table, (AbstractBGUPanel)this.panelAction);
        this.table.setEnabled(false);
        this.uniqueInterfaces.addActionListener(e -> this.setIfacesEnabled(!this.uniqueInterfaces.isSelected()));
    }

    private void setIfacesEnabled(boolean enabled) {
        this.table.setEnabled(enabled);
        this.setActionEnabled("new", enabled);
        this.setActionEnabled("edit", enabled);
        this.setActionEnabled("delete", enabled);
        this.setActionEnabled("new.auto", enabled);
    }

    private void setActionEnabled(String name, boolean enabled) {
        Action action = this.panelAction.getActionMap().get(name);
        if (action != null) {
            action.setEnabled(enabled);
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.uniqueInterfaces.setSelected(false);
            this.setIfacesEnabled(true);
            this.model.setData(new ArrayList(this.currentTypeRef.get().getInterfaceList()));
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            this.uniqueInterfaces.setSelected(this.currentTypeRef.get().isUniqueInterfaces());
            this.setIfacesEnabled(!this.currentTypeRef.get().isUniqueInterfaces());
            this.model.setData(new ArrayList(this.currentTypeRef.get().getInterfaceList()));
        });
        new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetInterfacePanel.this.currentTypeRef.get().setUniqueInterfaces(InetInterfacePanel.this.uniqueInterfaces.isSelected());
                InetInterfacePanel.this.currentTypeRef.get().setInterfaceList(InetInterfacePanel.this.model.getRows());
            }
        };
    }

    class InetInterfaceTableModel
    extends BGTableModel<InetInterface> {
        public InetInterfaceTableModel() {
            super(InetInterfaceTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class PanelAction
    extends BGUPanel {
        PanelAction() {
        }

        protected void jbInit() throws Exception {
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new InetInterfaceDialog("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441", new InetInterface(), true).open());
            new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> InetInterfacePanel.this.model.optSelectedRow().ifPresentOrElse(inetInterface -> new InetInterfaceDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441", (InetInterface)inetInterface, false).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441")));
            new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
                if (InetInterfacePanel.this.model.getSelectedRow() != null) {
                    InetInterfacePanel.this.model.deleteSelectedRows();
                }
            });
            new AbstractBGUPanel.DefaultAction("new.auto", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438", ClientUtils.getIcon((String)"fugue/block--plus.png")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    MultipleInterfaceData multipleInterfaceData = new MultipleInterfaceData(InetInterfacePanel.this);
                    multipleInterfaceData.interfaceCount = 1;
                    multipleInterfaceData.interfaceStartNumber = 1;
                    multipleInterfaceData.titlePattern = "\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 {id}";
                    new AddMultipleInterfaceDialog("\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u043e\u0432", multipleInterfaceData).open();
                }
            };
        }
    }

    class MultipleInterfaceData {
        public int interfaceCount = 1;
        public int interfaceStartNumber = 1;
        public String titlePattern = "";

        MultipleInterfaceData(InetInterfacePanel this$0) {
        }
    }

    class AddMultipleInterfaceDialog
    extends BGEditorDialog<MultipleInterfaceData> {
        private BGTextField titlePattern;
        private IntTextField interfaceCount;
        private IntTextField interfaceStartNumber;
        private BGUComboBox<KeyValue> typeOperation;
        private List<KeyValue> typeOperationItems;

        public AddMultipleInterfaceDialog(String title, MultipleInterfaceData data) {
            super(title, (Object)data);
            this.titlePattern = new BGTextField(40);
            this.interfaceCount = new IntTextField();
            this.interfaceStartNumber = new IntTextField();
            this.typeOperation = new BGUComboBox();
            this.typeOperationItems = Arrays.asList(new KeyValue("add", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"), new KeyValue("replace", "\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c"));
        }

        public void doDialogPanel() {
            JLabel intialNumberInterface = new JLabel("\u041d\u0430\u0447\u0430\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430:");
            this.typeOperation.setData(this.typeOperationItems);
            this.typeOperation.addActionListener(e -> {
                KeyValue item = (KeyValue)this.typeOperation.getSelectedItem();
                boolean add = item.getKey().equals("add");
                intialNumberInterface.setEnabled(add);
                this.interfaceStartNumber.setEnabled(add);
            });
            this.interfaceCount.setMinValue(-1L);
            this.interfaceStartNumber.setMinValue(0L);
            this.titlePattern.setPreferredSize(new Dimension(100, (int)this.titlePattern.getPreferredSize().getHeight()));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u043e\u0432:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
            this.panel.add((Component)this.interfaceCount, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 3, 0), 0, 0));
            this.panel.add((Component)this.typeOperation, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)intialNumberInterface, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 3, 0), 0, 0));
            this.panel.add((Component)this.interfaceStartNumber, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
            this.panel.add((Component)new JLabel("\u0428\u0430\u0431\u043b\u043e\u043d \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 3, 0), 0, 0));
            this.panel.add((Component)this.titlePattern, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.interfaceCount.setText(String.valueOf(((MultipleInterfaceData)this.data).interfaceCount));
            this.interfaceStartNumber.setText(String.valueOf(((MultipleInterfaceData)this.data).interfaceStartNumber));
            this.titlePattern.setText(((MultipleInterfaceData)this.data).titlePattern);
        }

        public boolean doApply() throws Exception {
            if (this.interfaceCount.getValue() <= 0L) {
                BGSwingUtilites.error((String)"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f");
                return false;
            }
            if (Utils.isEmptyString((String)this.titlePattern.getText())) {
                BGSwingUtilites.error((String)"\u0428\u0430\u0431\u043b\u043e\u043d \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0435 \u043f\u0443\u0441\u0442\u044b\u043c");
                return false;
            }
            String text = this.titlePattern.getText();
            KeyValue item = (KeyValue)this.typeOperation.getSelectedItem();
            int startNumber = 1;
            int idMax = 0;
            if (item.getKey().equals("add")) {
                startNumber = (int)this.interfaceStartNumber.getValue();
                if (InetInterfacePanel.this.model.getRowCount() > 0) {
                    idMax = (Integer)InetInterfacePanel.this.model.getValueAt(InetInterfacePanel.this.model.getRowCount() - 1, 0) - startNumber + 1;
                }
            } else {
                InetInterfacePanel.this.model.setData(new ArrayList());
            }
            int i = startNumber;
            while ((long)i < (long)startNumber + this.interfaceCount.getValue()) {
                String title = text.replaceAll("\\{id\\}", String.valueOf(i));
                InetInterface current = new InetInterface();
                current.setId(idMax + i);
                current.setTitle(title);
                InetInterfacePanel.this.model.addRow(current);
                ++i;
            }
            return true;
        }
    }

    class InetInterfaceDialog
    extends BGEditorDialog<InetInterface> {
        private boolean isNew;
        private IntTextField interfaceIndex;
        private BGTextField title;

        public InetInterfaceDialog(String title, InetInterface data, boolean isNew) {
            super(title, (Object)data);
            this.interfaceIndex = new IntTextField();
            this.title = new BGTextField(30);
            this.isNew = isNew;
        }

        public void doDialogPanel() {
            this.interfaceIndex.setMinValue(-1L);
            this.interfaceIndex.setValue((long)((InetInterface)this.data).getId());
            this.title.setText(((InetInterface)this.data).getTitle());
            this.panel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.interfaceIndex, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        }

        public boolean doApply() throws Exception {
            ((InetInterface)this.data).setId((int)this.interfaceIndex.getValue());
            ((InetInterface)this.data).setTitle(this.title.getText());
            if (!InetInterfacePanel.this.model.getRows().contains(this.data)) {
                InetInterfacePanel.this.model.addRow((InetInterface)this.data);
            } else if (this.isNew) {
                BGSwingUtilites.error((String)"\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 c \u0442\u0430\u043a\u0438\u043c \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
            }
            return true;
        }
    }
}

