/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cloudpayments.client;

import ru.bitel.bgbilling.client.common.AbstractTransactionTableModel;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.modules.cloudpayments.common.bean.Transaction;
import ru.bitel.bgbilling.modules.cloudpayments.common.bean.TransactionStatus;
import ru.bitel.common.Utils;

public abstract class TransactionTableModel
extends AbstractTransactionTableModel<Transaction> {
    static final String COLUMN_PAN = "pan";
    static final String COLUMN_ERROR = "error";
    static final String COLUMN_ORDER_ID = "orderId";
    static final String COLUMN_TRANSACTION_ID = "TransactionId";
    static final String COLUMN_CARDHOLDER_NAME = "cardholderName";
    static final String COLUMN_CODE_DESCRIPTION = "codeDescription";
    static final String COLUMN_TITLE_PAN = "\u041a\u0430\u0440\u0442\u0430";
    static final String COLUMN_TITLE_ERROR = "\u0421\u0442\u0430\u0442\u0443\u0441 \u0437\u0430\u043f\u0440\u043e\u0441\u0430";
    static final String COLUMN_TITLE_ORDER_ID = "OrderId";
    static final String COLUMN_TITLE_TRANSACTION_ID = "TransactionId";
    static final String COLUMN_TITLE_CARDHOLDER_NAME = "\u0418\u043c\u044f \u0434\u0435\u0440\u0436\u0430\u0442\u0435\u043b\u044f \u043a\u0430\u0440\u0442\u044b";
    static final String COLUMN_TITLE_CODE_DESCRIPTION = "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0448\u0438\u0431\u043a\u0438";

    public TransactionTableModel(String name) {
        super(name, Transaction.class);
    }

    protected Object getStatusValue(Transaction value, int column) throws BGException {
        AbstractTransactionStatus result = TransactionStatus.ALL.getStatusByCode(value.getStatus());
        return result == null ? value.getStatus() : result.getTitle();
    }

    public Object getValue(Transaction value, int column) throws Exception {
        String identifier = this.getIdentifier(column);
        if (COLUMN_PAN.equals(identifier)) {
            String paramValue = this.getParameter(value.getParameters(), "cardAuthInfo.pan");
            if (Utils.isBlankString((String)paramValue)) {
                paramValue = this.getParameter(value.getParameters(), "Pan");
            }
            return paramValue;
        }
        if (COLUMN_ORDER_ID.equals(identifier)) {
            return this.getParameter(value.getParameters(), COLUMN_ORDER_ID);
        }
        if (COLUMN_CARDHOLDER_NAME.equals(identifier)) {
            String paramValue = this.getParameter(value.getParameters(), "cardAuthInfo.cardholderName");
            if (Utils.isBlankString((String)paramValue)) {
                paramValue = this.getParameter(value.getParameters(), COLUMN_CARDHOLDER_NAME);
            }
            return paramValue;
        }
        if (COLUMN_ERROR.equals(identifier)) {
            String errorCode = this.getParameter(value.getParameters(), "errorCode");
            String errorMessage = this.getParameter(value.getParameters(), "errorMessage");
            return (errorMessage == null ? "" : errorMessage) + (String)(errorCode == null || "0".equals(errorCode) ? "" : " [" + errorCode + "]");
        }
        if (COLUMN_CODE_DESCRIPTION.equals(identifier)) {
            String actionCodeDescription = this.getParameter(value.getParameters(), "actionCodeDescription");
            return actionCodeDescription == null || actionCodeDescription.length() == 0 ? "" : actionCodeDescription;
        }
        if ("TransactionId".equals(identifier)) {
            return this.getParameter(value.getParameters(), "Model.TransactionId");
        }
        return super.getValue((Object)value, column);
    }
}

