/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tinkoff.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.modules.tinkoff.common.bean.Transaction;
import ru.bitel.bgbilling.modules.tinkoff.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="TinkoffExecutor", urlPatterns={"/tinkoff/*"})
public class ModuleExecutor
extends CommonExecutor {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Transaction transaction;
        TransactionManager transactionManager;
        JSONObject requestJsonObject;
        Connection con;
        block12: {
            String transactionId;
            String orderId;
            block11: {
                block10: {
                    String data;
                    ModuleSetup moduleSetup;
                    int moduleId;
                    block9: {
                        con = null;
                        moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
                        Setup setup = Setup.getSetup();
                        con = setup.getDBConnectionFromPool();
                        moduleSetup = setup.getModuleSetup(Integer.valueOf(moduleId));
                        byte[] bytes = Utils.readByBlock((InputStream)request.getInputStream());
                        data = new String(bytes, "UTF-8");
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("In data = " + data);
                        }
                        if (!Utils.isBlankString((String)data)) break block9;
                        this.getLogger().error("Request data is empty!!!");
                        this.send(response);
                        ServerUtils.closeConnection((Connection)con);
                        return;
                    }
                    requestJsonObject = new JSONObject(data);
                    String inToken = requestJsonObject.optString("Token");
                    transactionManager = new TransactionManager(con, moduleId);
                    String password = moduleSetup.get("tinkoff.terminal.pswd", "");
                    String calcToken = transactionManager.getToken(requestJsonObject, password);
                    if (inToken != null && inToken.equalsIgnoreCase(calcToken)) break block10;
                    this.getLogger().error("inToken = " + inToken);
                    this.getLogger().error("calcToken  = " + calcToken);
                    this.send(response);
                    ServerUtils.closeConnection((Connection)con);
                    return;
                }
                orderId = requestJsonObject.optString("OrderId");
                transactionId = requestJsonObject.optString("PaymentId");
                transaction = (Transaction)transactionManager.get(Utils.parseInt((String)orderId));
                if (transaction != null) break block11;
                this.getLogger().error("Not found transaction for ID = " + orderId);
                this.send(response);
                ServerUtils.closeConnection((Connection)con);
                return;
            }
            if (transaction.getTransactionId() != null && transaction.getTransactionId().equals(transactionId)) break block12;
            this.getLogger().error("Transaction for ID = " + orderId + "( " + transaction.getTransactionId() + " != " + transactionId + " )");
            this.send(response);
            ServerUtils.closeConnection((Connection)con);
            return;
        }
        try {
            transactionManager.check(transaction, requestJsonObject);
            this.send(response);
        }
        catch (Exception ex) {
            try {
                this.logError(ex);
                response.sendError(500, ex.getMessage());
            }
            catch (Throwable throwable) {
                ServerUtils.closeConnection(con);
                throw throwable;
            }
            ServerUtils.closeConnection((Connection)con);
        }
        ServerUtils.closeConnection((Connection)con);
    }

    private void send(HttpServletResponse response) {
        response.setStatus(200);
        response.setContentType("text/plain");
        try (PrintWriter printWriter = response.getWriter();){
            printWriter.write("OK");
            printWriter.flush();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }
}

