/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;

public class SynchronizedListMap<K, V> {
    private final int initialListCapacity;
    private final ConcurrentHashMap<K, Holder<V>> map;

    public SynchronizedListMap(int initialCapacity, int initialListCapacity) {
        this.initialListCapacity = initialListCapacity;
        this.map = new ConcurrentHashMap(initialCapacity);
    }

    public List<V> get(K key) {
        Holder<V> holder = this.map.get(key);
        return holder != null ? holder.unmodifiable : null;
    }

    public List<V> remove(K key) {
        Holder<V> holder = this.map.remove(key);
        return holder != null ? holder.unmodifiable : null;
    }

    public void clear() {
        this.map.clear();
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return new AbstractSet<Map.Entry<K, List<V>>>(){
            final Set<Map.Entry<K, Holder<V>>> set;
            {
                this.set = SynchronizedListMap.this.map.entrySet();
            }

            @Override
            public Iterator<Map.Entry<K, List<V>>> iterator() {
                final Iterator iterator = this.set.iterator();
                return new Iterator<Map.Entry<K, List<V>>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, List<V>> next() {
                        final Map.Entry entry = (Map.Entry)iterator.next();
                        return new Map.Entry<K, List<V>>(){

                            @Override
                            public K getKey() {
                                return entry.getKey();
                            }

                            @Override
                            public List<V> getValue() {
                                return ((Holder)entry.getValue()).unmodifiable;
                            }

                            @Override
                            public List<V> setValue(List<V> value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return this.set.size();
            }
        };
    }

    public int size() {
        return this.map.size();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean add(K key, V value, BiFunction<Holder<V>, V, Boolean> func) {
        while (true) {
            Holder holder;
            Holder holder2 = holder = this.map.computeIfAbsent(key, k -> new Holder(new ArrayList(this.initialListCapacity)));
            synchronized (holder2) {
                if (!holder.removed) {
                    return func.apply(holder, value);
                }
            }
        }
    }

    public void add(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.add(key, value, (h, v) -> h.value.add(v));
    }

    public boolean addIfAbsent(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        return this.add(key, value, (h, v) -> {
            if (h.value.contains(value)) {
                return false;
            }
            h.value.add(value);
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Holder<V> holder = this.map.get(key);
        if (holder == null) {
            return false;
        }
        Holder<V> holder2 = holder;
        synchronized (holder2) {
            if (holder.value.remove(value)) {
                if (holder.value.size() == 0) {
                    holder.removed = true;
                    this.map.remove(key, holder);
                }
                return true;
            }
            return false;
        }
    }

    static final class Holder<V> {
        final List<V> unmodifiable;
        final List<V> value;
        volatile boolean removed = false;

        public Holder(List<V> value, boolean u) {
            this.value = value;
            this.unmodifiable = value;
        }

        public Holder(List<V> value) {
            this.value = value;
            this.unmodifiable = Collections.unmodifiableList(value);
        }
    }
}

