/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractDao;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseComponentPrice;

public class LicensePriceDao
extends AbstractDao<LicenseComponentPrice> {
    public LicensePriceDao(Connection con, int moduleId) {
        super(con, moduleId, "lic_price");
    }

    public List<LicenseComponentPrice> list(int productId) throws SQLException {
        return this.listImpl(null, "product_id=?", null, new Object[]{productId});
    }

    public LicenseComponentPrice getPrice(int productId, int componentId) throws SQLException {
        return (LicenseComponentPrice)this.get("product_id=? AND component_id=?", new Object[]{productId, componentId});
    }

    protected LicenseComponentPrice getFromRS(ResultSet rs) throws SQLException {
        return new LicenseComponentPrice().setProductId(rs.getInt("product_id")).setComponentId(rs.getInt("component_id")).setPrice(rs.getString("price"));
    }

    protected void updateImpl(LicenseComponentPrice componentPrice) throws SQLException {
        Objects.requireNonNull(componentPrice);
        String query = "INSERT INTO " + this.tableName + " SET product_id=?, component_id=?, price=? ON DUPLICATE KEY UPDATE price=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, componentPrice.getProductId());
            ps.setInt(index++, componentPrice.getComponentId());
            ps.setString(index++, componentPrice.getPrice());
            ps.setString(index++, componentPrice.getPrice());
            ps.executeUpdate();
        }
    }
}

