/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.yoomoney.server;

import bitel.billing.server.BGPaymentModule;
import bitel.billing.server.ModuleBase;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.PaymentMethod;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.yoomoney.server.event.worker.YoomoneyAutopaymentEventWorker;
import ru.bitel.bgbilling.modules.yoomoney.server.event.worker.YoomoneyCheckEventWorker;
import ru.bitel.bgbilling.modules.yoomoney.server.service.YoomoneyServiceImpl;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.jmx.MBeanPaymentModule;

@BGPaymentModule
public class Module
extends ModuleBase
implements MBeanPaymentModule {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.yoomoney.server"};
    final String[] loggerName = new String[]{Module.class.getName(), TransactionManager.class.getName(), YoomoneyServiceImpl.class.getName()};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void start(Connection con, BGModule module) throws BGException {
        this.registerMBean(module);
        new YoomoneyCheckEventWorker(Setup.getSetup(), module.getId());
        new YoomoneyAutopaymentEventWorker(Setup.getSetup(), module.getId());
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        if (event instanceof ContractDeleteEvent) {
            ContractDeleteEvent contractDeleteEvent = (ContractDeleteEvent)event;
            if (!contractDeleteEvent.isCheck()) {
                String cidStr = String.valueOf(event.getContractId());
                ServerUtils.deleteRowsFromTable((Connection)serverContext.getConnection(), (String)("yoomoney_transactions_" + moduleId), (String)"cid", (String)cidStr, null);
            }
        } else if (event instanceof PaymentEvent) {
            PaymentEvent paymentEvent = (PaymentEvent)event;
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
            int chargeTypeId = moduleSetup.getInt("yoomoney.commission.charge.type.id", 0);
            if (moduleSetup.getBoolean("yoomoney.commission.charge.enable", false) && chargeTypeId > 0) {
                Payment payment = paymentEvent.getPayment();
                int paymentId = payment.getId();
                try (Connection con = serverContext.getConnection();
                     BalanceUtils balanceUtils = new BalanceUtils(con);){
                    ChargeDao chargeDao = new ChargeDao(con);
                    Transaction transaction = new TransactionManager(con, moduleId).getTransactionByPaymentId(paymentId);
                    if (transaction != null) {
                        JSONObject json = new JSONObject(transaction.getRawRequest());
                        Object amountValue = json.optQuery("/amount/value");
                        Object incomeAmountValue = json.optQuery("/income_amount/value");
                        if (amountValue != null && incomeAmountValue != null) {
                            BigDecimal sum = new BigDecimal(String.valueOf(amountValue)).subtract(new BigDecimal(String.valueOf(incomeAmountValue)));
                            Charge charge = Charge.builder().setContractId(payment.getContractId()).setDate(new Date()).setTypeId(chargeTypeId).setSum(sum).setComment("\u041a\u043e\u043c\u043c\u0438c\u0441\u0438\u044f \u0437\u0430 \u043f\u043b\u0430\u0442\u0435\u0436 (#" + payment.getId() + ")").setUserId(0).build();
                            chargeDao.update((Object)charge);
                            balanceUtils.updateBalance(charge.getDate(), charge.getContractId());
                        }
                    }
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
        }
    }

    public void serializeContract(Connection con, int cid, int mid, XMLStreamWriter tables, boolean onlyCurrent) throws SQLException, XMLStreamException {
    }

    public List<PaymentMethod> getPaymentMethods(int moduleId) {
        ArrayList<PaymentMethod> methods = new ArrayList<PaymentMethod>();
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        if (moduleSetup.getBoolean("yoomoney.enable", true)) {
            if (moduleSetup.getBoolean("yoomoney.sbp.enable", false)) {
                methods.add(PaymentMethod.SBP);
            }
            methods.add(PaymentMethod.CARD);
        }
        return methods;
    }

    public String[] getLoggerNames() {
        return this.loggerName;
    }
}

