/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime.restriction;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServRestriction;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServRestrictionTimeCondition;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.restriction.InetServRestrictionRuntime;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffRequest;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;

public class InetServRestrictionTimeRuntime
extends InetServRestrictionRuntime {
    private static final Set<Integer> allDaysOfMonth = IntStream.rangeClosed(1, 31).boxed().collect(Collectors.toSet());
    private static final Set<Integer> allMonths = IntStream.rangeClosed(1, 12).boxed().collect(Collectors.toSet());
    private static final Set<Integer> allDaysOfWeek = IntStream.rangeClosed(1, 12).boxed().collect(Collectors.toSet());
    private final InetServRestrictionTimeCondition timeCondition;
    private final boolean twoDaysTime;

    public InetServRestrictionTimeRuntime(InetServRuntime inetServRuntime, InetServRestriction restriction, Calendar utilCalendar) {
        super(restriction, utilCalendar);
        this.timeCondition = (InetServRestrictionTimeCondition)restriction.getConfig();
        if (this.timeCondition.getDaysOfMonth() != null && this.timeCondition.getDaysOfMonth().containsAll(allDaysOfMonth)) {
            this.timeCondition.setDaysOfMonth(null);
        }
        if (this.timeCondition.getDaysOfWeek() != null && this.timeCondition.getDaysOfWeek().containsAll(allDaysOfWeek)) {
            this.timeCondition.setDaysOfWeek(null);
        }
        if (this.timeCondition.getMonths() != null && this.timeCondition.getMonths().containsAll(allMonths)) {
            this.timeCondition.setMonths(null);
        }
        this.twoDaysTime = this.timeCondition.getTimeFrom() != null && this.timeCondition.getTimeTo() != null && !this.timeCondition.getTimeTo().isAfter(this.timeCondition.getTimeFrom());
    }

    @Override
    protected Integer testImpl(InetTariffWorkerContext workerContext, InetApplication application, InetServRuntime inetServRuntime, InetConnectionRuntime connectionRuntime, InetTariffRequest req) throws BGException {
        if (this.timeCondition.getTimeFrom() == null || this.timeCondition.getTimeTo() == null) {
            return null;
        }
        LocalDateTime dateTime = req != null ? LocalDateTime.ofInstant(req.getTime().toInstant(), ZoneId.systemDefault()) : LocalDateTime.now();
        if (this.twoDaysTime) {
            LocalTime time = dateTime.toLocalTime();
            if (!this.timeCondition.getTimeFrom().isAfter(time) ? !this.checkDays(dateTime) : this.timeCondition.getTimeTo().isBefore(time) && !this.checkDays(dateTime.plusDays(-1L))) {
                return null;
            }
        } else {
            if (!this.checkDays(dateTime)) {
                return null;
            }
            LocalTime time = dateTime.toLocalTime();
            if (this.timeCondition.getTimeFrom().isAfter(time)) {
                return null;
            }
            if (!this.timeCondition.getTimeTo().isAfter(time)) {
                return null;
            }
        }
        return this.timeCondition.getMode() == 0 ? AccessCode.SERVICE_DENY.getCode() : AccessCode.AUTHORIZATION_SUCCEEDED.getCode();
    }

    private boolean checkDays(LocalDateTime dateTime) {
        if (this.timeCondition.getMonths() != null && !this.timeCondition.getMonths().isEmpty() && !this.timeCondition.getMonths().contains(dateTime.getMonth().getValue())) {
            return false;
        }
        if (this.timeCondition.getDaysOfMonth() != null && !this.timeCondition.getDaysOfMonth().isEmpty() && !this.timeCondition.getDaysOfMonth().contains(dateTime.getDayOfMonth())) {
            return false;
        }
        return this.timeCondition.getDaysOfWeek() == null || this.timeCondition.getDaysOfWeek().isEmpty() || this.timeCondition.getDaysOfWeek().contains(dateTime.getDayOfWeek().getValue());
    }
}

