/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.List;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractNote;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractNoteService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractNoteDao;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.api.common.service.ContractNoteService")
public class ContractNoteServiceImpl
extends AbstractService
implements ContractNoteService {
    private ContractNoteDao contractNoteDao;

    @PostConstruct
    void init() {
        this.contractNoteDao = new ContractNoteDao(this.getConnection());
    }

    @Override
    public List<ContractNote> contractNoteList(int contractId, boolean customer) throws Exception {
        return this.contractNoteDao.list(contractId, customer);
    }

    @Override
    public void contractNoteDelete(int contractId, int id) throws Exception {
        ContractNote cn = (ContractNote)this.contractNoteDao.get(id);
        if (cn == null || cn.getContractId() != contractId) {
            throw new BGIllegalArgumentException();
        }
        this.contractNoteDao.delete(id);
    }

    @Override
    public int contractNoteUpdate(int contractId, ContractNote contractNote) throws Exception {
        if (contractNote == null) {
            throw new BGIllegalArgumentException("contractNotification");
        }
        if (contractNote.getContractId() <= 0 || contractNote.getContractId() != contractId) {
            throw new BGIllegalArgumentException("contractId");
        }
        contractNote.setUserId(this.userId);
        this.contractNoteDao.update(contractNote);
        return contractNote.getId();
    }

    @Override
    public ContractNote contractNoteGet(int contractId, int contractNoteId) throws Exception {
        return (ContractNote)this.contractNoteDao.get(contractNoteId);
    }
}

