/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vidimax.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.vidimax.common.VidimaxClientPairData;
import ru.bitel.common.dao.AbstractDao;

public class VidimaxClientPairDataDao
extends AbstractDao<VidimaxClientPairData> {
    public VidimaxClientPairDataDao(Connection con, int mid) {
        super(con, mid, "vidimax_client_pair");
    }

    public VidimaxClientPairData getByContractid(int contractId) throws BGException {
        return (VidimaxClientPairData)this.get("contractId=?", new Object[]{contractId});
    }

    public VidimaxClientPairData getByCustomerId(String customerId) throws BGException {
        return (VidimaxClientPairData)this.get("customerId=?", new Object[]{customerId});
    }

    public void pairAccountUpdate(VidimaxClientPairData pairData, boolean pair) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET pair=?, deviceId=? WHERE contractId=?");){
            ps.setBoolean(1, pair);
            ps.setString(2, pairData.getDeviceId());
            ps.setInt(3, pairData.getContractId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    protected VidimaxClientPairData getFromRS(ResultSet rs) throws SQLException, BGException {
        VidimaxClientPairData pairData = new VidimaxClientPairData();
        pairData.setContractId(rs.getInt("contractId"));
        pairData.setCustomerId(rs.getString("customerId"));
        pairData.setPair(rs.getBoolean("pair"));
        pairData.setFirstTariffIds(rs.getString("firstTariffIds"));
        pairData.setLastChange((Date)rs.getDate("lm"));
        return pairData;
    }

    public void deleteByContractId(int contractId) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE contractId=" + contractId);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    protected void updateImpl(VidimaxClientPairData pairData) throws BGException, SQLException {
        if (pairData != null) {
            VidimaxClientPairData pairDataLast = (VidimaxClientPairData)this.get("contractId=?", new Object[]{pairData.getContractId()});
            VidimaxClientPairData pairDataCI = this.getByCustomerId(pairData.getCustomerId());
            if (pairDataCI != null && pairDataCI.getContractId() != pairData.getContractId()) {
                throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 \u043e\u0434\u0438\u043d\u0430\u043a\u043e\u0432\u044b\u043c\u0438 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430\u043c\u0438 \u0437\u0430\u043f\u0440\u044f\u0449\u0435\u043d\u044b! \u041f\u043e\u0432\u0442\u043e\u0440\u0435\u043d\u0438\u0435 \u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u043c \u043f\u043e\u0434 \u043a\u043e\u0434\u043e\u043c " + pairDataCI.getContractId());
            }
            int index = 1;
            if (pairDataLast == null) {
                PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET contractId=?, customerId=?, pair=?, firstTariffIds=?");
                ps.setInt(index++, pairData.getContractId());
                ps.setString(index++, pairData.getCustomerId());
                ps.setBoolean(index++, false);
                ps.setString(index++, pairData.getFirstTariffIds());
                ps.executeUpdate();
                ps.close();
            } else {
                if (pairDataLast.isPair()) {
                    throw new BGMessageException("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e!");
                }
                PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET customerId=?, firstTariffIds=? WHERE contractId=?");
                ps.setString(index++, pairData.getCustomerId());
                ps.setString(index++, pairData.getFirstTariffIds());
                ps.setInt(index++, pairData.getContractId());
                ps.executeUpdate();
                ps.close();
            }
        } else {
            throw new BGIllegalArgumentException();
        }
    }
}

