/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mangooffice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoPhone;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class MangoPhoneDao
extends AbstractIdDao<MangoPhone> {
    public MangoPhoneDao(Connection con, int moduleId) {
        super(con, moduleId, "mango_product_phone_number");
    }

    public List<MangoPhone> phoneList(int contractId) throws SQLException {
        return this.list("contractId=?", null, new Object[]{contractId});
    }

    protected MangoPhone getFromRS(ResultSet rs) throws SQLException {
        MangoPhone phone = new MangoPhone();
        phone.setId(rs.getInt("id"));
        phone.setAccountProductId(rs.getInt("accountProductId"));
        phone.setPhone(rs.getString("phone"));
        phone.setDateFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dateFrom")));
        phone.setDateTo(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dateTo")));
        phone.setStatus(rs.getInt("status"));
        return phone;
    }

    protected void updateImpl(MangoPhone mangoPhone) throws SQLException {
        Objects.requireNonNull(mangoPhone);
        int index = 1;
        if (mangoPhone.getId() < 1) {
            String query = "INSERT INTO " + this.tableName + " SET contractId=?, accountProductId=?, phone=?, dateFrom=?, dateTo=?, status=?";
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                ps.setInt(index++, mangoPhone.getContractId());
                ps.setInt(index++, mangoPhone.getAccountProductId());
                ps.setString(index++, mangoPhone.getPhone());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)mangoPhone.getDateFrom()));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)mangoPhone.getDateTo()));
                ps.setInt(index++, mangoPhone.getStatus());
                ps.executeUpdate();
                mangoPhone.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        String query = "UPDATE " + this.tableName + " SET dateTo=?, status=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)mangoPhone.getDateTo()));
            ps.setInt(index++, mangoPhone.getStatus());
            ps.setInt(index++, mangoPhone.getId());
            ps.executeUpdate();
        }
    }
}

