/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.common.service;

import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebService;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.modules.license.common.bean.AdditionalAgreement;
import ru.bitel.bgbilling.modules.license.common.bean.ContractData;
import ru.bitel.bgbilling.modules.license.common.bean.License;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseComponent;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseComponentPrice;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseCopy;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrder;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrderBillData;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrderConfirmed;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrderPermanentNew;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrderTestNew;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseProduct;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseStatData;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseTariffGroup;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseTariffRange;
import ru.bitel.bgbilling.modules.license.common.bean.SpecificationTitle;
import ru.bitel.common.model.IdTitle;

@WebService
@XmlSeeAlso(value={IdTitle.class})
public interface LicenseService {
    public List<LicenseCopy> copyList(@WebParam(name="contractId") int var1) throws Exception;

    public LicenseCopy copyGet(@WebParam(name="id") int var1) throws Exception;

    public int copyUpdate(@WebParam(name="copy") LicenseCopy var1) throws Exception;

    public boolean copyDelete(@WebParam(name="copyId") int var1, @WebParam(name="contractId") int var2) throws Exception;

    public List<LicenseOrderConfirmed> confirmedOrderList(@WebParam(name="contractId") int var1, @WebParam(name="copyId") int var2, @WebParam(name="filter") int var3) throws Exception;

    public List<LicenseProduct> productList() throws Exception;

    public List<IdTitle> productTitles() throws Exception;

    public List<LicenseProduct> productListWithComponent(@WebParam(name="contractId") int var1) throws Exception;

    public List<LicenseCopy> productCopyList(@WebParam(name="contractId") int var1) throws Exception;

    public List<License> licenseList(@WebParam(name="contractId") int var1, @WebParam(name="copyId") int var2) throws Exception;

    public List<LicenseOrderConfirmed> licenseComponentList(@WebParam(name="contractId") int var1, @WebParam(name="licenseId") int var2) throws Exception;

    public int licenseCreate(@WebParam(name="contractId") int var1, @WebParam(name="copyId") int var2, @WebParam(name="confirmedOrderIds") Set<String> var3, @WebParam(name="customer") boolean var4) throws Exception;

    public int createPackage(@WebParam(name="contractId") int var1, @WebParam(name="copyId") int var2, @WebParam(name="confirmedOrderIds") Set<String> var3) throws Exception;

    public void prolongTestOrders(@WebParam(name="contractId") int var1, @WebParam(name="dateTo") Date var2, @WebParam(name="ids") List<Integer> var3) throws Exception;

    @WebMethod
    public LicenseOrder orderGet(@WebParam(name="orderId") int var1) throws Exception;

    @WebMethod
    public void orderUpdate(@WebParam(name="order") LicenseOrder var1) throws Exception;

    @WebMethod
    public void orderDelete(@WebParam(name="orderId") int var1) throws Exception;

    @WebMethod
    public List<LicenseStatData> doStatData(@WebParam(name="productId") int var1) throws Exception;

    @WebMethod
    public List<ContractData> doContractData(@WebParam(name="productId") int var1, @WebParam(name="componentId") int var2) throws Exception;

    @WebMethod
    public String getProductLinks(@WebParam(name="productId") int var1) throws Exception;

    @WebMethod
    public String getProductItemLinks(@WebParam(name="productItemId") int var1) throws Exception;

    @WebMethod
    public List<LicenseComponent> productAllLicenseComponents() throws Exception;

    @WebMethod
    public List<LicenseComponent> productLicenseComponents(@WebParam(name="productId") int var1) throws Exception;

    @WebMethod
    public String sendLicenseTextByEmail(@WebParam(name="contractId") int var1, @WebParam(name="copyId") int var2, @WebParam(name="email") String var3, @WebParam(name="licenseText") String var4) throws Exception;

    @WebMethod
    public List<LicenseOrder> getOrders(@WebParam(name="copyId") int var1, @WebParam(name="testFilter") String var2, @WebParam(name="permanentFilter") String var3, @WebParam(name="componentFilter") int var4) throws Exception;

    @WebMethod
    public List<LicenseOrder> getOrdersList(@WebParam(name="copyId") int var1, @WebParam(name="type") int var2, @WebParam(name="status") int var3, @WebParam(name="componentId") int var4) throws Exception;

    @WebMethod
    public List<LicenseComponent> getComponentItems(@WebParam(name="copyId") int var1, @WebParam(name="showHidden") boolean var2, @WebParam(name="customer") boolean var3) throws Exception;

    @WebMethod
    public BigDecimal getCostComponent(@WebParam(name="componentName") String var1, @WebParam(name="count") int var2, @WebParam(name="copyId") int var3) throws Exception;

    @WebMethod
    public Integer getCountOrderedComponents(@WebParam(name="componentName") String var1, @WebParam(name="copyId") int var2) throws Exception;

    @WebMethod
    public List<LicenseOrderPermanentNew> getNewPermanentOrders(@WebParam(name="copyId") int var1) throws Exception;

    @WebMethod
    public List<LicenseOrderTestNew> getNewTestOrders(@WebParam(name="copyId") int var1) throws Exception;

    public int orderCreate(@WebParam(name="contractId") int var1, @WebParam(name="order") LicenseOrder var2, @WebParam(name="customer") boolean var3) throws Exception;

    public void ordersCopy(@WebParam(name="contractId") int var1, @WebParam(name="copyId") int var2, @WebParam(name="orderIds") Set<Integer> var3, @WebParam(name="term") int var4) throws Exception;

    public void ordersDelete(@WebParam(name="contractId") int var1, @WebParam(name="copyId") int var2, @WebParam(name="orderIds") Set<Integer> var3) throws Exception;

    public List<LicenseOrderBillData> ordersBillDataList(@WebParam(name="contractId") int var1, @WebParam(name="copyId") int var2, @WebParam(name="orderIds") Set<Integer> var3) throws Exception;

    @WebMethod
    public List<AdditionalAgreement> additionalAgreements(@WebParam(name="contractId") int var1, @WebParam(name="copyId") int var2) throws Exception;

    @WebMethod
    public void additionalAgreementCreate(@WebParam(name="contractId") int var1, @WebParam(name="additionalAgreement") AdditionalAgreement var2, @WebParam(name="typeDocument") int var3) throws Exception;

    @WebMethod
    public void additionalAgreementUpdate(@WebParam(name="contractId") int var1, @WebParam(name="additionalAgreement") AdditionalAgreement var2) throws Exception;

    @WebMethod
    public void additionalAgreementDelete(@WebParam(name="contractId") int var1, @WebParam(name="additionalAgreement") AdditionalAgreement var2) throws Exception;

    @WebMethod
    public List<SpecificationTitle> specificationTitles(@WebParam(name="id") int var1) throws Exception;

    @WebMethod
    public List<LicenseOrder> permanentOrders(@WebParam(name="copyId") int var1, @WebParam(name="onlyPerformed") boolean var2) throws Exception;

    @WebMethod
    public BigDecimal costComponents(@WebParam(name="copyId") int var1, @WebParam(name="specificationList") List<SpecificationTitle> var2) throws Exception;

    @WebMethod
    public int lastNumber(@WebParam(name="contractId") int var1) throws Exception;

    @WebMethod
    public BigDecimal prospectiveDiscount(@WebParam(name="copyId") int var1) throws Exception;

    @WebMethod
    public BigDecimal discountGet(@WebParam(name="contractId") int var1, @WebParam(name="copyId") int var2) throws Exception;

    @WebMethod
    public void discountSet(@WebParam(name="contractId") int var1, @WebParam(name="copyId") int var2, @WebParam(name="discount") BigDecimal var3) throws Exception;

    @WebMethod
    public void statusSignedSet(@WebParam(name="contractId") int var1, @WebParam(name="copyId") int var2, @WebParam(name="additionalAgreement") AdditionalAgreement var3) throws Exception;

    @WebMethod
    public AdditionalAgreement toReplaceSpecification(@WebParam(name="agreement") AdditionalAgreement var1, @WebParam(name="oldCopyId") int var2) throws Exception;

    @WebMethod
    public LicenseComponentPrice licenseComponentPriceGet(@WebParam(name="productId") int var1, @WebParam(name="componentId") int var2) throws Exception;

    @WebMethod
    public void licenseComponentPriceUpdate(@WebParam(name="productId") int var1, @WebParam(name="componentId") int var2, @WebParam(name="price") String var3) throws Exception;

    @WebMethod
    public List<IdTitle> licenseTariffGroupTitles() throws Exception;

    @WebMethod
    public LicenseTariffGroup licenseTariffGroupGet(@WebParam(name="id") int var1) throws Exception;

    @WebMethod
    public int licenseTariffGroupUpdate(@WebParam(name="tariffRange") LicenseTariffGroup var1) throws Exception;

    @WebMethod
    public boolean licenseTariffGroupDelete(@WebParam(name="id") int var1) throws Exception;

    @WebMethod
    public List<IdTitle> licenseTariffRangeTitles() throws Exception;

    @WebMethod
    public LicenseTariffRange licenseTariffRangeGet(@WebParam(name="id") int var1) throws Exception;

    @WebMethod
    public int licenseTariffRangeUpdate(@WebParam(name="tariffGroup") LicenseTariffRange var1) throws Exception;

    @WebMethod
    public boolean licenseTariffRangeDelete(@WebParam(name="id") int var1) throws Exception;

    @WebMethod
    public LicenseComponent productComponentGet(@WebParam(name="id") int var1) throws Exception;

    @WebMethod
    public LicenseComponent productComponentByNameGet(@WebParam(name="name") String var1) throws Exception;

    @WebMethod
    public int productComponentUpdate(@WebParam(name="component") LicenseComponent var1) throws Exception;
}

