/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.bean;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.Occupant;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Reserve;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ReserveDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.event.events.system.HelpDeskMessageForContractEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.modules.botmanager.server.bots.BotSender;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicListFilter;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.event.TopicWasUpdatedEvent;
import ru.bitel.bgbilling.plugins.helpdesk.server.notification.EmailNotification;
import ru.bitel.bgbilling.plugins.helpdesk.server.notification.TelegramNotification;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class TopicManager
extends BGLogger {
    protected java.sql.Connection con;
    protected BGPluginServer plugin;
    private ReserveDao reserveDao;
    private static final String HELPDESK_RESERVE = " helpdesk_topic_reserve ";

    public TopicManager(java.sql.Connection con, BGPluginServer plugin) {
        this.con = con;
        this.plugin = plugin;
    }

    protected String getDBTableName(String name) {
        return name + "_" + this.plugin.getPluginUID();
    }

    private ReserveDao getReserveDao() {
        if (this.reserveDao == null) {
            this.reserveDao = new ReserveDao(this.con);
        }
        return this.reserveDao;
    }

    public List<Topic> getTopicList(TopicListFilter topicListFilter) {
        ArrayList<Topic> result = new ArrayList<Topic>();
        HashMap<Integer, Topic> topicMap = new HashMap<Integer, Topic>();
        try {
            StringBuilder topicIds = new StringBuilder();
            StringBuilder query = new StringBuilder();
            query.append("SELECT topic.*, contracts.title, contracts.comment FROM ");
            if (topicListFilter.isOnlyNew() || topicListFilter.getMessage() != null && topicListFilter.getMessage().length() > 0 || Utils.notBlankString((String)topicListFilter.getSearchString())) {
                query.append(this.getDBTableName("helpdesk_message"));
                query.append(" AS message LEFT JOIN ");
            }
            query.append(this.getDBTableName("helpdesk_topic"));
            query.append(" AS topic ");
            if (topicListFilter.isOnlyNew() || topicListFilter.getMessage() != null && topicListFilter.getMessage().length() > 0 || Utils.notBlankString((String)topicListFilter.getSearchString())) {
                query.append(" ON topic.id = message.topic_id ");
            }
            query.append(" LEFT JOIN contract AS contracts ON topic.cid=contracts.id");
            query.append(this.getWhere(topicListFilter));
            query.append(" GROUP BY topic.id ORDER BY topic.date");
            if (topicListFilter.getPage() != null) {
                query.append(topicListFilter.getPage().sqlLimit());
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Topic topic = new Topic();
                this.setTopicData(topic, rs, "topic.", "contracts.");
                result.add(topic);
                topicMap.put(topic.getId(), topic);
                if (topicIds.length() > 0) {
                    topicIds.append(", ");
                }
                topicIds.append(topic.getId());
            }
            rs.close();
            ps.close();
            if (topicIds.length() > 0) {
                if (topicListFilter.isAllMessage()) {
                    query = new StringBuilder();
                    query.append("SELECT topic_id, count(*), MAX(date_from) FROM ");
                    query.append(this.getDBTableName("helpdesk_message"));
                    query.append(" WHERE topic_id IN ( ");
                    query.append((CharSequence)topicIds);
                    query.append(" ) GROUP BY topic_id");
                    ps = this.con.prepareStatement(query.toString());
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        ((Topic)topicMap.get(rs.getInt(1))).setMessageCount(rs.getInt(2));
                        ((Topic)topicMap.get(rs.getInt(1))).setLastMessageDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(3)));
                    }
                    rs.close();
                    ps.close();
                }
                if (topicListFilter.isNewManagerMessage()) {
                    query = new StringBuilder();
                    query.append("SELECT topic_id, count(*) FROM ");
                    query.append(this.getDBTableName("helpdesk_message"));
                    query.append(" WHERE user_from>0 AND user_to=-1 AND topic_id IN ( ");
                    query.append((CharSequence)topicIds);
                    query.append(" ) GROUP BY topic_id");
                    ps = this.con.prepareStatement(query.toString());
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        ((Topic)topicMap.get(rs.getInt(1))).setMessageNewManagerCount(rs.getInt(2));
                    }
                    rs.close();
                    ps.close();
                }
                if (topicListFilter.isNewUserMessage()) {
                    query = new StringBuilder();
                    query.append("SELECT topic_id, count(*) FROM ");
                    query.append(this.getDBTableName("helpdesk_message"));
                    query.append(" WHERE user_from=0 AND user_to=-1 AND topic_id IN ( ");
                    query.append((CharSequence)topicIds);
                    query.append(" ) GROUP BY topic_id");
                    ps = this.con.prepareStatement(query.toString());
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        ((Topic)topicMap.get(rs.getInt(1))).setMessageNewUserCount(rs.getInt(2));
                    }
                    rs.close();
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    public int getManagersNewMessagesCount(int contractId) throws Exception {
        String query = "SELECT count(*) FROM " + this.getDBTableName("helpdesk_message") + " AS hm RIGHT JOIN " + this.getDBTableName("helpdesk_topic") + " AS topic ON topic.id=hm.topic_id AND topic.cid=? WHERE user_from>0 AND user_to = -1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    int n = rs.getInt(1);
                    return n;
                }
            }
        }
        return 0;
    }

    public int getClientNewMessageCount() throws Exception {
        int count = 0;
        String query = "SELECT count(*) FROM " + this.getDBTableName("helpdesk_message") + " WHERE user_from=0 AND user_to=-1";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            if (rs.next()) {
                count = rs.getInt(1);
            }
        }
        return count;
    }

    public int getClientNewMessageCount(String contractTitleRegexp, List<Integer> contractMaskLabelIds) {
        return this.getClientNewMessageCount(contractTitleRegexp, contractMaskLabelIds, 0);
    }

    public Map<Integer, Map<IdTitle, Integer>> getClientNewMessagesMap() throws Exception {
        HashMap<Integer, Map<IdTitle, Integer>> map = new HashMap<Integer, Map<IdTitle, Integer>>();
        StringBuffer query = new StringBuffer(500);
        query.append("SELECT `message`.`topic_id`, `topic`.`user_id`, count(`message`.`topic_id`) as `count`, `topic`.`title` ");
        query.append("FROM ").append(this.getDBTableName("helpdesk_message")).append(" as `message` ");
        query.append("LEFT JOIN ").append(this.getDBTableName("helpdesk_topic")).append(" as `topic` ON `message`.`topic_id`=`topic`.`id` ");
        query.append("WHERE `message`.`user_from`=0 AND `message`.`user_to`=-1 ");
        query.append("GROUP BY `message`.`topic_id` ");
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query.toString());){
            while (rs.next()) {
                int topic_id = rs.getInt(1);
                int user_id = rs.getInt(2);
                int count = rs.getInt(3);
                String topic_title = rs.getString(4);
                HashMap<IdTitle, Integer> topicCountMap = (HashMap<IdTitle, Integer>)map.get(user_id);
                if (topicCountMap == null) {
                    topicCountMap = new HashMap<IdTitle, Integer>();
                    map.put(user_id, topicCountMap);
                }
                topicCountMap.put(new IdTitle(topic_id, topic_title), count);
            }
        }
        return map;
    }

    public int getClientNewMessageCount(String contractTitleRegexp, List<Integer> contractMaskLabelIds, int mode) {
        int count = 0;
        boolean labelMask = contractMaskLabelIds != null && !contractMaskLabelIds.isEmpty();
        StringBuffer query = new StringBuffer(500);
        query.append("SELECT count(*) FROM ");
        query.append(this.getDBTableName("helpdesk_message"));
        query.append(" AS message LEFT JOIN ");
        query.append(this.getDBTableName("helpdesk_topic"));
        query.append(" AS topic ON topic_id=topic.id");
        query.append(" LEFT JOIN contract AS contract ON topic.cid=contract.id");
        if (labelMask) {
            query.append(" INNER JOIN hd_contract_label AS label ON topic.cid=label.contract_id");
        }
        query.append(" WHERE user_from=0 AND user_to=-1");
        if (mode > 0) {
            query.append(" AND date_from > ?");
        }
        if (contractTitleRegexp != null && !contractTitleRegexp.isEmpty()) {
            query.append(" AND contract.title regexp ?");
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            if (labelMask) {
                this.con.createStatement().execute("DROP TABLE IF EXISTS hd_contract_label");
                this.con.createStatement().execute("CREATE TEMPORARY TABLE hd_contract_label AS SELECT DISTINCT contract_id FROM contract_label_link WHERE label_id IN ( " + Utils.toString(contractMaskLabelIds) + " )");
            }
            int index = 1;
            if (mode == 1) {
                now = new GregorianCalendar();
                now.clear(14);
                now.clear(13);
                now.clear(12);
                now.set(11, 0);
                ps.setTimestamp(index++, new Timestamp(now.getTimeInMillis()));
            } else if (mode == 2) {
                now = new GregorianCalendar();
                ((Calendar)now).add(11, -1);
                ps.setTimestamp(index++, new Timestamp(now.getTimeInMillis()));
            }
            if (contractTitleRegexp != null && !contractTitleRegexp.isEmpty()) {
                ps.setString(index++, contractTitleRegexp);
            }
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    count = rs.getInt(1);
                }
            }
            if (labelMask) {
                this.con.createStatement().execute("DROP TABLE IF EXISTS hd_contract_label");
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return count;
    }

    public int getTopicCount(TopicListFilter tf) {
        int result = -1;
        try {
            if (tf.isOnlyNew() || tf.getMessage() != null && tf.getMessage().length() > 0) {
                StringBuilder query = new StringBuilder();
                query.append("SELECT count(*) FROM (SELECT count(*) as P FROM ");
                query.append(this.getDBTableName("helpdesk_message") + " as message ");
                query.append(" left join " + this.getDBTableName("helpdesk_topic") + " as topic ON topic.id = message.topic_id ");
                query.append(this.getWhere(tf));
                query.append(" group by message.topic_id) R");
                PreparedStatement ps = this.con.prepareStatement(query.toString());
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result = rs.getInt(1);
                }
                rs.close();
                ps.close();
            } else {
                StringBuilder query = new StringBuilder();
                query.append("SELECT count(*) FROM ");
                query.append(this.getDBTableName("helpdesk_topic") + " AS topic ");
                query.append(this.getWhere(tf));
                PreparedStatement ps = this.con.prepareStatement(query.toString());
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    result = rs.getInt(1);
                }
                rs.close();
                ps.close();
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    private String getWhere(TopicListFilter topicListFilter) {
        StringBuilder query = new StringBuilder();
        query.append(" WHERE (1=1) ");
        if (topicListFilter.getTopicId() > 0) {
            query.append(" AND topic.id=");
            query.append(topicListFilter.getTopicId());
        }
        if (topicListFilter.getStatus() >= 0) {
            query.append(" AND topic.status=");
            query.append(topicListFilter.getStatus());
        }
        if (topicListFilter.getMessage() != null && topicListFilter.getMessage().length() > 0) {
            query.append(" AND message.body LIKE \"%");
            query.append(topicListFilter.getMessage());
            query.append("%\"");
        }
        if (topicListFilter.getContractId() > 0) {
            query.append(" AND topic.cid=");
            query.append(topicListFilter.getContractId());
        }
        if (topicListFilter.isClosed() != null) {
            query.append(" AND topic.closed=");
            query.append(topicListFilter.isClosed() != false ? 1 : 0);
        }
        if (topicListFilter.getPeriod() != null && topicListFilter.getPeriod().getDateFrom() != null) {
            query.append(" AND ");
            query.append("topic.date>='");
            query.append(TimeUtils.format((Date)topicListFilter.getPeriod().getDateFrom(), (String)"yyyy-MM-dd"));
            query.append("'");
        }
        if (topicListFilter.getPeriod() != null && topicListFilter.getPeriod().getDateTo() != null) {
            query.append(" AND ");
            query.append("topic.date<=DATE_ADD('");
            query.append(TimeUtils.format((Date)topicListFilter.getPeriod().getDateTo(), (String)"yyyy-MM-dd"));
            query.append("', INTERVAL 1 DAY )");
        }
        if (topicListFilter.getTitle() != null && topicListFilter.getTitle().trim().length() > 0) {
            query.append(" AND topic.title like '%");
            query.append(topicListFilter.getTitle());
            query.append("%'");
        }
        if (Utils.notBlankString((String)topicListFilter.getSearchString())) {
            query.append(" AND message.body LIKE '%");
            query.append(topicListFilter.getSearchString());
            query.append("%'");
        }
        if (topicListFilter.isOnlyNew()) {
            query.append(" AND message.user_from=0 AND message.user_to=-1 ");
        }
        if (topicListFilter.getUserselect() != null) {
            int userId = Utils.parseInt((String)topicListFilter.getUserselect(), (int)-1);
            if (userId > 0) {
                query.append(" AND topic.user_id=");
                query.append(userId);
                query.append(" ");
            } else if ("none".equals(topicListFilter.getUserselect())) {
                query.append(" AND topic.user_id=");
                query.append(-1);
                query.append(" ");
            } else if ("my".equals(topicListFilter.getUserselect())) {
                query.append(" AND topic.user_id=");
                query.append(topicListFilter.getUserId());
                query.append(" ");
            }
        }
        return query.toString();
    }

    private void setTopicData(Topic topic, ResultSet rs, String tableTopic, String tableContract) throws Exception {
        topic.setId(rs.getInt(tableTopic + "id"));
        topic.setContractId(rs.getInt(tableTopic + "cid"));
        topic.setTitle(rs.getString(tableTopic + "title"));
        topic.setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(tableTopic + "date")));
        topic.setClosed(rs.getBoolean(tableTopic + "closed"));
        topic.setDateClose(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(tableTopic + "date_close")));
        topic.setComm(rs.getInt(tableTopic + "comm"));
        topic.setCommValue(rs.getString(tableTopic + "comm_value"));
        topic.setUserId(rs.getInt(tableTopic + "user_id"));
        topic.setUserName(this.userNameFromId(topic.getUserId()));
        topic.setStatus(rs.getInt(tableTopic + "status"));
        topic.setContractPackageId(rs.getInt(tableTopic + "contract_package_id"));
        topic.setAutoClose(rs.getBoolean(tableTopic + "autoclose"));
        topic.setCost(rs.getBigDecimal(tableTopic + "cost"));
        topic.setChargeId(rs.getInt(tableTopic + "charge_id"));
        topic.setCategoryId(rs.getInt("category_id"));
        topic.setSubcategoryId(rs.getInt("subcategory_id"));
        if (tableContract != null) {
            topic.setContract(rs.getString(tableContract + "title"));
            topic.setContractComment(rs.getString(tableContract + "comment"));
        }
    }

    private ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message getMessageFromRS(ResultSet rs, String tableMessage) throws Exception {
        int userIdFrom = rs.getInt(tableMessage + "user_from");
        int userIdTo = rs.getInt(tableMessage + "user_to");
        return ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message.builder().setId(rs.getInt(tableMessage + "id")).setTopicId(rs.getInt(tableMessage + "topic_id")).setBody(rs.getString(tableMessage + "body")).setDateFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(tableMessage + "date_from"))).setUserIdFrom(userIdFrom).setUserNameFrom(this.userNameFromId(userIdFrom)).setDateTo(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(tableMessage + "date_to"))).setUserIdTo(userIdTo).setUserNameTo(this.userNameFromId(userIdTo)).setComment(rs.getString("comment")).build();
    }

    @Deprecated
    public void updateTopic(String id, Topic topic) throws Exception {
        topic.setId(Utils.parseInt((String)id, (int)-1));
        this.updateTopic(topic);
    }

    public int updateTopic(Topic topic) throws Exception {
        int count = 0;
        try (BalanceUtils bu = new BalanceUtils(this.con);){
            ChargeDao chargeDao;
            Charge charge;
            Topic oldTopic = this.getTopic(topic.getId());
            String query = null;
            PreparedStatement ps = null;
            if (topic.getId() < 0) {
                query = "INSERT INTO " + this.getDBTableName("helpdesk_topic") + " SET cid=?, title=?, closed=?, date=?, comm=?, comm_value=?, user_id=?, status=?, autoclose=?, cost=?, category_id=?, subcategory_id=?";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE " + this.getDBTableName("helpdesk_topic") + " SET cid=?, title=?, closed=?, date=?, comm=?, comm_value=?, user_id=?, status=?, autoclose=?, cost=? , category_id=?, subcategory_id=?, charge_id=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(13, topic.getChargeId());
                ps.setInt(14, topic.getId());
            }
            ps.setInt(1, topic.getContractId());
            ps.setString(2, topic.getTitle());
            ps.setBoolean(3, topic.isClosed());
            ps.setTimestamp(4, TimeUtils.convertDateToTimestamp((Date)topic.getDate()));
            ps.setInt(5, topic.getComm());
            ps.setString(6, topic.getCommValue());
            ps.setInt(7, topic.getUserId());
            ps.setInt(8, topic.getStatus());
            ps.setBoolean(9, topic.isAutoClose());
            ps.setBigDecimal(10, topic.getCost());
            ps.setInt(11, topic.getCategoryId());
            ps.setInt(12, topic.getSubcategoryId());
            count = ps.executeUpdate();
            if (topic.getId() < 0) {
                topic.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
            if (topic.getChargeId() > 0 && (charge = (Charge)(chargeDao = new ChargeDao(this.con)).get(topic.getChargeId())) != null) {
                charge.setSum(topic.getCost());
                chargeDao.update((Object)charge);
                ServerUtils.commitConnection((java.sql.Connection)this.con);
                bu.updateBalance(charge.getDate(), topic.getContractId());
            }
            if (count > 0) {
                try {
                    EventProcessor.getInstance().publishAfterCommit((Event)new TopicWasUpdatedEvent(oldTopic, this.plugin.getPluginUID(), topic));
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
        }
        return count;
    }

    public void updateTopicPackage(int topicId, int contractPackageId) throws Exception {
        String query = "UPDATE " + this.getDBTableName("helpdesk_topic") + " SET contract_package_id=" + contractPackageId + " WHERE id=" + topicId;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.executeUpdate();
        }
    }

    public int updateTopicMessage(ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message message) throws Exception {
        boolean update = message.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.getDBTableName("helpdesk_message") + " SET topic_id=?, body=?, date_from=?, user_from=?, date_to=?, user_to=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, message.getTopicId());
            ps.setString(index++, message.getBody());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)message.getDateFrom()));
            ps.setInt(index++, message.getUserIdFrom());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)message.getDateTo()));
            ps.setInt(index++, message.getUserIdTo());
            if (update) {
                ps.setInt(index++, message.getId());
            }
            ps.executeUpdate();
            message.setId(update ? message.getId() : ServerUtils.lastInsertId((PreparedStatement)ps));
            int n = message.getId();
            return n;
        }
    }

    public Topic getTopic(int topicId) throws Exception {
        return this.getTopic(topicId, true);
    }

    public Topic getTopic(int topicId, boolean loadMessages) throws Exception {
        ResultSet rs;
        Topic topic = null;
        String query = "SELECT topic.* FROM " + this.getDBTableName("helpdesk_topic") + " AS topic WHERE topic.id=" + topicId;
        try (PreparedStatement psSelectTopic = this.con.prepareStatement(query);){
            rs = psSelectTopic.executeQuery();
            try {
                while (rs.next()) {
                    topic = new Topic();
                    this.setTopicData(topic, rs, "topic.", null);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        if (topic != null) {
            query = "SELECT COUNT(*) FROM " + this.getDBTableName("helpdesk_message") + " WHERE user_from>0 AND user_to=-1 AND topic_id=" + topicId;
            try (PreparedStatement psSelectNewMessageCount = this.con.prepareStatement(query);){
                rs = psSelectNewMessageCount.executeQuery();
                try {
                    while (rs.next()) {
                        topic.setMessageNewManagerCount(rs.getInt(1));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            if (loadMessages) {
                this.loadMessages(topic);
            }
        }
        return topic;
    }

    public List<ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message> loadMessages(Topic topic) throws Exception {
        List<Object> list = new ArrayList<ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message>();
        if (topic != null) {
            SearchResult searchResult = new SearchResult(new Page(1, Integer.MAX_VALUE));
            this.searchTopicMessages((SearchResult<ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message>)searchResult, topic.getId());
            list = topic.getMessages();
            list.clear();
            list.addAll(searchResult.getList());
        }
        return list;
    }

    public void searchTopicMessages(SearchResult<ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message> searchResult, int topicId) throws Exception {
        if (searchResult != null) {
            String fileTableName;
            Page page = searchResult.getPage();
            List list = searchResult.getList();
            if (page == null) {
                page = new Page(1, Integer.MAX_VALUE);
                searchResult.setPage(page);
            }
            String query = "SELECT COUNT(*) FROM " + this.getDBTableName("helpdesk_message") + " WHERE topic_id=" + topicId;
            try (PreparedStatement psCount = this.con.prepareStatement(query);
                 ResultSet rs = psCount.executeQuery();){
                while (rs.next()) {
                    page.setRecordCount(rs.getInt(1));
                }
            }
            if (page.getPageIndex() > page.getPageCount()) {
                page.setPageIndex(page.getPageCount());
            }
            if (ServerUtils.tableExists((java.sql.Connection)this.con, (String)(fileTableName = this.getDBTableName("filestorage_files_list")))) {
                query = "SELECT mess.*, storage.id as storageId FROM " + this.getDBTableName("helpdesk_message") + " AS mess LEFT JOIN " + fileTableName + " as storage on storage.id_owner = mess.id WHERE topic_id=? GROUP BY mess.id  ORDER BY mess.date_from" + page.sqlLimit();
                try (PreparedStatement ps = this.con.prepareStatement(query);){
                    ps.setInt(1, topicId);
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message message = this.getMessageFromRS(rs, "");
                            int storageId = rs.getInt("storageId");
                            message.setIncludes(storageId > 0);
                            list.add(message);
                        }
                    }
                }
            }
        }
    }

    private String userNameFromId(int userId) {
        if (userId == -1) {
            return "-";
        }
        if (userId == 0) {
            return "\u041a\u043b\u0438\u0435\u043d\u0442";
        }
        User userFrom = UserMap.getUser((Integer)userId);
        if (userFrom == null) {
            return "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 (id=" + userId + ")";
        }
        return userFrom.getName();
    }

    public ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message getMessage(int id) throws Exception {
        ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message message = null;
        String query = "SELECT msg.* FROM " + this.getDBTableName("helpdesk_message") + " AS msg WHERE msg.id=" + id;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                message = this.getMessageFromRS(rs, "msg.");
            }
        }
        return message;
    }

    public int getPrevMessageId(int id, int topicId) throws Exception {
        String query = "SELECT id FROM " + this.getDBTableName("helpdesk_message") + " WHERE id<" + id + " AND topic_id=" + topicId + " ORDER BY id DESC LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        return -1;
    }

    public int getNextMessageId(int id, int topicId) throws Exception {
        String query = "SELECT id FROM " + this.getDBTableName("helpdesk_message") + " WHERE id>" + id + " AND topic_id=" + topicId + " ORDER BY id LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        return -1;
    }

    public int getTopicOwnerId(int topicId) throws Exception {
        String query = "SELECT cid FROM " + this.getDBTableName("helpdesk_topic") + " WHERE id=" + topicId;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        return -1;
    }

    public void updateMessage(int id, ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message message) throws Exception {
        this.updateMessage(id, message, false);
    }

    protected void updateMessage(int id, ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message message, boolean fromIM) throws Exception {
        boolean update = id > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.getDBTableName("helpdesk_message") + " SET topic_id=?, body=?, date_from=?, user_from=?, date_to=?, user_to=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, message.getTopicId());
            ps.setString(index++, message.getBody());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)message.getDateFrom()));
            ps.setInt(index++, message.getUserIdFrom());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)message.getDateTo()));
            ps.setInt(index++, message.getUserIdTo());
            if (update) {
                ps.setInt(index++, id);
            }
            ps.executeUpdate();
            message.setId(update ? id : ServerUtils.lastInsertId((PreparedStatement)ps));
            if (!fromIM) {
                MultiUserChat muc = this.getChat(message.getTopicId());
                Topic topic = this.getTopic(message.getTopicId());
                String userJID = this.getUserJID(topic.getUserId());
                if (muc != null && userJID != null) {
                    muc.changeNickname("helpdesk/" + UserMap.getUser((Integer)message.getUserIdFrom()).getName());
                    muc.sendMessage(message.getBody());
                }
            }
        }
    }

    public void updateMessageComment(int messageId, String comment) throws Exception {
        String query = "UPDATE " + this.getDBTableName("helpdesk_message") + " SET comment=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, comment);
            ps.setInt(2, messageId);
            ps.executeUpdate();
        }
    }

    public void setTopicClosed(int id, boolean closed, boolean packetMode, int userId) throws Exception {
        Topic oldTopic = this.getTopic(id);
        String query = "UPDATE " + this.getDBTableName("helpdesk_topic") + " SET closed=?, date_close=NULL WHERE id=?";
        if (closed) {
            query = "UPDATE " + this.getDBTableName("helpdesk_topic") + " SET closed=?, date_close=NOW() WHERE id=?";
        }
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setBoolean(1, closed);
            ps.setInt(2, id);
            int count = ps.executeUpdate();
            MultiUserChat muc = this.getChat(id);
            if (muc != null) {
                muc.destroy("closed", null);
            }
            if (count > 0) {
                Topic topic = this.getTopic(id);
                EventProcessor.getInstance().publishAfterCommit((Event)new TopicWasUpdatedEvent(oldTopic, this.plugin.getPluginUID(), topic));
            }
            this.postTopicStateChange(id, closed, packetMode, userId);
        }
    }

    private void postTopicStateChange(int topicId, boolean closed, boolean packetMode, int userId) throws Exception {
        if (packetMode) {
            return;
        }
        ChargeDao chargeDao = new ChargeDao(this.con);
        Topic topic = this.getTopic(topicId);
        Date dateBalance = null;
        if (closed) {
            BigDecimal cost = topic.getCost();
            if (cost.compareTo(BigDecimal.ZERO) > 0) {
                String comment = this.plugin.getSetup().get("topic.default.comment", "\u0420\u0430\u0431\u043e\u0442\u044b \u043f\u043e \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u044e \u043d\u043e\u043c\u0435\u0440 {topicId}");
                comment = comment.replaceAll("\\{topicId\\}", String.valueOf(topic.getId()));
                Charge charge = new Charge(-1, userId, topic.getContractId(), this.getChargeType(), topic.getDateClose(), comment, cost, null);
                chargeDao.update((Object)charge);
                topic.setChargeId(charge.getId());
                this.updateTopic(topic);
                dateBalance = topic.getDateClose();
            }
        } else {
            Charge charge;
            int chargeId = topic.getChargeId();
            if (chargeId > 0 && (charge = (Charge)chargeDao.get(chargeId)) != null) {
                dateBalance = charge.getDate();
                chargeDao.delete(chargeId);
            }
        }
        if (dateBalance != null) {
            ServerUtils.commitConnection((java.sql.Connection)this.con);
            BalanceUtils bu = new BalanceUtils(this.con);
            bu.updateBalance(dateBalance, topic.getContractId());
            bu.close();
        }
    }

    private int getChargeType() throws Exception {
        String chargeKey = "topic.charge.type.id";
        String chargeTypeStr = this.plugin.getSetup().get(chargeKey, "none");
        if (chargeTypeStr.equals("none")) {
            throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 " + chargeKey + " \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u043b\u0430\u0433\u0438\u043d\u0430 HelpDesk.");
        }
        int chargeTypeId = -1;
        try {
            chargeTypeId = Integer.valueOf(chargeTypeStr);
        }
        catch (NumberFormatException e) {
            throw new BGMessageException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 " + chargeKey + " \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u043b\u0430\u0433\u0438\u043d\u0430 HelpDesk.");
        }
        return chargeTypeId;
    }

    public void setTopicAutoclose(int id, boolean autoclose) throws Exception {
        String query = "UPDATE " + this.getDBTableName("helpdesk_topic") + " SET autoclose=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setBoolean(1, autoclose);
            ps.setInt(2, id);
            ps.executeUpdate();
        }
    }

    public void setTopicClientRead(int topicId) throws Exception {
        String query = "UPDATE " + this.getDBTableName("helpdesk_message") + " SET user_to=0, date_to=NOW() WHERE topic_id=? AND user_from > 0 AND user_to=-1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, topicId);
            ps.executeUpdate();
        }
    }

    public void setMessageAdminRead(int messageId, int userId) throws Exception {
        String query = "UPDATE " + this.getDBTableName("helpdesk_message") + " SET user_to=?, date_to=NOW() WHERE id=? AND user_from=0 AND user_to=-1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, userId);
            ps.setInt(2, messageId);
            ps.executeUpdate();
        }
    }

    public void setBindTopic(int id, int userId, String comment) throws Exception {
        String query = "UPDATE " + this.getDBTableName("helpdesk_topic") + " SET user_id=" + userId + " WHERE id=" + id;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.executeUpdate();
            String userJID = this.getUserJID(userId);
            MultiUserChat muc = this.getChat(id);
            if (userJID != null && muc != null) {
                muc.grantMembership(userJID);
            }
            this.updateManagerForTopic(userId, id, comment);
        }
    }

    private String getUserJID(int userId) {
        String jid;
        User user = UserMap.getUser((Integer)userId);
        if (user != null && !Utils.isBlankString((String)(jid = user.getConfigSetup().get("jid", null)))) {
            return jid;
        }
        return null;
    }

    private MultiUserChat getChat(int topicId) {
        return this.getChat(topicId, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiUserChat getChat(final int topicId, int messageId) {
        try {
            MultiUserChat muc;
            XMPPConnection connection = (XMPPConnection)Setup.getSetup().getObject("helpdesk.xmppconnection");
            if (connection == null) {
                return null;
            }
            HashMap<Integer, MultiUserChat> map = (HashMap<Integer, MultiUserChat>)Setup.getSetup().getObject("helpdesk.xmppconnection.mucmap");
            if (map == null) {
                map = new HashMap<Integer, MultiUserChat>();
                Setup.getSetup().putObject("helpdesk.xmppconnection.mucmap", map);
            }
            HashMap<Integer, MultiUserChat> hashMap = map;
            synchronized (hashMap) {
                muc = (MultiUserChat)map.get(topicId);
                if (muc == null) {
                    muc = new MultiUserChat((Connection)connection, "helpdesk#" + topicId + "@" + Setup.getSetup().get("jabber.conference", ""));
                    map.put(topicId, muc);
                    try {
                        Topic topic = this.getTopic(topicId);
                        muc.create("bgbilling");
                        Form form = muc.getConfigurationForm();
                        Form submitForm = form.createAnswerForm();
                        Iterator fields = form.getFields();
                        while (fields.hasNext()) {
                            FormField field = (FormField)fields.next();
                            if ("hidden".equals(field.getType()) || field.getVariable() == null) continue;
                            submitForm.setDefaultAnswer(field.getVariable());
                            if ("muc#roomconfig_roomname".equals(field.getVariable())) {
                                submitForm.setAnswer("muc#roomconfig_roomname", topic.getTitle());
                                continue;
                            }
                            if ("muc#roomconfig_persistentroom".equals(field.getVariable())) {
                                submitForm.setAnswer("muc#roomconfig_persistentroom", false);
                                continue;
                            }
                            if ("muc#roomconfig_publicroom".equals(field.getVariable())) {
                                submitForm.setAnswer("muc#roomconfig_publicroom", false);
                                continue;
                            }
                            if ("public_list".equals(field.getVariable())) {
                                submitForm.setAnswer("public_list", false);
                                continue;
                            }
                            if ("muc#roomconfig_roomsecret".equals(field.getVariable())) {
                                submitForm.setAnswer("muc#roomconfig_roomsecret", "12345");
                                continue;
                            }
                            if ("muc#roomconfig_membersonly".equals(field.getVariable())) {
                                submitForm.setAnswer("muc#roomconfig_membersonly", true);
                                continue;
                            }
                            if ("muc#roomconfig_moderatedroom".equals(field.getVariable())) {
                                submitForm.setAnswer("muc#roomconfig_moderatedroom", true);
                                continue;
                            }
                            if ("muc#roomconfig_changesubject".equals(field.getVariable())) {
                                submitForm.setAnswer("muc#roomconfig_changesubject", true);
                                continue;
                            }
                            if ("allow_private_messages".equals(field.getVariable())) {
                                submitForm.setAnswer("allow_private_messages", false);
                                continue;
                            }
                            if (!"muc#roomconfig_allowinvites".equals(field.getVariable())) continue;
                            submitForm.setAnswer("muc#roomconfig_allowinvites", true);
                        }
                        muc.sendConfigurationForm(submitForm);
                        muc.changeSubject(topic.getTitle());
                        muc.grantModerator("bgbilling");
                        int user = 0;
                        muc.changeNickname("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c");
                        muc.sendMessage("\u0422\u0435\u043c\u0430: " + topic.getTitle());
                        for (ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message m : topic.getMessages()) {
                            if (m.getId() == messageId) continue;
                            if (user != m.getUserIdFrom()) {
                                switch (m.getUserIdFrom()) {
                                    case 0: {
                                        muc.changeNickname("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c");
                                        break;
                                    }
                                    default: {
                                        muc.changeNickname("helpdesk/" + UserMap.getUser((Integer)m.getUserIdFrom()).getName());
                                    }
                                }
                            }
                            muc.sendMessage(m.getBody());
                        }
                    }
                    catch (XMPPException e) {
                        DiscussionHistory history = new DiscussionHistory();
                        history.setMaxStanzas(0);
                        muc.join("bgbilling", null, history, (long)SmackConfiguration.getPacketReplyTimeout());
                    }
                    final MultiUserChat chat = muc;
                    muc.addMessageListener(new PacketListener(){

                        private Map<String, Integer> getUserMap() {
                            HashMap<String, Integer> userMap = (HashMap<String, Integer>)Setup.getSetup().getObject("helpdesk.xmppconnection.usermap");
                            if (userMap == null) {
                                userMap = new HashMap<String, Integer>();
                                for (User u : UserMap.getMap().values()) {
                                    String userJID = u.getConfigSetup().get("jid", null);
                                    if (Utils.isBlankString((String)userJID)) continue;
                                    userMap.put(userJID, u.getId());
                                }
                                Setup.getSetup().putObject("helpdesk.xmppconnection.usermap", userMap);
                            }
                            return userMap;
                        }

                        public void processPacket(Packet packet) {
                            block9: {
                                try {
                                    Integer userId;
                                    if (!(packet instanceof Message)) break block9;
                                    Message message = (Message)packet;
                                    String from = message.getFrom();
                                    for (Occupant o : chat.getParticipants()) {
                                        if (!from.equals(chat.getRoom() + "/" + o.getNick())) continue;
                                        from = o.getJid();
                                        int pos = from.indexOf(47);
                                        if (pos < 0) break;
                                        from = from.substring(0, pos);
                                        break;
                                    }
                                    if ((userId = this.getUserMap().get(from)) == null) break block9;
                                    try (java.sql.Connection con = Setup.getSetup().getDBConnectionFromPool();){
                                        ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message hdMessage = ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message.builder().setTopicId(topicId).setDateFrom(new Date()).setUserIdFrom(userId.intValue()).setBody(message.getBody()).build();
                                        new TopicManager(con, TopicManager.this.plugin).updateMessage(0, hdMessage, true);
                                        chat.sendMessage("\u0412\u0430\u0448\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u0432 \u0442\u043e\u043f\u0438\u043a.");
                                    }
                                }
                                catch (Exception ex) {
                                    TopicManager.this.logError(ex);
                                }
                            }
                        }
                    });
                }
            }
            return muc;
        }
        catch (Exception ex) {
            this.logError(ex);
            return null;
        }
    }

    public void setTopicStatus(int id, int status) throws Exception {
        String query = "UPDATE " + this.getDBTableName("helpdesk_topic") + " SET status=" + status + " WHERE id=" + id;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.executeUpdate();
        }
    }

    public String getStatusName(int statusId) throws Exception {
        String query = "SELECT title FROM " + this.getDBTableName("helpdesk_topic_statuses") + " WHERE id=" + statusId;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            String string;
            block16: {
                ResultSet rs;
                block14: {
                    String string2;
                    block15: {
                        rs = ps.executeQuery();
                        try {
                            if (!rs.next()) break block14;
                            string2 = rs.getString(1);
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return string2;
                }
                string = "";
                if (rs == null) break block16;
                rs.close();
            }
            return string;
        }
    }

    public Map<Integer, String> getStatusMap() {
        HashMap<Integer, String> map = new HashMap();
        try {
            map = this.getStatusesMap();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return map;
    }

    public Map<Integer, String> getStatusesMap() throws Exception {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        String query = "SELECT id, title FROM " + this.getDBTableName("helpdesk_topic_statuses");
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                map.put(rs.getInt(1), rs.getString(2));
            }
        }
        return map;
    }

    public void updateManagerForTopic(int userId, int topicId, String comment) throws Exception {
        String query = "INSERT INTO " + this.getDBTableName("helpdesk_topic_manager_change") + " (topic_id, user_id, date, comment) VALUES(?, ?, NOW(), ?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, topicId);
            ps.setInt(2, userId);
            ps.setString(3, comment);
            ps.executeUpdate();
        }
    }

    public int updateTopicReservStatus(int topicId, int reserveStatus, Integer reserveId) throws Exception {
        if (reserveStatus != 2 && reserveStatus != 1 && reserveStatus != 0) {
            throw new BGIllegalArgumentException();
        }
        String query = "INSERT INTO  helpdesk_topic_reserve  VALUES(" + topicId + "," + reserveStatus + "," + reserveId + ") ON DUPLICATE KEY UPDATE status=" + reserveStatus + ",reserveId=" + reserveId;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int n = ps.executeUpdate();
            return n;
        }
    }

    public Reserve getReserveOnTopic(int topicId) throws Exception {
        Reserve reserve = null;
        String query = "SELECT reserveId FROM helpdesk_topic_reserve  WHERE topicId=" + topicId;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                reserve = (Reserve)this.getReserveDao().get(rs.getInt("reserveId"));
            }
        }
        return reserve;
    }

    public int getReserveStatus(int topicId) throws Exception {
        String query = "SELECT status FROM helpdesk_topic_reserve  WHERE topicId=" + topicId;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                int n = rs.getInt("status");
                return n;
            }
        }
        return 0;
    }

    public List<Integer> getTopicInStatusBlocked(int contractId) throws Exception {
        String query = "SELECT t.id FROM " + this.getDBTableName("helpdesk_topic") + " t LEFT JOIN helpdesk_topic_reserve r ON t.id=r.topicId WHERE t.cid=" + contractId + " AND r.status=1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ArrayList<Integer> arrayList;
            block13: {
                ResultSet rs = ps.executeQuery();
                try {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    while (rs.next()) {
                        list.add(rs.getInt("id"));
                    }
                    arrayList = list;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
    }

    public List<ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message> getMessageListRevert(int topicId, int lastMessageId, int count, boolean before) throws Exception {
        ArrayList<ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message> list = new ArrayList<ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message>();
        String query = "SELECT mess.*, storage.id as storageId FROM " + this.getDBTableName("helpdesk_message") + " AS mess LEFT JOIN " + this.getDBTableName("filestorage_files_list") + " as storage on storage.id_owner = mess.id WHERE topic_id=? AND mess.id" + (before ? "<" : ">") + "? GROUP BY mess.id  ORDER BY mess.id DESC LIMIT ?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, topicId);
            ps.setInt(2, lastMessageId);
            ps.setInt(3, count);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message message = this.getMessageFromRS(rs, "");
                    int storageId = rs.getInt("storageId");
                    message.setIncludes(storageId > 0);
                    list.add(message);
                }
            }
        }
        return list;
    }

    public void sendNotification(Topic topic, ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message message) throws Exception {
        String msgTitle = this.plugin.getSetup().get("default.comm.email.subject", "HelpDesk => \u041e\u043f\u0443\u0431\u043b\u0438\u043a\u043e\u0432\u0430\u043d \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0412\u0430\u0448\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0432 \u0442\u0435\u043c\u0435: [{id}] {title}");
        msgTitle = msgTitle.replaceAll("\\{id\\}", String.valueOf(topic.getId()));
        msgTitle = msgTitle.replaceAll("\\{title\\}", topic.getTitle());
        int commMode = topic.getComm();
        String commValue = topic.getCommValue();
        if (commMode == 2 && Utils.notBlankString((String)commValue)) {
            String url = this.plugin.getSetup().get("url.reference.topic", null);
            StringBuilder sb = new StringBuilder();
            if (Utils.notBlankString((String)url)) {
                sb.append("ID: ").append(topic.getId());
                sb.append("\n\u0422\u0435\u043c\u0430: ").append(topic.getTitle());
                sb.append("\n\n").append(message.getBody());
                sb.append("\n\n\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0442\u0435\u043c\u0443 \u0432 HelpDesk: ");
                sb.append(url).append("action=HelpDesk&module=ru.bitel.bgbilling.plugins.helpdesk&mid=0&topicId=").append(topic.getId());
                sb.append("&contractId=").append(topic.getContractId());
            } else {
                sb.append(message.getBody());
            }
            EmailNotification.sendMessage(commValue, topic, sb.toString());
        } else if (commMode == 4) {
            if (Utils.isBlankString((String)commValue) && this.checkBotManagerModuleInstalled()) {
                new BotSender().send(BotSender.BotMessage.createMessage().setContract(topic.getContractId()).setText(msgTitle + "\n\n" + message.getBody()));
            } else {
                SendMessage sendMessage = new SendMessage();
                sendMessage.setText(msgTitle + "\n\n" + message.getBody());
                new TelegramNotification().sendMessage(commValue.trim(), 0, topic, message, sendMessage);
            }
        }
        HelpDeskMessageForContractEvent event = new HelpDeskMessageForContractEvent(this.plugin.getPluginUID(), topic.getContractId(), topic.getUserId());
        event.setTopicId(message.getTopicId());
        event.setMsgTitle(msgTitle);
        event.setMessageId(message.getId());
        event.setBody(message.getBody());
        EventProcessor.getInstance().request((QueueEvent)event);
    }

    private boolean checkBotManagerModuleInstalled() throws Exception {
        return Utils.notBlankString((String)new ModuleManager(this.con).getInstalledModules().stream().filter(installedModuleTitle -> installedModuleTitle.equals("botmanager")).findFirst().orElse(null));
    }
}

