/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItem;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttribute;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttributeKit;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttributeValue;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemType;
import ru.bitel.bgbilling.plugins.shop.common.bean.Warehouse;
import ru.bitel.bgbilling.plugins.shop.common.service.WarehouseOperationService;
import ru.bitel.bgbilling.plugins.shop.common.service.WarehouseService;
import ru.bitel.bgbilling.plugins.shop.server.dao.AttributeLinkKitDao;
import ru.bitel.bgbilling.plugins.shop.server.dao.StockItemAttributeDao;
import ru.bitel.bgbilling.plugins.shop.server.dao.StockItemAttributeKitDao;
import ru.bitel.bgbilling.plugins.shop.server.dao.StockItemAttributeValueDao;
import ru.bitel.bgbilling.plugins.shop.server.dao.StockItemDao;
import ru.bitel.bgbilling.plugins.shop.server.dao.StockItemTypeDao;
import ru.bitel.bgbilling.plugins.shop.server.dao.WarehouseDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.shop.common.service.WarehouseService")
public class WarehouseServiceImpl
extends AbstractService
implements WarehouseService {
    private WarehouseDao warehouseDao;
    private StockItemDao stockItemDao;
    private StockItemTypeDao stockItemTypeDao;
    private StockItemAttributeDao attributeDao;
    private StockItemAttributeKitDao attributeKitDao;
    private StockItemAttributeValueDao attributeValueDao;

    @PostConstruct
    public void init() {
        this.warehouseDao = new WarehouseDao(this.getConnection(), this.context.getModuleId());
        this.stockItemDao = new StockItemDao(this.getConnection(), this.context.getModuleId());
        this.stockItemTypeDao = new StockItemTypeDao(this.getConnection(), this.context.getModuleId());
        this.attributeDao = new StockItemAttributeDao(this.getConnection(), this.context.getModuleId());
        this.attributeKitDao = new StockItemAttributeKitDao(this.getConnection(), this.context.getModuleId());
        this.attributeValueDao = new StockItemAttributeValueDao(this.getConnection(), this.context.getModuleId(), this.attributeDao);
    }

    public List<Warehouse> getWarehouseList() throws Exception, BGMessageException {
        return this.warehouseDao.getList();
    }

    public Warehouse getWarehouse(int id) throws Exception, BGMessageException {
        return (Warehouse)this.warehouseDao.get(id);
    }

    public Warehouse updateWarehouse(Warehouse warehouse) throws Exception, BGMessageException {
        this.warehouseDao.update(warehouse);
        return warehouse;
    }

    public void deleteWarehouse(int warehouseId) throws Exception {
        this.warehouseDao.delete(warehouseId);
    }

    public StockItem getStockItemById(int stockItemId) throws Exception, BGMessageException {
        return (StockItem)this.stockItemDao.get(stockItemId);
    }

    public StockItem updateStockItem(StockItem stockItem) throws Exception, BGMessageException {
        for (StockItemAttributeValue attributeValue : stockItem.getAttributeValues()) {
            if (!attributeValue.getAttribute().isUnique() || this.attributeValueDao.checkUniqueValueByAttribute(attributeValue)) continue;
            throw new Exception("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u0430 \"" + attributeValue.getAttribute().getTitle() + "\" \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u043c!");
        }
        this.stockItemDao.update(stockItem);
        this.attributeValueDao.updateValuesByStockItem(stockItem);
        ((WarehouseOperationService)this.context.getService(WarehouseOperationService.class, this.moduleId)).stockItemAdded(stockItem);
        return stockItem;
    }

    public SearchResult<StockItem> getWarehouseItemsByType(int warehouseId, int stockItemTypeId, Page page) throws Exception, BGMessageException {
        SearchResult searchResult = new SearchResult(page);
        searchResult.setList(new ArrayList());
        this.stockItemDao.getStockItemsByWarehouseAndType((SearchResult<StockItem>)searchResult, warehouseId, stockItemTypeId);
        return searchResult;
    }

    public void deleteStockItem(int stockItemId) throws Exception, BGMessageException {
        StockItem stockItem = (StockItem)this.stockItemDao.get(stockItemId);
        if (stockItem.getContractId() > 0) {
            throw new Exception("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e! \u0422\u043e\u0432\u0430\u0440 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 ID=" + stockItem.getContractId());
        }
        this.stockItemDao.delete(stockItemId);
        ((WarehouseOperationService)this.context.getService(WarehouseOperationService.class, this.moduleId)).stockItemDeleted(stockItem);
    }

    public StockItemType getStockItemType(int stockItemTypeId) throws Exception, BGMessageException {
        return (StockItemType)this.stockItemTypeDao.get(stockItemTypeId);
    }

    public StockItemType getStockItemTypeTreeRoot() throws Exception, BGMessageException {
        StockItemType root = new StockItemType();
        root.setId(0);
        root.setTitle("\u0422\u0438\u043f\u044b");
        ArrayList<StockItemType> children = new ArrayList<StockItemType>();
        root.setChildren(children);
        List<StockItemType> stockItemTypes = this.stockItemTypeList();
        for (StockItemType type : stockItemTypes) {
            if (type.getParentTypeId() > 0) continue;
            children.add(type);
        }
        return root;
    }

    public List<StockItemType> stockItemTypeList() throws Exception, BGMessageException {
        List<StockItemType> stockItemTypes = this.stockItemTypeDao.getList();
        HashMap<Integer, List> parentWithChildren = new HashMap<Integer, List>();
        for (StockItemType t2 : stockItemTypes) {
            if (t2.getParentTypeId() <= 0) continue;
            List children = parentWithChildren.getOrDefault(t2.getParentTypeId(), new ArrayList());
            children.add(t2);
            parentWithChildren.put(t2.getParentTypeId(), children);
        }
        stockItemTypes.forEach(t -> t.setChildren((List)parentWithChildren.get(t.getId())));
        return stockItemTypes;
    }

    public StockItemType updateStockItemType(StockItemType stockItemType) throws Exception, BGMessageException {
        this.stockItemTypeDao.update(stockItemType);
        return stockItemType;
    }

    public void deleteStockItemType(int stockItemTypeId) throws Exception, BGMessageException {
        this.stockItemTypeDao.delete(stockItemTypeId);
    }

    public List<StockItemType> getStockItemTypesByWarehouse(int warehouseId) throws Exception, BGMessageException {
        return this.stockItemTypeDao.getStockItemTypesByWarehouse(warehouseId);
    }

    public List<StockItemAttributeKit> getAttributeKitList() throws Exception, BGMessageException {
        return this.attributeKitDao.getList();
    }

    public StockItemAttributeKit getAttributeKit(int attributeKitId) throws Exception, BGMessageException {
        StockItemAttributeKit kit = (StockItemAttributeKit)this.attributeKitDao.get(attributeKitId);
        AttributeLinkKitDao attributeLinkKitDao = new AttributeLinkKitDao(this.getConnection());
        kit.setAttributes(attributeLinkKitDao.getAttributesByKitId(kit.getId(), this.attributeDao));
        return kit;
    }

    public StockItemAttributeKit updateAttributeKit(StockItemAttributeKit attributeKit) throws Exception, BGMessageException {
        this.attributeKitDao.update(attributeKit);
        if (Utils.notEmptyCollection((Collection)attributeKit.getAttributes())) {
            AttributeLinkKitDao attributeLinkKitDao = new AttributeLinkKitDao(this.getConnection());
            attributeLinkKitDao.updateAttributesByKitId(attributeKit);
        }
        return attributeKit;
    }

    public void deleteAttributeKit(int attributeKitId) throws Exception, BGMessageException {
        this.attributeKitDao.delete(attributeKitId);
    }

    public StockItemAttribute updateAttribute(StockItemAttribute attribute) throws Exception, BGMessageException {
        this.attributeDao.update(attribute);
        return attribute;
    }

    public List<StockItemAttribute> getAttributeList() throws Exception, BGMessageException {
        return this.attributeDao.getList();
    }

    public void deleteAttribute(int attributeId) throws Exception, BGMessageException {
        for (StockItemAttributeKit kit : this.attributeKitDao.getList()) {
            if (!kit.getAttributes().stream().anyMatch(a -> a.getId() == attributeId)) continue;
            throw new Exception(String.format("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0442.\u043a. \u043e\u043d \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u043d\u0430\u0431\u043e\u0440\u0435 \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432: \"%s\" ", kit.getTitle()));
        }
        this.attributeDao.delete(attributeId);
    }

    public List<StockItemAttributeValue> getAttributeValuesByStockItem(int stockItemId) throws Exception, BGMessageException {
        return this.attributeValueDao.getValuesByStockItem(stockItemId);
    }

    public int getCurrentUserId() throws Exception {
        return this.userId;
    }

    public List<StockItem> searchStockItems(int warehouseId, int attributeId, String data) throws Exception, BGMessageException {
        if (warehouseId <= 0) {
            throw new Exception("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d ID \u0441\u043a\u043b\u0430\u0434\u0430");
        }
        if (attributeId <= 0) {
            throw new Exception("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d ID \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u0430");
        }
        if (Utils.isBlankString((String)data)) {
            throw new Exception("\u041d\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430");
        }
        return this.stockItemDao.searchStockItemByValue(warehouseId, attributeId, data);
    }
}

