/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.aots.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.aots.common.bean.AOTSContractService;
import ru.bitel.bgbilling.modules.aots.common.service.AOTSService;
import ru.bitel.bgbilling.modules.aots.server.bean.AOTSContractServiceDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.aots.common.service.AOTSService")
public class AOTSServiceImpl
extends AbstractService
implements AOTSService {
    private AOTSContractServiceDao aotsContractServiceDao;

    @PostConstruct
    protected void init() {
        this.aotsContractServiceDao = new AOTSContractServiceDao(this.getConnection(), this.moduleId);
    }

    public boolean aotsContractServiceDelete(String id) throws Exception {
        boolean result = false;
        AOTSContractService aotsContractService = this.aotsContractServiceDao.getById(id);
        if (aotsContractService != null && (result = this.aotsContractServiceDao.deleteById(id))) {
            this.setBalanceAccount(aotsContractService.getContractId(), aotsContractService.getServiceId(), aotsContractService.getServiceTime().toLocalDate());
        }
        return result;
    }

    public AOTSContractService aotsContractServiceNew(int contractId) throws Exception {
        return new AOTSContractService().setContractId(contractId).setServiceTime(LocalDateTime.now()).setAmount(BigDecimal.ONE).setCost(BigDecimal.ZERO).setNdsRate(new BigDecimal(20)).setServiceSum(BigDecimal.ZERO);
    }

    public AOTSContractService aotsContractServiceGet(String data) throws Exception {
        return this.aotsContractServiceDao.getById(data);
    }

    public List<IdTitle> aotsServiceList(int serviceId) throws Exception {
        List services = ModuleCache.getInstance().getModuleServicesList(this.moduleId);
        return services.stream().filter(a -> a.isUsing() || a.getId() == serviceId).map(IdTitle::toIdTitle).toList();
    }

    public void aotsContractServiceUpdate(int contractId, AOTSContractService contractService) throws Exception {
        Objects.requireNonNull(contractService, "contractService must be not null");
        contractService.setContractId(contractId);
        if (contractService.getId() == null && contractService.getServiceTime().toLocalDate().isEqual(LocalDate.now())) {
            contractService.setServiceTime(LocalDateTime.now());
        }
        contractService.setUserId(this.userId);
        AOTSContractService oldAotsContractService = null;
        if (contractService.getId() != null) {
            oldAotsContractService = this.aotsContractServiceDao.getById(contractService.getId());
        }
        this.aotsContractServiceDao.update(contractService);
        LocalDate newTime = contractService.getServiceTime().toLocalDate();
        if (oldAotsContractService != null) {
            LocalDate oldTime = oldAotsContractService.getServiceTime().toLocalDate();
            if (newTime.getYear() != oldTime.getYear() || newTime.getMonthValue() != oldTime.getMonthValue()) {
                this.setBalanceAccount(contractId, oldAotsContractService.getServiceId(), oldTime);
            }
        }
        this.setBalanceAccount(contractId, contractService.getServiceId(), newTime);
    }

    private void setBalanceAccount(int contractId, int serviceId, LocalDate serviceTime) throws Exception {
        BigDecimal serviceSum = this.aotsContractServiceDao.getServiceSum(contractId, serviceId, Period.toMonthPeriod((LocalDate)serviceTime));
        try (BalanceDao balanceDao = new BalanceDao(this.getConnection());
             BalanceUtils balanceUtils = new BalanceUtils(this.getConnection());){
            balanceDao.setContractAccount(contractId, serviceTime.getYear(), serviceTime.getMonthValue(), serviceId, serviceSum);
            balanceUtils.updateBalance(TimeUtils.convertLocalDateToDate((LocalDate)serviceTime), contractId);
        }
    }
}

