/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree.old;

import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class OptionTariffTreeNode
extends DefaultTariffTreeNode {
    private Set<Integer> options = Collections.synchronizedSet(new HashSet());
    private boolean modeOr;

    @Override
    public void init(String data, int deep, int nodeId) {
        super.init(data, deep, nodeId);
        Map<String, String> dataHash = this.getDataInHash();
        List<Integer> options = Utils.toIntegerList(dataHash.get("options"));
        this.options.addAll(options);
        this.modeOr = Utils.parseInt(dataHash.get("mode"), 0) == 0;
    }

    @Override
    public void processRequest(TariffRequest request) {
        ContractTariffOptionList options = (ContractTariffOptionList)request.getRequestParam("tariffOptions");
        Calendar time = (Calendar)request.getRequestParam("time_real");
        if (time == null) {
            time = (Calendar)request.getRequestParam("time");
        }
        String action = (String)request.getRequestParam("action");
        String paramName = "t_o_a_" + this._parent.getId();
        String tariffOptionAccepted = (String)request.getResponseParam(paramName);
        if (action != null && action.equals("reset")) {
            if (options == null || this.options.size() == 0 || options.contains(TimeUtils.convertCalendarToDate(time).getTime(), this.options)) {
                this.processForChilds(request);
            }
        } else if (options != null) {
            if (this.options.size() == 0) {
                if (tariffOptionAccepted == null) {
                    this.processForChilds(request);
                    request.setResponseParam(paramName, "true");
                }
            } else if (this.modeOr) {
                if (options.contains(TimeUtils.convertCalendarToDate(time).getTime(), this.options)) {
                    this.processForChilds(request);
                    request.setResponseParam(paramName, "true");
                }
            } else if (options.containsAll(TimeUtils.convertCalendarToDate(time), this.options)) {
                this.processForChilds(request);
                request.setResponseParam(paramName, "true");
            }
        }
    }
}

