package ru.bitel.bgbilling.modules.inet.dyn.device.dhcp;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import ru.bitel.bgbilling.apps.inet.access.sa.ProtocolHandlerAdapter;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpOption;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpPacket;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDeviceType;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;

public class PonDhcpRelayProtocolHandler
    extends ProtocolHandlerAdapter
{
    private static final Logger logger = LogManager.getLogger();

    private byte macCode = 0;
    
    @Override
    public void init( Setup setup, int moduleId, InetDevice inetDevice, InetDeviceType inetDeviceType, ParameterMap deviceConfig )
        throws Exception
    {
        macCode = (byte)deviceConfig.getInt( "dhcp.option82.mac.code", 2 );
    }
    
    @Override
    public void preprocessDhcpRequest( final DhcpPacket request, final DhcpPacket response )
        throws Exception
    {
        if ( macCode > 0 )
        {
            final DhcpOption subOption = request.getSubOption( macCode );
            if ( subOption != null )
            {
                request.chaddr = subOption.value;
                if ( logger.isDebugEnabled() )
                {
                    logger.debug( "request.chaddr={}", request.chaddr );
                }
            }
            else
            {
                if ( logger.isDebugEnabled() )
                {
                    logger.debug( "subOption=null" );
                }
            }
        }
    }    
}
