/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.flow;

import java.nio.ByteBuffer;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Template;
import ru.bitel.common.inet.IpAddress;

public class IPFIXRecord
extends Data {
    private static final byte[] ZERO = new byte[4];
    private final byte[] postNatDestinationAddress = new byte[4];

    public int fillData(ByteBuffer data, NetFlow9Template template) {
        if (template.dataLength >= 0) {
            this.fillDataWithoutVariableLength(data, template);
            return template.dataLength;
        }
        return this.fillDataWithVariableLength(data, template);
    }

    private void fillDataWithoutVariableLength(ByteBuffer data, NetFlow9Template template) {
        int position = data.position();
        this.fillSrcAddress(data, template, position);
        boolean postNatDest = this.fillDstAddress(data, template, position);
        this.nextHop = template.ip4NextHopItem.init ? (long)data.getInt(position + template.ip4NextHopItem.offset) & 0xFFFFFFFFL : 0L;
        this.inputInterface = template.inSnmpIfaceItem.init ? data.getShort(position + template.inSnmpIfaceItem.offset) & 0xFFFF : 0;
        this.outputInterface = template.outSnmpIfaceItem.init ? data.getShort(position + template.outSnmpIfaceItem.offset) & 0xFFFF : 0;
        if (template.inOctetsItem.init) {
            int length = template.inOctetsItem.length;
            if (length == 4) {
                this.octets = (long)data.getInt(position + template.inOctetsItem.offset) & 0xFFFFFFFFL;
            } else if (length == 8) {
                this.octets = data.getLong(position + template.inOctetsItem.offset) & 0xFFFFFFFFFFFFFFFFL;
            }
        } else {
            this.octets = 0L;
        }
        this.srcPort = template.l4SrcPortItem.init ? data.getShort(position + template.l4SrcPortItem.offset) & 0xFFFF : 0;
        if (postNatDest && template.hslNatLogFieldTranslatedDestinationPort.init) {
            this.dstPort = data.getShort(position + template.hslNatLogFieldTranslatedDestinationPort.offset) & 0xFFFF;
            if (this.dstPort == 0 && template.l4DstPortItem.init) {
                this.dstPort = data.getShort(position + template.l4DstPortItem.offset) & 0xFFFF;
            }
        } else {
            this.dstPort = template.l4DstPortItem.init ? data.getShort(position + template.l4DstPortItem.offset) & 0xFFFF : 0;
        }
        this.diffServ = template.srcTosBytesItem.init ? data.get(position + template.srcTosBytesItem.offset) & 0xFF : 0;
        this.protocol = template.protocolItem.init ? data.get(position + template.protocolItem.offset) & 0xFF : 0;
    }

    private void fillSrcAddress(ByteBuffer data, NetFlow9Template template, int position) {
        if (template.ip4SrcAddressItem.init) {
            data.position(position + template.ip4SrcAddressItem.offset);
            data.get(this.ipv4SrcAddress, 0, 4);
            if (!template.ip6SrcAddressItem.init || !IpAddress.equals(this.ipv4SrcAddress, IpAddress.ZERO_ADDRESS.address)) {
                this.srcAddress.address = this.ipv4SrcAddress;
                return;
            }
        }
        if (template.ip6SrcAddressItem.init) {
            this.srcAddress.address = this.ipv6SrcAddress;
            data.position(position + template.ip6SrcAddressItem.offset);
            data.get(this.srcAddress.address, 0, 16);
            return;
        }
        this.srcAddress.address = this.ipv4SrcAddress;
        System.arraycopy(ZERO, 0, this.srcAddress.address, 0, 4);
    }

    private boolean fillDstAddress(ByteBuffer data, NetFlow9Template template, int position) {
        if (template.hslNatLogFieldTranslatedDestinationIPv4Addr.init) {
            data.position(position + template.hslNatLogFieldTranslatedDestinationIPv4Addr.offset);
            data.get(this.ipv4DstAddress, 0, 4);
            if (!IpAddress.equals(this.ipv4DstAddress, ZERO)) {
                this.dstAddress.address = this.ipv4DstAddress;
                return true;
            }
        }
        if (template.ip4DstAddressItem.init) {
            data.position(position + template.ip4DstAddressItem.offset);
            data.get(this.ipv4DstAddress, 0, 4);
            if (!template.ip6DstAddressItem.init || !IpAddress.equals(this.ipv4DstAddress, ZERO)) {
                this.dstAddress.address = this.ipv4DstAddress;
                return false;
            }
        }
        if (template.ip6DstAddressItem.init) {
            this.dstAddress.address = this.ipv6DstAddress;
            data.position(position + template.ip6DstAddressItem.offset);
            data.get(this.dstAddress.address, 0, 16);
            return false;
        }
        this.dstAddress.address = this.ipv4DstAddress;
        System.arraycopy(ZERO, 0, this.srcAddress.address, 0, 4);
        return false;
    }

    private int fillDataWithVariableLength(ByteBuffer data, NetFlow9Template template) {
        int position;
        if (template.ip6SrcAddressItem.init) {
            if (template.ip4DstAddressItem.init) {
                this.srcAddress.address = this.ipv4SrcAddress;
                System.arraycopy(ZERO, 0, this.srcAddress.address, 0, 4);
            } else {
                this.srcAddress.address = this.ipv6SrcAddress;
            }
        } else {
            this.srcAddress.address = this.ipv4SrcAddress;
            if (!template.ip4SrcAddressItem.init) {
                System.arraycopy(ZERO, 0, this.srcAddress.address, 0, 4);
            }
        }
        if (template.ip6DstAddressItem.init) {
            if (template.ip4DstAddressItem.init) {
                this.dstAddress.address = this.ipv4DstAddress;
                System.arraycopy(ZERO, 0, this.dstAddress.address, 0, 4);
            } else {
                this.dstAddress.address = this.ipv6DstAddress;
            }
        } else {
            this.dstAddress.address = this.ipv4DstAddress;
            if (!template.ip4DstAddressItem.init) {
                System.arraycopy(ZERO, 0, this.dstAddress.address, 0, 4);
            }
        }
        this.nextHop = 0L;
        this.inputInterface = 0;
        this.outputInterface = 0;
        this.octets = 0L;
        this.srcPort = 0;
        this.dstPort = 0;
        this.diffServ = 0;
        this.protocol = 0;
        int beginPosition = position = data.position();
        for (int i = 0; i < template.items.length; ++i) {
            NetFlow9Template.NetFlow9TemplateItem item = template.items[i];
            if (item.init) {
                this.fill(template, item, data, position);
            }
            if (item.length == -1) {
                int len = data.get(position) & 0xFF;
                if (len == 255) {
                    len = data.getShort(++position) & 0xFFFF;
                    position += len + 2;
                    continue;
                }
                position += len + 1;
                continue;
            }
            position += item.length;
        }
        return position - beginPosition;
    }

    private void fill(NetFlow9Template template, NetFlow9Template.NetFlow9TemplateItem item, ByteBuffer data, int position) {
        switch (item.type) {
            case 27: {
                assert (item == template.ip6SrcAddressItem);
                data.position(position);
                data.get(this.ipv6SrcAddress, 0, 16);
                if (template.ip4SrcAddressItem.init && IpAddress.equals(this.ipv6SrcAddress, IpAddress.IPV6_ZERO_ADDRESS.address)) break;
                this.srcAddress.address = this.ipv6SrcAddress;
                break;
            }
            case 8: {
                assert (item == template.ip4SrcAddressItem);
                data.position(position);
                data.get(this.ipv4SrcAddress, 0, 4);
                if (template.ip6SrcAddressItem.init && IpAddress.equals(this.ipv4SrcAddress, IpAddress.ZERO_ADDRESS.address)) break;
                this.srcAddress.address = this.ipv4SrcAddress;
                break;
            }
            case 28: {
                assert (item == template.ip6DstAddressItem);
                data.position(position);
                data.get(this.ipv6DstAddress, 0, 16);
                if ((template.ip4DstAddressItem.init || template.hslNatLogFieldTranslatedDestinationIPv4Addr.init) && IpAddress.equals(this.ipv6DstAddress, IpAddress.IPV6_ZERO_ADDRESS.address)) break;
                this.dstAddress.address = this.ipv6DstAddress;
                break;
            }
            case 12: {
                if (template.hslNatLogFieldTranslatedDestinationIPv4Addr.init && !IpAddress.equals(this.ipv4DstAddress, ZERO)) break;
                assert (item == template.ip4DstAddressItem);
                data.position(position);
                data.get(this.ipv4DstAddress, 0, 4);
                if (template.ip6DstAddressItem.init && IpAddress.equals(this.ipv4DstAddress, IpAddress.ZERO_ADDRESS.address)) break;
                this.dstAddress.address = this.ipv4DstAddress;
                break;
            }
            case 226: {
                assert (item == template.hslNatLogFieldTranslatedDestinationIPv4Addr);
                data.position(position);
                data.get(this.postNatDestinationAddress, 0, 4);
                if (IpAddress.equals(this.postNatDestinationAddress, ZERO)) break;
                this.dstAddress.address = this.ipv4DstAddress;
                System.arraycopy(this.postNatDestinationAddress, 0, this.dstAddress.address, 0, 4);
                break;
            }
            case 15: {
                assert (item == template.ip4NextHopItem);
                this.nextHop = (long)data.getInt(position) & 0xFFFFFFFFL;
                break;
            }
            case 10: {
                assert (item == template.inSnmpIfaceItem);
                this.inputInterface = data.getShort(position) & 0xFFFF;
                break;
            }
            case 14: {
                assert (item == template.outSnmpIfaceItem);
                this.outputInterface = data.getShort(position) & 0xFFFF;
                break;
            }
            case 1: {
                assert (item == template.inOctetsItem);
                int length = template.inOctetsItem.length;
                if (length == 4) {
                    this.octets = (long)data.getInt(position) & 0xFFFFFFFFL;
                    break;
                }
                if (length != 8) break;
                this.octets = data.getLong(position) & 0xFFFFFFFFFFFFFFFFL;
                break;
            }
            case 7: {
                assert (item == template.l4SrcPortItem);
                this.srcPort = data.getShort(position) & 0xFFFF;
                break;
            }
            case 11: {
                if (template.hslNatLogFieldTranslatedDestinationPort.init && this.dstPort != 0) break;
                assert (item == template.l4DstPortItem);
                this.dstPort = data.getShort(position) & 0xFFFF;
                break;
            }
            case 228: {
                assert (item == template.hslNatLogFieldTranslatedDestinationPort);
                int dstPort = data.getShort(position) & 0xFFFF;
                if (dstPort == 0) break;
                this.dstPort = dstPort;
                break;
            }
            case 5: {
                assert (item == template.srcTosBytesItem);
                this.diffServ = data.get(position) & 0xFF;
                break;
            }
            case 4: {
                assert (item == template.protocolItem);
                this.protocol = data.get(position) & 0xFF;
                break;
            }
        }
    }
}

