/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.util.exslt;

import bitel.billing.common.SummaToString;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class BGXsltFunctions {
    private Map<String, BigDecimal> values = new HashMap<String, BigDecimal>();

    public void counterSet(String name, String value) {
        this.values.put(name, Utils.parseBigDecimal((String)value, (BigDecimal)BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP));
    }

    public String counterGet(String name) {
        return Optional.ofNullable(this.values.get(name)).orElse(BigDecimal.ZERO).toPlainString();
    }

    public void counterAdd(String name, String value) {
        BigDecimal currentValue = this.values.get(name);
        if (currentValue == null) {
            currentValue = BigDecimal.ZERO.setScale(2);
        }
        currentValue = currentValue.add(Utils.parseBigDecimal((String)value, (BigDecimal)BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP));
        this.values.put(name, currentValue);
    }

    public String configValueGet(int moduleId, String name) {
        if (moduleId == 0) {
            return Setup.getSetup().get(name, "");
        }
        return Setup.getSetup().getModuleSetup(moduleId).get(name, "");
    }

    public Element sqlSelect(String query) throws Exception {
        Element result = null;
        Document doc = XMLUtils.newDocument();
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            result = doc.createElement("data");
            doc.appendChild(result);
            try (Statement st = con.createStatement();
                 ResultSet rs = st.executeQuery(query);){
                ServerUtils.resultSetToXML(rs, result, "row");
            }
        }
        return result;
    }

    public String summaToString(String summa) {
        return this.summaToString(summa, false);
    }

    public final String summaToString(String summa, boolean firstUpperCase) {
        return this.summaToString(summa, firstUpperCase, false);
    }

    public final String summaToString(String summa, boolean firstUpperCase, boolean hideZero) {
        return SummaToString.summaToString((String)summa, (boolean)firstUpperCase, (boolean)hideZero);
    }
}

