/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.task;

import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.modules.bill.common.bean.BillDocSendLog;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentSendParameters;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentSendMode;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDocSendLogDao;
import ru.bitel.bgbilling.modules.bill.server.bean.EmailMaster;
import ru.bitel.bgbilling.modules.bill.server.mail.MailDocsSender;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class BillDocsSender
extends RunTask {
    private final int moduleId;
    private final DocumentSendParameters.SendingDataType docType;
    private final List<Integer> documentIds;
    private final int userId;

    public BillDocsSender(DocumentSendParameters documentSendParameters) {
        this.moduleId = documentSendParameters.getModuleId();
        this.docType = documentSendParameters.getType();
        this.userId = documentSendParameters.getUserId();
        this.documentIds = Utils.isEmptyCollection((Collection)documentSendParameters.getBillIds()) ? documentSendParameters.getInvoiceIds() : documentSendParameters.getBillIds();
    }

    public String getDescription() {
        String doc = this.docType.equals((Object)DocumentSendParameters.SendingDataType.BILL) ? "\u0441\u0447\u0435\u0442\u0430" : "\u0441\u0447\u0435\u0442\u0430-\u0444\u0430\u043a\u0442\u0443\u0440\u044b, \u0430\u043a\u0442\u044b, \u0423\u041f\u0414";
        return "\u041c\u043e\u0434\u0443\u043b\u044c Bill. \u0417\u0430\u0434\u0430\u0447\u0430 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 (" + doc + "). \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId;
    }

    public void executeTask() {
        this.getLogger().debug("type=>{} ids=>{}", (Object)this.docType, this.documentIds);
        try (Connection con = this.setup.getDBConnectionFromPool();){
            int countSend = 0;
            int countAll = 0;
            BillDocSendLogDao billDocSendLogDao = new BillDocSendLogDao(con, this.moduleId);
            for (Integer docId : this.documentIds) {
                ++countAll;
                BillDocSendLog billDocSendLog = new BillDocSendLog().setDocumentType(this.docType == DocumentSendParameters.SendingDataType.BILL ? DocumentType.BILL : DocumentType.INVOICE).setDocumentId(docId.intValue()).setSendTime(LocalDateTime.now()).setSendMode(DocumentSendMode.EMAIL).setSendUserId(this.userId);
                try {
                    EmailMaster emailMaster = new EmailMaster(this.setup, con, this.moduleId, this.userId);
                    emailMaster.setDocumentId(this.docType, docId);
                    emailMaster.setContractId(-1);
                    try {
                        billDocSendLog.setSendAddress(emailMaster.getEmail());
                    }
                    catch (Exception ex) {
                        billDocSendLog.setSendAddress("\u043d\u0435 \u0437\u0430\u0434\u0430\u043d");
                    }
                    MailData mailData = new MailDocsSender().setDocType(this.docType).setDocId(docId).setModuleId(this.moduleId).setRecipients(emailMaster.getEmail()).setSubject(emailMaster.getSubject());
                    emailMaster.addMessage(mailData, "text");
                    emailMaster.addAttach(mailData, "file1");
                    new MailMsg((Preferences)this.setup).sendMessage(mailData);
                    billDocSendLog.setSendStatus("OK");
                    ++countSend;
                }
                catch (Exception ex) {
                    billDocSendLog.setSendStatus("ERROR").setSendStatusMessage(ex.getLocalizedMessage());
                    this.getLogger().error("error send document " + String.valueOf(this.docType) + "#" + docId, (Throwable)ex);
                }
                billDocSendLogDao.update(billDocSendLog);
            }
            this.getLogger().info("Send {} of {}", (Object)countSend, (Object)countAll);
        }
        catch (Exception ex) {
            this.getLogger().error("error bill docs sender task", (Throwable)ex);
        }
    }
}

