/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server.tasks;

import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubscription;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubscriptionStatusPeriod;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoSubscription;
import ru.bitel.bgbilling.modules.megogo.server.MegogoApi;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoContractSubscriptionDao;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoContractSubscriptionStatusPeriodDao;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoSubscriptionDao;
import ru.bitel.common.model.Period;

public class ChangeSubscriptionTask
extends TaskBase {
    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        try (Connection con = this.setup.getDBConnectionFromPool();){
            MegogoSubscriptionDao megogoSubscriptionDao = new MegogoSubscriptionDao(con, this.moduleId);
            MegogoContractSubscriptionDao megogoContractSubDao = new MegogoContractSubscriptionDao(con, this.moduleId);
            MegogoContractSubscriptionStatusPeriodDao statusPeriodDao = new MegogoContractSubscriptionStatusPeriodDao(con, this.moduleId);
            String typeTask = this.taskSetup.get("task.type", "all").toLowerCase();
            int minusHour = this.taskSetup.getInt("hour.minus", 0);
            Calendar time = Calendar.getInstance();
            time.add(11, minusHour * -1);
            Date now = new Date();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("task.type = " + typeTask);
                this.getLogger().debug("hour.minus = " + minusHour);
                this.getLogger().debug("time = " + String.valueOf(time.getTime()));
            }
            if (typeTask.equals("all") || typeTask.equals("disconnect")) {
                boolean disconnectInclusive = this.taskSetup.getBoolean("disconnect.inclusive", false);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("disconnect.inclusive = " + disconnectInclusive);
                }
                for (MegogoContractSubscription contractSubscription : megogoContractSubDao.getSubscriptionsForClose(time.getTime(), disconnectInclusive)) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("contractSubscription = " + String.valueOf(contractSubscription));
                    }
                    try {
                        this.requestToMegogo(contractSubscription, 2, megogoSubscriptionDao, megogoContractSubDao, con);
                        List<MegogoContractSubscriptionStatusPeriod> list = statusPeriodDao.getList(contractSubscription.getId(), 4, true, (Period)null);
                        if (list.size() <= 0) continue;
                        MegogoContractSubscriptionStatusPeriod statusPeriod = list.get(0);
                        statusPeriod.setDateTo(now);
                        statusPeriodDao.update(statusPeriod);
                    }
                    catch (Exception e) {
                        this.getLogger().error(e.getMessage() + " cid=" + contractSubscription.getContractId() + " contrSubId=" + contractSubscription.getId(), (Throwable)e);
                    }
                }
            }
            if (typeTask.equals("all") || typeTask.equals("open")) {
                boolean openInclusive = this.taskSetup.getBoolean("open.inclusive", true);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("open.inclusive = " + openInclusive);
                }
                for (MegogoContractSubscription contractSubscription : megogoContractSubDao.getSubscriptionsForOpen(time.getTime(), openInclusive)) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("contractSubscription = " + String.valueOf(contractSubscription));
                    }
                    try {
                        this.requestToMegogo(contractSubscription, 0, megogoSubscriptionDao, megogoContractSubDao, con);
                    }
                    catch (Exception e) {
                        this.getLogger().error(e.getMessage() + " cid=" + contractSubscription.getContractId() + " contrSubId=" + contractSubscription.getId(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            this.error = e;
        }
    }

    private void requestToMegogo(MegogoContractSubscription contractSub, int operation, MegogoSubscriptionDao megogoSubscriptionDao, MegogoContractSubscriptionDao megogoContractSubDao, Connection con) throws Exception {
        MegogoApi megogoApi = new MegogoApi(this.moduleId, 0, con, contractSub.getId());
        MegogoSubscription subscription = megogoSubscriptionDao.getByServiceId(contractSub.getServiceId());
        if (subscription == null) {
            this.getLogger().error("ERROR! NOT FOUND SUBSCRIPTION serviceId=" + contractSub.getServiceId() + " cid=" + contractSub.getContractId());
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("requestToMegogo: operation = " + operation);
        }
        if (operation == 0) {
            megogoApi.subscribe(contractSub.getContractId(), subscription);
            megogoContractSubDao.updateDateActivated(contractSub.getId(), new Date());
        } else if (operation == 2) {
            megogoApi.unsubscribe(contractSub, subscription);
            megogoContractSubDao.updateDateDeactivated(contractSub.getId(), new Date());
        }
        contractSub.setStatus(operation);
        contractSub.setUserId(0);
        megogoContractSubDao.update(contractSub);
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c Megogo. \u0417\u0430\u0434\u0430\u0447\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043e\u043a. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId;
    }
}

