/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.client.directory;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.plugins.documents.client.directory.DirectoryTableModel;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentType;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.Id;

public class TypeEditor
extends BGUPanel {
    private BGUTable typeTable;
    private TypeTableModel typeTableModel = new TypeTableModel();

    protected void jbInit() throws Exception {
        this.typeTable = new BGUTable((TableModel)((Object)this.typeTableModel));
        this.typeTable.setSelectionMode(0);
        this.typeTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    TypeEditor.this.performAction("delete");
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.typeTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.typeTableModel.setData(((ClientContext)this.getContext()).getDirectory(DocumentType.class).list()));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            List list = this.typeTableModel.getRows();
            if (list.size() == 0 || ((DocumentType)list.get(list.size() - 1)).getId() > 0) {
                this.typeTableModel.addRow(new DocumentType());
                this.typeTable.repaint();
                this.typeTable.updateUI();
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            DocumentType selectedRow = (DocumentType)this.typeTableModel.getSelectedRow();
            if (selectedRow.getId() > 0) {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u0441\u0442\u0440\u043e\u043a\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0440\u043e\u043a\u0438", 0) == 0) {
                    ((ClientContext)this.getContext()).getDirectory(DocumentType.class).delete(selectedRow.getId());
                }
            } else if (selectedRow.getId() == 0) {
                this.typeTableModel.deleteSelectedRows();
            } else {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                return;
            }
            this.performAction("refresh");
        });
    }

    class TypeTableModel
    extends DirectoryTableModel<DocumentType> {
        public TypeTableModel() {
            super(TypeEditor.class.getName());
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            DocumentType val = (DocumentType)this.getSelectedRow();
            String oldValue = val.getTitle();
            String newValue = (String)value;
            if (Utils.notBlankString((String)newValue)) {
                if (oldValue != null && oldValue.equals(newValue)) {
                    return;
                }
                val.setTitle(newValue);
                try {
                    ((ClientContext)TypeEditor.this.getContext()).getDirectory(DocumentType.class).update((Id)val);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            TypeEditor.this.performAction("refresh");
        }
    }
}

