/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.filestorage.common.bean;

import java.util.Date;
import java.util.Objects;
import org.json.JSONObject;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Idable;

public class BGServerFile
implements Idable,
Cloneable {
    private int id;
    private int ownerId;
    private int contractId;
    private int userId = -1;
    private long size = -1L;
    private Date date = null;
    private String title = null;
    private String comment = null;
    private String uuid = "";

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(int ownerId) {
        this.ownerId = ownerId;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public int getContractId() {
        return this.contractId;
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public BGServerFile clone() {
        try {
            BGServerFile copy = (BGServerFile)super.clone();
            copy.setId(0);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void toJSON(BGServerFile bgServerFile, JSONObject jsonObject) {
        Objects.requireNonNull(jsonObject);
        Objects.requireNonNull(bgServerFile);
        jsonObject.put("id", bgServerFile.getId());
        jsonObject.put("ownerId", bgServerFile.getOwnerId());
        jsonObject.put("contractId", bgServerFile.getContractId());
        jsonObject.put("userId", bgServerFile.getUserId());
        jsonObject.put("size", bgServerFile.getSize());
        jsonObject.put("date", (Object)TimeUtils.format((Date)bgServerFile.getDate(), (String)"dd.MM.yyyy HH:mm:ss"));
        jsonObject.put("title", (Object)bgServerFile.getTitle());
        jsonObject.put("comment", (Object)bgServerFile.getComment());
        jsonObject.put("uuid", (Object)bgServerFile.getUuid());
    }

    public static void fromJSON(JSONObject jsonObject, BGServerFile bgServerFile) {
        Objects.requireNonNull(jsonObject);
        Objects.requireNonNull(bgServerFile);
        bgServerFile.setId(jsonObject.optInt("id"));
        bgServerFile.setOwnerId(jsonObject.optInt("ownerId"));
        bgServerFile.setContractId(jsonObject.optInt("contractId"));
        bgServerFile.setUserId(jsonObject.optInt("userId"));
        bgServerFile.setSize(jsonObject.optLong("size"));
        bgServerFile.setDate(TimeUtils.parseDate((String)jsonObject.optString("date"), (String)"dd.MM.yyyy HH:mm:ss"));
        bgServerFile.setTitle(jsonObject.optString("title"));
        bgServerFile.setComment(jsonObject.optString("comment"));
        bgServerFile.setUuid(jsonObject.optString("uuid"));
    }
}

