/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.script.common.bean.ContractScript;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class ContractScriptManager {
    private Connection con;

    public ContractScriptManager(Connection con) {
        this.con = con;
    }

    public List<ContractScript> getContractScriptList(int contractId) {
        ArrayList<ContractScript> result = new ArrayList<ContractScript>();
        try {
            String query = "SELECT * FROM contract_script WHERE cid=? ORDER BY date1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ContractScript script = new ContractScript();
                ContractScriptManager.loadFromRS(script, rs);
                result.add(script);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<ContractScript> getContractScriptList(int contractId, Calendar date) {
        ArrayList<ContractScript> result = new ArrayList<ContractScript>();
        String query = "SELECT * FROM contract_script WHERE cid=? AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ContractScript contractScript = new ContractScript();
                ContractScriptManager.loadFromRS(contractScript, rs);
                result.add(contractScript);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public ContractScript getContractScriptById(int id) {
        ContractScript result = null;
        try {
            String query = "SELECT * FROM contract_script WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new ContractScript();
                ContractScriptManager.loadFromRS(result, rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public ContractScript getContractScriptByID(int id) {
        return this.getContractScriptById(id);
    }

    public ContractScript getContractScriptByScriptId(int cid, int scriptId) {
        ContractScript result = null;
        try {
            String query = "SELECT * FROM contract_script WHERE cid=? AND script_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, scriptId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new ContractScript();
                ContractScriptManager.loadFromRS(result, rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public ContractScript getContractScriptByScriptID(int cid, int scriptId) {
        return this.getContractScriptByScriptId(cid, scriptId);
    }

    public void updateContractScript(ContractScript contractScript) throws BGException {
        Objects.requireNonNull(contractScript, "contractScript must be not null");
        try {
            String query = null;
            PreparedStatement ps = null;
            boolean isInsert = contractScript.getId() < 1;
            query = (isInsert ? "INSERT INTO " : "UPDATE ") + "contract_script SET cid=?, date1=?, date2=?, script_id=?, comment=?" + (isInsert ? "" : " WHERE id=?");
            ps = this.con.prepareStatement(query, 1);
            ps.setInt(1, contractScript.getContractId());
            Period period = contractScript.getPeriod();
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)(period != null ? period.getDateFrom() : null)));
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)(period != null ? period.getDateTo() : null)));
            ps.setInt(4, contractScript.getScriptId());
            ps.setString(5, contractScript.getComment() == null ? "" : contractScript.getComment());
            if (!isInsert) {
                ps.setInt(6, contractScript.getId());
            }
            ps.executeUpdate();
            contractScript.setId(isInsert ? ServerUtils.lastInsertId(ps) : contractScript.getId());
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deleteContractScript(int id) {
        try {
            String query = "DELETE FROM contract_script WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteScript(int scriptId) {
        try {
            String query = "DELETE FROM contract_script WHERE script_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, scriptId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteScript(int scriptId, List<Integer> cids) {
        if (cids == null || cids.isEmpty()) {
            return;
        }
        try {
            String query = "DELETE FROM contract_script WHERE script_id=? AND cid IN (" + Utils.toString(cids) + ")";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, scriptId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void loadFromRS(ContractScript contractScript, ResultSet rs) throws SQLException {
        contractScript.setId(rs.getInt("id"));
        contractScript.setContractId(rs.getInt("cid"));
        contractScript.setPeriod(new Period((Date)rs.getDate("date1"), (Date)rs.getDate("date2")));
        contractScript.setScriptId(rs.getInt("script_id"));
        contractScript.setComment(rs.getString("comment"));
    }
}

