/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.im.client;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.plugin.client.inpoint.OnDestroyClient;
import ru.bitel.bgbilling.kernel.plugin.client.inpoint.OnStart;
import ru.bitel.bgbilling.kernel.plugin.client.inpoint.OnStop;
import ru.bitel.bgbilling.plugins.im.client.IMManager;
import ru.bitel.bgbilling.plugins.im.client.bean.IMButton;
import ru.bitel.bgbilling.plugins.im.common.IMConstants;

public class PluginClientListener
implements OnStart,
OnStop,
OnDestroyClient {
    public static IMManager imManager = null;
    private static final String USER_CONFIG_STATUS_KEY = "ru.bitel.bgbilling.plugins.im.STATUS";
    private static final String USER_CONFIG_ROSTER_KEY = "ru.bitel.bgbilling.plugins.im.ROSTER.JSON";
    public static IMButton toolbarIMButton = null;
    public static Map<IMConstants.STATUS, Icon> statusIcon = new HashMap<IMConstants.STATUS, Icon>();
    public static Icon emailIcon = ClientUtils.getIcon((String)"ru.bitel.bgbilling.plugins.im.client.img", (String)"email", (boolean)true);

    public void onStart() {
        imManager = new IMManager();
        try {
            String statusKey = ClientSetup.getInstance().getUserConfig().get(USER_CONFIG_STATUS_KEY, null);
            if (statusKey != null) {
                imManager.tryConnect(IMConstants.STATUS.valueOf((String)statusKey));
            }
            imManager.setRosterJson(ClientSetup.getInstance().getUserConfig().get(USER_CONFIG_ROSTER_KEY, null));
        }
        catch (Throwable ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void onStop() {
        if (imManager != null) {
            try {
                ClientSetup setup = ClientSetup.getInstance();
                IMConstants.STATUS status = imManager.getComboBoxStatus();
                setup.getUserConfig().set(USER_CONFIG_STATUS_KEY, status != null ? status.toString() : null);
                setup.getUserConfig().set(USER_CONFIG_ROSTER_KEY, imManager.getRosterJson());
                setup.saveUserConfig();
                imManager.tryConnect(IMConstants.STATUS.OFFLINE);
            }
            catch (Throwable ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    public void onDestroyClient() {
        this.onStop();
    }

    static {
        statusIcon.put(IMConstants.STATUS.ONLINE, ClientUtils.getIcon((String)"ru.bitel.bgbilling.plugins.im.client.img", (String)"status_online", (boolean)true));
        statusIcon.put(IMConstants.STATUS.AWAY, ClientUtils.getIcon((String)"ru.bitel.bgbilling.plugins.im.client.img", (String)"status_away", (boolean)true));
        statusIcon.put(IMConstants.STATUS.DND, ClientUtils.getIcon((String)"ru.bitel.bgbilling.plugins.im.client.img", (String)"status_busy", (boolean)true));
        statusIcon.put(IMConstants.STATUS.OFFLINE, ClientUtils.getIcon((String)"ru.bitel.bgbilling.plugins.im.client.img", (String)"status_offline", (boolean)true));
    }
}

