/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.bean;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.ws.Holder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.license.common.bean.AdditionalAgreement;
import ru.bitel.bgbilling.modules.license.common.bean.ContractData;
import ru.bitel.bgbilling.modules.license.common.bean.License;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseComponent;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseCopy;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrder;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrderConfirmed;
import ru.bitel.bgbilling.modules.license.common.bean.SpecificationTitle;
import ru.bitel.bgbilling.modules.license.common.bean.enums.LicenseOrderType;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseComponentDao;
import ru.bitel.bgbilling.modules.license.server.utils.LicenseUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstarctDaoConstant;
import ru.bitel.common.model.Result;

public class LicenseManager
extends AbstarctDaoConstant {
    protected Connection con = null;
    protected int moduleId;

    public LicenseManager(Connection con, int moduleId) {
        this.con = con;
        this.moduleId = moduleId;
    }

    public void deleteProduct(int productId) {
        String query = "DELETE  FROM lic_product_" + this.moduleId + " WHERE  id=?";
        String queryDelete = "DELETE  FROM  lic_product_component_" + this.moduleId + " WHERE product_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);
             PreparedStatement psDelete = this.con.prepareStatement(queryDelete);){
            ps.setInt(1, productId);
            int affectedRows = ps.executeUpdate();
            if (affectedRows > 0) {
                psDelete.setInt(1, productId);
                psDelete.executeUpdate();
            }
        }
        catch (SQLException ex) {
            this.getLogger().error("deleteProduct( " + productId + " )", (Throwable)ex);
        }
    }

    public int getOrdersCountOnProduct(int productId) {
        int copiesCount = 0;
        StringBuilder query = new StringBuilder().append("SELECT ").append(" COUNT(*)").append(" FROM ").append(" lic_copy_" + this.moduleId).append(" WHERE ").append(" product_id=? ");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, productId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    copiesCount = rs.getInt(1);
                }
            }
        }
        catch (SQLException e) {
            this.getLogger().error(" getOrdersCountOnProduct( " + productId + " ) ", (Throwable)e);
        }
        return copiesCount;
    }

    public void deleteComponent(int id) throws SQLException {
        if (new LicenseComponentDao(this.con, this.moduleId).delete(id) > 0) {
            StringBuilder query = new StringBuilder().append("DELETE ").append(" FROM ").append(" lic_product_component_" + this.moduleId).append(" WHERE ").append(" component_id=? ");
            try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
                ps.setInt(1, id);
                ps.executeUpdate();
            }
        }
    }

    public int getOrdersCountOnComponent(int componentId) {
        int ordersCount = 0;
        String query = "SELECT  COUNT(*) FROM  lic_order_" + this.moduleId + " WHERE component_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, componentId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    ordersCount = rs.getInt(1);
                }
            }
        }
        catch (SQLException e) {
            this.getLogger().error(" getOrdersCountOnProductItem( " + componentId + " ) ", (Throwable)e);
        }
        return ordersCount;
    }

    public void linkComponentToProduct(int productId, int componentId) {
        String query = "INSERT INTO  lic_product_component_" + this.moduleId + " SET product_id=?, component_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, productId);
            ps.setInt(2, componentId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.getLogger().error("linkProductItemToProduct( " + productId + ", " + componentId + " )", (Throwable)e);
        }
    }

    public void unlinkComponentFromProduct(int productId, int componentId) {
        try {
            StringBuilder query = new StringBuilder();
            query.append("DELETE ");
            query.append(" FROM ");
            query.append(" lic_product_component_" + this.moduleId);
            query.append(" WHERE ");
            query.append(" product_id=? AND component_id=? ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, productId);
            ps.setInt(2, componentId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            this.getLogger().error("unlinkProductItemFromProduct( " + productId + ", " + componentId + " )", (Throwable)e);
        }
    }

    public void updateCopy(LicenseCopy copy) {
        if (copy != null) {
            try {
                int index = 1;
                StringBuilder query = new StringBuilder();
                PreparedStatement ps = null;
                if (copy.getId() > 0) {
                    query.append("UPDATE ").append(" lic_copy_" + this.moduleId);
                    query.append(" SET contract_id=?, product_id=?, licensee_name=?, comment=?");
                    query.append(" WHERE id=? AND (contract_id<>? OR product_id<>? OR licensee_name<>? OR comment<>?)");
                    ps = this.con.prepareStatement(query.toString());
                    ps.setInt(index++, copy.getContractId());
                    ps.setInt(index++, copy.getProductId());
                    ps.setString(index++, copy.getLicenseName());
                    ps.setString(index++, copy.getComment());
                    ps.setInt(index++, copy.getId());
                    ps.setInt(index++, copy.getContractId());
                    ps.setInt(index++, copy.getProductId());
                    ps.setString(index++, copy.getLicenseName());
                    ps.setString(index++, copy.getComment());
                    ps.executeUpdate();
                    ps.close();
                } else {
                    query.append("INSERT INTO ");
                    query.append(" lic_copy_" + this.moduleId);
                    query.append(" SET contract_id=?, product_id=?, licensee_name=?, comment=?, dt=now()");
                    ps = this.con.prepareStatement(query.toString(), 1);
                    ps.setInt(index++, copy.getContractId());
                    ps.setInt(index++, copy.getProductId());
                    ps.setString(index++, copy.getLicenseName());
                    ps.setString(index++, copy.getComment());
                    ps.executeUpdate();
                    copy.setId(this.lastInsertId(ps));
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.getLogger().error("updateCopy( " + String.valueOf(copy) + ")", (Throwable)e);
            }
        }
    }

    public boolean deleteCopy(int copyId) throws SQLException {
        String query = "DELETE FROM  lic_copy_" + this.moduleId + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, copyId);
            boolean bl = ps.executeUpdate() > 0;
            return bl;
        }
    }

    public LicenseCopy getCopy(int copyId) throws BGException {
        LicenseCopy copy = null;
        String query = "SELECT  tc.id, tc.contract_id, tc.product_id, tc.dt, tc.licensee_name, tc.comment, tc.lu, tp.title, tp.version  FROM  lic_copy_" + this.moduleId + " as tc  JOIN lic_product_" + this.moduleId + " as tp ON tc.product_id=tp.id  WHERE  tc.id=? ";
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, copyId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    copy = this.getCopyFromRs(rs);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return copy;
    }

    public void updateCopyItem(LicenseOrderConfirmed copyItem) {
        if (copyItem == null) {
            return;
        }
        try {
            int index = 1;
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            if (copyItem.getId() > 0) {
                query.append("UPDATE ");
                query.append(" lic_confirmed_order_" + this.moduleId);
                query.append(" SET to_date=?");
                query.append(" WHERE id=? ");
                ps = this.con.prepareStatement(query.toString());
                ps.setTimestamp(index++, new Timestamp(copyItem.getDateTo().getTime()));
                ps.setInt(index++, copyItem.getId());
                ps.executeUpdate();
            } else {
                query.append("INSERT INTO ");
                query.append(" lic_confirmed_order_" + this.moduleId);
                query.append(" SET order_id=?, to_date=? ");
                ps = this.con.prepareStatement(query.toString(), 1);
                ps.setInt(index++, copyItem.getOrderId());
                ps.setTimestamp(index++, new Timestamp(copyItem.getDateTo().getTime()));
                ps.executeUpdate();
                copyItem.setId(this.lastInsertId(ps));
            }
            ps.close();
        }
        catch (SQLException ex) {
            this.getLogger().error("updateCopyItem( " + String.valueOf(copyItem) + " )", (Throwable)ex);
        }
    }

    public void updateCopyItemOrder(LicenseOrder order) throws BGException, BGMessageException {
        this.updateCopyItemOrder(order, true);
    }

    public void updateCopyItemOrder(LicenseOrder order, boolean updateConfirmed) throws BGException, BGMessageException {
        if (order != null) {
            try {
                this.updateOrder(order);
                if (updateConfirmed) {
                    int confirmedId = this.getConfirmedId(order.getId());
                    if (order.getStatus() == 3 || order.getStatus() == 2) {
                        LicenseOrderConfirmed confirmed = new LicenseOrderConfirmed();
                        confirmed.setId(confirmedId);
                        confirmed.setOrderId(order.getId());
                        confirmed.setDateTo(this.convertToLicenseDate(null, order));
                        this.updateCopyItem(confirmed);
                    }
                }
            }
            catch (SQLException ex) {
                this.getLogger().error("updateCopyItemOrder( " + String.valueOf(order) + " )", (Throwable)ex);
            }
        }
    }

    public void updateCopyItemOrder(LicenseOrder order, Date copyItemToDate) throws BGException, BGMessageException {
        if (order == null) {
            return;
        }
        try {
            this.updateOrder(order);
            int confirmedId = this.getConfirmedId(order.getId());
            if (order.getStatus() == 3 || order.getStatus() == 2) {
                LicenseOrderConfirmed confirmed = new LicenseOrderConfirmed();
                confirmed.setId(confirmedId);
                confirmed.setOrderId(order.getId());
                confirmed.setDateTo(this.convertToLicenseDate(copyItemToDate, order));
                this.updateCopyItem(confirmed);
            } else {
                this.setOrderUnconfirmed(order);
            }
        }
        catch (SQLException ex) {
            this.getLogger().error("updateCopyItemOrder( " + String.valueOf(order) + " )", (Throwable)ex);
        }
    }

    private void updateOrder(LicenseOrder order) throws SQLException, BGException, BGMessageException {
        StringBuilder query = new StringBuilder();
        PreparedStatement ps = null;
        int index = 1;
        try {
            if (order.getType() == LicenseOrderType.BUY && order.getCount() != 0) {
                List<LicenseOrderType> orderTypes = Stream.of(order.getType()).toList();
                List<Integer> statusIds = Stream.of(0, 2).toList();
                List<LicenseOrder> list = this.getOrders(order.getCopyId(), orderTypes, statusIds, order.getComponentId());
                int allCount = order.getCount();
                for (LicenseOrder ord : list) {
                    if (order.getId() != 0 && (order.getId() <= 0 || ord.getId() == order.getId())) continue;
                    allCount += ord.getCount();
                }
                String ver = this.getCopy(order.getCopyId()).getProductVersion();
                String compName = ((LicenseComponent)new LicenseComponentDao(this.con, this.moduleId).get(order.getComponentId())).getName();
                String costUrl = LicenseUtils.buildLicenseCostUrlRequest(compName, 1, ver, (Preferences)Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)));
                Holder holderUnlimCount = new Holder((Object)-1);
                LicenseUtils.getCost(costUrl, (Holder<Integer>)holderUnlimCount);
                if ((Integer)holderUnlimCount.value > 0 && allCount > (Integer)holderUnlimCount.value) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430!!! \u041e\u0431\u0449\u0435\u0435 \u043a\u043e\u043b-\u0432\u043e \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0439 \u0434\u043b\u044f " + compName + " \u0440\u0430\u0432\u043d\u043e " + allCount + ", \u0447\u0442\u043e \u0431\u043e\u043b\u044c\u0448\u0435 " + String.valueOf(holderUnlimCount.value) + ", \u043d\u0443\u0436\u043d\u043e \u0437\u0430\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043d\u043e!");
                }
            }
        }
        catch (Exception e) {
            if (e instanceof BGMessageException) {
                throw e;
            }
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        if (order.getId() > 0) {
            query.append("UPDATE ");
            query.append(" lic_order_" + this.moduleId);
            query.append(" SET copy_id=?, component_id=?, user_id=?, type=?, term=?, count=?, status=?, lu=now() ");
            query.append(" WHERE id=? AND ( copy_id<>? OR component_id<>? OR user_id<>? OR type<>? OR term<>? OR count<>? OR status<>? )");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(index++, order.getCopyId());
            ps.setInt(index++, order.getComponentId());
            ps.setInt(index++, order.getUserId());
            ps.setInt(index++, order.getType().getCode());
            ps.setInt(index++, order.getTerm());
            ps.setInt(index++, order.getCount());
            ps.setInt(index++, order.getStatus());
            ps.setInt(index++, order.getId());
            ps.setInt(index++, order.getCopyId());
            ps.setInt(index++, order.getComponentId());
            ps.setInt(index++, order.getUserId());
            ps.setInt(index++, order.getType().getCode());
            ps.setInt(index++, order.getTerm());
            ps.setInt(index++, order.getCount());
            ps.setInt(index++, order.getStatus());
            ps.executeUpdate();
        } else {
            query.append("INSERT INTO ");
            query.append(" lic_order_" + this.moduleId);
            query.append(" SET copy_id=?, component_id=?, user_id=?, type=?, term=?, count=?, status=?, create_date=now() ");
            ps = this.con.prepareStatement(query.toString(), 1);
            ps.setInt(index++, order.getCopyId());
            ps.setInt(index++, order.getComponentId());
            ps.setInt(index++, order.getUserId());
            ps.setInt(index++, order.getType().getCode());
            ps.setInt(index++, order.getTerm());
            ps.setInt(index++, order.getCount());
            ps.setInt(index++, order.getStatus());
            ps.executeUpdate();
            order.setId(this.lastInsertId(ps));
        }
    }

    private Date convertToLicenseDate(Date date, LicenseOrder order) {
        if (date != null) {
            return date;
        }
        if (date == null) {
            if (order.getType() == LicenseOrderType.TEST) {
                Date today = new Date();
                long time = today.getTime();
                date = new Date(time += 86400000L * (long)order.getTerm());
            } else if (order.getType() == LicenseOrderType.BUY) {
                date = new GregorianCalendar(2050, 11, 30).getTime();
            }
        }
        return date;
    }

    private void setOrderUnconfirmed(LicenseOrder order) {
        if (order == null) {
            return;
        }
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append("DELETE ");
            query.append(" FROM ");
            query.append(" lic_confirmed_order_");
            query.append(" WHERE ");
            query.append(" order_id=? ");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, order.getId());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            this.getLogger().error("deleteCopyItemForOrder( " + String.valueOf(order) + " )", (Throwable)e);
        }
    }

    private int getConfirmedId(int orderId) {
        if (orderId < 0) {
            return -1;
        }
        int res = -1;
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append("SELECT ");
            query.append(" id, order_id ");
            query.append(" FROM ");
            query.append(" lic_confirmed_order_" + this.moduleId + " as orders ");
            query.append(" WHERE ");
            query.append(" order_id=? ");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, orderId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                res = rs.getInt("id");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            this.getLogger().error("isOrderConfirmed( " + orderId + " )", (Throwable)ex);
        }
        return res;
    }

    public int getOrderStatus(int id) {
        int status = 0;
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append("SELECT ");
            query.append(" status ");
            query.append(" FROM ");
            query.append(" lic_order_" + this.moduleId);
            query.append(" WHERE ");
            query.append(" id=? ");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                status = rs.getInt("status");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            this.getLogger().error("getOrderStatus( " + id + " )", (Throwable)ex);
        }
        return status;
    }

    public int getOrderType(int id) {
        int type = 0;
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append("SELECT ");
            query.append(" type ");
            query.append(" FROM ");
            query.append(" lic_order_" + this.moduleId);
            query.append(" WHERE ");
            query.append(" id=? ");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                type = rs.getInt("type");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            this.getLogger().error("getOrderType( " + id + " )", (Throwable)ex);
        }
        return type;
    }

    public List<LicenseOrder> getOrders(int copyId, List<LicenseOrderType> filterTypes, List<Integer> statusIds, int filterComponentItemId) {
        ArrayList<LicenseOrder> orders = new ArrayList<LicenseOrder>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(" orders.id, orders.copy_id, orders.component_id, orders.type, orders.term, orders.count, orders.status, orders.create_date, orders.user_id, orders.lu, productItems.title as product_item_title, productItems.name as product_item_name, users.name as user_name");
        query.append(" FROM ").append(" lic_order_" + this.moduleId + " as orders ");
        query.append(" JOIN ").append("lic_component_" + this.moduleId + " as productItems ").append(" ON orders.component_id=productItems.id");
        query.append(" LEFT JOIN ").append(" user as users ").append(" ON orders.user_id=users.id");
        query.append(" WHERE ").append(" orders.copy_id=? ");
        if (!Utils.isEmptyCollection(filterTypes)) {
            query.append(" AND orders.type IN (" + Utils.toString(filterTypes.stream().map(a -> a.getCode()).toList()) + ")");
        }
        if (!Utils.isEmptyCollection(statusIds)) {
            query.append(" AND orders.status IN (" + Utils.toString(statusIds) + ")");
        }
        if (filterComponentItemId >= 0) {
            query.append(" AND orders.component_id=" + filterComponentItemId);
        }
        query.append(" ORDER BY orders.create_date DESC, product_item_title");
        try (PreparedStatement psSelect = this.con.prepareStatement(query.toString());){
            psSelect.setInt(1, copyId);
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    orders.add(this.getOrderFromRs(rs));
                }
            }
        }
        catch (SQLException ex) {
            this.getLogger().error("getCopyItemOrders( " + copyId + " )", (Throwable)ex);
        }
        return orders;
    }

    public List<LicenseOrder> getOrders(int copyId, String filterPermanentStatus, String filterTestStatus, int filterComponentItemId) {
        ArrayList<LicenseOrder> orders = new ArrayList<LicenseOrder>();
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append("SELECT ");
            query.append(" orders.id, orders.copy_id, orders.component_id, orders.type, orders.term, orders.count, orders.status, orders.create_date, orders.user_id, orders.lu, productItems.title as product_item_title, productItems.name as product_item_name, users.name as user_name");
            query.append(" FROM ").append(" lic_order_" + this.moduleId + " as orders ");
            query.append(" JOIN ").append("lic_component_" + this.moduleId + " as productItems ").append(" ON orders.component_id=productItems.id");
            query.append(" LEFT JOIN ").append(" user as users ").append(" ON orders.user_id=users.id");
            query.append(" WHERE ").append(" orders.copy_id=? ");
            if (!Utils.isBlankString((String)filterTestStatus) || !Utils.isBlankString((String)filterPermanentStatus)) {
                query.append(" AND (");
                if (!Utils.isBlankString((String)filterTestStatus)) {
                    query.append(" (orders.type=0 AND orders.status in (" + filterTestStatus + ")) ");
                }
                if (!Utils.isBlankString((String)filterPermanentStatus) && !Utils.isBlankString((String)filterTestStatus)) {
                    query.append(" OR ");
                }
                if (!Utils.isBlankString((String)filterPermanentStatus)) {
                    query.append("(orders.type=1 AND orders.status in (" + filterPermanentStatus + ")) ");
                }
                query.append(")");
            }
            if (filterComponentItemId >= 0) {
                query.append(" AND orders.component_id=" + filterComponentItemId);
            }
            query.append(" ORDER BY orders.create_date DESC, product_item_title");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, copyId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    orders.add(this.getOrderFromRs(rs));
                }
            }
            ps.close();
        }
        catch (SQLException ex) {
            this.getLogger().error("getCopyItemOrders( " + copyId + " )", (Throwable)ex);
        }
        return orders;
    }

    public List<LicenseOrder> getOrders(int copyId) {
        return this.getOrders(copyId, new ArrayList<LicenseOrderType>(), null, -1);
    }

    public LicenseOrder getOrder(int orderId) {
        LicenseOrder order = null;
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(" orders.id, orders.copy_id, orders.component_id, orders.type, orders.term, orders.count, orders.status, orders.create_date, orders.user_id, orders.lu, pi.title as product_item_title, pi.name as product_item_name, users.name as user_name");
        query.append(" FROM ");
        query.append(" lic_order_" + this.moduleId + " as orders ");
        query.append(" JOIN ");
        query.append("lic_component_" + this.moduleId + " as pi ");
        query.append(" ON orders.component_id=pi.id");
        query.append(" LEFT JOIN ");
        query.append(" user as users ");
        query.append(" ON orders.user_id=users.id");
        query.append(" WHERE ");
        query.append(" orders.id=? ");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, orderId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    order = this.getOrderFromRs(rs);
                }
            }
        }
        catch (SQLException ex) {
            this.getLogger().error("getCopyItemOrder( " + orderId + " )", (Throwable)ex);
        }
        return order;
    }

    public void createTestCopiesForOrder(LicenseOrder order, int term, int count) throws BGException, BGMessageException {
        order.setId(0);
        order.setTerm(term);
        order.setCount(count);
        order.setType(LicenseOrderType.TEST);
        this.updateCopyItemOrder(order);
    }

    public void deleteOrder(int orderId) {
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append("DELETE ");
            query.append(" FROM ");
            query.append(" lic_order_" + this.moduleId);
            query.append(" WHERE ");
            query.append(" id=? ");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, orderId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            this.getLogger().error("deleteOrder( " + orderId + " )", (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkCopyItemStatus(int copyItemId) {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(" status ");
        query.append(" FROM ");
        query.append(" lic_order_" + this.moduleId + " as orders ");
        query.append(" JOIN ");
        query.append(" lic_confirmed_order_" + this.moduleId + " as ci ");
        query.append(" ON ci.order_id=orders.id ");
        query.append(" WHERE ");
        query.append(" ci.id=? ");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, copyItemId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return false;
            int status = rs.getInt("status");
            if (status != 3) {
                if (status != 2) return false;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.getLogger().error("checkCopyItemStatus( " + copyItemId + " ) ", (Throwable)e);
        }
        return false;
    }

    public boolean checkHaveNonSignAdditionalAgreement(int copyId) throws BGException {
        LicenseCopy copy = this.getCopy(copyId);
        if (copy == null) {
            throw new BGIllegalArgumentException();
        }
        for (AdditionalAgreement aa : this.getListAdditionalAgreement(copy.getContractId(), copyId)) {
            if (aa.isSign()) continue;
            return true;
        }
        return false;
    }

    public int createLicense(License license) {
        int packageId = 0;
        if (license != null) {
            PreparedStatement ps;
            String query = "INSERT INTO  lic_license_" + this.moduleId + " SET copy_id=?, user_id=?, data=?, create_date=now()";
            try {
                ps = this.con.prepareStatement(query, 1);
                try {
                    int index = 1;
                    ps.setInt(index++, license.getCopyId());
                    ps.setInt(index++, license.getUserId());
                    ps.setString(index++, license.getData());
                    ps.executeUpdate();
                    packageId = this.lastInsertId(ps);
                    license.setId(packageId);
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception ex) {
                this.getLogger().error("createPackage( " + String.valueOf(license) + " )", (Throwable)ex);
            }
            query = "INSERT INTO  lic_license_component_" + this.moduleId + " SET license_id=?, component_id=? ";
            try {
                ps = this.con.prepareStatement(query);
                try {
                    ps.setInt(1, packageId);
                    int[] copyItemIds = license.getCopyItemIds();
                    for (int i = 0; i < copyItemIds.length; ++i) {
                        ps.setInt(2, copyItemIds[i]);
                        ps.executeUpdate();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception ex) {
                this.getLogger().error("createPackage( " + String.valueOf(license) + " )", (Throwable)ex);
            }
        }
        return packageId;
    }

    public void updateLicenseData(License lic) {
        if (lic != null) {
            try {
                int index = 1;
                PreparedStatement ps = null;
                StringBuilder query = new StringBuilder();
                query.append("UPDATE ");
                query.append(" lic_license_" + this.moduleId);
                query.append(" SET data=?, original_data=? ");
                query.append(" WHERE id=? ");
                ps = this.con.prepareStatement(query.toString());
                ps.setString(index++, lic.getData());
                ps.setString(index++, lic.getOriginalData());
                ps.setInt(index++, lic.getId());
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception ex) {
                this.getLogger().error("updatePackageData( " + String.valueOf(lic) + " )", (Throwable)ex);
            }
        }
    }

    public LicenseOrderConfirmed groupCopyItems(int productItemId, int copyId, int[] orderStatuses) {
        LicenseOrderConfirmed grouppedCopyItem = null;
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append("product.id, product.name, GROUP_CONCAT(ord.count) as counts ");
        query.append(" FROM ");
        query.append(" lic_order_" + this.moduleId + " as ord ");
        query.append(" JOIN ");
        query.append("lic_component_" + this.moduleId + " as product ");
        query.append(" ON ord.component_id=product.id ");
        query.append(" JOIN ");
        query.append(" lic_copy_" + this.moduleId + " as copy ");
        query.append(" ON ord.copy_id=copy.id ");
        query.append(" WHERE ");
        query.append(" ord.component_id=? AND ord.copy_id=? AND ord.type=1 ");
        for (int i = 0; i < orderStatuses.length; ++i) {
            if (i == 0) {
                query.append(" AND ( ");
            } else {
                query.append(" OR ");
            }
            query.append(" ord.status=" + orderStatuses[i] + " ");
            if (i != orderStatuses.length - 1) continue;
            query.append(" ) ");
        }
        query.append(" GROUP BY ");
        query.append(" ord.component_id ");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, productItemId);
            ps.setInt(2, copyId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    grouppedCopyItem = new LicenseOrderConfirmed();
                    grouppedCopyItem.setComponentId(rs.getInt(1));
                    grouppedCopyItem.setComponentName(rs.getString(2));
                    grouppedCopyItem.setCount(this.getCountFromBlob(rs.getString(3)));
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("groupCopyItems", (Throwable)e);
        }
        return grouppedCopyItem;
    }

    public List<License> getLicenses(int copyId) {
        ArrayList<License> licenses = new ArrayList<License>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(" pack.*, users.name ");
        query.append(" FROM ");
        query.append(" lic_license_" + this.moduleId + " as pack ");
        query.append(" LEFT JOIN ");
        query.append(" user as users ");
        query.append(" ON pack.user_id=users.id");
        query.append(" WHERE ");
        query.append(" copy_id=? ");
        query.append(" ORDER BY ");
        query.append(" create_date DESC ");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, copyId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    licenses.add(this.getLicenseFromRs(rs));
                }
            }
        }
        catch (SQLException e) {
            this.getLogger().error("getPackages( " + copyId + " )", (Throwable)e);
        }
        return licenses;
    }

    public License getCurrentLicense(int copyId) {
        License lic = new License();
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT ");
            query.append(" pack.*, users.name ");
            query.append(" FROM ");
            query.append(" lic_license_" + this.moduleId + " as pack ");
            query.append(" LEFT JOIN ");
            query.append(" user as users ");
            query.append(" ON pack.user_id=users.id");
            query.append(" WHERE ");
            query.append(" copy_id=? ");
            query.append(" ORDER BY ");
            query.append(" create_date DESC ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, copyId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                lic = this.getLicenseFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            this.getLogger().error("getCurrentLicense( " + copyId + " )", (Throwable)e);
        }
        return lic;
    }

    public License getLicenseById(int licenseId) {
        License lic = new License();
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT ");
            query.append(" pack.*, users.name ");
            query.append(" FROM ");
            query.append(" lic_license_" + this.moduleId + " as pack ");
            query.append(" LEFT JOIN ");
            query.append(" user as users ");
            query.append(" ON pack.user_id=users.id");
            query.append(" WHERE ");
            query.append(" pack.id=? ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, licenseId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                lic = this.getLicenseFromRs(rs);
            }
        }
        catch (SQLException e) {
            this.getLogger().error("getLicenseById( " + licenseId + " )", (Throwable)e);
        }
        return lic;
    }

    public List<LicenseOrderConfirmed> getLicenseItems(int licenseId, boolean testDateForNow) {
        ArrayList<LicenseOrderConfirmed> copyItems = new ArrayList<LicenseOrderConfirmed>();
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT ");
            query.append("GROUP_CONCAT(ci.id) as ids, ord.type, GROUP_CONCAT(ord.count) as counts, ci.to_date, pi.title as product_item_title, pi.name as product_item_name, ord.component_id ");
            query.append(" FROM ");
            query.append(" lic_license_component_" + this.moduleId + " as packi ");
            query.append(" JOIN ");
            query.append(" lic_confirmed_order_" + this.moduleId + " as ci ");
            query.append(" ON packi.component_id=ci.id ");
            query.append(" JOIN ");
            query.append(" lic_order_" + this.moduleId + " as ord ");
            query.append(" ON ci.order_id=ord.id ");
            query.append(" JOIN ");
            query.append("lic_component_" + this.moduleId + " as pi ");
            query.append(" ON ord.component_id=pi.id ");
            query.append(" WHERE ");
            query.append(" packi.license_id=? AND ord.type=? ");
            query.append(" GROUP BY ");
            query.append("component_id");
            query.append(" ORDER BY ");
            query.append("to_date DESC");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, licenseId);
            ps.setInt(2, LicenseOrderType.BUY.getCode());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                copyItems.add(this.getCopyItemFromRs(rs));
            }
            rs.close();
            ps.close();
            query = new StringBuilder();
            query.append("SELECT ");
            query.append("ci.id as ids, ord.type, ord.count as counts, ci.to_date, pi.title as product_item_title, pi.name as product_item_name, ord.component_id ");
            query.append(" FROM ");
            query.append(" lic_license_component_" + this.moduleId + " as packi ");
            query.append(" JOIN ");
            query.append(" lic_confirmed_order_" + this.moduleId + " as ci ");
            query.append(" ON packi.component_id=ci.id ");
            query.append(" JOIN ");
            query.append(" lic_order_" + this.moduleId + " as ord ");
            query.append(" ON ci.order_id=ord.id ");
            query.append(" JOIN ");
            query.append("lic_component_" + this.moduleId + " as pi ");
            query.append(" ON ord.component_id=pi.id ");
            query.append(" WHERE ");
            query.append(" packi.license_id=? AND ord.type=? " + (testDateForNow ? "and ci.to_date>=now() " : ""));
            query.append(" ORDER BY ");
            query.append("to_date DESC");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, licenseId);
            ps.setInt(2, LicenseOrderType.TEST.getCode());
            rs = ps.executeQuery();
            while (rs.next()) {
                copyItems.add(this.getCopyItemFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            this.getLogger().error("getLicenseItems( " + licenseId + ")", (Throwable)e);
        }
        return copyItems;
    }

    public List<LicenseCopy> getCopyList(int contractId) {
        ArrayList<LicenseCopy> copyList = new ArrayList<LicenseCopy>();
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT ");
            query.append(" tc.id, tc.contract_id, tc.product_id, tc.dt, tc.licensee_name, tc.comment, tc.lu, tp.title, tp.version ");
            query.append(" FROM ");
            query.append(" lic_copy_" + this.moduleId + " as tc ");
            query.append(" JOIN ");
            query.append("lic_product_" + this.moduleId + " as tp ");
            query.append(" ON tc.product_id=tp.id ");
            query.append(" WHERE ");
            query.append(" tc.contract_id=? ");
            query.append(" ORDER BY ");
            query.append(" product_id ");
            try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
                int index = 1;
                ps.setInt(index++, contractId);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        copyList.add(this.getCopyFromRs(rs));
                    }
                }
            }
        }
        catch (SQLException e) {
            this.getLogger().error("getCopyList( " + contractId + ")", (Throwable)e);
        }
        return copyList;
    }

    public List<LicenseOrderConfirmed> getCopyItems(int copyId, int filter) throws BGException {
        LicenseOrderConfirmed item;
        ResultSet resultSet;
        int index;
        PreparedStatement ps;
        ArrayList<LicenseOrderConfirmed> copyItems = new ArrayList<LicenseOrderConfirmed>();
        StringBuilder query = new StringBuilder().append("SELECT ").append("GROUP_CONCAT(ci.id) as ids, ord.type, GROUP_CONCAT(ord.count) as counts, ci.to_date, pi.title as product_item_title, pi.name as product_item_name, ord.component_id ").append(" FROM ").append(" lic_confirmed_order_" + this.moduleId + " as ci ").append(" JOIN ").append(" lic_order_" + this.moduleId + " as ord ").append(" ON ci.order_id=ord.id ").append(" JOIN ").append("lic_component_" + this.moduleId + " as pi ").append(" ON ord.component_id=pi.id ").append(" WHERE ").append(" ord.type=1 AND ord.status=2 AND ord.copy_id=? AND ci.to_date>=now() ").append(" GROUP BY ").append("component_id").append(" ORDER BY ").append(" product_item_title");
        HashMap<Integer, LicenseOrderConfirmed> copyItemsMap = new HashMap<Integer, LicenseOrderConfirmed>();
        try {
            ps = this.con.prepareStatement(query.toString());
            try {
                index = 1;
                ps.setInt(index++, copyId);
                resultSet = ps.executeQuery();
                try {
                    while (resultSet.next()) {
                        item = this.getCopyItemFromRs(resultSet);
                        copyItems.add(item);
                        copyItemsMap.put(item.getComponentId(), item);
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        if (filter != 1) {
            query = new StringBuilder().append("SELECT ").append("ci.id as ids, ord.type, ord.count as counts, ci.to_date, pi.title as product_item_title, pi.name as product_item_name,  ord.component_id ").append(" FROM ").append(" lic_confirmed_order_" + this.moduleId + " as ci ").append(" JOIN ").append(" lic_order_" + this.moduleId + " as ord ON ci.order_id=ord.id ").append(" JOIN ").append("lic_component_" + this.moduleId + " as pi ON ord.component_id=pi.id ").append(" WHERE ").append("ord.type=0 AND ord.status=3 AND ord.copy_id=? AND ci.to_date>=now() ").append(" ORDER BY ").append("product_item_title");
            try {
                ps = this.con.prepareStatement(query.toString());
                try {
                    index = 1;
                    ps.setInt(index++, copyId);
                    resultSet = ps.executeQuery();
                    try {
                        while (resultSet.next()) {
                            item = this.getCopyItemFromRs(resultSet);
                            if (filter == 0) {
                                LicenseOrderConfirmed boughtItem = (LicenseOrderConfirmed)copyItemsMap.get(item.getComponentId());
                                if (boughtItem != null && (boughtItem.getCount() <= 0 || item.getCount() <= boughtItem.getCount() && item.getCount() != 0)) continue;
                                if (boughtItem != null) {
                                    copyItems = new ArrayList<LicenseOrderConfirmed>(copyItems.stream().filter(a -> a.getComponentId() != boughtItem.getComponentId() || a.getType() != boughtItem.getType() || a.getCount() != boughtItem.getCount()).toList());
                                }
                                copyItems.add(item);
                                continue;
                            }
                            copyItems.add(item);
                        }
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        return copyItems;
    }

    public int[] getCopyItemIds(int copyId) throws BGException {
        List<LicenseOrderConfirmed> copyItems = this.getCopyItems(copyId, 2);
        StringBuilder itemIds = new StringBuilder();
        for (int i = 0; i < copyItems.size(); ++i) {
            itemIds.append(copyItems.get(i).getIds());
            if (i >= copyItems.size() - 1) continue;
            itemIds.append(',');
        }
        List idList = Utils.toList((String)itemIds.toString());
        int[] ids = new int[idList.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = Integer.valueOf((String)idList.get(i));
        }
        return ids;
    }

    public List<Contract> getContractByTitlePart(String titlePart) throws BGException {
        ArrayList<Contract> contracts = new ArrayList<Contract>();
        try {
            String query = "SELECT * FROM contract WHERE title LIKE ?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, titlePart + "%");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                contracts.add(this.getContractFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return contracts;
    }

    public void updateTestComponentDateTo(int orderId, Date dateTo) {
        String query = "UPDATE  lic_confirmed_order_" + this.moduleId + " SET to_date=? WHERE id=? AND to_date<?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setTimestamp(1, new Timestamp(dateTo.getTime()));
            ps.setInt(2, orderId);
            ps.setTimestamp(3, new Timestamp(dateTo.getTime()));
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            this.getLogger().error("LicenseManager.updateTestComponentDateTo", (Throwable)e);
        }
    }

    private LicenseOrder getOrderFromRs(ResultSet rs) throws SQLException {
        return LicenseOrder.builder().setId(rs.getInt("id")).setCopyId(rs.getInt("copy_id")).setComponentId(rs.getInt("component_id")).setCount(rs.getInt("count")).setStatus(rs.getInt("status")).setType(LicenseOrderType.getOrderTypeByCode((int)rs.getInt("type"))).setTerm(rs.getInt("term")).setUserId(rs.getInt("user_id")).setCreateDate((Date)rs.getTimestamp("create_date")).setLastUpdate((Date)rs.getTimestamp("lu")).setComponentTitle(rs.getString("product_item_title")).setComponentName(rs.getString("product_item_name")).setUserName(rs.getString("user_name")).build();
    }

    public List<LicenseOrderConfirmed> getCopyItemsFromPackage(int packageId) {
        ArrayList<LicenseOrderConfirmed> copyItems = new ArrayList<LicenseOrderConfirmed>();
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT ");
            query.append("id, component_id, type, count, from_date, to_date, lu");
            query.append(" FROM ");
            query.append(" lic_confirmed_order_" + this.moduleId + " as ci ");
            query.append(" LEFT JOIN ");
            query.append(" lic_license_component_" + this.moduleId + " as packi ");
            query.append(" ON ci.id=packi.component_id ");
            query.append(" WHERE ");
            query.append(" packi.license_id=?");
            int index = 1;
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(index++, packageId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                copyItems.add(this.getCopyItemFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            this.getLogger().error("getCopyItemsFromPackage( " + packageId + ")", (Throwable)e);
        }
        return copyItems;
    }

    private LicenseOrderConfirmed getCopyItemFromRs(ResultSet rs) throws SQLException, UnsupportedEncodingException {
        LicenseOrderConfirmed copyItem = new LicenseOrderConfirmed();
        copyItem.setIds(rs.getString("ids"));
        copyItem.setComponentTitle(rs.getString("product_item_title"));
        copyItem.setComponentName(rs.getString("product_item_name"));
        copyItem.setComponentId(rs.getInt("component_id"));
        copyItem.setType(rs.getInt("type"));
        copyItem.setCount(this.getCountFromBlob(rs.getString("counts")));
        copyItem.setDateTo((Date)rs.getDate("to_date"));
        return copyItem;
    }

    private int getCountFromBlob(String countList) throws UnsupportedEncodingException, SQLException {
        String[] countArray = countList.split(",");
        int count = 0;
        for (int i = 0; i < countArray.length; ++i) {
            if (Utils.parseInt((String)countArray[i]) == 0) {
                count = 0;
                break;
            }
            count += Integer.valueOf(countArray[i]).intValue();
        }
        return count;
    }

    private LicenseCopy getCopyFromRs(ResultSet rs) throws SQLException {
        return new LicenseCopy(rs.getInt("id"), (Date)rs.getDate("lu")).setProductId(rs.getInt("product_id")).setProductTitle(rs.getString("title")).setProductVersion(rs.getString("version")).setContractId(rs.getInt("contract_id")).setLicenseName(rs.getString("licensee_name")).setComment(rs.getString("comment")).setDate((Date)rs.getTimestamp("dt"));
    }

    private License getLicenseFromRs(ResultSet rs) throws SQLException {
        License license = new License();
        license.setId(rs.getInt("id"));
        license.setCopyId(rs.getInt("copy_id"));
        license.setCreateDate((Date)rs.getTimestamp("create_date"));
        license.setUserId(rs.getInt("user_id"));
        license.setUserName(rs.getString("name"));
        license.setData(rs.getString("data"));
        license.setOriginalData(rs.getString("original_data"));
        return license;
    }

    public String getOrganizationTitle(int contractId, int fullOrganizationNameParamId) {
        String title = new String();
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT ");
            query.append(" val ");
            query.append(" FROM ");
            query.append("contract_parameter_type_1");
            query.append(" WHERE ");
            query.append(" cid=? AND pid=? ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, contractId);
            ps.setInt(2, fullOrganizationNameParamId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                title = rs.getString("val");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            this.getLogger().error("getOrganizationTitle( " + contractId + " ) ", (Throwable)e);
        }
        return title;
    }

    public String getContractComment(int contractId) {
        String comment = null;
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            comment = ((Contract)contractDao.get(contractId)).getComment();
        }
        catch (BGException e) {
            e.printStackTrace();
        }
        return comment;
    }

    public String getLicenseText(int licenseId) {
        String licText = new String();
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append("data");
        query.append(" FROM ");
        query.append(" lic_license_" + this.moduleId);
        query.append(" WHERE ");
        query.append("id=? ");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, licenseId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    licText = rs.getString("data");
                }
            }
        }
        catch (SQLException e) {
            this.getLogger().error("getLicenseText( " + licenseId + " )", (Throwable)e);
        }
        return licText;
    }

    public String getOriginalLicenseText(int licenseId) {
        String licText = new String();
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(" original_data ");
        query.append(" FROM ");
        query.append(" lic_license_" + this.moduleId);
        query.append(" WHERE ");
        query.append(" id=? ");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, licenseId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    licText = rs.getString("original_data");
                }
            }
        }
        catch (SQLException e) {
            this.getLogger().error("getOriginalLicenseText( " + licenseId + " )", (Throwable)e);
        }
        return licText;
    }

    protected int lastInsertId(PreparedStatement ps) throws SQLException {
        int id = -1;
        ResultSet rs = ps.getGeneratedKeys();
        while (rs.next()) {
            id = rs.getInt(1);
        }
        return id;
    }

    protected void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException ex) {
                this.getLogger().error("closeConnection( " + String.valueOf(con) + ")", (Throwable)ex);
            }
        }
    }

    private Contract getContractFromRS(ResultSet rs) throws SQLException {
        return Contract.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setPassword(rs.getString("pswd")).setComment(rs.getString("comment")).setBalanceMode((byte)rs.getInt("mode")).setBalanceLimit(rs.getBigDecimal("closesumma")).setGroups(rs.getLong("gr")).setPersonType((byte)rs.getInt("fc")).setParamGroupId(rs.getInt("pgid")).setDateFrom((Date)rs.getDate("date1")).setDateTo((Date)rs.getDate("date2")).setHidden(rs.getInt("del") > 0).setSuperContractId(rs.getInt("scid")).setStatus((byte)rs.getInt("status")).setCommentPatternId(rs.getInt("title_pattern_id")).setStatusTimeChange((Date)rs.getDate("status_date")).build();
    }

    public List<AdditionalAgreement> getListAdditionalAgreement(int contractId, int copyId) throws BGException {
        ArrayList<AdditionalAgreement> result = new ArrayList<AdditionalAgreement>();
        String query = "SELECT  *  FROM lic_additional_agreement_" + this.moduleId + " WHERE contractId=? AND copy_id=? ORDER BY  number";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractId);
            ps.setInt(index++, copyId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    AdditionalAgreement row = new AdditionalAgreement();
                    row.setId(rs.getInt("id"));
                    row.setCopyId(rs.getInt("copy_id"));
                    row.setAgreementNumber(rs.getInt("number"));
                    row.setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("date")));
                    row.setStatus(rs.getInt("status"));
                    row.setSum(rs.getBigDecimal("sum"));
                    row.setDocumentId(rs.getInt("document_id"));
                    row.setBillId(rs.getInt("bill_id"));
                    row.setChargeId(rs.getInt("charge_id"));
                    row.setInvoiceId(rs.getInt("invoice_id"));
                    if (rs.getBytes("specification") != null) {
                        ByteArrayInputStream stream = new ByteArrayInputStream(rs.getBytes("specification"));
                        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Result.class, SpecificationTitle.class});
                        Unmarshaller unmarshaller = context.createUnmarshaller();
                        Result r = (Result)unmarshaller.unmarshal((InputStream)stream);
                        row.setSpecification(r.getList());
                    }
                    row.setChargeId(rs.getInt("charge_id"));
                    result.add(row);
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public AdditionalAgreement getAdditionalAgreement(int id) throws BGException {
        AdditionalAgreement row = new AdditionalAgreement();
        String query = "SELECT * FROM lic_additional_agreement_" + this.moduleId + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    row.setId(rs.getInt("id"));
                    row.setCopyId(rs.getInt("copy_id"));
                    row.setAgreementNumber(rs.getInt("number"));
                    row.setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("date")));
                    row.setStatus(rs.getInt("status"));
                    row.setSum(rs.getBigDecimal("sum"));
                    row.setDocumentId(rs.getInt("document_id"));
                    row.setBillId(rs.getInt("bill_id"));
                    row.setChargeId(rs.getInt("charge_id"));
                    row.setInvoiceId(rs.getInt("invoice_id"));
                    if (rs.getBytes("specification") == null) continue;
                    ByteArrayInputStream stream = new ByteArrayInputStream(rs.getBytes("specification"));
                    JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Result.class, SpecificationTitle.class});
                    Unmarshaller unmarshaller = context.createUnmarshaller();
                    Result r = (Result)unmarshaller.unmarshal((InputStream)stream);
                    row.setSpecification(r.getList());
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new BGException((Throwable)e);
        }
        return row;
    }

    public void setAdditionalAgreement(int contractId, AdditionalAgreement additionalAgreement) throws BGException {
        String query = "INSERT INTO lic_additional_agreement_" + this.moduleId + " SET contractId=?, copy_Id=?, number=?, date=?, status=?, sum=?, document_id=?, bill_id=?, specification=?, charge_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            Result r = new Result(additionalAgreement.getSpecification());
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Result.class, SpecificationTitle.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)r, (OutputStream)stream);
            int index = 1;
            ps.setInt(index++, contractId);
            ps.setInt(index++, additionalAgreement.getCopyId());
            ps.setInt(index++, additionalAgreement.getAgreementNumber());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)additionalAgreement.getDate()));
            ps.setInt(index++, additionalAgreement.getStatus());
            ps.setBigDecimal(index++, additionalAgreement.getSum());
            ps.setInt(index++, additionalAgreement.getDocumentId());
            ps.setInt(index++, additionalAgreement.getBillId());
            ps.setBytes(index++, stream.toByteArray());
            ps.setInt(index++, additionalAgreement.getChargeId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updateAdditionalAgreement(int contractId, AdditionalAgreement additionalAgreement) throws BGException {
        String query = "UPDATE " + "lic_additional_agreement_" + this.moduleId + " SET status=?, sum=?, bill_id=?, charge_id=?, invoice_id=?" + " WHERE " + "id=? AND contractId=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, additionalAgreement.getStatus());
            ps.setBigDecimal(index++, additionalAgreement.getSum());
            ps.setInt(index++, additionalAgreement.getBillId());
            ps.setInt(index++, additionalAgreement.getChargeId());
            ps.setInt(index++, additionalAgreement.getInvoiceId());
            ps.setInt(index++, additionalAgreement.getId());
            ps.setInt(index++, contractId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void deleteAdditionalAgreement(int idAdditionalAgreement) throws BGException {
        String query = "DELETE  FROM lic_additional_agreement_" + this.moduleId + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, idAdditionalAgreement);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void resetCopyDiscount(int contractId, int productCopyId) throws BGException {
        String query = "UPDATE  lic_copy_" + this.moduleId + " SET discount=0 WHERE contract_id=? AND id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, productCopyId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<SpecificationTitle> getSpecificationOfAdditionalAgreement(int id) throws BGException {
        List list = null;
        String query = "SELECT specification FROM lic_additional_agreement_" + this.moduleId + " WHERE id=?" + id;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next() && rs.getBytes("specification") != null) {
                    ByteArrayInputStream stream = new ByteArrayInputStream(rs.getBytes("specification"));
                    JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Result.class, SpecificationTitle.class});
                    Unmarshaller unmarshaller = context.createUnmarshaller();
                    list = ((Result)unmarshaller.unmarshal((InputStream)stream)).getList();
                }
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return list;
    }

    public int getLastNumber(int contractId) throws BGException {
        int result = -1;
        String query = "SELECT MAX(number) FROM lic_additional_agreement_" + this.moduleId + " WHERE contractId=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getInt(1);
                    if (rs.wasNull()) {
                        result = -1;
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BigDecimal getDiscount(int contractId, int copyId) throws BGException {
        String query = "SELECT discount FROM lic_copy_" + this.moduleId + " WHERE contract_id=? AND id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, copyId);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                BigDecimal bigDecimal = rs.getBigDecimal("discount");
                return bigDecimal;
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void setDiscount(BigDecimal discount, int contractId, int copyId) throws BGException {
        String query = "UPDATE lic_copy_" + this.moduleId + " SET discount=? WHERE id=? AND contract_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setBigDecimal(1, discount);
            ps.setInt(2, copyId);
            ps.setInt(3, contractId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void setStatusSigned(int id) throws BGException {
        try {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE lic_additional_agreement_" + this.moduleId + " SET status=1 WHERE id=" + id);
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void setCharge(int id, int chargeId) throws SQLException {
        String query = "UPDATE lic_additional_agreement_" + this.moduleId + " SET charge_id=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, chargeId);
            ps.setInt(2, id);
            ps.executeUpdate();
        }
    }

    public void setInvoice(int id, int invoiceId) throws SQLException {
        String query = "UPDATE lic_additional_agreement_" + this.moduleId + " SET invoice_id=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, invoiceId);
            ps.setInt(2, id);
            ps.executeUpdate();
        }
    }

    public int getOrderIdFromConfirmedId(int condirmedOrderId) {
        if (condirmedOrderId < 0) {
            return -1;
        }
        int res = -1;
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append("SELECT ").append(" order_id ").append(" FROM ").append(" lic_confirmed_order_" + this.moduleId).append(" WHERE ").append(" id=? ");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, condirmedOrderId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    res = rs.getInt("order_id");
                }
            }
            ps.close();
        }
        catch (SQLException ex) {
            this.getLogger().error("getOrderIdFromConfirmedId( " + condirmedOrderId + " )", (Throwable)ex);
        }
        return res;
    }

    public Map<Integer, int[]> getCopyCountForComponentByProductMap(int productId) {
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        try {
            int[] counters;
            StringBuilder subQuery = new StringBuilder().append("SELECT ").append("id").append(" FROM ").append(" lic_copy_").append(this.moduleId).append(" WHERE ").append("product_id=?");
            StringBuilder sub1Query = new StringBuilder().append("SELECT ").append("concat(copy_id,' ',component_id)").append(" FROM ").append(" lic_order_").append(this.moduleId).append(" WHERE ").append("count=0 AND type=1 AND status=2 AND ").append("copy_id").append(" IN ").append("( ").append((CharSequence)subQuery).append(" )");
            StringBuilder query = new StringBuilder().append("SELECT ").append("component_id, COUNT(DISTINCT copy_id)").append(" FROM ").append(" lic_order_").append(this.moduleId).append(" WHERE ").append("type=1").append(" AND ").append("status=2").append(" AND ").append("copy_id").append(" IN ").append("( ").append((CharSequence)subQuery).append(" )").append(" GROUP BY ").append("component_id");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, productId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                counters = new int[3];
                counters[0] = rs.getInt(2);
                map.put(rs.getInt(1), counters);
            }
            rs.close();
            ps.close();
            query = new StringBuilder().append("SELECT ").append("component_id, COUNT(DISTINCT copy_id)").append(" FROM ").append(" lic_order_").append(this.moduleId).append(" WHERE ").append("type=1").append(" AND ").append("status=2").append(" AND ").append("count=0").append(" AND ").append("copy_id").append(" IN ").append("( ").append((CharSequence)subQuery).append(" )").append(" GROUP BY ").append("component_id");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, productId);
            rs = ps.executeQuery();
            while (rs.next()) {
                counters = (int[])map.get(rs.getInt(1));
                if (counters == null) {
                    counters = new int[3];
                    map.put(rs.getInt(1), counters);
                }
                counters[1] = rs.getInt(2);
            }
            rs.close();
            ps.close();
            query = new StringBuilder().append("SELECT ").append("component_id, SUM(count)").append(" FROM ").append(" lic_order_").append(this.moduleId).append(" WHERE ").append("type=1").append(" AND ").append("status=2").append(" AND ").append("copy_id").append(" IN ").append("( ").append((CharSequence)subQuery).append(" )").append(" AND ").append("concat(copy_id,' ',component_id)").append(" NOT IN ").append("( ").append((CharSequence)sub1Query).append(" )").append(" GROUP BY ").append("component_id");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, productId);
            ps.setInt(2, productId);
            rs = ps.executeQuery();
            while (rs.next()) {
                counters = (int[])map.get(rs.getInt(1));
                if (counters == null) {
                    counters = new int[3];
                    map.put(rs.getInt(1), counters);
                }
                counters[2] = rs.getInt(2);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return map;
    }

    public List<ContractData> doContractData(int productId, int componentId) {
        ArrayList<ContractData> list = new ArrayList<ContractData>();
        try {
            StringBuilder query = new StringBuilder().append("SELECT ").append("DISTINCT ").append("c.id, title, c.comment").append(" FROM ").append(" lic_order_").append(this.moduleId).append(" AS a").append(" LEFT JOIN ").append(" lic_copy_").append(this.moduleId).append(" AS b").append(" ON ").append("a.copy_id=b.id").append(" LEFT JOIN ").append("contract").append(" AS c").append(" ON ").append("c.id=b.contract_id").append(" WHERE ").append("component_id=?").append(" AND ").append("product_id=?").append(" AND ").append("type=1").append(" AND ").append("a.status=2");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, componentId);
            ps.setInt(2, productId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ContractData contractData = new ContractData();
                contractData.setContractId(rs.getInt(1));
                contractData.setContractTitle(rs.getString(2));
                contractData.setContractComment(rs.getString(3));
                list.add(contractData);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return list;
    }
}

