<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:svg="http://www.w3.org/2000/svg" 
	xmlns:xalan="http://xml.apache.org/xalan"
	xmlns:bg="ru.bitel.bgbilling.server.util.exslt.BGXsltFunctions"
	xmlns:server_utils="ru.bitel.bgbilling.server.util.ServerUtils">
	
	<xalan:component prefix="bg" functions="summaToString">
		<xalan:script lang="javaclass" src="xalan://ru.bitel.bgbilling.server.util.exslt.BGXsltFunctions"/>
  	</xalan:component>
  	<xalan:component prefix="server_utils" functions="replace">
		<xalan:script lang="javaclass" src="xalan://ru.bitel.bgbilling.server.util.ServerUtils"/>
  	</xalan:component>

	<xsl:output encoding="UTF-8" method='text' indent='yes' />
	
	<xsl:template match="data">
		<xsl:apply-templates select="bill" />
	</xsl:template>
	<xsl:variable name="fio" select="/data/bill/contract_params/parameter[@pid='51']/@value"/>
	<xsl:variable name="address" select="/data/bill/contract_params/parameter[@pid='19']/@value"/>
	<xsl:variable name="phone" select="/data/bill/contract_params/parameter[@pid='40']/@value"/>
	<xsl:variable name="dolg" select="format-number(/data/bill/@saldo_prev, '0.00')"/>
	<xsl:variable name="itogo" select="format-number(/data/bill/@total_sum,'0.00')"/>
	<xsl:template match="bill">
			<xsl:value-of select="$fio"/>;<xsl:value-of select="$address"/>;<xsl:value-of select="@bill_number"/>;<xsl:value-of select="@type_title"/>;<xsl:value-of select="server_utils:replace($phone,';',',')"/>;<xsl:value-of select="@date"/>;<xsl:value-of select="$dolg"/>;<xsl:call-template name="positions"/> <xsl:value-of select="$itogo"/>;
	</xsl:template>
	<xsl:template name="positions">
		<xsl:for-each select="pos">	<xsl:value-of select="@summ"/>;</xsl:for-each>
	</xsl:template>
	
</xsl:stylesheet>