/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.handler;

import jakarta.servlet.ServletContext;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.ws.server.DynamicJaxWsHandler;
import ru.bitel.bgbilling.kernel.container.ws.server.ModuleKey;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;

public class TvWsHandler
extends DynamicJaxWsHandler {
    private static final Logger logger = LogManager.getLogger();

    public TvWsHandler(ServletContext context) throws BGException {
        super(context);
    }

    protected Class<?> findEndpointClass(ModuleKey moduleKey) {
        try {
            Setup setup = Setup.getSetup();
            ModuleSetup moduleSetup = setup.getModuleSetup(Integer.valueOf(moduleKey.moduleId));
            String className = moduleKey.module + ".impl." + moduleKey.service + "Impl";
            boolean exist = false;
            for (Map.Entry e : moduleSetup.subKeyed("tv.ws.").entrySet()) {
                ParameterMap params = (ParameterMap)e.getValue();
                if (!className.equals(params.get("class", ""))) continue;
                exist = true;
                break;
            }
            if (exist) {
                return DynamicClassManager.getInstance().loadClass(className);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    protected String getUrlPatternName(ModuleKey moduleKey, Class<?> implementorClass) {
        return "/tv-ws/" + moduleKey.module + "/" + (String)(moduleKey.moduleId > 0 ? moduleKey.moduleId + "/" : "") + moduleKey.service;
    }
}

