/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.client.contract;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGControlPanelButtonGroup;
import bitel.billing.module.common.BGTextArea;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGEditorDialogVPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.plugins.helpdesk.client.contract.HelpdeskMessageEditor;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.ChangeManager;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGControlPanelCategorySubcategory;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class HelpdeskMessageTab
extends BGUPanel {
    private boolean comboBoxUpdateFlag = false;
    private String mode = "topic";
    private int topicId = 0;
    private int topicUserId = 0;
    private String[] notification = new String[2];
    private JPanel tablePanel = null;
    private JPanel infoPanel = null;
    private JPanel infoPanel1 = null;
    private JPanel infoPanel2 = null;
    private JTextField topicTitleField = new JTextField();
    private JLabel toticItogoLabel = new JLabel("\u0412\u0441\u0435\u0433\u043e: 0");
    private JLabel messageItogoLabel = new JLabel("\u0412\u0441\u0435\u0433\u043e: 0");
    private BGTextField managerTF = new BGTextField();
    private BGTextField notificationTF = new BGTextField(10);
    private CardLayout tableCardLayout = new CardLayout();
    private JComboBox<ComboBoxItem> stateClosedComboBox = new JComboBox();
    private BGUComboBox<IdTitle> statusComboBox = new BGUComboBox();
    private JComboBox<ComboBoxItem> packageIncludeComboBox = new JComboBox();
    private BGUComboBox<IdTitle> autocloseComboBox = new BGUComboBox();
    private JComboBox<ComboBoxItem> notificationComboBox = new JComboBox();
    private BGControlPanelButtonGroup cpButtonGroup = new BGControlPanelButtonGroup();
    private BGControlPanelPages topicPagePanel = new BGControlPanelPages();
    private BGControlPanelPages messagePagePanel = new BGControlPanelPages();
    private JToggleButton filterButton = null;
    private BGTextField title = new BGTextField();
    private IntTextField id_topic = new IntTextField();
    private BGTextField message = new BGTextField();
    private BGUComboBox<IdTitle> statusBox = new BGUComboBox();
    private BGControlPanelPeriodNoB periodPanel = new BGControlPanelPeriodNoB();
    private BGControlPanelButtonGroup cpButtonGroupUserSelect = new BGControlPanelButtonGroup();
    private String COST_PANEL = "cost_panel";
    private BGTextField costTextField = new BGTextField(6);
    private BGButton[] notificationButton = new BGButton[2];
    private String INCLUDE_PANEL = "package_include_panel";
    private JPanel cardsCostIncludePanel = new JPanel(new CardLayout());
    private BGControlPanelCategorySubcategory categorySubcategory = new BGControlPanelCategorySubcategory();
    private HelpdeskMessageEditor editor;
    private JToggleButton buttonOnlyNew = new JToggleButton();
    private final String PACKAGE = "packageModeTable";
    private final String DEFAULT = "defaultModeTable";
    private JPanel topicTable = new JPanel(new CardLayout());
    private int messageRow = -1;
    private BGUTable packageModeTopicTable = null;
    private BGUTable defaultModeTopicTable = null;
    private JList<Message> messageList = new JList(new DefaultListModel());
    private DefaultModeTopicTableModel defaultModeTopicTableModel = new DefaultModeTopicTableModel(DefaultModeTopicTableModel.class.getName());
    private PackageModeTopicTableModel packageModeTopicTableModel = new PackageModeTopicTableModel(PackageModeTopicTableModel.class.getName());
    private SearchResult<Message> searchResult;
    private List<IdTitle> statusList = new ArrayList<IdTitle>();
    private List<IdTitle> categoryList = new ArrayList<IdTitle>();
    private List<IdTitle> subcategoryList = new ArrayList<IdTitle>();
    private List<IdTitle> autoclosebleItems = Arrays.asList(new IdTitle(0, "\u043d\u0435\u0442"), new IdTitle(1, "\u0434\u0430"));

    public HelpdeskMessageTab(ClientContext clientContext) {
        super(clientContext);
        this.contractModeChanged(this.isPacketModeEnabled() ? "package" : "");
        this.editor = new HelpdeskMessageEditor(this);
        this.editor.setBorder((Border)new BGTitleBorder(" \u041f\u0438\u0441\u044c\u043c\u043e "));
        this.editor.init("ru.bitel.bgbilling.plugins.helpdesk", -1);
        this.editor.setContractId(this.getContext().getContractId());
        this.messageList.setCellRenderer(new MessageListCellRenderer(this));
        this.messageList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                HelpdeskMessageTab.this.performAction("edit");
            }
        });
        this.defaultModeTopicTable = new BGUTable((TableModel)((Object)this.defaultModeTopicTableModel));
        this.defaultModeTopicTable.setSelectionMode(0);
        this.packageModeTopicTable = new BGUTable((TableModel)((Object)this.packageModeTopicTableModel));
        this.packageModeTopicTable.setSelectionMode(0);
    }

    protected void jbInit() throws Exception {
        BGPluginClient plugin = BGPluginManagerClient.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");
        PropertyChangeListener propertyChangeListener = e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.performAction("refresh");
            }
        };
        this.topicPagePanel.init();
        this.topicPagePanel.setKey(((Object)((Object)this)).getClass().getName());
        this.topicPagePanel.addPropertyChangeListener(propertyChangeListener);
        this.messagePagePanel.init();
        this.messagePagePanel.addPropertyChangeListener(propertyChangeListener);
        this.initTablePanel();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getInfoPanel(plugin), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 13, 1, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.tablePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.managerTF.setEditable(false);
        this.topicTable.add((Component)new JScrollPane((Component)this.packageModeTopicTable), "packageModeTable");
        this.topicTable.add((Component)new JScrollPane((Component)this.defaultModeTopicTable), "defaultModeTable");
        this.stateClosedComboBox.addItemListener(e -> {
            if (!this.comboBoxUpdateFlag && e.getStateChange() == 1) {
                try {
                    boolean state = (Boolean)((ComboBoxItem)this.stateClosedComboBox.getSelectedItem()).getObject();
                    this.getHelpdeskService().topicStateUpdate(this.topicId, state, this.isPacketModeEnabled());
                    this.performAction("refresh");
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        });
        this.packageIncludeComboBox.addActionListener(e -> {
            if (!this.comboBoxUpdateFlag) {
                this.setTopicPackageState((Boolean)((ComboBoxItem)this.packageIncludeComboBox.getSelectedItem()).getObject());
            }
        });
        this.autocloseComboBox.addItemListener(e -> {
            if (!this.comboBoxUpdateFlag && e.getStateChange() == 1) {
                try {
                    this.getHelpdeskService().topicAutocloseUpdate(this.topicId, ((IdTitle)this.autocloseComboBox.getSelectedItem()).getId() == 1);
                    this.performAction("refresh");
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        });
        this.statusComboBox.addItemListener(e -> {
            if (!this.comboBoxUpdateFlag && e.getStateChange() == 1) {
                try {
                    this.getHelpdeskService().topicStatusUpdate(this.topicId, ((IdTitle)this.statusComboBox.getSelectedItem()).getId());
                    this.performAction("refresh");
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        });
        this.categorySubcategory.addPropertyChangeListener(event -> {
            if ("changeData".equals(event.getPropertyName())) {
                String[] selectedCategory = this.categorySubcategory.getSelectedCategory();
                String[] selectedSubcategory = this.categorySubcategory.getSelectedSubcategory();
                if (selectedCategory != null && selectedSubcategory != null) {
                    try {
                        this.getHelpdeskService().topicCategorySubcategoryUpdate(this.topicId, Utils.parseInt((String)selectedCategory[0]), Utils.parseInt((String)selectedSubcategory[0]));
                        this.performAction("refresh");
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }
        });
        BGSwingUtilites.handleEdit((JTable)this.packageModeTopicTable, (BGUPanel)this, (String)"edit");
        BGSwingUtilites.handleEdit((JTable)this.defaultModeTopicTable, (BGUPanel)this, (String)"edit");
    }

    private JPanel getInfoPanel(BGPluginClient plugin) {
        if (this.infoPanel == null) {
            ActionListener actionListener = e -> {
                this.topicPagePanel.init();
                this.performAction("refresh");
            };
            this.infoPanel = new JPanel(new GridBagLayout());
            this.infoPanel.setBorder((Border)new BGTitleBorder(plugin.getResourceString("helpdeskAdminInfoPanelBorderTitle")));
            this.infoPanel.add((Component)this.getInfoPanel2(plugin, actionListener), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.infoPanel.add((Component)this.getInfoPanel1(plugin, actionListener), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        }
        return this.infoPanel;
    }

    private JPanel getInfoPanel1(BGPluginClient plugin, ActionListener actionListener) {
        if (this.infoPanel1 == null) {
            JLabel label = null;
            this.infoPanel1 = new JPanel(new GridBagLayout());
            label = new JLabel(plugin.getResourceString("helpdeskAdminInfoPanelIDTitle"));
            this.infoPanel1.add((Component)label, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.infoPanel1.add((Component)this.id_topic, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            label = new JLabel(plugin.getResourceString("helpdeskAdminInfoPanelTitleTitle"));
            this.infoPanel1.add((Component)label, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.infoPanel1.add((Component)this.title, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            label = new JLabel(plugin.getResourceString("helpdeskAdminInfoPanelStatusTitle"));
            this.infoPanel1.add((Component)label, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.infoPanel1.add((Component)this.statusBox, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            label = new JLabel(plugin.getResourceString("helpdeskAdminInfoPanelPeriodTitle"));
            this.infoPanel1.add((Component)label, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
            this.infoPanel1.add((Component)this.periodPanel, new GridBagConstraints(8, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
            label = new JLabel(plugin.getResourceString("helpdeskAdminInfoPanelMessageTitle"));
            this.infoPanel1.add((Component)label, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.infoPanel1.add((Component)this.message, new GridBagConstraints(4, 1, 4, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            BGButton buttonSearch = new BGButton(plugin.getResourceString("helpdeskAdminInfoPanelSearchButtonTitle"));
            buttonSearch.addActionListener(actionListener);
            BGButton buttonReset = new BGButton(plugin.getResourceString("helpdeskAdminInfoPanelResetButtonTitle"));
            buttonReset.addActionListener(e -> this.resetFilter());
            buttonReset.addActionListener(actionListener);
            this.infoPanel1.add((Component)buttonSearch, new GridBagConstraints(8, 1, 1, 1, 0.005, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.infoPanel1.add((Component)buttonReset, new GridBagConstraints(9, 1, 1, 1, 0.005, 0.0, 10, 2, new Insets(0, 5, 5, 8), 0, 0));
        }
        return this.infoPanel1;
    }

    private JPanel getInfoPanel2(BGPluginClient plugin, ActionListener actionListener) {
        if (this.infoPanel2 == null) {
            this.cpButtonGroup = new BGControlPanelButtonGroup();
            this.cpButtonGroup.addButton(plugin.getResourceString("helpdeskContractInfoPanelActiveButtonTitle"), "0");
            this.cpButtonGroup.addButton(plugin.getResourceString("helpdeskContractInfoPanelArchiveButtonTitle"), "1");
            this.cpButtonGroup.setSelectedCommand("0");
            this.cpButtonGroup.addActionListener(actionListener);
            this.buttonOnlyNew.setText(plugin.getResourceString("helpdeskContractInfoPanelOnlyNewButtonTitle"));
            this.buttonOnlyNew.addActionListener(actionListener);
            this.cpButtonGroupUserSelect.addButton(plugin.getResourceString("helpdeskAdminInfoPanelAllUserButtonTitle"), "all");
            this.cpButtonGroupUserSelect.addButton(plugin.getResourceString("helpdeskAdminInfoPanelNoneUserButtonTitle"), "none");
            this.cpButtonGroupUserSelect.addButton(plugin.getResourceString("helpdeskAdminInfoPanelMyUserButtonTitle"), "my");
            this.cpButtonGroupUserSelect.setSelectedCommand("all");
            this.cpButtonGroupUserSelect.addActionListener(actionListener);
            this.filterButton = new JToggleButton(plugin.getResourceString("helpdeskAdminInfoPanelFilterButtonTitle"));
            this.filterButton.addActionListener(e -> this.showFilter());
            JLabel label1 = new JLabel(plugin.getResourceString("helpdeskAdminInfoPanelSubjectTitle"));
            this.infoPanel2 = new JPanel(new GridBagLayout());
            this.infoPanel2.add((Component)this.cpButtonGroup, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.infoPanel2.add((Component)this.buttonOnlyNew, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 15, 5, 0), 0, 0));
            this.infoPanel2.add((Component)label1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.infoPanel2.add((Component)this.cpButtonGroupUserSelect, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 25), 0, 0));
            this.infoPanel2.add((Component)this.filterButton, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 35), 0, 0));
            this.infoPanel2.add((Component)this.toticItogoLabel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 10), 0, 0));
            this.infoPanel2.add((Component)this.topicPagePanel, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        }
        return this.infoPanel2;
    }

    private JPanel getParamPanel() {
        BGButton setManagerButton = new BGButton("\u042f");
        setManagerButton.addActionListener(e -> this.onBindThisTopic("me"));
        BGButton noManagerButton = new BGButton("\u041d\u0435\u0442");
        noManagerButton.addActionListener(e -> this.onBindThisTopic("-1"));
        BGButton chooseManagerButton = new BGButton("\u0412\u044b\u0431\u0440\u0430\u0442\u044c");
        chooseManagerButton.addActionListener(actionEvent -> new ManagerSelectDialog("\u0412\u044b\u0431\u043e\u0440 \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u0430", null).open());
        BGButton historyManagerButton = new BGButton("\u0418\u0441\u0442\u043e\u0440\u0438\u044f");
        historyManagerButton.addActionListener(actionEvent -> new ManagerLogDialog("\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0441\u043c\u0435\u043d\u044b \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u0430", null).open());
        WhitePanel managerPanel = new WhitePanel();
        managerPanel.add((Component)this.managerTF, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        managerPanel.add((Component)setManagerButton, new GridBagConstraints(-1, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        managerPanel.add((Component)noManagerButton, new GridBagConstraints(-1, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        managerPanel.add((Component)chooseManagerButton, new GridBagConstraints(-1, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        managerPanel.add((Component)historyManagerButton, new GridBagConstraints(-1, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.notificationButton[0] = new BGButton("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c");
        this.notificationButton[0].addActionListener(e -> {
            this.notification[0] = String.valueOf(((ComboBoxItem)this.notificationComboBox.getSelectedItem()).getObject());
            this.notification[1] = this.notificationTF.getText();
            try {
                this.getHelpdeskService().topicNotificationUpdate(Integer.valueOf(this.topicId).intValue(), Integer.valueOf(this.notification[0]).intValue(), this.notification[1]);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.notificationButton[0].setEnabled(false);
            this.notificationButton[1].setEnabled(false);
        });
        this.notificationButton[1] = new BGButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        this.notificationButton[1].addActionListener(event -> {
            ClientUtils.setComboBoxSelection(this.notificationComboBox, (Object)this.notification[0]);
            this.notificationTF.setText(this.notification[1]);
            this.notificationButton[0].setEnabled(false);
            this.notificationButton[1].setEnabled(false);
        });
        this.notificationComboBox.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                ComboBoxItem comboBoxItem = (ComboBoxItem)event.getItem();
                this.notificationTF.setText(String.valueOf(comboBoxItem.getObject()).equals(this.notification[0]) ? this.notification[1] : "");
                this.notificationTF.setEnabled(!"0".equals(String.valueOf(comboBoxItem.getObject())));
                this.setNotificationButtonEnable(comboBoxItem, this.notificationTF.getText());
            }
        });
        this.notificationTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent event) {
                HelpdeskMessageTab.this.setNotificationButtonEnable((ComboBoxItem)HelpdeskMessageTab.this.notificationComboBox.getSelectedItem(), HelpdeskMessageTab.this.notificationTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                HelpdeskMessageTab.this.setNotificationButtonEnable((ComboBoxItem)HelpdeskMessageTab.this.notificationComboBox.getSelectedItem(), HelpdeskMessageTab.this.notificationTF.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
                HelpdeskMessageTab.this.setNotificationButtonEnable((ComboBoxItem)HelpdeskMessageTab.this.notificationComboBox.getSelectedItem(), HelpdeskMessageTab.this.notificationTF.getText());
            }
        });
        WhitePanel notificationPanel = new WhitePanel();
        notificationPanel.add(this.notificationComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        notificationPanel.add((Component)this.notificationTF, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        notificationPanel.add((Component)this.notificationButton[0], new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 3, new Insets(0, 5, 5, 0), 0, 0));
        notificationPanel.add((Component)this.notificationButton[1], new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 5, 5, 0), 0, 0));
        int y = 0;
        WhitePanel paramPanel = new WhitePanel();
        paramPanel.add((Component)new JLabel("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f/\u041f\u043e\u0434\u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f:"), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 5, 2, 0), 0, 0));
        paramPanel.add((Component)this.categorySubcategory, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        paramPanel.add((Component)new JLabel("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435:"), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 2, 0), 0, 0));
        paramPanel.add(this.stateClosedComboBox, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        paramPanel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441:"), new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 2, 0), 0, 0));
        paramPanel.add((Component)this.statusComboBox, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        paramPanel.add((Component)new JLabel("\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u0442\u044c \u0430\u0432\u0442\u043e\u043c.:"), new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 2, 0), 0, 0));
        paramPanel.add((Component)this.autocloseComboBox, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        paramPanel.add((Component)new JLabel("\u041c\u0435\u043d\u0435\u0434\u0436\u0435\u0440: "), new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 2, 0), 0, 0));
        paramPanel.add((Component)managerPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        paramPanel.add((Component)this.cardsCostIncludePanel, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        paramPanel.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c \u043e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u044f: "), new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 2, 0), 0, 0));
        paramPanel.add((Component)notificationPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        paramPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, y++, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JScrollPane scrollPane = new JScrollPane(paramPanel);
        scrollPane.setMinimumSize(new Dimension(350, 50));
        scrollPane.setPreferredSize(new Dimension(350, 50));
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        WhitePanel panel = new WhitePanel();
        panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    private void setNotificationButtonEnable(ComboBoxItem item, String value) {
        boolean fl = value.equals(this.notification[1]);
        fl = fl && String.valueOf(item.getObject()).equals(this.notification[0]);
        this.notificationButton[0].setEnabled(!fl || "0".equals(String.valueOf(item.getObject())) && Utils.isBlankString((String)this.notification[0]));
        this.notificationButton[1].setEnabled(!fl);
    }

    protected void showFilter() {
        this.infoPanel1.setVisible(this.filterButton.isSelected());
        if (!this.filterButton.isSelected()) {
            this.resetFilter();
        }
    }

    protected void resetFilter() {
        this.message.setText("");
        this.id_topic.setText("");
        this.title.setText("");
        this.periodPanel.setDateCalendar1(null);
        this.periodPanel.setDateCalendar2(null);
        if (this.statusBox.getModel().getSize() > 0) {
            this.statusBox.setSelectedIndex(0);
        }
    }

    private void initTablePanel() {
        this.autocloseComboBox.setData(this.autoclosebleItems);
        this.packageIncludeComboBox.addItem(new ComboBoxItem((Object)true, "\u0434\u0430"));
        this.packageIncludeComboBox.addItem(new ComboBoxItem((Object)false, "\u043d\u0435\u0442"));
        this.stateClosedComboBox.addItem(new ComboBoxItem((Object)false, "\u043e\u0442\u043a\u0440\u044b\u0442\u0430"));
        this.stateClosedComboBox.addItem(new ComboBoxItem((Object)true, "\u0437\u0430\u043a\u0440\u044b\u0442\u0430"));
        this.notificationComboBox.addItem(new ComboBoxItem(0, "\u043d\u0435 \u043e\u043f\u043e\u0432\u0435\u0449\u0430\u0442\u044c"));
        this.notificationComboBox.addItem(new ComboBoxItem(1, "\u043f\u043e \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0443"));
        this.notificationComboBox.addItem(new ComboBoxItem(2, "\u043f\u043e e-mail"));
        this.notificationComboBox.addItem(new ComboBoxItem(3, "\u043f\u043e sms"));
        this.notificationComboBox.addItem(new ComboBoxItem(4, "\u043f\u043e telegram"));
        BGSwingUtilites.handleLDMouseClicked(this.messageList, e -> this.performAction("edit"));
        this.costTextField.setHorizontalAlignment(4);
        BGButton okCostButton = new BGButton("OK");
        okCostButton.addActionListener(e -> this.applyTopicCost(this.costTextField.getText()));
        BGButton resetCostButton = new BGButton("\u0421\u0431\u0440\u043e\u0441");
        resetCostButton.addActionListener(e -> {
            this.costTextField.setText("0.00");
            this.applyTopicCost("0");
        });
        WhitePanel costPanel = new WhitePanel();
        costPanel.add((Component)new JLabel("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 2, 5), 0, 0));
        costPanel.add((Component)this.costTextField, new GridBagConstraints(-1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        costPanel.add((Component)new JLabel(ClientSetup.getInstance().get("dbinfo.currency.title.medium", "\u0440\u0443\u0431.")), new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        costPanel.add((Component)okCostButton, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        costPanel.add((Component)resetCostButton, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        WhitePanel packageIncludePanel = new WhitePanel();
        packageIncludePanel.add((Component)new JLabel("\u0412\u0445\u043e\u0434\u0438\u0442 \u0432 \u043f\u0430\u043a\u0435\u0442:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 2, 0), 0, 0));
        packageIncludePanel.add(this.packageIncludeComboBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.cardsCostIncludePanel.add((Component)costPanel, this.COST_PANEL);
        this.cardsCostIncludePanel.add((Component)packageIncludePanel, this.INCLUDE_PANEL);
        JPanel topicPanel = new JPanel(new GridBagLayout());
        topicPanel.add((Component)this.topicTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGButton showTopicTable = new BGButton("\u041a \u0441\u043f\u0438\u0441\u043a\u0443 \u0442\u0435\u043c");
        showTopicTable.addActionListener(e -> {
            this.mode = "topic";
            this.tableCardLayout.show(this.tablePanel, this.mode);
            this.infoPanel.setVisible(true);
            this.performAction("refresh");
        });
        JPanel topicSubjectPanel1 = new JPanel(new GridBagLayout());
        topicSubjectPanel1.add((Component)showTopicTable, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        topicSubjectPanel1.add((Component)this.messageItogoLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 25, 0, 10), 0, 0));
        topicSubjectPanel1.add((Component)this.messagePagePanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        Color bgColor = this.topicTitleField.getBackground();
        this.topicTitleField.setEditable(false);
        this.topicTitleField.setBackground(bgColor);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)topicSubjectPanel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)this.topicTitleField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 5, 0), 0, 0));
        JPanel messagePanel = new JPanel(new BorderLayout());
        messagePanel.add((Component)panel, "North");
        messagePanel.add((Component)new BGSplitPaneNoBorder(1, (Component)new JScrollPane(this.messageList), (Component)((Object)this.editor), 400L), "Center");
        messagePanel.add((Component)this.getParamPanel(), "East");
        this.tablePanel = new JPanel(this.tableCardLayout);
        this.tablePanel.add((Component)topicPanel, "topic");
        this.tablePanel.add((Component)messagePanel, "message");
    }

    public ClientContext getContext() {
        return (ClientContext)super.getContext();
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (this.statusBox.getData() == null) {
                this.comboBoxUpdateFlag = true;
                this.statusList = this.getHelpdeskService().topicStatusList();
                this.statusList.add(0, new IdTitle(-1, "---------"));
                this.statusBox.setData(this.statusList);
                this.statusComboBox.setData(this.statusList);
                this.comboBoxUpdateFlag = false;
                this.categoryList.addAll(this.getHelpdeskService().categoryList(new Page(1, 0)).getList());
                this.subcategoryList.addAll(this.getHelpdeskService().subcategoryList(new Page(1, 0)).getList());
            }
            if ("topic".equals(this.mode)) {
                this.showFilter();
                BGTableModel activeTableModel = null;
                if (this.isPacketModeEnabled()) {
                    ((CardLayout)this.topicTable.getLayout()).show(this.topicTable, "packageModeTable");
                    activeTableModel = this.packageModeTopicTableModel;
                } else {
                    ((CardLayout)this.topicTable.getLayout()).show(this.topicTable, this.DEFAULT);
                    activeTableModel = this.defaultModeTopicTableModel;
                }
                Request request = new Request();
                request.setModule(this.getContext().getModule());
                request.setContractId(this.getContext().getContractId());
                request.setAction("GetTopicTable");
                request.setPageIndex(this.topicPagePanel.getPageIndex());
                request.setPageSize(this.topicPagePanel.getPageSize());
                request.setAttribute("closed", this.cpButtonGroup.getSelectedCommand());
                request.setAttribute("onlynew", this.buttonOnlyNew.isSelected());
                request.setAttribute("message", this.message.getText().trim());
                request.setAttribute("tid", this.id_topic.getText());
                request.setAttribute("status", ((IdTitle)this.statusBox.getSelectedItem()).getId());
                request.setAttribute("title", this.title.getText());
                request.setAttribute("userselect", this.cpButtonGroupUserSelect.getSelectedCommand());
                Document doc = TransferManager.getDocument((Request)request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    ArrayList<Element> data = new ArrayList<Element>();
                    for (Element element : XMLUtils.selectElements((Node)doc, (String)"//data/table/data/row")) {
                        data.add(element);
                    }
                    activeTableModel.setData(data, true);
                    Element tableElement = XMLUtils.selectElement((Node)doc, (String)"//data/table");
                    this.topicPagePanel.setPageInfo(tableElement);
                    this.toticItogoLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Page.getRecordCount((Element)tableElement));
                }
            } else if ("message".equals(this.mode) && this.topicId > 0) {
                String selectCategoryId = "";
                String selectSubcategoryId = "";
                Topic topic = ((HelpdeskService)this.getContext().getWebService(HelpdeskService.class)).topicGet(this.getContext().getContractId(), this.topicId, false);
                if (topic != null) {
                    this.topicUserId = topic.getUserId();
                    String topicSubject = "ID: " + this.topicId + " \u0422\u0435\u043c\u0430: " + topic.getTitle();
                    this.topicTitleField.setText(topicSubject);
                    this.managerTF.setText(topic.getUserName());
                    this.costTextField.setText(topic.getCost().toPlainString());
                    selectCategoryId = String.valueOf(topic.getCategoryId());
                    selectSubcategoryId = String.valueOf(topic.getSubcategoryId());
                    this.comboBoxUpdateFlag = true;
                    this.notification[0] = String.valueOf(topic.getComm());
                    this.notification[1] = String.valueOf(topic.getCommValue());
                    this.notificationTF.setText(this.notification[1]);
                    this.notificationTF.setEnabled(!"0".equals(this.notification[0]));
                    this.notificationButton[0].setEnabled(false);
                    this.notificationButton[1].setEnabled(false);
                    int id = topic.isAutoClose() ? 1 : 0;
                    this.autocloseComboBox.setSelectedItem((Object)this.autoclosebleItems.stream().filter(a -> a.getId() == id).findFirst().orElse(this.autoclosebleItems.get(0)));
                    ClientUtils.setComboBoxSelection(this.packageIncludeComboBox, (Object)(topic.getContractPackageId() != -1 ? 1 : 0));
                    ClientUtils.setComboBoxSelection(this.stateClosedComboBox, (Object)topic.isClosed());
                    ClientUtils.setComboBoxSelection(this.notificationComboBox, (Object)this.notification[0]);
                    this.statusComboBox.setSelectedItem((Object)this.statusList.stream().filter(a -> a.getId() == topic.getStatus()).findFirst().orElse(this.statusList.get(0)));
                    this.comboBoxUpdateFlag = false;
                }
                this.categorySubcategory.setData(this.getHelpdeskService().categorySubcategoryIdsForGroup(this.getContext().getContractId()), this.categoryList, this.subcategoryList, selectCategoryId, selectSubcategoryId);
                this.loadMessageOfList();
            }
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            if ("message".equals(this.mode)) {
                this.editor.startEdit(0, this.topicId, this.topicUserId, 3);
            }
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            if ("topic".equals(this.mode)) {
                BGTableModel activeTableModel = this.isPacketModeEnabled() ? this.packageModeTopicTableModel : this.defaultModeTopicTableModel;
                this.openTopic(Utils.parseInt((String)((Element)activeTableModel.getSelectedRow()).getAttribute("id"), (int)0));
            } else if ("message".equals(this.mode)) {
                Message rowMap = this.messageList.getSelectedValue();
                if (rowMap == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
                } else {
                    int id = rowMap.getId();
                    if (this.topicId > 0) {
                        this.messageRow = this.messageList.getSelectedIndex();
                        this.editor.startEdit(id, this.topicId, this.topicUserId, 1);
                        this.checkButtonStates();
                    }
                }
            }
            this.messageList.requestFocus();
        });
    }

    public void openTopic(int topicId) {
        this.topicId = topicId;
        if (topicId > 0) {
            this.mode = "message";
            this.tableCardLayout.show(this.tablePanel, this.mode);
            this.infoPanel.setVisible(false);
            this.messagePagePanel.init();
            this.messagePagePanel.setPageIndex(Integer.MAX_VALUE);
            this.performAction("refresh");
            this.selectFirstMessage();
        }
    }

    public void selectFirstMessage() {
        this.messageList.setSelectedIndex(0);
        this.performAction("edit");
    }

    public void contractModeChanged(String contractMode) {
        CardLayout cl = (CardLayout)this.cardsCostIncludePanel.getLayout();
        if ("package".equals(contractMode)) {
            cl.show(this.cardsCostIncludePanel, this.INCLUDE_PANEL);
        } else {
            cl.show(this.cardsCostIncludePanel, this.COST_PANEL);
        }
    }

    public void editItem(int id, int mode) {
        this.editor.startEdit(id, this.topicId, this.topicUserId, mode);
    }

    public void setTopicPackageState(Boolean include) {
        try {
            this.getHelpdeskService().topicPackageStateSet(this.getContext().getContractId(), this.topicId, include);
            this.performAction("refresh");
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void onBindThisTopic(String userId) {
        try {
            this.getHelpdeskService().topicBindSet(this.topicId, userId);
            this.performAction("refresh");
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void checkButtonStates() {
        boolean prevEnabled = false;
        boolean nextEnabled = false;
        boolean bl = prevEnabled = this.messageRow != 0 || this.messagePagePanel.getPageIndex() != 1;
        if (this.messageRow < this.messageList.getModel().getSize() - 1 || this.messagePagePanel.getPageIndex() != this.messagePagePanel.getPageCount()) {
            nextEnabled = true;
        }
        this.editor.setButtonStates(prevEnabled, nextEnabled);
    }

    public void onPrevButton() {
        if (this.messageRow > 0) {
            --this.messageRow;
            this.messageList.setSelectedIndex(this.messageRow);
            Message rowMap = this.messageList.getSelectedValue();
            if (rowMap != null) {
                this.editor.startEdit(rowMap.getId(), this.topicId, this.topicUserId, 1);
            }
        } else if (this.messageRow == 0) {
            if (this.messagePagePanel.getPageIndex() - 1 < this.messagePagePanel.getPageCount()) {
                this.messagePagePanel.setPageIndex(this.messagePagePanel.getPageIndex() - 1);
            }
            this.loadMessageOfList();
            this.messageRow = this.messagePagePanel.getPageSize() - 1;
            this.messageList.setSelectedIndex(this.messageRow);
            Message rowMap = this.messageList.getSelectedValue();
            if (rowMap != null) {
                this.editor.startEdit(rowMap.getId(), this.topicId, this.topicUserId, 1);
            }
        }
        this.checkButtonStates();
    }

    public void onNextButton() {
        if (this.messageRow < this.messageList.getModel().getSize() - 1) {
            ++this.messageRow;
            this.messageList.setSelectedIndex(this.messageRow);
            Message rowMap = this.messageList.getSelectedValue();
            if (rowMap != null) {
                this.editor.startEdit(rowMap.getId(), this.topicId, this.topicUserId, 1);
            }
        } else if (this.messagePagePanel.getPageIndex() != this.messagePagePanel.getPageCount()) {
            this.messageRow = 0;
            if (this.messagePagePanel.getPageIndex() < this.messagePagePanel.getPageCount()) {
                this.messagePagePanel.setPageIndex(this.messagePagePanel.getPageIndex() + 1);
            }
            this.loadMessageOfList();
            this.messageList.setSelectedIndex(this.messageRow);
            Message rowMap = this.messageList.getSelectedValue();
            if (rowMap != null) {
                this.editor.startEdit(rowMap.getId(), this.topicId, this.topicUserId, 1);
            }
        }
        this.checkButtonStates();
    }

    public void loadMessageOfList() {
        try {
            this.searchResult = ((HelpdeskService)this.getContext().getWebService(HelpdeskService.class)).searchTopicMessages(this.getContext().getContractId(), this.topicId, null, this.messagePagePanel.getPage());
            DefaultListModel defaultListModel = new DefaultListModel();
            this.searchResult.getList().forEach(e -> defaultListModel.addElement(e));
            int index = this.messageList.getSelectedIndex();
            this.messageList.setModel(defaultListModel);
            this.messageList.setSelectedIndex(index);
            this.messagePagePanel.setPage(this.searchResult.getPage());
            this.messageItogoLabel.setText("\u0417\u0430\u043f\u0438\u0441\u0435\u0439: " + this.searchResult.getPage().getRecordCount());
        }
        catch (Exception e2) {
            ClientUtils.showErrorMessageDialog((Throwable)e2);
        }
    }

    private boolean isPacketModeEnabled() {
        boolean packageModeEnabled = false;
        try {
            ClientContext clientContext = this.getContext();
            String currentMode = ((HelpdeskService)clientContext.getWebService(HelpdeskService.class)).getContractCurrentMode(this.getContext().getContractId());
            if (currentMode.equals("package")) {
                packageModeEnabled = true;
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        return packageModeEnabled;
    }

    private void applyTopicCost(String cost) {
        try {
            StringBuffer sb = new StringBuffer();
            if (this.getHelpdeskService().topicCostUpdate(Integer.valueOf(this.topicId).intValue(), Utils.parseBigDecimal((String)cost, (BigDecimal)BigDecimal.ONE.negate())) > 0) {
                sb.append("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0430.\n");
            }
            if (sb.length() > 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), sb.toString(), "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private HelpdeskService getHelpdeskService() {
        return (HelpdeskService)this.getContext().getWebService(HelpdeskService.class);
    }

    class DefaultModeTopicTableModel
    extends BGTableModel<Element> {
        public DefaultModeTopicTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435", 90, 90, 90, "state", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u043e\u0437\u0434\u0430\u043d\u0430", 150, 150, 150, "date", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0422\u0435\u043c\u0430", -1, -1, -1, "subject", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041c\u0435\u043d\u0435\u0434\u0436\u0435\u0440", 100, 150, 200, "user", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 [\u043d\u043e\u0432\u044b\u0445]", 50, 100, 150, "messages", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumn("\u041f\u043e\u0441\u043b. \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 150, 150, 150, "lastmessage", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 100, 150, 150, "status", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", 100, 100, 100, "cost", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u0410\u0432\u0442.\u0437\u0430\u043a\u0440.", Boolean.class, 50, 50, 50, "auto_close", true);
        }

        public Object getValue(Element val, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("auto_close".equals(identifier)) {
                return Boolean.valueOf(val.getAttribute(identifier));
            }
            return super.getValue((Object)val, column);
        }
    }

    class PackageModeTopicTableModel
    extends BGTableModel<Element> {
        public PackageModeTopicTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435", 90, 90, 90, "state", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u043e\u0437\u0434\u0430\u043d\u0430", 150, 150, 150, "date", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0422\u0435\u043c\u0430", -1, -1, -1, "subject", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041c\u0435\u043d\u0435\u0434\u0436\u0435\u0440", 100, 150, 200, "user", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 [\u043d\u043e\u0432\u044b\u0445]", 50, 100, 150, "messages", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumn("\u041f\u043e\u0441\u043b. \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 150, 150, 150, "lastmessage", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 100, 150, 150, "status", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", 100, 100, 100, "cost", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u041f\u0430\u043a\u0435\u0442", Boolean.class, 50, 50, 50, "package", true);
            this.addColumn("\u0410\u0432\u0442.\u0437\u0430\u043a\u0440.", Boolean.class, 50, 50, 50, "auto_close", true);
        }

        public Object getValue(Element val, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("auto_close".equals(identifier)) {
                return Boolean.valueOf(val.getAttribute(identifier));
            }
            if ("package".equals(identifier)) {
                return Boolean.valueOf(val.getAttribute(identifier));
            }
            return super.getValue((Object)val, column);
        }
    }

    public class MessageListCellRenderer
    implements ListCellRenderer<Message> {
        private Font font1 = new Font("Dialog", 2, 11);
        private Font font2 = new Font("Dialog", 0, 12);

        public MessageListCellRenderer(HelpdeskMessageTab this$0) {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Message> list, Message value, int index, boolean isSelected, boolean cellHasFocus) {
            String comment;
            String iconName = "mail_out";
            if (value.getUserIdFrom() == 0) {
                iconName = value.getUserIdFrom() == 0 && value.getUserIdTo() == -1 ? "mail_in_new" : "mail_in";
            }
            DateFormat format = TimeUtils.getDateFormat((String)"dd.MM.yyyy HH:mm");
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            panel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            panel.add((Component)new JLabel(ClientUtils.getIcon((String)iconName)), new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 3), 0, 0));
            panel.add((Component)new MessageLabel(TimeUtils.format((Date)value.getDateFrom(), (DateFormat)format), Color.DARK_GRAY, this.font2), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel(" # " + value.getUserNameFrom()), new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new MessageLabel("ID#" + Utils.formatBigDecimal((BigDecimal)BigDecimal.valueOf(value.getId()), (int)0), Color.GRAY, this.font2), new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new MessageLabel(TimeUtils.format((Date)value.getDateTo(), (DateFormat)format), Color.DARK_GRAY, this.font2), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel(" # " + value.getUserNameTo()), new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            if (value.isIncludes()) {
                panel.add((Component)new JLabel(ClientUtils.getIcon((String)"attach")), new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            }
            if ((comment = value.getComment()) != null) {
                JLabel label = new JLabel((String)(comment.length() > 60 ? comment.substring(0, 60) + "..." : comment));
                label.setFont(this.font1);
                label.setForeground(Color.GRAY);
                panel.add((Component)label, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
            }
            return panel;
        }

        class MessageLabel
        extends JLabel {
            public MessageLabel(String text, Color color, Font font) {
                super(text);
                this.setFont(font);
                this.setForeground(color);
            }
        }
    }

    class WhitePanel
    extends JPanel {
        public WhitePanel() {
            super(new GridBagLayout());
            this.setBackground(UIManager.getColor("Table.background"));
            this.setOpaque(true);
        }
    }

    class ManagerLogDialog
    extends BGEditorDialog<String> {
        public ManagerLogDialog(String title, String data) {
            super(title, (Object)data);
        }

        public void doDialogPanel() {
            ManagerLogTableModel logTableModel = new ManagerLogTableModel();
            BGUTable table = new BGUTable((TableModel)((Object)logTableModel));
            table.setSelectionMode(0);
            Dimension dimension = new Dimension(1200, 500);
            JScrollPane scrollPane = new JScrollPane((Component)table);
            scrollPane.setMinimumSize(dimension);
            scrollPane.setPreferredSize(dimension);
            this.panel.add((Component)scrollPane, new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 11, 1, new Insets(0, 10, 0, 0), 0, 0));
            try {
                logTableModel.setData(HelpdeskMessageTab.this.getHelpdeskService().topicManagerChangeList(HelpdeskMessageTab.this.topicId));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        class ManagerLogTableModel
        extends BGTableModel<ChangeManager> {
            public ManagerLogTableModel() {
                super(ManagerLogTableModel.class.getName());
            }

            protected void initColumns() {
                this.addColumn("\u0414\u0430\u0442\u0430", 150, 150, 150, "date", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
                this.addColumn("\u041c\u0435\u043d\u0435\u0434\u0436\u0435\u0440", 200, 200, 200, "userName", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 200, 200, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            }
        }
    }

    class ManagerSelectDialog
    extends BGEditorDialog<String> {
        private BGControlPanelListSelect managerList;
        private BGTextArea comment;

        public ManagerSelectDialog(String title, String data) {
            super(title, (Object)data);
            this.managerList = new BGControlPanelListSelect(true, 0);
            this.comment = new BGTextArea(15, 30);
        }

        public void doDialogPanel() {
            this.panel.add((Component)new BGEditorDialogVPanel("\u041c\u0435\u043d\u0435\u0434\u0436\u0435\u0440", (Component)this.managerList), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new BGEditorDialogVPanel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", (Component)new JScrollPane((Component)this.comment)), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 11, 1, new Insets(0, 10, 0, 0), 0, 0));
            ArrayList list = new ArrayList();
            try {
                HelpdeskMessageTab.this.getHelpdeskService().managerList().forEach(a -> list.add(new BGUListItem(a.getId(), a.getTitle())));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.managerList.getList().setData(list);
        }

        public boolean doApply() throws Exception {
            if (this.managerList.getSelectedElements().isEmpty()) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u0430");
                return false;
            }
            HelpdeskMessageTab.this.getHelpdeskService().topicManagerChange(HelpdeskMessageTab.this.topicId, ((BGUListItem)this.managerList.getSelectedElements().get(0)).getId(), this.comment.getText().trim());
            HelpdeskMessageTab.this.performAction("refresh");
            return true;
        }
    }
}

