/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.bonus.server.bean;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusPayment;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgram;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgramSpecification;
import ru.bitel.bgbilling.plugins.bonus.server.dao.BonusDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class OperationBonusProgram
implements BonusProgramSpecification {
    Connection con = null;
    ChargeDao chargeManager = null;
    PaymentDao paymentManager = null;

    public String getTitle() {
        return "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439";
    }

    public void accrualOfBonus(Connection con, BonusProgram program) throws Exception {
        this.con = con;
        this.paymentManager = new PaymentDao(con);
        this.chargeManager = new ChargeDao(con);
        BonusDao bonusDao = new BonusDao(con);
        Period period = this.getPeriod(program);
        if (period != null) {
            this.setLog(program.getId(), period);
            BigDecimal minSum = program.getParams().get("minSumOperationAll") != null ? new BigDecimal((String)program.getParams().get("minSumOperationAll")) : new BigDecimal(0);
            Period paymentPeriod = this.getPeriodForBonusPayment(program);
            for (Integer cid : bonusDao.getContractsOfThisProgram(program.getId(), new Date())) {
                BigDecimal bonusSum;
                BigDecimal allSum;
                if (!bonusDao.pluginInclude(cid) || minSum.compareTo(allSum = this.getSumOperationForPeriod(cid, program, period)) >= 1 || (bonusSum = this.getBonusSumAccrual(program, allSum)).compareTo(BigDecimal.ZERO) != 1) continue;
                BonusPayment bonusPayment = new BonusPayment(0, program.getPaymentTypeId(), new Date(), bonusSum, paymentPeriod.getDateFrom(), paymentPeriod.getDateTo());
                bonusDao.updatePayment(0, cid, bonusPayment);
            }
        }
    }

    public Period getPeriod(BonusProgram program) throws Exception {
        HashMap params = program.getParams();
        int accrualPeriod = Utils.parseInt((String)((String)params.get("accrualPeriod")));
        GregorianCalendar dateTo = new GregorianCalendar();
        dateTo.add(6, -1);
        TimeUtils.moveToEndDay((Calendar)dateTo);
        dateTo.set(14, 999);
        GregorianCalendar dateFrom = new GregorianCalendar();
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)dateFrom);
        switch (accrualPeriod) {
            case 1: {
                dateFrom.add(6, -1);
                if (this.isThisDay(program.getId(), dateFrom)) break;
                return null;
            }
            case 2: {
                if (dateFrom.get(5) == Utils.parseInt((String)((String)params.get("accrualPeriodDay")))) {
                    dateFrom.add(2, -1);
                    dateFrom.set(5, 1);
                    dateTo = new GregorianCalendar();
                    dateTo.add(2, -1);
                    TimeUtils.moveToEndOfMonth((Calendar)dateTo);
                    TimeUtils.moveToEndDay((Calendar)dateTo);
                    if (this.isThisDay(program.getId(), dateFrom)) break;
                    return null;
                }
                return null;
            }
            case 3: {
                dateFrom.add(6, 0 - Utils.parseInt((String)((String)params.get("accrualPeriodDay"))));
                if (program.getPeriod().getDateFrom().compareTo(dateFrom.getTime()) <= 0 && this.isThisDay(program.getId(), dateFrom)) break;
                return null;
            }
            default: {
                return null;
            }
        }
        return new Period(dateFrom.getTime(), dateTo.getTime());
    }

    public Period getPeriodForBonusPayment(BonusProgram program) {
        Calendar bDateFrom = Calendar.getInstance();
        String timeLag = program.getTimeLag();
        if (Utils.parseInt((String)timeLag, (int)-1) != -1) {
            bDateFrom.add(6, Utils.parseInt((String)timeLag));
        } else if (TimeUtils.parseCalendar((String)timeLag, (String)"dd.MM.yyyy") != null) {
            Calendar calen = TimeUtils.parseCalendar((String)timeLag, (String)"dd.MM.yyyy");
            if (calen.compareTo(Calendar.getInstance()) > 0) {
                bDateFrom = calen;
            }
        } else if (timeLag.equals("startWeek")) {
            bDateFrom.set(7, 2);
            bDateFrom.add(3, 1);
        } else if (timeLag.equals("startMonth")) {
            bDateFrom.add(2, 1);
            bDateFrom = TimeUtils.getStartMonth((Calendar)bDateFrom);
        } else if (timeLag.equals("startYear")) {
            bDateFrom.set(6, 1);
            bDateFrom.add(1, 1);
        }
        Calendar bDateTo = (GregorianCalendar)bDateFrom.clone();
        String activeTime = program.getActiveTime();
        if (Utils.parseInt((String)activeTime, (int)-1) != -1) {
            bDateTo.add(6, Utils.parseInt((String)activeTime));
        } else if (TimeUtils.parseDate((String)activeTime, (String)"dd.MM.yyyy") != null) {
            Calendar calen = TimeUtils.parseCalendar((String)timeLag, (String)"dd.MM.yyyy");
            if (calen.compareTo(Calendar.getInstance()) > 0) {
                bDateTo = calen;
            }
        } else if (activeTime.equals("endWeek")) {
            bDateTo.set(7, 1);
        } else if (activeTime.equals("endMonth")) {
            bDateTo = TimeUtils.getEndMonth((Calendar)bDateTo);
        } else if (activeTime.equals("endYear")) {
            bDateTo.set(6, 1);
            bDateTo.add(6, -1);
            bDateTo.add(1, 1);
        }
        return new Period(bDateFrom.getTime(), bDateTo.getTime());
    }

    public BigDecimal getBonusSumAccrual(BonusProgram program, BigDecimal allSum) {
        int typeCalculation = Utils.parseInt((String)((String)program.getParams().get("typeCalculation")));
        BigDecimal bonusSum = new BigDecimal(0);
        switch (typeCalculation) {
            case 1: {
                BigDecimal percent = Utils.parseBigDecimal((String)((String)program.getParams().get("valueCalculation")), (BigDecimal)BigDecimal.ZERO);
                if (percent.compareTo(BigDecimal.ZERO) != 1) break;
                bonusSum = percent.divide(new BigDecimal(100)).multiply(allSum);
                String rate = ((BGPluginServer)BGPluginManagerServer.getManager().getPluginsMap().get("ru.bitel.bgbilling.plugins.bonus")).getSetup().get("rate");
                bonusSum = bonusSum.multiply(new BigDecimal(Utils.parseInt((String)rate, (int)1)));
                break;
            }
            case 2: {
                bonusSum = Utils.parseBigDecimal((String)((String)program.getParams().get("valueCalculation")), (BigDecimal)BigDecimal.ZERO);
                break;
            }
            case 3: {
                BigDecimal stepValue = Utils.parseBigDecimal((String)((String)program.getParams().get("valueCalculation")), (BigDecimal)BigDecimal.ZERO);
                String paramName = ((String)program.getParams().get("accrualPeriod")).equals("4") ? "minSumOperation" : "minSumOperationAll";
                BigDecimal sumStep = Utils.parseBigDecimal((String)((String)program.getParams().get(paramName)), (BigDecimal)BigDecimal.ZERO);
                if (stepValue.compareTo(BigDecimal.ZERO) != 1 || sumStep.compareTo(BigDecimal.ZERO) != 1) break;
                int countStep = allSum.divide(sumStep, RoundingMode.DOWN).intValue();
                bonusSum = stepValue.multiply(new BigDecimal(countStep));
                break;
            }
            case 4: {
                String element;
                String[] m;
                List list = Utils.toList((String)((String)program.getParams().get("valueCalculation")));
                BigDecimal sum = BigDecimal.ZERO;
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && new BigDecimal((m = (element = (String)iterator.next()).split("-"))[0]).compareTo(allSum) != 1) {
                    sum = new BigDecimal(m[1]);
                }
                bonusSum = sum;
            }
        }
        return bonusSum;
    }

    public BigDecimal getSumOperationForPeriod(int cid, BonusProgram program, Period period) throws Exception {
        BigDecimal minSumOperation = program.getParams().get("minSumOperation") != null ? new BigDecimal((String)program.getParams().get("minSumOperation")) : new BigDecimal(0);
        BigDecimal allSum = BigDecimal.ZERO;
        int typeOperation = Utils.parseInt((String)((String)program.getParams().get("typeOperation")));
        Set typeSet = null;
        if (program.getParams().get("operationTypeId") != null) {
            typeSet = Utils.toIntegerSet((String)((String)program.getParams().get("operationTypeId")));
        }
        switch (typeOperation) {
            case 1: {
                for (Payment payment : this.paymentManager.getPaymentList(cid, period, 1).getList()) {
                    if (typeSet != null && !typeSet.contains(payment.getTypeId()) || payment.getSum().compareTo(minSumOperation) <= -1) continue;
                    allSum = allSum.add(payment.getSum());
                }
                break;
            }
            case 2: {
                for (Charge charge : this.chargeManager.getChargeList(cid, 0, period, 1).getList()) {
                    if (typeSet != null && !typeSet.contains(charge.getTypeId()) || charge.getSum().compareTo(minSumOperation) <= -1) continue;
                    allSum = allSum.add(charge.getSum());
                }
                break;
            }
            case 3: {
                if (typeSet != null) {
                    allSum = this.getAccountAllSum(cid, period.getDateFromCalendar(), Utils.toIntegerList((String)((String)program.getParams().get("operationTypeId"))), minSumOperation);
                    break;
                }
                allSum = this.getAccountAllSum(cid, period.getDateFromCalendar(), null, minSumOperation);
                break;
            }
            default: {
                return BigDecimal.ZERO;
            }
        }
        return allSum;
    }

    private boolean isThisDay(int programId, GregorianCalendar dateFrom) throws Exception {
        boolean result = false;
        String query = "SELECT COUNT(*) AS count FROM bonus_program_log WHERE programId=? AND dateTo>=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, programId);
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)dateFrom));
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next() && rs.getInt("count") == 0) {
                    result = true;
                }
            }
        }
        return result;
    }

    private BigDecimal getAccountAllSum(int cid, Calendar calendar, List<Integer> sidList, BigDecimal minSumOperation) throws Exception {
        BigDecimal allSum = null;
        StringBuilder query = new StringBuilder();
        if (sidList == null) {
            query.append("SELECT SUM(summa) AS allSum FROM contract_account WHERE cid=? AND yy=? AND mm=? AND summa>=?");
        } else if (sidList.size() == 1) {
            query.append("SELECT SUM(summa) AS allSum FROM contract_account WHERE cid=? AND yy=? AND mm=? AND summa>=? AND sid=" + String.valueOf(sidList.get(0)));
        } else {
            query.append("SELECT SUM(summa) AS allSum FROM contract_account WHERE cid=? AND yy=? AND mm=? AND summa>=? AND ( ");
            for (int i = 0; i < sidList.size() - 1; ++i) {
                query.append("sid=" + String.valueOf(sidList.get(i)) + " OR ");
            }
            query.append("sid=" + String.valueOf(sidList.get(sidList.size() - 1)) + ")");
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, cid);
            ps.setInt(2, calendar.get(1));
            ps.setInt(3, calendar.get(2) + 1);
            ps.setBigDecimal(4, minSumOperation);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    allSum = rs.getBigDecimal("allSum");
                }
            }
        }
        return allSum == null ? BigDecimal.ZERO : allSum;
    }

    private void setLog(int programId, Period period) throws Exception {
        String query = "INSERT INTO bonus_program_log VALUES ( ?, ?, ? ) ON DUPLICATE KEY UPDATE dateFrom=?, dateTo=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, programId);
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
            ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
            ps.setDate(5, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
            ps.executeUpdate();
            ps.close();
        }
    }
}

