/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.aots.server.service;

import jakarta.jws.WebService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.aots.common.bean.AOTSContractService;
import ru.bitel.bgbilling.modules.aots.common.service.AOTSService;
import ru.bitel.bgbilling.modules.aots.server.bean.AOTSContractServiceDao;
import ru.bitel.common.model.IdTitle;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.aots.common.service.AOTSService")
public class AOTSServiceImpl
extends AbstractService
implements AOTSService {
    public void aotsContractServiceDelete(String id) throws Exception {
    }

    public AOTSContractService aotsContractServiceNew(int contractId) throws Exception {
        return new AOTSContractService().setContractId(contractId).setServiceTime(LocalDateTime.now()).setAmount(BigDecimal.ONE).setCost(BigDecimal.ZERO).setNdsRate(new BigDecimal(20)).setServiceSum(BigDecimal.ZERO);
    }

    public AOTSContractService aotsContractServiceGet(String data) throws Exception {
        return new AOTSContractServiceDao(this.getConnection(), this.moduleId).getById(data);
    }

    public List<IdTitle> aotsServiceList(int serviceId) throws Exception {
        List services = ModuleCache.getInstance().getModuleServicesList(this.moduleId);
        return services.stream().filter(a -> a.isUsing() || a.getId() == serviceId).map(IdTitle::toIdTitle).toList();
    }

    public void aotsContractServiceUpdate(int contractId, AOTSContractService contractService) throws Exception {
        Objects.requireNonNull(contractService, "contractService must be not null");
        if (contractService.getId() == null && contractService.getServiceTime().toLocalDate().isEqual(LocalDate.now())) {
            contractService.setServiceTime(LocalDateTime.now());
        }
        contractService.setUserId(this.userId);
        new AOTSContractServiceDao(this.getConnection(), this.moduleId).update(contractService);
    }
}

