/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import jakarta.servlet.ServletContext;
import jakarta.xml.bind.annotation.XmlMimeType;
import jakarta.xml.ws.WebServiceContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.apps.voice.accounting.bean.SessionAccountAmount;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDestination;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperator;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSessionFilter;
import ru.bitel.bgbilling.modules.voice.common.bean.report.SessionAccountReportItem;
import ru.bitel.bgbilling.modules.voice.common.bean.report.SessionDestinationReportItem;
import ru.bitel.bgbilling.modules.voice.common.bean.report.SessionDetail;
import ru.bitel.bgbilling.modules.voice.common.bean.report.SessionDetailReportItem;
import ru.bitel.bgbilling.modules.voice.common.bean.report.SessionServiceReportItem;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceSessionService;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionExporter;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionLogDao;
import ru.bitel.bgbilling.modules.voice.server.bean.operator.Operator;
import ru.bitel.bgbilling.modules.voice.server.bean.operator.OperatorManager;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceSessionFinishEvent;
import ru.bitel.bgbilling.modules.voice.server.mail.MailSessionDetailReport;
import ru.bitel.bgbilling.modules.voice.server.mail.MailSessionReport;
import ru.bitel.bgbilling.modules.voice.server.reports.VoiceReportBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceSessionService")
public class VoiceSessionServiceImpl
extends AbstractService
implements VoiceSessionService {
    @Resource
    private WebServiceContext wsc;
    @Resource
    private VoiceService voiceService;

    public Result<VoiceSession> voiceSessionContractList(VoiceSessionFilter filter, Page page) throws BGException {
        Result result;
        try (VoiceSessionDao sessionDao = new VoiceSessionDao(this.getConnection(), this.moduleId);){
            List<VoiceSession> sessionList = sessionDao.list(filter, page, true);
            result = new Result(sessionList, page);
            this.addTotals(result, page, sessionDao, filter);
        }
        return result;
    }

    private void addTotals(Result<?> result, Page page, VoiceSessionLogDao sessionDao, VoiceSessionFilter filter) throws BGException {
        result.setAttribute("totalCount", (Object)page.getRecordCount());
        SessionAccountAmount accAmount = sessionDao.getContractSums(filter);
        result.setAttribute("totalTime", (Object)accAmount.getAmount());
        result.setAttribute("totalTimeRound", (Object)accAmount.getAmountRound());
        result.setAttribute("totalSum", (Object)accAmount.getAccount());
    }

    public Result<VoiceSession> voiceSessionLogContractList(VoiceSessionFilter filter, Page page) throws BGException {
        Result result;
        try (VoiceSessionLogDao sessionDao = new VoiceSessionLogDao(this.getConnection(), this.moduleId, filter.getHourFrom());){
            List<VoiceSession> sessionList = sessionDao.list(filter, page, true);
            result = new Result(sessionList, page);
            this.addTotals(result, page, sessionDao, filter);
        }
        return result;
    }

    public Result<VoiceSession> voiceSessionLogList(VoiceSessionFilter filter, Page page) throws BGException {
        List<Object> sessionList = new ArrayList();
        try (VoiceSessionLogDao sessionDao = new VoiceSessionLogDao(this.getConnection(), this.moduleId, filter.getDateFrom());){
            sessionList = sessionDao.list(filter, page, false);
        }
        return new Result(sessionList, page);
    }

    public Result<VoiceSession> voiceSessionList(VoiceSessionFilter filter, Page page) throws BGException {
        List<Object> sessionList = new ArrayList();
        try (VoiceSessionDao sessionDao = new VoiceSessionDao(this.getConnection(), this.moduleId);){
            sessionList = sessionDao.list(filter, page, false);
        }
        return new Result(sessionList, page);
    }

    public void sessionFinish(long sessionId) throws BGException {
        VoiceSessionFinishEvent event = (VoiceSessionFinishEvent)EventProcessor.getInstance().request((QueueEvent)new VoiceSessionFinishEvent(this.moduleId, this.userId, sessionId));
        if (event == null) {
            throw new BGMessageException("\u0422\u0430\u0439\u043c\u0430\u0443\u0442 \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e Accounting \u0441\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d");
        }
    }

    public List<SessionAccountReportItem> voiceSessionReportGroupByAccount(VoiceSessionFilter filter) throws BGException {
        try (VoiceSessionLogDao sessionDao = new VoiceSessionLogDao(this.getConnection(), this.moduleId, filter.getHourFrom());){
            List<SessionAccountReportItem> list = sessionDao.getSessionsGroupedByAccount(filter);
            return list;
        }
    }

    public List<SessionDestinationReportItem> voiceSessionReportGroupByAccountAndDestination(VoiceSessionFilter filter) throws BGException {
        try (VoiceSessionLogDao sessionDao = new VoiceSessionLogDao(this.getConnection(), this.moduleId, filter.getHourFrom());){
            List<SessionDestinationReportItem> list = sessionDao.getSessionsGroupedByAccountAndDestination(filter);
            return list;
        }
    }

    public List<SessionServiceReportItem> voiceSessionReportGroupByAccountAndService(VoiceSessionFilter filter) throws BGException {
        try (VoiceSessionLogDao sessionDao = new VoiceSessionLogDao(this.getConnection(), this.moduleId, filter.getHourFrom());){
            List<SessionServiceReportItem> list = sessionDao.getSessionsGroupedByAccountAndService(filter);
            return list;
        }
    }

    public Result<SessionDetail<SessionDetail<SessionDetailReportItem>>> voiceSessionDetailReport(VoiceSessionFilter filter, Page page) throws BGException {
        try (VoiceSessionLogDao sessionDao = new VoiceSessionLogDao(this.getConnection(), this.moduleId, filter.getHourFrom());){
            List<SessionDetail<SessionDetail<SessionDetailReportItem>>> detailList = sessionDao.getSessionsDetail(filter, page);
            Result result = new Result();
            result.setList(detailList);
            result.setPage(page);
            Map<String, SessionDetail> resultMap = sessionDao.getDetailSumValues(filter);
            for (SessionDetail<SessionDetail<SessionDetailReportItem>> det : detailList) {
                int serviceId = det.getServiceId();
                SessionDetail serviceDetail = resultMap.get(serviceId + "_0");
                det.copyInfoFrom(serviceDetail);
                for (SessionDetail det2 : det.getResult()) {
                    int accountId = det2.getAccountId();
                    SessionDetail accountDetail = resultMap.get(serviceId + "_" + accountId);
                    det2.copyInfoFrom(accountDetail);
                }
            }
            this.addTotals(result, page, sessionDao, filter);
            Result result2 = result;
            return result2;
        }
    }

    @XmlMimeType(value="application/octet-stream")
    public DataHandler voiceSessionContractLogExport(VoiceSessionFilter filter, String format, Page page) throws BGException {
        return (DataHandler)this.tryReturn(() -> {
            Result<VoiceSession> result = this.voiceSessionLogContractList(filter, page);
            SearchResult data = this.voiceService.voiceDestinationList(VoiceOperator.OPERTOR_ALL_ID, null, page);
            Map destinationsMap = VoiceDestination.getDestinationMap((List)data.getList());
            InputStream exportDataStream = null;
            if (format.equals("csv")) {
                char separator = this.getModuleSetup().get("csv.separator", ";").charAt(0);
                exportDataStream = new VoiceSessionExporter().csvExport(result, separator, destinationsMap);
            } else {
                Contract contract = this.getContract((Integer)filter.getContractIds().toArray()[0]);
                ServletContext context = (ServletContext)this.wsc.getMessageContext().get((Object)"jakarta.xml.ws.servlet.context");
                exportDataStream = new VoiceSessionExporter().htmlSessionExport(contract, new Period(filter.getHourFrom(), filter.getHourTo()), result, context, destinationsMap);
            }
            return this.createDataHandler("text/plain", exportDataStream);
        });
    }

    private DataHandler createDataHandler(final String contentType, final InputStream exportDataStream) {
        return new DataHandler(new DataSource(){

            public String getContentType() {
                return contentType;
            }

            public InputStream getInputStream() throws IOException {
                return exportDataStream;
            }

            public String getName() {
                return "sessions.html";
            }

            public OutputStream getOutputStream() throws IOException {
                return null;
            }
        });
    }

    public DataHandler voiceSessionDetailExport(VoiceSessionFilter filter, String format) throws BGException {
        return (DataHandler)this.tryReturn(() -> {
            InputStream exportDataStream;
            String contentType = "text/plain";
            Page page = new Page(1, Integer.MAX_VALUE);
            Result<SessionDetail<SessionDetail<SessionDetailReportItem>>> result = this.voiceSessionDetailReport(filter, page);
            try (VoiceSessionLogDao sessionDao = new VoiceSessionLogDao(this.getConnection(), this.moduleId, filter.getHourFrom());){
                this.addTotals(result, page, sessionDao, filter);
            }
            if (format.equals("csv")) {
                char separator = this.getModuleSetup().get("csv.separator", ";").charAt(0);
                exportDataStream = new VoiceSessionExporter().csvDetailExport(result, separator);
            } else if (format.equals("html")) {
                Contract contract = this.getContract((Integer)filter.getContractIds().toArray()[0]);
                ServletContext context = (ServletContext)this.wsc.getMessageContext().get((Object)"jakarta.xml.ws.servlet.context");
                exportDataStream = new VoiceSessionExporter().htmlDetailExport(contract, new Period(filter.getHourFrom(), filter.getHourTo()), result, context);
            } else {
                throw new BGException("Unknowm format");
            }
            return this.createDataHandler(contentType, exportDataStream);
        });
    }

    public void voiceSessionDetailEmail(VoiceSessionFilter filter, List<String> emails) throws BGException {
        this.tryCall(() -> {
            Period period = new Period(filter.getHourFrom(), filter.getHourTo());
            MailSessionDetailReport mailData = new MailSessionDetailReport();
            mailData.setModuleId(this.moduleId);
            mailData.setSubject("\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0441\u0435\u0441\u0441\u0438\u0439 ( " + TimeUtils.formatPeriod((Period)period) + " )");
            this.sendReport(emails, this.voiceSessionDetailExport(filter, "html"), mailData);
        });
    }

    public void voiceSessionEmail(VoiceSessionFilter filter, List<String> emails, Page page) throws BGException {
        this.tryCall(() -> {
            Period period = new Period(filter.getHourFrom(), filter.getHourTo());
            MailSessionReport mailData = new MailSessionReport().setModuleId(this.moduleId).setSubject("\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u0441\u0435\u0441\u0441\u0438\u044f\u043c ( " + TimeUtils.formatPeriod((Period)period) + " )");
            this.sendReport(emails, this.voiceSessionContractLogExport(filter, "html", page), mailData);
        });
    }

    private void sendReport(List<String> emails, DataHandler data, MailData mailData) throws BGException {
        this.tryCall(() -> {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                data.writeTo((OutputStream)baos);
                mailData.addPart("file", "attachment", "text/html", data.getName(), baos.toByteArray());
            }
            MailMsg msg = new MailMsg((Preferences)Setup.getSetup());
            for (String email : emails) {
                mailData.setRecipients(email);
                msg.sendMessage(mailData);
            }
        });
    }

    public String getParameter(String key) throws BGException {
        return ServerUtils.getSetupValue((Connection)this.getConnection(), (String)("voice_" + key + "_" + this.moduleId));
    }

    public String getParameters(String reportType) throws BGException, BGMessageException {
        JSONObject jsonObject = new JSONObject();
        String className = ServerUtils.getSetupValue((Connection)this.getConnection(), (String)("voice_" + reportType.toLowerCase() + "_class_" + this.moduleId));
        if (className != null) {
            jsonObject.put("className", (Object)className);
            JSONArray array = new JSONArray();
            jsonObject.put("params", (Object)array);
            for (String key : ((VoiceReportBase)DynamicClassManager.getInstance().newInstance(VoiceReportBase.class, className)).getParamKeys(this.moduleId)) {
                JSONObject param = new JSONObject();
                param.put("name", (Object)key);
                param.put("value", (Object)ServerUtils.getSetupValue((Connection)this.getConnection(), (String)("voice_" + reportType.toLowerCase() + "_" + key + "_" + this.moduleId), (String)""));
                array.put((Object)param);
            }
        }
        return jsonObject.toString();
    }

    public void updateParameter(String key, String value) throws BGException {
        if (Utils.isEmptyString((String)value)) {
            ServerUtils.removeSetupValue((Connection)this.getConnection(), (String)("voice_" + key + "_" + this.moduleId));
        } else {
            ServerUtils.setSetupValue((Connection)this.getConnection(), (String)("voice_" + key + "_" + this.moduleId), (String)value);
        }
    }

    public String getReportRecords(String reportType, LocalDate period) throws BGException {
        String className = ServerUtils.getSetupValue((Connection)this.getConnection(), (String)("voice_" + reportType.toLowerCase() + "_class_" + this.moduleId));
        if (className == null) {
            throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430!");
        }
        return ((VoiceReportBase)DynamicClassManager.getInstance().newInstance(VoiceReportBase.class, className)).getRecords(this.moduleId, period);
    }

    public String getReportCSV(String reportType, LocalDate period) throws BGException {
        String className = ServerUtils.getSetupValue((Connection)this.getConnection(), (String)("voice_" + reportType.toLowerCase() + "_class_" + this.moduleId));
        if (className == null) {
            throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430!");
        }
        return ((VoiceReportBase)DynamicClassManager.getInstance().newInstance(VoiceReportBase.class, className)).getCSV(this.moduleId, period);
    }

    public List<IdTitle> getOperatorList() throws BGException {
        ArrayList<IdTitle> operatorList = new ArrayList<IdTitle>();
        for (Operator oper : new OperatorManager(this.moduleId, (ParameterMap)this.getModuleSetup()).getOperatorList()) {
            operatorList.add(new IdTitle(oper.getId(), oper.getTitle()));
        }
        return operatorList;
    }
}

