/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountType;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperAccountType;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceOperAccountService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.Page;

public class VoiceSearchPanel
extends BGUPanel {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private boolean initContractTab = false;
    private boolean initOperatorTab = false;
    private BGDataSourceTableModel contractTableModel = new BGDataSourceTableModel("VoiceContractSearch");
    private BGDataSourceTableModel operatorTableModel = new BGDataSourceTableModel("VoiceOperatorSearch");
    private BGUComboBox<VoiceAccountType> contractAccountType = new BGUComboBox();
    private BGControlPanelPages contractPagePanel = new BGControlPanelPages();
    private BGControlPanelPeriodNoB contractPeriod = new BGControlPanelPeriodNoB();
    private BGUComboBox<VoiceOperAccountType> operatorAccountType = new BGUComboBox();
    private BGControlPanelPages operatorPagePanel = new BGControlPanelPages();
    private BGControlPanelPeriodNoB operatorPeriod = new BGControlPanelPeriodNoB();
    private BGUPanel.WebServiceHolder<VoiceAccountService> contractAccountWs = new BGUPanel.WebServiceHolder((BGUPanel)this, VoiceAccountService.class);
    private BGUPanel.WebServiceHolder<VoiceOperAccountService> operatorAccountWs = new BGUPanel.WebServiceHolder((BGUPanel)this, VoiceOperAccountService.class);
    private JTextField contractSearchFieldValue = new JTextField(30);
    private BGUComboBox<KeyValue> contractSearchFields = new BGUComboBox();
    private List<KeyValue> contractSearchFieldItems = Arrays.asList(new KeyValue("login", "\u041b\u043e\u0433\u0438\u043d"), new KeyValue("phone", "\u0422\u0435\u043b\u0435\u0444\u043e\u043d"), new KeyValue("title", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new KeyValue("accountId", "ID \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430"));
    private JTextField operatorSearchFieldValue = new JTextField(30);
    private BGUComboBox<KeyValue> operatorSearchFields = new BGUComboBox();
    private List<KeyValue> operatorSearchFieldItems = Arrays.asList(new KeyValue("fromPortRegexp", "\u0421 \u043f\u043e\u0440\u0442\u043e\u0432 Regexp"), new KeyValue("toPortRegexp", "\u041d\u0430 \u043f\u043e\u0440\u0442\u044b Regexp"), new KeyValue("regexpA", "Regexp A"), new KeyValue("regexpB", "Regexp B"), new KeyValue("noRegexpA", "No Regexp A"), new KeyValue("noRegexpB", "No Regexp B"), new KeyValue("title", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new KeyValue("accountId", "ID \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430"));

    public VoiceSearchPanel(ClientContext ctx) {
        super(ctx);
    }

    protected void jbInit() {
        this.tabbedPane.add("\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0435", this.getContractPanel());
        this.tabbedPane.add("\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0441\u043a\u0438\u0435", this.getOperatorPanel());
        this.tabbedPane.addChangeListener(e -> {
            int tabIndex = this.tabbedPane.getSelectedIndex();
            if (tabIndex == 0 && !this.initContractTab) {
                this.performAction("refresh");
            } else if (tabIndex == 1 && !this.initOperatorTab) {
                this.performAction("refresh");
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(this.tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getContractPanel() {
        BGUTable table = new BGUTable((TableModel)this.contractTableModel);
        BGSwingUtilites.handleLDMouseClicked((Component)table, e -> this.contractTableModel.optSelectContractId().ifPresent(a -> ClientUtils.openContract((int)a)));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getContractSearchPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)table)), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getOperatorPanel() {
        BGUTable table = new BGUTable((TableModel)this.operatorTableModel);
        BGSwingUtilites.handleLDMouseClicked((Component)table, e -> this.operatorTableModel.optSelectContractId().ifPresent(a -> ClientUtils.openContract((int)a)));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getOperatorSearchPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)table)), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getContractSearchPanel() {
        this.contractSearchFields.setData(this.contractSearchFieldItems);
        this.contractSearchFieldValue.setMinimumSize(new Dimension(200, 26));
        this.contractSearchFieldValue.setHorizontalAlignment(0);
        BGButton clearField = new BGButton("X");
        clearField.addActionListener(e -> this.contractSearchFieldValue.setText(""));
        BGButton searchButton = new BGButton(this.getActionMap().get("contractAccountFind"));
        this.contractSearchFieldValue.setAction(this.getActionMap().get("contractAccountFind"));
        this.contractPagePanel.addToHandler(a -> this.getActionMap().get("contractAccountFind").actionPerformed(null));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.contractSearchFields, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.contractSearchFieldValue, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)clearField, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("\u0422\u0438\u043f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 30, 0, 5), 0, 0));
        panel.add((Component)this.contractAccountType, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 30, 0, 5), 0, 0));
        panel.add((Component)this.contractPeriod, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)searchButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 30, 0, 5), 0, 0));
        panel.add((Component)this.contractPagePanel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getOperatorSearchPanel() {
        this.operatorSearchFields.setData(this.operatorSearchFieldItems);
        this.operatorSearchFieldValue.setMinimumSize(new Dimension(200, 26));
        this.operatorSearchFieldValue.setHorizontalAlignment(0);
        BGButton clearField = new BGButton("X");
        clearField.addActionListener(e -> this.operatorSearchFieldValue.setText(""));
        BGButton searchButton = new BGButton(this.getActionMap().get("operatorAccountFind"));
        this.operatorSearchFieldValue.setAction(this.getActionMap().get("operatorAccountFind"));
        this.operatorPagePanel.addToHandler(a -> this.getActionMap().get("operatorAccountFind").actionPerformed(null));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.operatorSearchFields, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.operatorSearchFieldValue, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)clearField, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("\u0422\u0438\u043f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 30, 0, 5), 0, 0));
        panel.add((Component)this.operatorAccountType, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 30, 0, 5), 0, 0));
        panel.add((Component)this.operatorPeriod, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)searchButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 30, 0, 5), 0, 0));
        panel.add((Component)this.operatorPagePanel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            int tabIndex = this.tabbedPane.getSelectedIndex();
            if (tabIndex == 0 && !this.initContractTab) {
                List typeList = ((VoiceAccountService)this.contractAccountWs.get()).voiceAccountTypeList();
                typeList.add(0, new VoiceAccountType(0, "\u041b\u044e\u0431\u043e\u0439"));
                this.contractAccountType.setData(typeList);
                this.contractTableModel.loadData((ClientContext)this.getContext(), null);
                this.initContractTab = true;
            } else if (tabIndex == 1 && !this.initOperatorTab) {
                List typeList = ((VoiceOperAccountService)this.operatorAccountWs.get()).voiceOperAccountTypeList();
                typeList.add(0, new VoiceOperAccountType(0, "\u041b\u044e\u0431\u043e\u0439"));
                this.operatorAccountType.setData(typeList);
                this.operatorTableModel.loadData((ClientContext)this.getContext(), null);
                this.initOperatorTab = true;
            }
        });
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, "contractAccountFind", "contractAccountFind", e -> {
            KeyValue selectedItem = (KeyValue)this.contractSearchFields.getSelectedItem();
            VoiceAccountType selectedType = (VoiceAccountType)this.contractAccountType.getSelectedItem();
            long number = -1L;
            if ("phone".equals(selectedItem.getKey())) {
                number = Utils.parseLong((String)this.contractSearchFieldValue.getText(), (long)-1L);
                if (!Utils.isEmptyString((String)this.contractSearchFieldValue.getText()) && number < 0L) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0451\u043d \u041d\u043e\u043c\u0435\u0440!");
                    return;
                }
            }
            this.contractTableModel.loadData((ClientContext)this.getContext(), new BGUTableParams().addParam("typeId", String.valueOf(selectedType != null ? selectedType.getId() : 0)).addParam("filter_key", selectedItem.getKey()).addParam("filter_value", this.contractSearchFieldValue.getText()).setPeriod(this.contractPeriod.getPeriod()).setPage(this.contractPagePanel.getPage()));
            this.contractPagePanel.setPage(Optional.ofNullable(this.contractTableModel.getPage()).orElse(new Page()));
        }).putValue("Name", (Object)"\u041d\u0430\u0439\u0442\u0438");
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, "operatorAccountFind", "operatorAccountFind", e -> {
            KeyValue selectedItem = (KeyValue)this.operatorSearchFields.getSelectedItem();
            VoiceOperAccountType selectedType = (VoiceOperAccountType)this.operatorAccountType.getSelectedItem();
            this.operatorTableModel.loadData((ClientContext)this.getContext(), new BGUTableParams().addParam("typeId", String.valueOf(selectedType != null ? selectedType.getId() : 0)).addParam("filter_key", selectedItem.getKey()).addParam("filter_value", this.operatorSearchFieldValue.getText()).setPeriod(this.operatorPeriod.getPeriod()).setPage(this.operatorPagePanel.getPage()));
            this.operatorPagePanel.setPage(Optional.ofNullable(this.operatorTableModel.getPage()).orElse(new Page()));
        }).putValue("Name", (Object)"\u041d\u0430\u0439\u0442\u0438");
    }
}

