/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload.mfisoft;

import au.com.bytecode.opencsv.CSVWriter;
import bitel.billing.server.contract.bean.Contract;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.sorm.common.UploadModulesTitle;
import ru.bitel.bgbilling.modules.sorm.common.bean.Bunch;
import ru.bitel.bgbilling.modules.sorm.common.bean.Directional;
import ru.bitel.bgbilling.modules.sorm.common.bean.InstalledInstanceModule;
import ru.bitel.bgbilling.modules.sorm.common.bean.ServiceSorm;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.upload.mfisoft.MfiSoftPaymentType;
import ru.bitel.bgbilling.modules.sorm.server.bean.InternalUser;
import ru.bitel.bgbilling.modules.sorm.server.bean.NumberRange;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormCSVWriter;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormContract;
import ru.bitel.bgbilling.modules.sorm.server.service.SormServiceImpl;
import ru.bitel.bgbilling.modules.sorm.server.upload.PaymentsToUpload;
import ru.bitel.bgbilling.modules.sorm.server.upload.Upload;
import ru.bitel.bgbilling.modules.sorm.server.upload.mfisoft.MfiSoftFileTitle;
import ru.bitel.bgbilling.modules.sorm.server.utils.InternalUserAddressUtils;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUploadHelper;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Pair;
import ru.bitel.common.model.Period;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpCategory;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;

public class MfiSoftUpload
extends Upload {
    protected static Logger logger = LogManager.getLogger();
    protected Path internalUsersFile;
    protected final String regionId;

    public MfiSoftUpload(int moduleId, SormProject sormProject, boolean isFullUpload) {
        super(moduleId, sormProject, isFullUpload);
        this.regionId = this.config.get("sorm.upload.regionid", "1");
    }

    @Override
    public Path abonents() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 ");
        Path file = SormUtils.getUploadFile(this.localUserPath, MfiSoftFileTitle.ABONENT.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        this.internalUsersFile = SormUtils.getUploadFile(this.localUserPath, MfiSoftFileTitle.ABONENT_INTERNAL_USER.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');
             SormCSVWriter internalUsersFileWriter = SormUtils.getCSVFile(this.internalUsersFile, '\u0000');){
            csvFile.writeNext(new String[]{"ID", "REGION_ID", "CONTRACT_DATE", "CONTRACT", "ACTUAL_FROM", "ACTUAL_TO", "ABONENT_TYPE", "NAME_INFO_TYPE", "FAMILY_NAME", "GIVEN_NAME", "INITIAL_NAME", "UNSTRUCT_NAME", "BIRTH_DATE", "IDENT_CARD_TYPE_ID", "IDENT_CARD_TYPE", "IDENT_CARD_SERIAL", "IDENT_CARD_NUMBER", "IDENT_CARD_DESCRIPTION", "IDENT_CARD_UNSTRUCT", "BANK", "BANK_ACCOUNT", "FULL_NAME", "INN", "CONTACT", "PHONE_FAX", "STATUS", "ATTACH", "DETACH", "NETWORK_TYPE", "INTERNAL_ID1", "INTERNAL_ID2"});
            List<IdTitle> documentTypes = SormUtils.getDocumentsTypes(this.config, this.cpm);
            String connectionStandard = SormUtils.getConnectionStandart(this.config);
            for (SormContract contract : this.contracts) {
                try {
                    this.helper.setCurrentContract(contract);
                    int cid = contract.getContractId();
                    String[] item = new String[31];
                    item[0] = String.valueOf(cid);
                    item[1] = this.regionId;
                    item[2] = TimeUtils.format((java.util.Date)contract.getDateFrom(), (String)"yyyy-MM-dd HH:mm:ss");
                    item[3] = contract.getContractTitle();
                    item[4] = TimeUtils.format((java.util.Date)contract.getDateFrom(), (String)"yyyy-MM-dd HH:mm:ss");
                    item[5] = contract.getDateTo() != null ? TimeUtils.format((java.util.Date)contract.getDateTo(), (String)"yyyy-MM-dd HH:mm:ss") : "2049-12-31 23:59:59";
                    item[6] = String.valueOf(contract.isFiz() ? 42 : 43);
                    if (contract.isFiz()) {
                        String lastName = this.helper.getLastName();
                        String firstName = this.helper.getFirstName();
                        String middleName = this.helper.getMiddleName();
                        if (Utils.notBlankString((String)lastName) && Utils.notBlankString((String)firstName) && Utils.notBlankString((String)middleName)) {
                            item[7] = "0";
                            item[8] = lastName;
                            item[9] = firstName;
                            item[10] = middleName;
                            item[11] = "";
                        } else {
                            item[7] = "1";
                            item[8] = "";
                            item[9] = "";
                            item[10] = "";
                            String unstructFio = this.helper.getStringParam("sorm.upload.fiz.unstructfio");
                            item[11] = Utils.maskBlank((String)unstructFio, (String)(lastName + " " + firstName + " " + middleName)).trim();
                        }
                        item[12] = this.helper.getBirthday("yyyy-MM-dd HH:mm:ss");
                        item[13] = String.valueOf(SormUtils.getDocumentTypeIdOfContract(this.config, this.contractDao, cid, documentTypes));
                        String serial = this.helper.getDocumentSerial();
                        String number = this.helper.getDocumentNumber();
                        String whoGive = this.helper.getDocumentWhoGive();
                        String whenGive = this.helper.getDocumentWhenGive("dd.MM.yyyy");
                        String whoWhenGive = whenGive + " " + whoGive;
                        if (Utils.notBlankString((String)serial) && Utils.notBlankString((String)number) && Utils.notBlankString((String)whoWhenGive)) {
                            item[14] = "0";
                            item[15] = serial;
                            item[16] = number;
                            item[17] = whoWhenGive;
                            item[18] = "";
                        } else {
                            String unstructDocument;
                            item[14] = "1";
                            item[15] = "";
                            item[16] = "";
                            item[17] = "";
                            item[18] = unstructDocument = this.helper.getStringParam("sorm.upload.fiz.documentunstruct");
                        }
                        item[19] = "";
                        item[20] = "";
                        item[21] = "";
                        item[22] = "";
                        item[23] = "";
                        item[24] = "";
                    } else {
                        item[7] = "";
                        item[8] = "";
                        item[9] = "";
                        item[10] = "";
                        item[11] = "";
                        item[12] = "";
                        item[13] = "";
                        item[14] = "";
                        item[15] = "";
                        item[16] = "";
                        item[17] = "";
                        item[18] = "";
                        item[19] = this.helper.getBankTitle();
                        item[20] = this.helper.getBankAccount();
                        item[21] = this.helper.getFullTitleOrg();
                        item[22] = this.helper.getINN();
                        item[23] = this.helper.getStringParam("sorm.upload.org.contactface");
                        item[24] = this.helper.getContactFacePhone().replaceAll(";", ",");
                    }
                    item[25] = this.helper.contractIsActive() ? "0" : "1";
                    item[26] = TimeUtils.format((java.util.Date)contract.getDateFrom(), (String)"yyyy-MM-dd HH:mm:ss");
                    item[27] = this.helper.contractIsActive() ? "" : TimeUtils.format((java.util.Date)contract.getDateTo(), (String)"yyyy-MM-dd HH:mm:ss");
                    item[28] = connectionStandard;
                    item[29] = String.valueOf(cid);
                    item[30] = String.valueOf(cid);
                    this.writeItemToFile(item, cid, MfiSoftFileTitle.ABONENT.getTitle(), csvFile);
                    if (contract.isFiz()) continue;
                    List<InternalUser> internalUsers = SormUtils.getInternalUsers(this.contractObjectDao, this.helper, this.config);
                    for (int i = 0; i < internalUsers.size(); ++i) {
                        InternalUser internalUser = internalUsers.get(i);
                        String[] internalItem = this.createInternalUserItem(internalUser, item, documentTypes);
                        this.writeItemToFile(internalItem, cid, MfiSoftFileTitle.ABONENT.getTitle(), csvFile);
                        this.writeInternalUserToAbonentUsersFile(contract.getContractId(), internalUser, internalItem, internalUsersFileWriter, i);
                    }
                }
                catch (Exception e) {
                    logger.error(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 id=%s, \u041e\u0448\u0438\u0431\u043a\u0430: %s", contract.getContractId(), e));
                }
            }
            logger.info("\u0421\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043e " + this.contracts.size() + " \u0437\u0430\u043f\u0438\u0441\u0435\u0439");
            if (Utils.notEmptyCollection((Collection)this.contracts)) {
                SormUtils.updateContractLogTable(this);
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text, this.adminEmail);
        }
        return file;
    }

    protected String[] createInternalUserItem(InternalUser internalUser, String[] item, List<IdTitle> documentTypes) {
        String[] internalItem = Arrays.copyOfRange(item, 0, item.length);
        internalItem[2] = internalUser.getDateFrom() != null ? TimeUtils.format((java.util.Date)internalUser.getDateFrom(), (String)"yyyy-MM-dd HH:mm:ss") : "";
        internalItem[5] = internalUser.getDateTo() != null ? TimeUtils.format((java.util.Date)internalUser.getDateTo(), (String)"yyyy-MM-dd HH:mm:ss") : "2049-12-31 23:59:59";
        internalItem[6] = "42";
        internalItem[7] = "1";
        internalItem[8] = Utils.maskBlank((String)internalUser.getLastName(), (String)"");
        internalItem[9] = Utils.maskBlank((String)internalUser.getFirstName(), (String)"");
        internalItem[10] = Utils.maskBlank((String)internalUser.getMiddleName(), (String)"");
        StringBuilder unstructName = new StringBuilder();
        unstructName.append(Utils.maskBlank((String)internalUser.getLastName(), (String)"")).append(Utils.maskBlank((String)internalUser.getFirstName(), (String)"")).append(Utils.maskBlank((String)internalUser.getMiddleName(), (String)"")).append(" ( ").append(item[21]).append(" )");
        internalItem[11] = unstructName.toString();
        internalItem[12] = internalUser.getBirthday() != null ? TimeUtils.format((java.util.Date)internalUser.getBirthday(), (String)"yyyy-MM-dd HH:mm:ss") : "";
        int documentTypeId = 1;
        if (Utils.notBlankString((String)internalUser.getDocumentType())) {
            for (IdTitle docType : documentTypes) {
                if (!docType.getTitle().equals(internalUser.getDocumentType())) continue;
                documentTypeId = docType.getId();
                break;
            }
        }
        internalItem[13] = String.valueOf(documentTypeId);
        internalItem[14] = "0";
        internalItem[15] = Utils.maskBlank((String)internalUser.getDocumentSerial(), (String)"");
        internalItem[16] = Utils.maskBlank((String)internalUser.getDocumentNumber(), (String)"");
        Object whoWhenGive = internalUser.getDocumentWhenGive() != null ? TimeUtils.format((java.util.Date)internalUser.getDocumentWhenGive(), (String)"dd.MM.yyyy") : " " + Utils.maskBlank((String)internalUser.getDocumentWhoGive(), (String)"");
        internalItem[17] = ((String)whoWhenGive).trim();
        internalItem[18] = "";
        internalItem[19] = "";
        internalItem[20] = "";
        internalItem[21] = "";
        internalItem[22] = "";
        internalItem[23] = "";
        internalItem[24] = "";
        internalItem[29] = internalUser.getId();
        internalItem[30] = internalUser.getId();
        return internalItem;
    }

    protected void writeInternalUserToAbonentUsersFile(int parentContractId, InternalUser internalUser, String[] internalItem, CSVWriter internalUsersFileWriter, int userNumber) {
        String[] item = new String[]{String.valueOf(parentContractId), this.regionId, Utils.maskBlank((String)internalUser.getLastName(), (String)"") + " " + Utils.maskBlank((String)internalUser.getFirstName(), (String)"") + " " + Utils.maskBlank((String)internalUser.getMiddleName(), (String)""), "00" + userNumber, internalItem[4], internalItem[5], internalItem[31], internalItem[31]};
        internalUsersFileWriter.writeNext(item);
    }

    @Override
    public Path abonentsAddresses() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, MfiSoftFileTitle.ABONENTS_ADDRESSES.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            csvFile.writeNext(new String[]{"ABONENT_ID", "REGION_ID", "ADDRESS_TYPE_ID", "ADDRESS_TYPE", "ZIP", "COUNTRY", "REGION", "ZONE", "CITY", "STREET", "BUILDING", "BUILD_SECT", "APARTMENT", "UNSTRUCT_INFO", "BEGIN_TIME", "END_TIME", "INTERNAL_ID1", "INTERNAL_ID2"});
            List<Pair<Integer, List<Pair<String, Integer>>>> addresses = SormUtils.getAddressList(this.config, this.contracts);
            logger.info("\u0412\u0441\u0435\u0433\u043e \u043f\u0430\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0438 \u0430\u0434\u0440\u0435\u0441\u043e\u0432: " + addresses.size());
            for (Pair<Integer, List<Pair<String, Integer>>> addressItem : addresses) {
                int cid = (Integer)addressItem.getFirst();
                Contract contract = this.contractManager.getContractById(cid);
                this.helper.setCurrentContract(contract);
                List addressesPids = (List)addressItem.getSecond();
                for (Pair typeAddressWithPid : addressesPids) {
                    String[] item = new String[18];
                    item[0] = String.valueOf(cid);
                    item[1] = this.regionId;
                    item[2] = SormUtils.getAddressType((String)typeAddressWithPid.getFirst());
                    int pid = (Integer)typeAddressWithPid.getSecond();
                    AddressStruct addressStruct = this.helper.getAddressByPid(pid);
                    if (addressStruct != null) {
                        String region = SormUtils.getParameterOfCity((Upload)this, addressStruct, "region");
                        String zone = SormUtils.getParameterOfCity((Upload)this, addressStruct, "zone");
                        item[3] = "0";
                        item[4] = addressStruct.getIndex();
                        item[5] = addressStruct.getCountry();
                        item[6] = Utils.maskBlank((String)region, (String)"\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
                        item[7] = Utils.maskBlank((String)zone, (String)"\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
                        item[8] = addressStruct.getCity();
                        item[9] = addressStruct.getStreet();
                        item[10] = addressStruct.getHouse();
                        item[11] = addressStruct.getFrac();
                        item[12] = addressStruct.getFlat();
                        item[13] = "";
                    } else {
                        String unstruct = this.helper.getStringParam(pid, false);
                        if (Utils.isBlankString((String)unstruct)) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("\u0414\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 ID=" + cid + " \u043d\u0435\u0442 \u0430\u0434\u0440\u0435\u0441\u0430 \u0434\u043b\u044f \u0442\u0438\u043f\u0430 " + (String)typeAddressWithPid.getFirst() + ". \u0421\u0442\u0440\u043e\u043a\u0430 \u0441 \u0430\u0434\u0440\u0435\u0441\u043e\u043c \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u0430");
                            continue;
                        }
                        item[3] = "1";
                        item[4] = "";
                        item[5] = "";
                        item[6] = "";
                        item[7] = "";
                        item[8] = "";
                        item[9] = "";
                        item[10] = "";
                        item[11] = "";
                        item[12] = "";
                        item[13] = unstruct;
                    }
                    item[14] = contract.getDateFrom() != null ? TimeUtils.format((java.util.Date)contract.getDateFrom(), (String)"yyyy-MM-dd HH:mm:ss") : "2005-01-01 00:00:00";
                    item[15] = contract.getDateTo() != null ? TimeUtils.format((java.util.Date)contract.getDateTo(), (String)"yyyy-MM-dd HH:mm:ss") : "2049-12-31 23:59:59";
                    item[16] = String.valueOf(cid);
                    item[17] = String.valueOf(cid);
                    this.writeItemToFile(item, cid, MfiSoftFileTitle.ABONENTS_ADDRESSES.getTitle(), csvFile);
                }
                if (contract.getFc() != 1) continue;
                for (InternalUser internalUser : SormUtils.getInternalUsers(this.contractObjectDao, this.helper, this.config)) {
                    String[] internalItem = new String[18];
                    internalItem[0] = String.valueOf(cid);
                    internalItem[1] = "1";
                    internalItem[2] = "0";
                    EntityAttrAddress entityAttrAddress = internalUser.getAddressStruct();
                    if (entityAttrAddress != null) {
                        InternalUserAddressUtils addressUtils = new InternalUserAddressUtils(entityAttrAddress, this.con);
                        internalItem[3] = "0";
                        internalItem[4] = addressUtils.getIndex();
                        internalItem[5] = addressUtils.getCountry();
                        internalItem[6] = "\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445";
                        internalItem[7] = "\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445";
                        internalItem[8] = addressUtils.getCity();
                        internalItem[9] = addressUtils.getStreet();
                        internalItem[10] = addressUtils.getHouse();
                        internalItem[11] = addressUtils.getFrac();
                        internalItem[12] = addressUtils.getFlat();
                        internalItem[13] = "";
                    } else {
                        internalItem[3] = "1";
                        internalItem[4] = "";
                        internalItem[5] = "";
                        internalItem[6] = "";
                        internalItem[7] = "";
                        internalItem[8] = "";
                        internalItem[9] = "";
                        internalItem[10] = "";
                        internalItem[11] = "";
                        internalItem[12] = "";
                        internalItem[13] = Utils.maskBlank((String)internalUser.getAddress(), (String)"");
                    }
                    internalItem[14] = internalUser.getDateFrom() != null ? TimeUtils.format((java.util.Date)internalUser.getDateFrom(), (String)"yyyy-MM-dd HH:mm:ss") : "";
                    internalItem[15] = internalUser.getDateTo() != null ? TimeUtils.format((java.util.Date)internalUser.getDateTo(), (String)"yyyy-MM-dd HH:mm:ss") : "";
                    internalItem[16] = internalUser.getId();
                    internalItem[17] = internalUser.getId();
                    this.writeItemToFile(internalItem, cid, MfiSoftFileTitle.ABONENTS_ADDRESSES.getTitle(), csvFile);
                }
            }
            logger.info("\u0417\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430 \u0441 \u0430\u0434\u0440\u0435\u0441\u0430\u043c\u0438 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path abonentLogins() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043b\u043e\u0433\u0438\u043d\u043e\u0432(\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u0432) \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, MfiSoftFileTitle.ABONENTS_IDENT.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            String[] item;
            csvFile.writeNext(new String[]{"ABONENT_ID", "REGION_ID", "IDENT_TYPE", "PHONE", "INTERNAL_NUMBER", "IMSI", "IMEI", "ICC", "MIN", "ESN", "EQUIPMENT_TYPE", "MAC", "VPI", "VCI", "LOGIN", "E_MAIL", "PIN", "USER_DOMAIN", "RESERVED", "ORIGINATOR_NAME", "IP_TYPE", "IPV4", "IPV6", "IP_MASK_TYPE", "IPV4_MASK", "IPV6_MASK", "IP_RANGE_START", "IP_RANGE_END", "INTERNAL_ID1", "INTERNAL_ID2", "BEGIN_TIME", "END_TIME", "LINE_OBJECT", "LINE_CROSS", "LINE_BLOCK", "LINE_PAIR", "LINE_RESERVED", "LOC_TYPE", "LOC_LAC", "LOC_CELL", "LOC_TA", "LOC_CELL_WIRELESS", "LOC_MAC", "LOC_LATITUDE", "LOC_LONGITUDE", "LOC_PROJECTION_TYPE", "LOC_IP_TYPE", "LOC_IPV4", "LOC_IPV6", "LOC_IP_PORT"});
            if (this.checkInstalledModule(UploadModulesTitle.INET)) {
                List<InetServ> servicesList = SormUtils.getInetServices(this.config, this.serverContext, this.contracts);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043b\u043e\u0433\u0438\u043d\u043e\u0432 \u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f Inet. \u0412\u0441\u0435\u0433\u043e \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 InetServ: " + servicesList.size() + " \n\u0412\u0441\u0435\u0433\u043e \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: " + this.contracts.size());
                }
                for (InetServ serv : servicesList) {
                    int cid = serv.getContractId();
                    Contract contract = this.contractManager.getContractById(cid);
                    this.helper.setCurrentContract(contract);
                    byte[] addressFrom = serv.getAddressFrom();
                    InetAddress inetAddress = null;
                    String subnetHex = "";
                    if (addressFrom != null) {
                        inetAddress = InetAddress.getByAddress(addressFrom);
                        String cidr = IpNet.newInstance((byte[])serv.getAddressFrom(), (byte[])serv.getAddressTo()).toString();
                        if (cidr.endsWith("/32")) {
                            subnetHex = SormUtils.ip2Hex("255.255.255.255");
                        } else {
                            SubnetUtils subnetUtils = new SubnetUtils(cidr);
                            subnetHex = SormUtils.ip2Hex(subnetUtils.getInfo().getNetmask());
                        }
                    }
                    String ipv4 = inetAddress != null ? SormUtils.ip2Hex(inetAddress.getHostAddress()) : "";
                    byte[] mac = serv.getMacAddressListBytes();
                    String macStr = mac != null && mac.length > 0 ? Utils.bytesToString((byte[])mac) : "";
                    item = this.getLoginItem(cid, macStr, serv.getLogin(), null, ipv4, serv.getDateFrom(), serv.getDateTo(), "5", subnetHex);
                    this.writeItemToFile(item, cid, MfiSoftFileTitle.ABONENTS_IDENT.getTitle(), csvFile);
                    if (contract.getFc() != 1) continue;
                    this.writeInternalUsers(item, this.helper, csvFile);
                }
            }
            if (this.checkInstalledModule(UploadModulesTitle.VOICE)) {
                List<Integer> voiceMids = SormUtils.getTelephoneModulesIds(this.config).get(UploadModulesTitle.VOICE.getTitleModule());
                if (Utils.notEmptyCollection(voiceMids) && logger.isDebugEnabled()) {
                    logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043b\u043e\u0433\u0438\u043d\u043e\u0432 \u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f Voice");
                }
                for (Integer voiceMid : voiceMids) {
                    VoiceAccountService accountService = (VoiceAccountService)this.serverContext.getService(VoiceAccountService.class, voiceMid.intValue());
                    for (SormContract contract : this.contracts) {
                        this.helper.setCurrentContract(contract);
                        List accounts = accountService.voiceAccountList(contract.getContractId(), 0, new Period(contract.getDateFrom(), contract.getDateTo()));
                        for (VoiceAccount account : accounts) {
                            String login = Utils.maskBlank((String)account.getLogin(), (String)contract.getContractTitle());
                            String number = account.getNumber() > 0L ? String.valueOf(account.getNumber()) : "";
                            item = this.getLoginItem(contract.getContractId(), null, login, number, null, account.getDateFrom(), account.getDateTo(), "2", "");
                            this.writeItemToFile(item, account.getContractId(), MfiSoftFileTitle.ABONENTS_IDENT.getTitle(), csvFile);
                            this.writeInternalUsers(item, this.helper, csvFile);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u0432 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text, this.adminEmail);
        }
        return file;
    }

    protected String[] getLoginItem(int cid, String macStr, String login, String phoneNumber, String ipv4, java.util.Date dateFrom, java.util.Date dateTo, String identType, String subnetHex) throws BGException {
        String[] item = new String[]{String.valueOf(cid), this.regionId, identType, Utils.maskBlank((String)phoneNumber, (String)""), "", "", "", "", "", "", Utils.notBlankString((String)macStr) ? "0" : "", Utils.notBlankString((String)macStr) ? SormUtils.trimField(macStr.replaceAll(" ", ""), 12) : "", "", "", Utils.maskBlank((String)login, (String)""), "5".equals(identType) ? this.helper.getEmail(this.helper.getCurrentContract().isFiz()) : "", "", "", "", "", Utils.notBlankString((String)ipv4) ? "0" : "", Utils.maskBlank((String)ipv4, (String)""), "", Utils.notBlankString((String)ipv4) ? "0" : "", Utils.maskBlank((String)subnetHex, (String)""), "", "", "", String.valueOf(cid), String.valueOf(cid), dateFrom != null ? TimeUtils.format((java.util.Date)dateFrom, (String)"yyyy-MM-dd HH:mm:ss") : "2005-01-01 00:00:00", dateTo != null ? TimeUtils.format((java.util.Date)dateTo, (String)"yyyy-MM-dd HH:mm:ss") : "2049-12-31 23:59:59", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        return item;
    }

    protected void writeInternalUsers(String[] item, SormUploadHelper helper, CSVWriter csvFile) throws Exception {
        for (InternalUser internalUser : SormUtils.getInternalUsers(this.contractObjectDao, helper, this.config)) {
            String[] internalItem = Arrays.copyOfRange(item, 0, item.length);
            internalItem[0] = internalUser.getId();
            internalItem[28] = internalUser.getId();
            internalItem[29] = internalUser.getId();
            this.writeItemToFile(internalItem, helper.getCurrentContract().getContractId(), MfiSoftFileTitle.ABONENTS_IDENT.getTitle(), csvFile);
        }
    }

    @Override
    public Path services() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, MfiSoftFileTitle.SERVICE_LIST.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            csvFile.writeNext(new String[]{"ID", "MNEMONIC", "BEGIN_TIME", "END_TIME", "DESCRIPTION", "REGION_ID"});
            for (ServiceSorm service : SormUtils.getSelectedServicesForUpload(this.config)) {
                String[] item = new String[6];
                item[0] = String.valueOf(service.getId());
                String serviceTitle = service.getTitle();
                item[1] = SormUtils.trimField(serviceTitle, 64);
                String operatorStartDate = this.config.get("sorm.upload.operator.startdate");
                java.util.Date startDate = null;
                if (Utils.notBlankString((String)operatorStartDate)) {
                    startDate = TimeUtils.parseDate((String)operatorStartDate, (String)"dd.MM.yyyy");
                }
                item[2] = startDate == null ? "2005-01-01 00:00:00" : TimeUtils.format((java.util.Date)startDate, (String)"yyyy-MM-dd HH:mm:ss");
                item[3] = "2049-12-31 23:59:59";
                item[4] = Utils.maskBlank((String)service.getDescription(), (String)serviceTitle);
                item[5] = this.regionId;
                this.writeItemToFile(item, -1, MfiSoftFileTitle.SERVICE_LIST.getTitle(), csvFile);
            }
        }
        catch (IOException | BGException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)e, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path abonentServices() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, MfiSoftFileTitle.ABONENTS_TARIFFS.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            String idsServices = Utils.toString(SormUtils.getIdsServices(this.config));
            if (logger.isDebugEnabled()) {
                logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432. \u0412\u044b\u0433\u0440\u0443\u0436\u0430\u0435\u043c \u0443\u0441\u043b\u0443\u0433\u0438 \u0434\u043b\u044f \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432, \u0443 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0435\u0441\u0442\u044c \u043a\u0430\u043a\u0430\u044f-\u043b\u0438\u0431\u043e \u0443\u0441\u043b\u0443\u0433\u0430 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430: " + idsServices);
                logger.debug("\u0410\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u0432 \u0441\u043f\u0438\u0441\u043a\u0435: " + this.contracts.size());
            }
            csvFile.writeNext(new String[]{"ABONENT_ID", "REGION_ID", "ID", "BEGIN_TIME", "END_TIME", "PARAMETER", "INTERNAL_ID1", "INTERNAL_ID2"});
            List<InstalledInstanceModule> npayModules = new SormServiceImpl().getInstanceModules("npay");
            for (int x = 0; x < npayModules.size(); ++x) {
                String npayServiceTable = ServerUtils.getModuleTableName((String)"npay_service_object", (int)npayModules.get(x).getModuleId());
                String query = "SELECT nso.sid AS sid, s.title AS title, nso.date1 AS date1, nso.date2 AS date2 FROM " + npayServiceTable + " AS nso LEFT JOIN service AS s ON nso.sid=s.id WHERE cid=?";
                if (Utils.notBlankString((String)idsServices)) {
                    query = query + " AND sid in (" + idsServices + ")";
                }
                try (PreparedStatement ps = this.con.prepareStatement(query);){
                    for (SormContract contract : this.contracts) {
                        int cid = contract.getContractId();
                        ps.setInt(1, cid);
                        ResultSet rs = ps.executeQuery();
                        while (rs.next()) {
                            int sid = rs.getInt("sid");
                            Date date1 = rs.getDate("date1");
                            Date date2 = rs.getDate("date2");
                            String[] item = new String[]{String.valueOf(cid), this.regionId, String.valueOf(sid), date1 != null ? TimeUtils.format((java.util.Date)date1, (String)"yyyy-MM-dd HH:mm:ss") : "2005-01-01 00:00:00", date2 != null ? TimeUtils.format((java.util.Date)date2, (String)"yyyy-MM-dd HH:mm:ss") : "2049-12-31 23:59:59", "", String.valueOf(cid), String.valueOf(cid)};
                            this.writeItemToFile(item, cid, MfiSoftFileTitle.ABONENTS_TARIFFS.getTitle(), csvFile);
                        }
                        rs.close();
                    }
                    continue;
                }
            }
        }
        catch (IOException | SQLException | BGException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0443\u0441\u043b\u0443\u0433 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)e, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path ipNumbering() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 ip-\u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, MfiSoftFileTitle.IP_NUMBERING.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            csvFile.writeNext(new String[]{"DESCRIPTION", "IP_TYPE", "IPV4", "IPV6", "IP_MASK_TYPE", "IPV4_MASK", "IPV6_MASK", "BEGIN_TIME", "END_TIME", "REGION_ID"});
            Map<IpCategory, List<IpResource>> categoriesWithResources = SormUtils.getIPResources(this.config, this.serverContext);
            for (Map.Entry<IpCategory, List<IpResource>> entry : categoriesWithResources.entrySet()) {
                String ipCategoryComment = entry.getKey().getComment();
                for (IpResource ip : entry.getValue()) {
                    String cidrNotation = IpNet.newInstance((byte[])ip.getAddressFrom(), (byte[])ip.getAddressTo()).toString();
                    SubnetUtils.SubnetInfo info = null;
                    try {
                        SubnetUtils subnetUtils = new SubnetUtils(cidrNotation);
                        info = subnetUtils.getInfo();
                    }
                    catch (Exception e) {
                        logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 ip-\u0440\u0435\u0441\u0443\u0440\u0441\u043e\u043c: " + ip.getId() + " \u041e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage());
                    }
                    String[] item = new String[10];
                    String resourceComment = Utils.notBlankString((String)ip.getComment()) ? ip.getComment() : "\u043d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445";
                    item[0] = Utils.isBlankString((String)ipCategoryComment) ? resourceComment : ipCategoryComment;
                    item[1] = "0";
                    item[2] = info != null ? SormUtils.ip2Hex(info.getAddress()) : "";
                    item[3] = "";
                    item[4] = "0";
                    item[5] = info != null ? SormUtils.ip2Hex(info.getNetmask()) : "";
                    item[6] = "";
                    item[7] = ip.getDateFrom() != null ? TimeUtils.format((java.util.Date)ip.getDateFrom(), (String)"yyyy-MM-dd HH:mm:ss") : "2005-01-01 00:00:00";
                    item[8] = ip.getDateTo() != null ? TimeUtils.format((java.util.Date)ip.getDateTo(), (String)"yyyy-MM-dd HH:mm:ss") : "2049-12-31 23:59:59";
                    item[9] = this.regionId;
                    this.writeItemToFile(item, -1, MfiSoftFileTitle.IP_NUMBERING.getTitle(), csvFile);
                }
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 ip-\u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path abonentsIpNumbering() {
        return null;
    }

    @Override
    public Path switches() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043a\u043e\u043c\u043c\u0443\u0442\u0430\u0442\u043e\u0440\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, MfiSoftFileTitle.SWITCHES.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            String[] item;
            EntityAttrAddress address;
            csvFile.writeNext(new String[]{"SWITCH_ID", "BEGIN_TIME", "END_TIME", "DESCRIPTION", "NETWORK_TYPE", "SWITCH_TYPE", "ADDRESS_TYPE_ID", "ADDRESS_TYPE", "ZIP", "COUNTRY", "REGION", "ZONE", "CITY", "STREET", "BUILDING", "BUILD_SECT", "APARTMENT", "UNSTRUCT_INFO", "SWITCH_SIGN", "REGION_ID"});
            if (this.config.get("sorm.upload.switches.enable", "").equals("1") && this.checkInstalledModule(UploadModulesTitle.INET)) {
                for (Device device : SormUtils.getInetDevices(this.config, this.serverContext)) {
                    address = SormUtils.getAddressFromDeviceAttributes(device);
                    item = this.getSwitchItem(device.getId(), device.getTitle(), 4, address != null ? address.toString() : "", device.getDateFrom(), device.getDateTo());
                    this.writeItemToFile(item, -1, MfiSoftFileTitle.SWITCHES.getTitle(), csvFile);
                }
            }
            if (this.config.get("sorm.upload.commutators.enable").equals("1") && this.checkInstalledModule(UploadModulesTitle.VOICE)) {
                for (Device voiceDevice : SormUtils.getVoiceDevices(this.config, this.serverContext)) {
                    address = SormUtils.getAddressFromDeviceAttributes(voiceDevice);
                    item = this.getSwitchItem(voiceDevice.getId(), voiceDevice.getTitle(), 10, address != null ? address.toString() : "", voiceDevice.getDateFrom(), voiceDevice.getDateTo());
                    this.writeItemToFile(item, -1, MfiSoftFileTitle.SWITCHES.getTitle(), csvFile);
                }
            }
        }
        catch (IOException | BGException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043a\u043e\u043c\u043c\u0443\u0442\u0430\u0442\u043e\u0440\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)e, text, this.adminEmail);
        }
        return file;
    }

    protected String[] getSwitchItem(int id, String title, int netType, String address, java.util.Date dateFrom, java.util.Date dateTo) {
        String[] item = new String[]{String.valueOf(id), dateFrom != null ? TimeUtils.format((java.util.Date)dateFrom, (String)"yyyy-MM-dd HH:mm:ss") : "2005-01-01 00:00:00", dateTo != null ? TimeUtils.format((java.util.Date)dateTo, (String)"yyyy-MM-dd HH:mm:ss") : "2049-12-31 23:59:59", title, String.valueOf(netType), "0", "3", "1", "", "", "", "", "", "", "", "", "", address, "", this.regionId};
        return item;
    }

    @Override
    public Path gateways() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0448\u043b\u044e\u0437\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, MfiSoftFileTitle.GATEWAYS.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            csvFile.writeNext(new String[]{"GATE_ID", "BEGIN_TIME", "END_TIME", "DESCRIPTION", "GATE_TYPE", "ADDRESS_TYPE_ID", "ADDRESS_TYPE", "ZIP", "COUNTRY", "REGION", "ZONE", "CITY", "STREET", "BUILDING", "BUILD_SECT", "APARTMENT", "UNSTRUCT_INFO", "REGION_ID"});
            if (this.checkInstalledModule(UploadModulesTitle.INET)) {
                for (Device inetDevice : SormUtils.getSelectedGateways(this.config, this.serverContext)) {
                    EntityAttrAddress address = SormUtils.getAddressFromDeviceAttributes(inetDevice);
                    this.writeItemToFile(this.getGatewayItem(inetDevice.getId(), inetDevice.getDateFrom(), inetDevice.getDateTo(), inetDevice.getComment(), address != null ? address.toString() : ""), -1, MfiSoftFileTitle.GATEWAYS.getTitle(), csvFile);
                }
            }
        }
        catch (IOException | BGException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0448\u043b\u044e\u0437\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)e, text, this.adminEmail);
        }
        return file;
    }

    protected String[] getGatewayItem(int id, java.util.Date dateFrom, java.util.Date dateTo, String comment, String address) {
        String[] item = new String[]{String.valueOf(id), dateFrom == null ? "" : TimeUtils.format((java.util.Date)dateFrom, (String)"yyyy-MM-dd HH:mm:ss"), dateTo == null ? "" : TimeUtils.format((java.util.Date)dateTo, (String)"yyyy-MM-dd HH:mm:ss"), SormUtils.trimField(comment != null ? comment : "", 256), "7", "3", "1", "", "", "", "", "", "", "", "", "", Utils.notBlankString((String)address) ? address : this.config.get("sorm.upload.operator.location"), this.regionId};
        return item;
    }

    @Override
    public Path bunches() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u0443\u0447\u043a\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, MfiSoftFileTitle.BUNCHES.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            csvFile.writeNext(new String[]{"ID", "ID_TYPE", "BUNCH_ID", "EQUIPMENT_TYPE", "MAC", "VPI", "VCI", "CIRCUIT_ID", "SWITCH_ID", "BUNCH_TYPE", "BEGIN_TIME", "END_TIME", "DESCRIPTION", "REGION_ID"});
            for (Bunch bunch : SormUtils.getBunches(this.config)) {
                String[] item = new String[14];
                item[0] = String.valueOf(bunch.getId());
                item[1] = "0";
                item[2] = String.valueOf(bunch.getId());
                item[3] = "0";
                item[4] = Utils.maskBlank((String)bunch.getMac(), (String)"");
                item[5] = "";
                item[6] = "";
                item[7] = "";
                item[8] = Utils.maskBlank((String)bunch.getIdCommutator(), (String)"");
                int directionalCode = bunch.getDirectional().equals((Object)Directional.BIDIRECTIONAL) ? 3 : bunch.getDirectional().ordinal();
                item[9] = String.valueOf(directionalCode);
                item[10] = bunch.getDateStart() == null ? "2005-01-01 00:00:00" : TimeUtils.format((java.util.Date)bunch.getDateStart(), (String)"yyyy-MM-dd HH:mm:ss");
                item[11] = bunch.getDateEnd() == null ? "2049-12-31 23:59:59" : TimeUtils.format((java.util.Date)bunch.getDateEnd(), (String)"yyyy-MM-dd HH:mm:ss");
                item[12] = bunch.getDescription();
                item[13] = this.regionId;
                this.writeItemToFile(item, -1, MfiSoftFileTitle.BUNCHES.getTitle(), csvFile);
            }
        }
        catch (IOException | BGException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u0443\u0447\u043a\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)e, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path phoneNumbering() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u043e\u0439 \u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, MfiSoftFileTitle.PHONE_NUMBERING.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            csvFile.writeNext(new String[]{"ISO_3166_APHA_2", "ISO_3166_APHA_3", "COUNTRY_CODE", "NUMBER_PREFIX", "AREA_CODE_LENGTH", "MIN_NUMBER_LENGTH", "MAX_NUMBER_LENGTH", "UTC_MIN", "UTC_MAX", "COUNTRY_DEST", "NETWORK_TYPE", "CAPACITY_FROM", "CAPACITY_TO", "CAPACITY_SIZE", "LOCATION", "OPERATOR_NAME", "BEGIN_TIME", "END_TIME", "MCC", "MNC", "STATUS", "DESCRIPTION", "OPERATOR_CODE", "REGION_ID"});
            ArrayList<NumberRange> resources = new ArrayList<NumberRange>();
            if (this.checkInstalledModule(UploadModulesTitle.VOICE)) {
                resources.addAll(SormUtils.getUploadVoiceNumberingResources(this.config, this.serverContext));
            }
            for (NumberRange numberRange : resources) {
                String phoneNumberPrefix = SormUtils.trimField(String.valueOf(numberRange.getFromNumber()), 15).substring(1, 4);
                String[] item = new String[]{"ru", "rus", "7", phoneNumberPrefix, String.valueOf(phoneNumberPrefix.length()), "11", "11", "-12", "12", "\u0420\u043e\u0441\u0441\u0438\u044f", "0", SormUtils.trimField(String.valueOf(numberRange.getFromNumber()), 15), SormUtils.trimField(String.valueOf(numberRange.getToNumber()), 15), String.valueOf(numberRange.getToNumber() - numberRange.getFromNumber() + 1L), this.config.get("sorm.upload.operator.location"), this.config.get("sorm.upload.operator.title"), numberRange.getDateFrom() == null ? "" : TimeUtils.format((java.util.Date)numberRange.getDateFrom(), (String)"yyyy-MM-dd HH:mm:ss"), numberRange.getDateTo() == null ? "" : TimeUtils.format((java.util.Date)numberRange.getDateTo(), (String)"yyyy-MM-dd HH:mm:ss"), "250", "000", "", Utils.isBlankString((String)numberRange.getComment()) ? "" : numberRange.getComment(), "", this.regionId};
                this.writeItemToFile(item, -1, MfiSoftFileTitle.PHONE_NUMBERING.getTitle(), csvFile);
            }
        }
        catch (IOException | BGException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043d\u043e\u043c\u0435\u0440\u043d\u043e\u0439 \u0451\u043c\u043a\u043e\u0441\u0442\u0438 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)e, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path phoneNumberingAbonents() {
        return null;
    }

    @Override
    public Path documentTypes() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0441\u043f\u0438\u0441\u043a\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, MfiSoftFileTitle.DOCUMENT_TYPE.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            csvFile.writeNext(new String[]{"DOC_TYPE_ID", "BEGIN_TIME", "END_TIME", "DESCRIPTION", "REGION_ID"});
            for (IdTitle document : SormUtils.getDocumentsTypes(this.config, this.cpm)) {
                String[] item = new String[]{String.valueOf(document.getId()), "2005-01-01 00:00:00", "2049-12-31 23:59:59", document.getTitle(), this.regionId};
                this.writeItemToFile(item, -1, MfiSoftFileTitle.DOCUMENT_TYPE.getTitle(), csvFile);
            }
        }
        catch (IOException | BGException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)e, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path paymentTypes() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0438\u043f\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
        Path file = SormUtils.getUploadFile(this.localUserPath, MfiSoftFileTitle.PAY_TYPE.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            csvFile.writeNext(new String[]{"ID", "BEGIN_TIME", "END_TIME", "DESCRIPTION", "REGION_ID"});
            for (PaymentType paymentType : this.paymentsToUpload.getPaymentTypesToUpload()) {
                String[] item = new String[]{String.valueOf(paymentType.getId()), "2005-01-01 00:00:00", "", paymentType.getTitle(), this.regionId};
                this.writeItemToFile(item, -1, MfiSoftFileTitle.PAY_TYPE.getTitle(), csvFile);
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0442\u0438\u043f\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path abonentsPayments() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, MfiSoftFileTitle.PAYMENTS.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            csvFile.writeNext(new String[]{"PAYMENT_TYPE", "PAY_TYPE_ID", "PAYMENT_DATE", "AMOUNT", "AMOUNT_CURRENCY", "PHONE_NUMBER", "ACCOUNT", "INTERNAL_ID1", "INTERNAL_ID2", "BANK_ACCOUNT", "BANK_NAME", "EXPRESS_CARD_NUMBER", "TERMINAL_ID", "TERMINAL_NUMBER", "LATITUDE", "LONGITUDE", "PROJECTION_TYPE", "CENTER_ID", "DONATED_PHONE_NUMBER", "DONATED_ACCOUNT", "DONATED_INTERNAL_ID1", "DONATED_INTERNAL_ID2", "CARD_NUMBER", "PAY_PARAMS", "PERSON_RECIEVED", "BANK_DIVISION_NAME", "BANK_CARD_ID", "ADDRESS_TYPE_ID", "ADDRESS_TYPE", "ZIP", "COUNTRY", "REGION", "ZONE", "CITY", "STREET", "BUILDING", "BUILD_SECT", "APARTMENT", "UNSTRUCT_INFO", "REGION_ID"});
            List<Payment> payments = this.paymentsToUpload.getPaymentsToUpload(true);
            logger.debug("\u0412\u0441\u0435\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438: {}", (Object)payments.size());
            for (Payment payment : payments) {
                try {
                    Contract contract = this.contractManager.getContractById(payment.getContractId());
                    if (contract == null) continue;
                    this.helper.setCurrentContract(contract);
                    boolean isFiz = contract.getFc() == 0;
                    String[] item = new String[40];
                    String paymentType = this.paymentsToUpload.getPaymentTypeCode(payment.getTypeId());
                    boolean isNeedAddress = paymentType.equals(MfiSoftPaymentType.BANK_TRANSACTION.getCodeStr()) || paymentType.equals(MfiSoftPaymentType.TERMINAL_PAYMENT.getCodeStr()) || paymentType.equals(MfiSoftPaymentType.CLIENT_CENTER.getCodeStr());
                    item[0] = paymentType;
                    item[1] = String.valueOf(payment.getTypeId());
                    item[2] = TimeUtils.format((java.util.Date)payment.getDate(), (String)"yyyy-MM-dd HH:mm:ss");
                    item[3] = Utils.formatBigDecimalSumm((BigDecimal)payment.getSum());
                    item[4] = "";
                    String phoneNumber = isFiz ? this.helper.getPhoneParam("sorm.upload.fiz.phone") : this.helper.getPhoneParam("sorm.upload.org.phone");
                    item[5] = Utils.maskBlank((String)phoneNumber, (String)"");
                    item[6] = contract.getTitle();
                    item[7] = String.valueOf(contract.getId());
                    item[8] = "";
                    if (!isFiz && paymentType.equals(MfiSoftPaymentType.BANK_TRANSACTION.getCodeStr())) {
                        item[9] = this.helper.getBankAccount();
                        item[10] = this.helper.getBankTitle();
                    } else {
                        item[9] = "";
                        item[10] = "";
                    }
                    item[11] = "";
                    item[12] = paymentType.equals(MfiSoftPaymentType.TERMINAL_PAYMENT.getCodeStr()) ? "0" : "";
                    item[13] = paymentType.equals(MfiSoftPaymentType.TERMINAL_PAYMENT.getCodeStr()) ? "0" : "";
                    item[14] = "";
                    item[15] = "";
                    item[16] = "";
                    String officeAddress = SormUtils.getFullOperatorAddress(this.config);
                    String string = item[17] = paymentType.equals(MfiSoftPaymentType.CLIENT_CENTER.getCodeStr()) ? officeAddress : "";
                    if (paymentType.equals(MfiSoftPaymentType.ANOTHER_CLIENT_ACCOUNT.getCodeStr())) {
                        item[18] = Utils.maskBlank((String)phoneNumber, (String)"");
                        item[19] = contract.getTitle();
                    } else {
                        item[18] = "";
                        item[19] = "";
                    }
                    item[20] = "";
                    item[21] = "";
                    item[22] = "";
                    item[23] = "";
                    item[24] = "";
                    item[25] = "";
                    item[26] = "";
                    AddressStruct address = this.helper.getAddress();
                    if (isNeedAddress && address != null) {
                        item[27] = "0";
                        item[28] = "0";
                        item[29] = Utils.maskBlank((String)address.getIndex(), (String)"");
                        item[30] = "\u0420\u0424";
                        item[31] = this.config.get("sorm.upload.regiontitle", "");
                        item[32] = Utils.maskBlank((String)address.getArea(), (String)"");
                        item[33] = Utils.maskBlank((String)address.getCity(), (String)"");
                        item[34] = Utils.maskBlank((String)address.getStreet(), (String)"");
                        item[35] = Utils.maskBlank((String)address.getHouse(), (String)"");
                        item[36] = Utils.maskBlank((String)address.getFrac(), (String)"");
                        item[37] = Utils.maskBlank((String)address.getFlat(), (String)"");
                    } else if (isNeedAddress) {
                        item[27] = "0";
                        item[28] = "1";
                        item[29] = "";
                        item[30] = "";
                        item[31] = "";
                        item[32] = "";
                        item[33] = "";
                        item[34] = "";
                        item[35] = "";
                        item[36] = "";
                        item[37] = "";
                    } else {
                        item[27] = "";
                        item[28] = "";
                        item[29] = "";
                        item[30] = "";
                        item[31] = "";
                        item[32] = "";
                        item[33] = "";
                        item[34] = "";
                        item[35] = "";
                        item[36] = "";
                        item[37] = "";
                    }
                    item[38] = PaymentsToUpload.getAdditionalPaymentData(payment);
                    item[39] = this.regionId;
                    this.writeItemToFile(item, contract.getId(), MfiSoftFileTitle.PAYMENTS.getTitle(), csvFile);
                }
                catch (Exception ex) {
                    logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: {} \u041e\u0448\u0438\u0431\u043a\u0430: {}", (Object)payment.getId(), (Object)ex);
                }
            }
            if (Utils.notEmptyCollection(payments)) {
                this.paymentsToUpload.updatePaymentsLogTable(payments.get(payments.size() - 1).getId());
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        return file;
    }

    @Override
    public Path operatorInfo() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \u0444\u0438\u043b\u0438\u0430\u043b\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path uploadFile = SormUtils.getUploadFile(this.localUserPath, MfiSoftFileTitle.REGIONS.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(uploadFile, '\u0000');){
            csvFile.writeNext(new String[]{"ID", "BEGIN_TIME", "END_TIME", "DESCRIPTION", "MCC", "MNC"});
            String[] item = new String[6];
            item[0] = this.regionId;
            LocalDate startDate = this.config.getLocalDate("sorm.upload.operator.startdate", null);
            item[1] = startDate != null ? TimeUtils.format((java.util.Date)TimeUtils.convertLocalDateToDate((LocalDate)startDate), (String)"yyyy-MM-dd HH:mm:ss") : "2005-01-01 00:00:00";
            item[2] = "";
            item[3] = this.config.get("sorm.upload.operator.title") + " " + this.config.get("sorm.upload.operator.location");
            item[4] = "";
            item[5] = "";
            this.writeItemToFile(item, -1, MfiSoftFileTitle.REGIONS.getTitle(), csvFile);
        }
        catch (IOException | BGException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \u0444\u0438\u043b\u0438\u0430\u043b\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)e, text);
        }
        return uploadFile;
    }

    @Override
    public List<Pair<String, Path>> getOtherFiles() {
        return Collections.singletonList(new Pair(null, (Object)this.IPGateway()));
    }

    protected Path IPGateway() {
        logger.info("\u0424\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430 IP_GATEWAY");
        Path file = SormUtils.getUploadFile(this.localUserPath, MfiSoftFileTitle.IP_GATEWAY.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        if (this.checkInstalledModule(UploadModulesTitle.INET)) {
            List<Device> inetDevices = SormUtils.getSelectedGateways(this.config, this.serverContext);
            if (Utils.isEmptyCollection(inetDevices)) {
                return file;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u0412\u0441\u0435\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432 \u0434\u043b\u044f \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f IP_GATEWAY: " + inetDevices.size());
            }
            try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
                csvFile.writeNext(new String[]{"GATE_ID", "IP_TYPE", "IPV4", "IPV6", "IP_PORT", "REGION_ID"});
                for (Device inetDevice : inetDevices) {
                    String[] item = SormUtils.getIPGatewayItem(inetDevice, this.regionId);
                    if (item == null) continue;
                    this.writeItemToFile(item, -1, MfiSoftFileTitle.IP_GATEWAY.getTitle(), csvFile);
                }
            }
            catch (IOException | BGException ex) {
                String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u0444\u0430\u0439\u043b\u0430 IP_GATEWAY: ";
                logger.error(text + ex.getMessage());
                SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)ex, text);
            }
        }
        return file;
    }
}

