/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.flussonicwatcher;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.modules.smarthouse.common.service.FlussonicWatcherService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;

public class FlussonicWatcherCamerasPanel
extends BGUPanel {
    private JLabel recordCountLabel = new JLabel();
    private BGControlPanelPages panelPages = new BGControlPanelPages();
    private BGDataSourceTableModel flussonicCameraTableModel = new BGDataSourceTableModel("FlussonicCameras");

    protected void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add(this.getFilterPanel(), "North");
        this.add(this.getCameraPanel(), "Center");
    }

    private JPanel getCameraPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 3, 0, 3), 0, 0));
        panel.add((Component)this.getTablePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.recordCountLabel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 14, 0, new Insets(0, 10, 0, 5), 0, 0));
        panel.add((Component)this.panelPages, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTablePanel() {
        BGUTable table = new BGUTable((TableModel)this.flussonicCameraTableModel);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            BGUTableParams tableParams = new BGUTableParams().setPage(this.panelPages.getPage());
            this.flussonicCameraTableModel.loadData((ClientContext)this.getContext(), tableParams, this.panelPages, this.recordCountLabel);
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new ImportCameraDialog("\u0418\u043c\u043f\u043e\u0440\u0442 \u043a\u0430\u043c\u0435\u0440", null).open());
    }

    class ImportCameraDialog
    extends BGEditorDialog<String> {
        private JTextField cameraModel;
        private JTextArea cameraSerial;

        public ImportCameraDialog(String title, String data) {
            super(title, (Object)data);
            this.cameraModel = new JTextField(30);
            this.cameraSerial = new JTextArea(15, 30);
        }

        public void doDialogPanel() {
            this.cameraModel.setHorizontalAlignment(0);
            this.cameraSerial.setMargin(Utils.getInsets());
            this.addFieldV("\u041c\u043e\u0434\u0435\u043b\u044c \u043a\u0430\u043c\u0435\u0440\u044b", this.cameraModel);
            this.addFieldV("\u0421\u0435\u0440\u0438\u0439\u043d\u044b\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 (\u043f\u043e \u043e\u0434\u043d\u043e\u043c\u0443 \u043d\u0430 \u0441\u0442\u0440\u043e\u043a\u0443)", new JScrollPane(this.cameraSerial));
        }

        public boolean doApply() throws Exception {
            if (Utils.isEmptyString((String)this.cameraModel.getText())) {
                BGToolTip.showErrorMessage((JComponent)this.cameraModel, (String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043c\u043e\u0434\u0435\u043b\u044c \u043a\u0430\u043c\u0435\u0440(\u044b)");
                return false;
            }
            if (Utils.isEmptyString((String)this.cameraSerial.getText())) {
                BGToolTip.showErrorMessage((JComponent)this.cameraSerial, (String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u0435\u0440\u0438\u0439\u043d\u044b\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u043a\u0430\u043c\u0435\u0440");
                return false;
            }
            return this.tryCallBoolean(() -> {
                ((FlussonicWatcherService)((ClientContext)FlussonicWatcherCamerasPanel.this.getContext()).getWebService(FlussonicWatcherService.class)).cameraImport(this.cameraModel.getText(), this.cameraSerial.getText());
                FlussonicWatcherCamerasPanel.this.performAction("refresh");
            });
        }
    }
}

