/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.contract;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.kernel.table.client.BGParamTableModel;
import ru.bitel.bgbilling.kernel.table.client.ParamRowData;
import ru.bitel.bgbilling.modules.smarthouse.common.service.FlussonicWatcherService;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Id;

public class SmartHouseAccountFlussonicWatcherEditor
extends BGEditorDialog<Id> {
    private JTabbedPane tabbedPane;
    private ClientContext context;
    private JTextArea orgTextArea = new JTextArea(5, 30);
    private FWOrgTableModel orgTableModel = new FWOrgTableModel();
    private FWOrgStatTableModel orgStatTableModel = new FWOrgStatTableModel();
    private FWOrgLimitTableModel orgLimitTableModel = new FWOrgLimitTableModel();
    private FWOrgUserPermissionTableModel orgUserPermissionTableModel = new FWOrgUserPermissionTableModel();
    private FWUserTableModel userTableModel = new FWUserTableModel();
    private FWPresetTableModel presetTableModel = new FWPresetTableModel();
    private FWCameraTableModel cameraTableModel = new FWCameraTableModel();

    public SmartHouseAccountFlussonicWatcherEditor(String title, Id data, ClientContext context) {
        super(title, (Object)data);
        this.context = context;
    }

    public void doDialogPanel() {
        this.panel.add((Component)this.getTabbedPane(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.add((Component)this.getOrganizationPanel(), "\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f");
            this.tabbedPane.add((Component)this.getCameraPanel(), "\u041a\u0430\u043c\u0435\u0440\u044b");
            this.tabbedPane.add((Component)this.getUserPanel(), "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0435\u0442\u043b\u0438");
            this.tabbedPane.add((Component)this.getPresetPanel(), "\u041f\u0440\u0435\u0441\u0435\u0442\u044b");
        }
        return this.tabbedPane;
    }

    private JPanel getOrganizationPanel() {
        BGUTable orgTable = new BGUTable((TableModel)((Object)this.orgTableModel));
        orgTable.setSelectionMode(0);
        BGUTable orgLimitTable = new BGUTable((TableModel)((Object)this.orgLimitTableModel));
        orgLimitTable.setSelectionMode(0);
        JPanel orgLimitPanel = new JPanel(new BorderLayout());
        orgLimitPanel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)orgLimitTable, (int)100, (int)100), "Center");
        BGUTable orgStatTable = new BGUTable((TableModel)((Object)this.orgStatTableModel));
        orgStatTable.setSelectionMode(0);
        JPanel orgStatPanel = new JPanel(new BorderLayout());
        orgStatPanel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)orgStatTable, (int)100, (int)100), "Center");
        BGUTable orgUserPermissionTable = new BGUTable((TableModel)((Object)this.orgUserPermissionTableModel));
        orgUserPermissionTable.setSelectionMode(0);
        JPanel orgUserPermissionPanel = new JPanel(new BorderLayout());
        orgUserPermissionPanel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)orgUserPermissionTable, (int)100, (int)100), "Center");
        ArrayList orgDatas = new ArrayList();
        ArrayList orgStatDatas = new ArrayList();
        ArrayList orgLimitDatas = new ArrayList();
        ArrayList orgUserPermissionDatas = new ArrayList();
        this.tryCall(() -> {
            String organization = ((FlussonicWatcherService)this.context.getWebService(FlussonicWatcherService.class, this.context.getModuleId())).organizationGet(((Id)this.data).getId());
            this.orgTextArea.setText(organization);
            this.orgTextArea.setLineWrap(true);
            JSONObject jsonObject = new JSONObject(organization);
            DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT, FormatStyle.MEDIUM);
            LocalDateTime orgCreateAt = LocalDateTime.ofInstant(Instant.ofEpochMilli(jsonObject.optLong("created_at")), ZoneId.systemDefault());
            orgDatas.add(new ParamRowData("orgId", "ID", jsonObject.optString("id")));
            orgDatas.add(new ParamRowData("orgTitle", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", jsonObject.optString("title")));
            orgDatas.add(new ParamRowData("orgOwner", "\u0412\u043b\u0430\u0434\u0435\u043b\u0435\u0446", jsonObject.optJSONObject("owner").optString("name")));
            orgDatas.add(new ParamRowData("orgDomain", "\u0414\u043e\u043c\u0435\u043d", jsonObject.optJSONObject("domain").optString("title")));
            orgDatas.add(new ParamRowData("orgCreateTime", "\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", orgCreateAt.format(formatter)));
            JSONObject orgStatJson = jsonObject.optJSONObject("stats");
            orgStatDatas.add(new ParamRowData("orgStatStreams", "\u0412\u0438\u0434\u0435\u043e\u043f\u043e\u0442\u043e\u043a\u043e\u0432", orgStatJson.optString("streams")));
            orgStatDatas.add(new ParamRowData("orgStatUsers", "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439", orgStatJson.optString("users")));
            orgStatDatas.add(new ParamRowData("orgStatMosaics", "\u041c\u043e\u0437\u0430\u0438\u043a\u0438", orgStatJson.optString("mosaics")));
            JSONObject orgLimitJson = jsonObject.optJSONObject("limits");
            orgLimitDatas.add(new ParamRowData("orgLimitStreams", "\u0412\u0438\u0434\u0435\u043e\u043f\u043e\u0442\u043e\u043a\u043e\u0432", orgLimitJson.optString("streams")));
            orgLimitDatas.add(new ParamRowData("orgLimitUsers", "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439", orgLimitJson.optString("users")));
            JSONObject orgUserPermissionJson = jsonObject.optJSONObject("user_permissions");
            orgUserPermissionDatas.add(new ParamRowData("is_member", "is_member", orgUserPermissionJson.optString("is_member")));
            orgUserPermissionDatas.add(new ParamRowData("can_view_stats", "\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438", orgUserPermissionJson.optString("can_view_stats")));
            orgUserPermissionDatas.add(new ParamRowData("can_edit_users", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439", orgUserPermissionJson.optString("can_edit_users")));
            orgUserPermissionDatas.add(new ParamRowData("can_view_persons_lists", "can_view_persons_lists", orgUserPermissionJson.optString("can_view_persons_lists")));
            orgUserPermissionDatas.add(new ParamRowData("can_edit_persons_lists", "can_edit_persons_lists", orgUserPermissionJson.optString("can_edit_persons_lists")));
            orgUserPermissionDatas.add(new ParamRowData("can_view_streams", "\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u043a\u0430\u043c\u0435\u0440", orgUserPermissionJson.optString("can_view_streams")));
            orgUserPermissionDatas.add(new ParamRowData("can_edit_streams", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u0430\u043c\u0435\u0440", orgUserPermissionJson.optString("can_edit_streams")));
        });
        this.orgTableModel.setData(orgDatas);
        this.orgStatTableModel.setData(orgStatDatas);
        this.orgLimitTableModel.setData(orgLimitDatas);
        this.orgUserPermissionTableModel.setData(orgUserPermissionDatas);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add((Component)orgStatPanel, "\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430");
        tabbedPane.add((Component)orgLimitPanel, "\u041b\u0438\u043c\u0438\u0442\u044b");
        tabbedPane.add((Component)orgUserPermissionPanel, "\u041f\u0440\u0430\u0432\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)orgTable, (int)400, (int)100), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane(this.orgTextArea), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getUserPanel() {
        BGUTable table = new BGUTable((TableModel)((Object)this.userTableModel));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)table, (int)800, (int)400), "Center");
        return panel;
    }

    private JPanel getPresetPanel() {
        BGUTable table = new BGUTable((TableModel)((Object)this.presetTableModel));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)table, (int)800, (int)400), "Center");
        return panel;
    }

    private JPanel getCameraPanel() {
        BGUTable table = new BGUTable((TableModel)((Object)this.cameraTableModel));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)table, (int)800, (int)400), "Center");
        return panel;
    }

    class FWOrgTableModel
    extends BGParamTableModel {
        public FWOrgTableModel() {
            super(FWOrgTableModel.class.getName());
        }
    }

    class FWOrgStatTableModel
    extends BGParamTableModel {
        public FWOrgStatTableModel() {
            super(FWOrgStatTableModel.class.getName());
        }
    }

    class FWOrgLimitTableModel
    extends BGParamTableModel {
        public FWOrgLimitTableModel() {
            super(FWOrgLimitTableModel.class.getName());
        }
    }

    class FWOrgUserPermissionTableModel
    extends BGParamTableModel {
        public FWOrgUserPermissionTableModel() {
            super(FWOrgUserPermissionTableModel.class.getName());
        }
    }

    class FWUserTableModel
    extends BGTableModel<String> {
        public FWUserTableModel() {
            super(FWUserTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u0418\u043c\u044f", 100, 250, 400, "name", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("E-mail", 100, 150, -1, "email", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumnId();
        }
    }

    class FWPresetTableModel
    extends BGTableModel<String> {
        public FWPresetTableModel() {
            super(FWPresetTableModel.class.getName());
        }

        protected void initColumns() {
        }
    }

    class FWCameraTableModel
    extends BGTableModel<String> {
        public FWCameraTableModel() {
            super(FWCameraTableModel.class.getName());
        }

        protected void initColumns() {
        }
    }
}

