/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostGroup;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostIntercomService;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ForpostIntercomRuntime;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.SmartHouseParamData;
import ru.bitel.common.Utils;

public class TableForpostIntercomHouseEdit
extends BGTableInfoBase {
    private List<SmartHouseParamData> params;

    public TableForpostIntercomHouseEdit() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnTextLeft((String)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", (String)"name").setWidth(400), BGUTableColumn.buildColumnTextLeft((String)"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", (String)"value").setWidth(-1)};
        this.params = Arrays.asList(new SmartHouseParamData("Name", "text", "\u0410\u0434\u0440\u0435\u0441 \u0434\u043e\u043c\u0430 ( \u0441\u0442\u0440\u043e\u043a\u0430 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 \"\u0423\u043b\u0438\u0446\u0430 \u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u043c\u0430\" )", ""));
    }

    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        int userId = Utils.parseInt((String)tableParams.get("id"));
        int accountId = Utils.parseInt((String)tableParams.get("accountId"));
        ForpostGroup forpostHouse = null;
        if (userId > 0) {
            ForpostIntercomRuntime forpostIntercomRuntime = ForpostIntercomRuntime.getInstance(moduleId);
            forpostHouse = forpostIntercomRuntime.getAccountHouses(accountId).stream().filter(a -> a.getId() == userId).findFirst().orElse(null);
        } else {
            forpostHouse = ((ForpostIntercomService)this.getContext().getService(ForpostIntercomService.class, moduleId)).forpostIntercomHouseDefault();
        }
        ArrayList<BGUTableRowData> rowDatas = new ArrayList<BGUTableRowData>();
        for (SmartHouseParamData data : this.params) {
            String value = switch (data.getName()) {
                case "ParentID" -> String.valueOf(forpostHouse.getParentId());
                case "Name" -> forpostHouse.getName();
                default -> forpostHouse.getString(data.getName());
            };
            BGUTableRowData rowData = new BGUTableRowData().addValue("name", data.getName()).addValue("type", data.getType()).addValue("title", data.getTitle()).addValue("value", value);
            rowDatas.add(rowData);
        }
        return rowDatas;
    }
}

