/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.qiwi.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.modules.qiwi.common.bean.Transaction;
import ru.bitel.bgbilling.modules.qiwi.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.qiwi.common.bean.TransactionStatusRest;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    public TransactionManager(Connection con, int moduleId) {
        super(con, "qiwi_transaction", moduleId);
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String status) throws SQLException {
        int index;
        Objects.requireNonNull(searchResult);
        Page page = searchResult.getPage();
        Period period = searchResult.getPeriod();
        List list = searchResult.getList();
        StringBuilder query = new StringBuilder(" FROM ").append(this.tableName).append(" AS q ").append("LEFT JOIN contract c ON c.id=q.cid WHERE true").append(this.queryPeriod(period, "q.create_date"));
        if (Utils.notEmptyString((String)status)) {
            query.append(" AND q.status=?");
        } else {
            String protocol = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)).get("qiwi.protocol.version");
            String statusList = Utils.toString((Iterable)Arrays.stream("soap".equals(protocol) ? TransactionStatus.values() : TransactionStatusRest.values()).filter(s -> Utils.notBlankString((String)((AbstractTransactionStatus)s).getCode())).map(s -> "'" + ((AbstractTransactionStatus)s).getCode() + "'").collect(Collectors.toList()));
            query.append(" AND q.status in (" + statusList + ")");
        }
        if (Utils.notBlankString((String)contractTitle)) {
            query.append(" AND c.title LIKE ?");
        }
        if (contractId > 0) {
            query.append(" AND c.id=").append(contractId);
        }
        try (PreparedStatement ps = this.con.prepareStatement("SELECT q.*, c.title " + query.toString() + Page.toSqlLimit((Page)page));){
            index = this.psSetPeriod(ps, 1, period);
            if (Utils.notEmptyString((String)status)) {
                ps.setString(index++, status);
            }
            if (Utils.notBlankString((String)contractTitle)) {
                ps.setString(index++, "%" + contractTitle + "%");
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
            }
        }
        ps = this.con.prepareStatement("SELECT SUM(q.summ), COUNT(*) " + query.toString());
        try {
            index = this.psSetPeriod(ps, 1, period);
            if (Utils.notEmptyString((String)status)) {
                ps.setString(index++, status);
            }
            if (Utils.notBlankString((String)contractTitle)) {
                ps.setString(index++, "%" + contractTitle + "%");
            }
            this.executeQuerySumPage(ps, searchResult);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public Transaction getTransaction(int transactionId) throws BGException {
        Transaction result = null;
        StringBuilder query = new StringBuilder("SELECT q.*, c.title FROM " + this.tableName + " AS q");
        query.append(" LEFT JOIN contract AS c ON c.id=q.cid");
        query.append(" WHERE q.id=" + transactionId);
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result = this.getFromRS(rs);
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void addTransaction(Transaction transaction) throws BGException {
        StringBuilder query = new StringBuilder("INSERT INTO " + this.tableName);
        query.append(" SET cid=?, create_date=NOW(), summ=?, status=?, add_key=?");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setBigDecimal(index++, transaction.getSum());
            ps.setString(index++, transaction.getStatus());
            ps.setString(index++, transaction.getAdditionalKey());
            ps.executeUpdate();
            transaction.setTransactionId(String.valueOf(ServerUtils.lastInsertId((PreparedStatement)ps)));
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("q.id"))).setTransactionId(rs.getString("q.id"))).setContractId(rs.getInt("q.cid"))).setContractTitle(rs.getString("c.title"))).setSum(rs.getBigDecimal("summ"))).setCreateDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("q.create_date")))).setTransactionDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("q.end_date")))).setStatus(rs.getString("q.status"))).setAdditionalKey(rs.getString("q.add_key")).setRefundId(rs.getString("q.refund_id")).build();
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        StringBuilder query = new StringBuilder("UPDATE " + this.tableName).append(" SET status=?");
        if (transaction.getPaymentDate() != null) {
            query.append(", end_date=?");
        }
        if (Utils.notBlankString((String)transaction.getRefundId())) {
            query.append(", refund_id=?");
        }
        query.append(" WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int index = 1;
            ps.setString(index++, transaction.getStatus());
            if (transaction.getPaymentDate() != null) {
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getPaymentDate()));
            }
            if (Utils.notBlankString((String)transaction.getRefundId())) {
                ps.setString(index++, transaction.getRefundId());
            }
            ps.setString(index++, transaction.getTransactionId());
            ps.executeUpdate();
        }
    }
}

