/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.organizer.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.plugins.organizer.client.CalendarTreePanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class OrganizerJournalPanel
extends BGUPanel {
    private boolean init = false;
    private BGTable table = new BGTable();
    private JLabel recordCountLabel = new JLabel();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGComboBox<ComboBoxItem> usersCombo = new BGComboBox();
    private BGControlPanelPeriodNoB periodPanel = new BGControlPanelPeriodNoB();
    private CalendarTreePanel calendar = new CalendarTreePanel();

    protected void jbInit() throws Exception {
        BGPluginClient plugin = BGPluginManagerClient.getManager().getPlugin("ru.bitel.bgbilling.plugins.organizer");
        this.table.setHeader(plugin.getResourceBundle(), plugin.getTable("journal"), "journal");
        JPanel leftPanel = new JPanel(new GridBagLayout());
        JPanel rightPanel = new JPanel(new GridBagLayout());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        BGButton buttonSearch = new BGButton("\u041f\u043e\u0438\u0441\u043a");
        BGButton buttonReset = new BGButton("\u0421\u0431\u0440\u043e\u0441");
        buttonSearch.addActionListener(e -> {
            this.pagePanel.init();
            this.performAction("refresh");
        });
        buttonReset.addActionListener(e -> {
            this.pagePanel.init();
            this.resetFilter();
            this.performAction("refresh");
        });
        this.pagePanel.addToHandler(a -> this.performAction("refresh"));
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.setBorder((Border)new BGTitleBorder("\u041f\u043e\u0438\u0441\u043a"));
        JPanel buttonZ = new JPanel(new GridBagLayout());
        buttonZ.add((Component)new JLabel("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        buttonZ.add((Component)this.usersCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        buttonZ.add((Component)this.periodPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        buttonZ.add((Component)buttonSearch, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        buttonZ.add((Component)buttonReset, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.recordCountLabel.setFont(new Font("Dialog", 1, 14));
        JPanel pages = new JPanel(new GridBagLayout());
        pages.add((Component)new JLabel(" "), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        pages.add((Component)this.recordCountLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        pages.add((Component)this.pagePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)buttonZ, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)pages, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.calendar.addActionListener(e -> this.setSelectedPeriod());
        leftPanel.add((Component)new JScrollPane(this.calendar), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        rightPanel.add((Component)filterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        rightPanel.add((Component)mainPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 2, 0, 2), 0, 0));
        JSplitPane mainSplit = new JSplitPane();
        mainSplit.setBorder(null);
        mainSplit.setDividerSize(5);
        mainSplit.setDividerLocation(180);
        mainSplit.add((Component)leftPanel, "left");
        mainSplit.add((Component)rightPanel, "right");
        this.setLayout(new GridBagLayout());
        this.add(mainSplit, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.init = false;
    }

    private void setSelectedPeriod() {
        Period p = this.calendar.getSelectedPeriod();
        this.periodPanel.setDateCalendar1(p.getDateFromCalendar());
        this.periodPanel.setDateCalendar2(p.getDateToCalendar());
    }

    public void setDocument(Document doc) throws Exception {
        if (ClientUtils.checkStatus((Document)doc)) {
            Element tableElement = this.table.updateData(doc);
            this.pagePanel.setPageInfo(tableElement);
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Page.getRecordCount((Element)tableElement));
        }
    }

    private void resetFilter() {
        this.usersCombo.setSelectedIndex(0);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (!this.init) {
                Request request = new Request();
                request.setModule("ru.bitel.bgbilling.plugins.organizer");
                request.setAction("GetCalendarYears");
                Document doc = TransferManager.getDocument((Request)request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    Element years = XMLUtils.selectElement((Node)doc, (String)"//years");
                    this.calendar.setYears(Utils.parseInt((String)years.getAttribute("from")), Utils.parseInt((String)years.getAttribute("to")));
                }
                request = new Request();
                request.setModule("ru.bitel.bgbilling.plugins.organizer");
                request.setAction("GetUsersAndGroups");
                doc = TransferManager.getDocument((Request)request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    Node users = XMLUtils.selectNode((Node)doc, (String)"//users");
                    this.usersCombo.setModel((ComboBoxModel)ClientUtils.buildComboBoxWithDefault((Node)users, null));
                }
                this.init = true;
            } else {
                Request request = new Request();
                request.setModule("ru.bitel.bgbilling.plugins.organizer");
                request.setAction("GetJournalList");
                request.setPageIndex(this.pagePanel.getPageIndex());
                request.setPageSize(this.pagePanel.getPageSize());
                request.setPeriod(this.periodPanel.getPeriod());
                request.setAttribute("user", ((ComboBoxItem)this.usersCombo.getSelectedItem()).getObject().toString());
                this.setDocument(TransferManager.getDocument((Request)request));
            }
        });
    }
}

