/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.npay.server.event.DebetStatusManageOpenGetAdditionalCharge;
import ru.bitel.bgbilling.modules.npay.server.task.Calculator;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class DebetStatusManageConfig
extends BGLogger {
    private boolean enable = false;
    private Set<Integer> contractLabelIds;
    private int serviceSet = 0;
    private int unlockSumForDays = 0;
    private String activeStatusString;
    private String lockedStatusString;
    private List<Integer> activeStatus;
    private List<Integer> lockedStatus;
    private Map<Integer, Integer> statusRuleMap;
    private String tariffIds;
    private boolean processDependentSub;
    private boolean checkServiceObjectList;
    private boolean activeFromMonthStart = false;
    private BigDecimal unlockBalanceLimit;

    public DebetStatusManageConfig(Preferences moduleSetup, String configKey) {
        this.enable = moduleSetup.getInt("debet.npay.status.manage", 0) == 1;
        this.serviceSet = moduleSetup.getInt(this.getKey(configKey, "service.set"), 0);
        this.unlockSumForDays = moduleSetup.getInt(this.getKey(configKey, "unlock.balance.for.days"), 0);
        this.activeStatusString = moduleSetup.get(this.getKey(configKey, "active.status"), "0");
        this.activeStatus = Utils.toIntegerList((String)this.activeStatusString);
        this.lockedStatusString = moduleSetup.get(this.getKey(configKey, "locked.status"), "3");
        this.lockedStatus = Utils.toIntegerList((String)this.lockedStatusString);
        this.statusRuleMap = this.parseStatusRule(moduleSetup.get(this.getKey(configKey, "status.rule"), null));
        this.processDependentSub = moduleSetup.getInt(this.getKey(configKey, "processDependentSub"), 0) > 0;
        this.checkServiceObjectList = moduleSetup.getInt(this.getKey(configKey, "checkServiceObjectList"), 1) > 0;
        this.activeFromMonthStart = moduleSetup.getBoolean(this.getKey(configKey, "payment.active.full.month"), false);
        this.unlockBalanceLimit = moduleSetup.getBigDecimal(this.getKey(configKey, "unlock.balance.limit"), BigDecimal.ZERO);
        List ids = Utils.toIntegerList((String)moduleSetup.get(this.getKey(configKey, "status.manage.tariff.ids"), null));
        if (!ids.isEmpty()) {
            this.tariffIds = Utils.toString((Iterable)ids);
        }
        Set groupsIds = Utils.toIntegerSet((String)moduleSetup.get(this.getKey(configKey, "status.manage.groups"), ""));
        String labelIds = "";
        if (!groupsIds.isEmpty()) {
            labelIds = Utils.toString(groupsIds.stream().map(a -> a + 2).toList());
        }
        this.contractLabelIds = Utils.toIntegerSet((String)moduleSetup.get(this.getKey(configKey, "status.manage.label.ids"), labelIds));
    }

    private String getKey(String configKey, String key) {
        return "debet.npay." + (String)(configKey.isEmpty() ? "" : configKey + ".") + key;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isEnableForContractLabelIds(List<Integer> chechContractLabelIds) {
        boolean fl = this.contractLabelIds.isEmpty();
        if (!fl && chechContractLabelIds != null && !chechContractLabelIds.isEmpty()) {
            for (Integer id : chechContractLabelIds) {
                if (!this.contractLabelIds.contains(id)) continue;
                fl = true;
                break;
            }
        }
        return fl;
    }

    public Set<Integer> getContractLabelIds() {
        HashSet<Integer> ids = new HashSet<Integer>();
        this.contractLabelIds.forEach(a -> ids.add((Integer)a));
        return ids;
    }

    public int getUnlockSumForDays() {
        return this.unlockSumForDays;
    }

    public BigDecimal getUnlockBalanceLimit() {
        return this.unlockBalanceLimit;
    }

    public List<Integer> getLockStatusList() {
        return this.lockedStatus;
    }

    public boolean checkLockStatus(int status) {
        return this.lockedStatus.contains(status);
    }

    public String getLockStatusString() {
        return this.lockedStatusString;
    }

    public List<Integer> getActiveStatusList() {
        return this.activeStatus;
    }

    public String getActiveStatusString() {
        return this.activeStatusString;
    }

    public int getServiceSet() {
        return this.serviceSet;
    }

    public String getTariffIds() {
        return this.tariffIds;
    }

    public boolean isProcessDependentSub() {
        return this.processDependentSub;
    }

    public boolean isCheckServiceObjectList() {
        return this.checkServiceObjectList;
    }

    public BigDecimal getSummaForUnlock(Connection con, int moduleId, Contract contract) throws BGException {
        BigDecimal result = null;
        if (contract.getBalanceMode() == 1 && this.checkLockStatus(contract.getStatus())) {
            GregorianCalendar now = new GregorianCalendar();
            ModuleCache cache = ModuleCache.getInstance();
            if (!this.processDependentSub && contract.getSuperCid() > 0 && contract.isDependSub()) {
                return this.getSummaForUnlock(con, moduleId, ContractDao.getContract((Connection)con, (int)contract.getSuperCid()));
            }
            ArrayList<Integer> cids = new ArrayList<Integer>();
            cids.add(contract.getId());
            if (!this.processDependentSub && contract.isSuper() && Utils.notBlankString((String)contract.getDependSubList())) {
                cids.addAll(Utils.toIntegerList((String)contract.getDependSubList()));
            }
            int days = this.unlockSumForDays;
            BigDecimal planAccount = BigDecimal.ZERO;
            HashMap<Integer, Map<String, String>> configMap = new HashMap<Integer, Map<String, String>>();
            Calendar startDate = (Calendar)((Calendar)now).clone();
            while (true) {
                Calculator calculator = new Calculator();
                calculator.setExecutingTime(startDate);
                calculator.setPreCalc(this.getNextStatus(contract.getStatus()));
                calculator.initTask(Setup.getSetup(), 0, "mid=" + moduleId + "\nservice.set=" + this.serviceSet);
                calculator.setContractIds(cids);
                if (days < 1) {
                    if (this.activeFromMonthStart) {
                        Calendar startMonth = TimeUtils.getStartMonth((Calendar)startDate);
                        calculator.setActiveFromDate(startMonth);
                        Calendar endMonth = TimeUtils.getEndMonth((Calendar)startDate);
                        calculator.setExecutingTime(endMonth);
                    }
                } else if (days > 0) {
                    calculator.setActiveFromDate(startDate);
                    int delta = startDate.getActualMaximum(5) - startDate.get(5) + 1;
                    if (delta < days) {
                        endDate = (Calendar)startDate.clone();
                        ((Calendar)endDate).add(5, delta - 1);
                        calculator.setExecutingTime((Calendar)endDate);
                        days -= delta;
                    } else {
                        endDate = (Calendar)startDate.clone();
                        ((Calendar)endDate).add(5, days - 1);
                        calculator.setExecutingTime((Calendar)endDate);
                        days = 0;
                    }
                }
                calculator.runLocal();
                Map planAccountMap = calculator.getCostCache().getContractAccounts();
                for (Integer contractId : cids) {
                    BigDecimal contractPlanAccount = Utils.maskNull((BigDecimal)((BigDecimal)planAccountMap.get(contractId)));
                    planAccount = planAccount.add(contractPlanAccount);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Plan account cid: " + contractId + "; planAccount: " + String.valueOf(contractPlanAccount));
                    }
                    configMap.put(contractId, calculator.getConfigCache().getConfigs(contractId));
                }
                if (days < 1) break;
                startDate.add(2, 1);
                startDate.set(5, 1);
            }
            try (BalanceUtils balanceUtils = new BalanceUtils(con);){
                BigDecimal currentAccount = balanceUtils.getAccountSumma(contract.getId(), (Calendar)now, cache.getModuleServicesString(moduleId));
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("currentAccount: " + String.valueOf(currentAccount) + "; planAccount: " + String.valueOf(planAccount));
                }
                BigDecimal accountDiff = planAccount.subtract(currentAccount);
                BigDecimal currentBalance = balanceUtils.getBalanceOut(now.getTime(), contract.getId());
                BigDecimal currentLimit = contract.getBalanceLimit();
                result = currentBalance.subtract(currentLimit).subtract(accountDiff).negate();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("accountDif: " + String.valueOf(accountDiff) + "; currentBalance: " + String.valueOf(currentBalance) + "; currentLimit: " + String.valueOf(currentLimit) + "; result: " + String.valueOf(result));
                }
                DebetStatusManageOpenGetAdditionalCharge event = new DebetStatusManageOpenGetAdditionalCharge(moduleId, contract.getId()).setCurrentAccount(currentAccount).setPlanAccount(planAccount).setCurrentBalance(currentBalance).setLimit(currentLimit).setConfigList(configMap).setResult(result);
                event = (DebetStatusManageOpenGetAdditionalCharge)EventProcessor.getInstance().request((QueueEvent)event);
                if (event.getSumma() != null) {
                    result = event.getMode() == 1 ? result.add(event.getSumma()) : event.getSumma();
                }
                if (result.compareTo(BigDecimal.ZERO) < 0) {
                    result = BigDecimal.ZERO;
                }
            }
        }
        return result;
    }

    public int getNextStatus(int status) {
        Integer result = this.statusRuleMap.get(status);
        if (result == null) {
            result = this.lockedStatus.contains(status) ? this.activeStatus.get(0) : this.lockedStatus.get(0);
        }
        return result;
    }

    private Map<Integer, Integer> parseStatusRule(String statusRule) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        if (statusRule != null) {
            String[] pairList;
            for (String pair : pairList = statusRule.split(",")) {
                String[] str = pair.split(":");
                if (str.length <= 1) continue;
                result.put(Utils.parseInteger((String)str[0], null), Utils.parseInteger((String)str[1], null));
            }
        }
        return result;
    }

    public static DebetStatusManageConfig getConfig(int moduleId, List<Integer> contractLabelIds) {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        List keys = Utils.toList((String)moduleSetup.get("debet.npay.keys", ""));
        if (!keys.isEmpty()) {
            for (String configKey : keys) {
                DebetStatusManageConfig config = new DebetStatusManageConfig((Preferences)moduleSetup, configKey);
                if (!config.isEnableForContractLabelIds(contractLabelIds)) continue;
                return config;
            }
        }
        return new DebetStatusManageConfig((Preferences)moduleSetup, "");
    }
}

