/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server;

import bitel.billing.server.ModuleBase;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubscription;
import ru.bitel.bgbilling.modules.megogo.common.service.MegogoService;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class Module
extends ModuleBase {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.megogo.server"};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void moduleAction(ServerContext ctx, int mid, Event event) throws Exception {
        block9: {
            int cid;
            block8: {
                cid = event.getContractId();
                if (!(event instanceof ContractDeleteEvent)) break block8;
                ContractDeleteEvent cdEvent = (ContractDeleteEvent)event;
                if (!cdEvent.isCheck()) break block9;
                ContractDeleteEvent e = (ContractDeleteEvent)event;
                List list = this.getMegogoService(mid).contractSubscriptionList(cid, -1, true);
                for (MegogoContractSubscription subscription : list) {
                    if (subscription.getStatus() == 2) continue;
                    e.setError("\u0415\u0441\u0442\u044c \u043d\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043c\u043e\u0434\u0443\u043b\u044f Megogo!");
                    return;
                }
                break block9;
            }
            if (event instanceof ContractCloseEvent) {
                ContractCloseEvent ccEvent = (ContractCloseEvent)event;
                if (ccEvent.isCheck()) {
                    return;
                }
                MegogoService megogoService = this.getMegogoService(mid);
                List list = megogoService.contractSubscriptionList(cid, -1, true);
                for (MegogoContractSubscription subscription : list) {
                    if (subscription.getStatus() != 0 && subscription.getStatus() != 1) continue;
                    if (subscription.getPeriod().getDateTo() == null) {
                        subscription.getPeriod().setDateTo(new Date());
                        if (TimeUtils.dateBefore((Date)new Date(), (Date)ccEvent.getDate())) {
                            subscription.getPeriod().setDateTo(ccEvent.getDate());
                        }
                    } else if (TimeUtils.dateBefore((Date)ccEvent.getDate(), (Date)subscription.getPeriod().getDateTo()) && TimeUtils.dateBefore((Date)new Date(), (Date)ccEvent.getDate())) {
                        subscription.getPeriod().setDateTo(ccEvent.getDate());
                    }
                    megogoService.updateContractSubscription(subscription, false);
                }
            }
        }
    }

    public void lockService(Connection con, int mid, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        int cid = contractRuntime.contractId;
        MegogoService megogoService = this.getMegogoService(mid);
        try {
            List list = megogoService.contractSubscriptionList(cid, -1, true);
            for (MegogoContractSubscription subscription : list) {
                if (subscription.getStatus() != 0 && subscription.getStatus() != 1) continue;
                megogoService.suspend(subscription.getId());
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void unlockService(Connection con, int mid, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        int cid = contractRuntime.contractId;
        MegogoService megogoService = this.getMegogoService(mid);
        try {
            List list = megogoService.contractSubscriptionList(cid, -1, true);
            for (MegogoContractSubscription subscription : list) {
                if (subscription.getStatus() != 4) continue;
                megogoService.resume(subscription.getId());
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void lockServiceNow(Connection con, int mid, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        this.lockService(con, mid, contractRuntime, balance, limit, lightweight);
    }

    public void unlockServiceNow(Connection con, int mid, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        this.unlockService(con, mid, contractRuntime, balance, limit, lightweight);
    }

    public void serializeContract(Connection con, int cid, int mid, XMLStreamWriter tables, boolean onlyCurrent) throws SQLException, XMLStreamException {
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("megogo_contract_credentials_" + mid), (String)"contractId", (String)("" + cid), null, (boolean)false, null, null);
    }

    private MegogoService getMegogoService(int mid) throws BGException {
        ServerContext context = (ServerContext)ServerContext.get();
        return (MegogoService)context.newService(MegogoService.class, mid);
    }
}

