/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server.tasks;

import bitel.billing.server.contract.bean.ContractModuleManager;
import bitel.billing.server.contract.bean.CostSum;
import bitel.billing.server.contract.bean.ServiceCostCache;
import java.sql.Connection;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.bean.PeriodicErrorManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTree;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubscription;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubscriptionStatusPeriod;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractTryAndBuy;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoContractSubscriptionDao;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoContractSubscriptionStatusPeriodDao;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoContractTryAndBuyDao;
import ru.bitel.bgbilling.modules.megogo.server.tariff.MegogoServiceCost;
import ru.bitel.bgbilling.modules.megogo.server.tariff.MegogoTariffContext;
import ru.bitel.bgbilling.modules.megogo.server.tariff.MegogoTariffRequest;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class Calculator
extends TaskBase {
    protected Calendar startMonth;
    protected Calendar endMonth;
    protected String cids;
    protected int daysInMonth;
    protected PeriodicErrorManager errorManager;
    protected MegogoTariffContext context;
    protected ServiceCostCache costCache;
    protected boolean calcErrors = false;
    protected boolean preCalcMode = false;
    private List<MegogoContractSubscription> subscriptions = null;
    protected TariffModuleTreeSetDao tariffModuleTreeSetDao;
    private Connection con;

    public void setSubscriptions(List<MegogoContractSubscription> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public ServiceCostCache getCostCache() {
        return this.costCache;
    }

    public void setCids(String codes) {
        this.cids = codes;
    }

    protected boolean initTask() {
        this.initDate(-1);
        return true;
    }

    public void setPreCalc() {
        this.preCalcMode = true;
    }

    public boolean isCalcErrors() {
        return this.calcErrors;
    }

    public String getDescription() {
        String cidStr = Utils.isBlankString((String)this.cids) ? "" : ". \u041a\u043e\u0434\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432: " + this.cids;
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c Megogo. \u0417\u0430\u0434\u0430\u0447\u0430 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ". \u0417\u0430 \u043c\u0435\u0441\u044f\u0446: " + TimeUtils.format((Calendar)this.startMonth, (String)"yyyy.MM") + cidStr;
    }

    protected void initDate(int delta) {
        this.startMonth = (Calendar)this.getOperatingTime().clone();
        if (!this.preCalcMode) {
            this.startMonth.add(11, delta);
            this.startMonth.set(5, 1);
            this.startMonth.set(11, 0);
        }
        this.endMonth = TimeUtils.getEndMonth((Calendar)this.startMonth);
        this.daysInMonth = this.startMonth.getActualMaximum(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        this.con = this.setup.getDBConnectionFromPool();
        try (BalanceUtils bu = new BalanceUtils(this.con);){
            MegogoContractTryAndBuyDao contractTryAndBuyDao = new MegogoContractTryAndBuyDao(this.con, this.moduleId);
            MegogoContractSubscriptionDao megogoContractServiceDao = new MegogoContractSubscriptionDao(this.con, this.moduleId);
            MegogoContractSubscriptionStatusPeriodDao statusPeriodDao = new MegogoContractSubscriptionStatusPeriodDao(this.con, this.moduleId);
            this.tariffModuleTreeSetDao = new TariffModuleTreeSetDao(this.con);
            this.errorManager = new PeriodicErrorManager(this.con);
            this.errorManager.initErrorMessage(this.moduleId, "Megogo", String.valueOf(this.moduleId), this.startMonth.getTime());
            this.getLogger().debug("Operation date: " + String.valueOf(this.getOperatingTime().getTime()));
            this.getLogger().debug("Calc period: " + TimeUtils.formatPeriod((Calendar)this.startMonth, (Calendar)this.endMonth));
            this.context = new MegogoTariffContext(this.moduleId, this.startMonth, this.getOperatingTime());
            this.costCache = new ServiceCostCache();
            String moduleServices = ModuleCache.getInstance().getModuleServicesString(this.moduleId);
            int cnt = 0;
            ContractModuleManager moduleManager = new ContractModuleManager(this.con);
            if (!this.preCalcMode || this.subscriptions == null) {
                this.subscriptions = megogoContractServiceDao.getContractsSubscriptionList(this.cids, moduleServices, -1, this.startMonth.getTime(), this.endMonth.getTime(), -1);
            }
            for (MegogoContractSubscription service : this.subscriptions) {
                if (!moduleManager.getContractModuleSet(service.getContractId()).contains(this.moduleId)) {
                    this.calcErrors = true;
                    if (!this.preCalcMode && !this.errorManager.isCapReached()) {
                        String subject = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438";
                        String text = "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043c\u043e\u0434\u0443\u043b\u044c mid=" + this.moduleId + " \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 cid=" + service.getContractId() + ", \u043d\u043e \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430 sid=" + service.getServiceId();
                        this.errorManager.addErrorToList(subject, text);
                    }
                    this.getLogger().error("No module mid=" + this.moduleId + " on the contract cid=" + service.getContractId() + ", but the presence active sid=" + service.getServiceId());
                    continue;
                }
                cnt = this.processServiceObject(cnt, service, this.tariffModuleTreeSetDao, contractTryAndBuyDao, statusPeriodDao);
            }
            if (!this.preCalcMode) {
                bu.setAccount(this.con, this.getLogger(), this.startMonth, this.costCache, moduleServices, this.cids, null);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            this.error = ex;
        }
        finally {
            if (!this.preCalcMode) {
                try {
                    this.errorManager.deleteErrorsByMarker(String.valueOf(this.moduleId), this.startMonth.getTime());
                    this.errorManager.processErrors();
                }
                catch (Exception exception) {}
            }
            ServerUtils.closeConnection((Connection)this.con);
        }
    }

    private int processServiceObject(int cnt, MegogoContractSubscription serviceObject, TariffModuleTreeSetDao tariffModuleTreeSetDao, MegogoContractTryAndBuyDao contractTryAndBuyDao, MegogoContractSubscriptionStatusPeriodDao statusPeriodDao) {
        int contractId = serviceObject.getContractId();
        int sid = serviceObject.getServiceId();
        try {
            Date serviceStartDate = serviceObject.getPeriod().getDateFrom();
            Date serviceEndDate = serviceObject.getPeriod().getDateTo();
            Calendar serviceStart = TimeUtils.convertDateToCalendar((Date)serviceObject.getPeriod().getDateFrom());
            Calendar serviceEnd = TimeUtils.convertDateToCalendar((Date)serviceObject.getPeriod().getDateTo());
            int col = serviceObject.getCount();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Found service taker cid: " + contractId + "; sid: " + sid + "; date1: " + TimeUtils.formatDate((Calendar)serviceStart) + "; date2: " + TimeUtils.formatDate((Calendar)serviceEnd) + "; col: " + col);
            }
            if (serviceEnd != null && TimeUtils.dateBefore((Calendar)serviceEnd, (Calendar)this.startMonth)) {
                this.getLogger().debug("Service end before month start.");
                return 0;
            }
            if (serviceStart != null && TimeUtils.dateBefore((Calendar)this.endMonth, (Calendar)serviceStart)) {
                this.getLogger().debug("Service starting after month end.");
                return 0;
            }
            Calendar serviceDate1 = TimeUtils.convertDateToCalendar((Date)this.trimByMonthStart(serviceStartDate));
            Calendar serviceDate2 = TimeUtils.convertDateToCalendar((Date)this.trimByMonthEnd(serviceEndDate));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("After trimming cid: " + contractId + "; sid: " + sid + "; date1: " + TimeUtils.formatDate((Calendar)serviceDate1) + "; date2: " + TimeUtils.formatDate((Calendar)serviceDate2));
            }
            TariffModuleTreeSet tariffTreeSet = tariffModuleTreeSetDao.getRealtimeTariffTreeSet(contractId, this.startMonth.getTime(), "megogo", this.moduleId, 0, 0);
            boolean accept = false;
            for (TariffModuleTreeSet.Entry tariffPeriod : tariffTreeSet.entries()) {
                Calendar tariffFrom = tariffPeriod.getCalendarFrom();
                Calendar tariffTo = tariffPeriod.getCalendarTo();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Tariff period: " + TimeUtils.formatPeriod((Calendar)tariffFrom, (Calendar)tariffTo));
                }
                Calendar date1 = (Calendar)serviceDate1.clone();
                Calendar date2 = (Calendar)serviceDate2.clone();
                if (tariffFrom != null && TimeUtils.dateBefore((Calendar)date2, (Calendar)tariffFrom)) continue;
                if (tariffFrom != null && TimeUtils.dateBefore((Calendar)date1, (Calendar)tariffFrom)) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Trim left");
                    }
                    date1 = tariffFrom;
                }
                if (tariffTo != null && TimeUtils.dateBefore((Calendar)tariffTo, (Calendar)date2)) {
                    if (!TimeUtils.dateBeforeOrEq((Calendar)date1, (Calendar)tariffTo)) continue;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Trim right");
                    }
                    date2 = tariffTo;
                }
                MegogoTariffRequest megogoTariffRequest = new MegogoTariffRequest(this.moduleId, contractId, sid);
                megogoTariffRequest.setInfoEnable(this.getLogger().isDebugEnabled());
                megogoTariffRequest.setAccountingMonthDays(this.daysInMonth);
                megogoTariffRequest.setTime(date1);
                List<MegogoContractSubscriptionStatusPeriod> statusPeriodList = statusPeriodDao.getList(serviceObject.getId(), 4, false, new Period(date1.getTime(), date2.getTime()));
                BitSet unpaidBitSet = this.getUnpaidBitSet(statusPeriodList, contractTryAndBuyDao.getContractTBByIdSub(serviceObject.getId()));
                MegogoServiceCost megogoServiceCost = (MegogoServiceCost)new MegogoServiceCost().setServiceId(sid).setServiceStart(serviceStart == null ? null : TimeUtils.convertDateToLocalDate((Date)serviceStart.getTime())).setServiceEnd(serviceEnd == null ? null : TimeUtils.convertDateToLocalDate((Date)serviceEnd.getTime())).setDate1(date1).setDate2(date2).setAmount((long)col).to(MegogoServiceCost.class);
                megogoServiceCost.unpaidBitSet = unpaidBitSet;
                megogoTariffRequest.setServiceCost(sid, Collections.singletonList(megogoServiceCost));
                TariffModuleTree tree = tariffPeriod.getTree();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Request in tree: " + tree.getTreeId());
                    this.getLogger().debug(megogoTariffRequest.toString());
                }
                tree.execute((AbstractTariffRequest)megogoTariffRequest, (TariffContext)this.context);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Request after processing: " + tariffPeriod.getTree().getTreeId());
                    this.getLogger().debug(megogoTariffRequest.toString());
                }
                if (!megogoTariffRequest.isAccepted()) continue;
                accept = true;
                for (MegogoServiceCost serviceCost : megogoTariffRequest.getServiceCostList()) {
                    CostSum sum = new CostSum(contractId, serviceCost.getServiceId(), serviceCost.getCost());
                    this.costCache.addAmount(sum);
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("Add cost cache cid: " + contractId + "; sid: " + serviceCost.getServiceId() + "; cost: " + String.valueOf(serviceCost.getCost()));
                }
            }
            if (!accept) {
                this.calcErrors = true;
                if (!this.preCalcMode && !this.errorManager.isCapReached()) {
                    String subject = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438";
                    String text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + contractId + "\n\u041e\u0431\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u043c\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430: " + sid;
                    this.errorManager.addErrorToList(subject, text);
                }
                this.getLogger().error("Tariff error contractId: " + contractId + "; serviceId: " + sid);
            }
            if (++cnt % 1000 == 0 && this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Item count " + cnt);
            }
        }
        catch (Exception e) {
            this.calcErrors = true;
            if (!this.preCalcMode && !this.errorManager.isCapReached()) {
                String subject = "\u041d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 " + e.getMessage();
                String text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + contractId + "\n\u041e\u0431\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u043c\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430: " + sid;
                this.errorManager.addErrorToList(subject, text, e);
            }
            Contract c = null;
            try {
                c = ContractDao.getContract((Connection)this.con, (int)contractId);
            }
            catch (BGException e1) {
                this.getLogger().error("\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u0441 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c " + contractId + " \u0438\u0437 \u0411\u0414", (Throwable)e1);
            }
            this.getLogger().error("Fatal tariff error contractId: " + contractId + "; serviceId: " + sid + "; contractStatus: " + c.getStatus(), (Throwable)e);
        }
        return cnt;
    }

    private BitSet getUnpaidBitSet(List<MegogoContractSubscriptionStatusPeriod> list, MegogoContractTryAndBuy tryAndBuy) {
        if (tryAndBuy != null && tryAndBuy.getPeriod() != null && tryAndBuy.getPeriod().getDateFrom() != null && tryAndBuy.getPeriod().getDateTo() != null) {
            MegogoContractSubscriptionStatusPeriod sP = new MegogoContractSubscriptionStatusPeriod();
            sP.setDateFrom(tryAndBuy.getPeriod().getDateFrom());
            sP.setDateTo(tryAndBuy.getPeriod().getDateTo());
            list.add(sP);
        }
        BitSet bitSet = new BitSet(32);
        for (MegogoContractSubscriptionStatusPeriod statusPeriod : list) {
            if (TimeUtils.dateBefore((Date)statusPeriod.getDateTo(), (Date)statusPeriod.getDateFrom())) {
                Date varFrom = statusPeriod.getDateFrom();
                statusPeriod.setDateFrom(statusPeriod.getDateTo());
                statusPeriod.setDateTo(varFrom);
            }
            Calendar from = TimeUtils.convertDateToCalendar((Date)this.trimByMonthStart(statusPeriod.getDateFrom()));
            Calendar to = TimeUtils.convertDateToCalendar((Date)this.trimByMonthEnd(statusPeriod.getDateTo()));
            TimeUtils.format((Calendar)from, (String)"dd.MM.yyyy");
            TimeUtils.format((Calendar)to, (String)"dd.MM.yyyy");
            while (TimeUtils.dateBeforeOrEq((Calendar)from, (Calendar)to)) {
                int day = from.get(5);
                bitSet.set(day);
                from.add(6, 1);
            }
        }
        this.getLogger().info("Free days - " + bitSet.toString());
        return bitSet;
    }

    private Date trimByMonthEnd(Date date) {
        if (date == null || TimeUtils.dateBefore((Date)this.endMonth.getTime(), (Date)date)) {
            date = ((Calendar)this.endMonth.clone()).getTime();
        }
        return date;
    }

    private Date trimByMonthStart(Date date1) {
        if (date1 == null || TimeUtils.dateBefore((Date)date1, (Date)this.startMonth.getTime())) {
            date1 = ((Calendar)this.startMonth.clone()).getTime();
        }
        return date1;
    }
}

