/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.api;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.LocalDateTime;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProduct;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonApiMethod;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonApiToken;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonKassaApiClient;
import ru.bitel.bgbilling.modules.megafon.server.utils.MegafonUtils;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class MegafonApiClient {
    private static final Logger log = LogManager.getLogger();
    public static final String MEGAFON_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private final HttpClient httpClient;
    private final ModuleSetup moduleSetup;
    private final int moduleId;
    private final boolean isTestWorkMode;

    public MegafonApiClient(int moduleId) {
        this.moduleId = moduleId;
        this.moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        this.httpClient = HttpClient.newBuilder().sslContext(MegafonSSLContext.getSSLContext(this.moduleSetup)).connectTimeout(Duration.ofSeconds(3L)).build();
        this.isTestWorkMode = this.moduleSetup.getInt("megafon.work.mode", 2) == 2;
    }

    public JSONObject getToken(String body) {
        log.debug("Request getToken BODY={}", (Object)body);
        String url = this.isTestWorkMode ? this.moduleSetup.get("megafon.token.url.test") : this.moduleSetup.get("megafon.token.url");
        URI uri = URI.create(url + MegafonApiMethod.getPath(MegafonApiMethod.Method.GET_TOKEN, this.moduleSetup, "megafon.realm"));
        return new JSONObject(this.sendRequest(this.requestBuilder(uri, "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(body, StandardCharsets.UTF_8)).build()));
    }

    public JSONArray getTariffInfo(String msisdn) {
        return this.getTariffInfo(msisdn, null);
    }

    public JSONArray getTariffInfo(String msisdn, JSONObject filters) {
        JSONObject pathParameters = new JSONObject();
        pathParameters.put("msisdn", (Object)msisdn);
        return this.sendGetRequest(this.createURI(MegafonApiMethod.getPath(MegafonApiMethod.Method.GET_TARIFF, pathParameters)), filters).optJSONArray("items");
    }

    public JSONObject getAvailableProducts(String msisdn, JSONObject filter) {
        JSONObject pathParameters = new JSONObject();
        pathParameters.put("msisdn", (Object)msisdn);
        return this.sendGetRequest(this.createURI(MegafonApiMethod.getPath(MegafonApiMethod.Method.GET_AVAILABLE_PRODUCTS, pathParameters)), filter);
    }

    public boolean checkActivateProduct(String msisdn, String productOfferingId, LocalDateTime dateFrom) throws BGException {
        JSONObject parameter = new JSONObject();
        parameter.put("productOfferingId", Utils.parseLong((String)productOfferingId));
        JSONObject activationPeriod = new JSONObject();
        activationPeriod.put("dateFrom", (Object)TimeUtils.format((LocalDateTime)dateFrom, (String)MEGAFON_DATE_FORMAT));
        parameter.put("activationPeriod", (Object)activationPeriod);
        JSONObject pathParameters = new JSONObject();
        pathParameters.put("msisdn", (Object)msisdn);
        URI uri = this.createURI(MegafonApiMethod.getPath(MegafonApiMethod.Method.CHECK_ACTIVATE, pathParameters));
        JSONObject response = this.sendPostRequest(uri, this.getRequestBody(parameter));
        JSONArray conflicts = response.optJSONArray("conflicts");
        if (conflicts.isEmpty()) {
            return true;
        }
        StringBuilder error = new StringBuilder("\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u044b:\n");
        for (int i = 0; i < conflicts.length(); ++i) {
            JSONObject conflict = conflicts.getJSONObject(i);
            error.append("[\u041f\u0440\u043e\u0434\u0443\u043a\u0442: ").append(conflict.optString("productOfferingName")).append(", \u041e\u0448\u0438\u0431\u043a\u0430: ").append(conflict.optString("message")).append("]\n");
        }
        throw new BGException(error.toString());
    }

    public long productActivate(MegafonContractProduct contractProduct, String productOfferingId) {
        return this.sendActivateRequest(MegafonUtils.defineCorrectMSISDN(contractProduct), contractProduct.getStartTime(), contractProduct.getEndTime() != null ? contractProduct.getEndTime() : null, productOfferingId);
    }

    public long optionActivate(String msisdn, LocalDateTime startDate, LocalDateTime endDate, String offeringId) {
        return this.sendActivateRequest(msisdn, startDate, endDate, offeringId);
    }

    private long sendActivateRequest(String msisdn, LocalDateTime startDate, LocalDateTime dateTo, String productOfferingId) {
        JSONObject parameter = new JSONObject();
        parameter.put("productOfferingId", (Object)productOfferingId);
        if (startDate != null) {
            JSONObject activationPeriod = new JSONObject();
            activationPeriod.put("dateFrom", (Object)TimeUtils.format((LocalDateTime)startDate, (String)MEGAFON_DATE_FORMAT));
            if (dateTo != null) {
                activationPeriod.put("dateTo", (Object)TimeUtils.format((LocalDateTime)dateTo, (String)MEGAFON_DATE_FORMAT));
            }
            parameter.put("activationPeriod", (Object)activationPeriod);
        }
        JSONObject pathParameters = new JSONObject();
        pathParameters.put("msisdn", (Object)msisdn);
        URI uri = this.createURI(MegafonApiMethod.getPath(MegafonApiMethod.Method.PRODUCT_ACTIVATE, pathParameters));
        JSONObject response = this.sendPostRequest(uri, this.getRequestBody(parameter));
        long orderId = response.optLong("orderId", 0L);
        if (orderId == 0L) {
            throw new RuntimeException("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0443\u0436\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d!");
        }
        return orderId;
    }

    public long productDeactivate(MegafonContractProduct contractProduct, String productOfferingId) {
        String msisdn = Utils.notBlankString((String)contractProduct.getMsisdn()) ? contractProduct.getMsisdn() : contractProduct.getAdditionalMsisdn();
        JSONObject pathParameters = new JSONObject();
        pathParameters.put("msisdn", (Object)msisdn);
        JSONObject parameter = new JSONObject();
        parameter.put("productId", this.getProductId(msisdn, productOfferingId));
        parameter.put("deactivationDateTime", (Object)TimeUtils.format((LocalDateTime)contractProduct.getEndTime(), (String)MEGAFON_DATE_FORMAT));
        URI uri = this.createURI(MegafonApiMethod.getPath(MegafonApiMethod.Method.PRODUCT_DEACTIVATE, pathParameters));
        JSONObject response = this.sendPostRequest(uri, this.getRequestBody(parameter));
        long orderId = response.optLong("orderId");
        if (orderId == 0L) {
            throw new RuntimeException("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u0443\u0436\u0435 \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d!");
        }
        return orderId;
    }

    public JSONObject getOrderInfo(long orderId) {
        JSONObject params = new JSONObject();
        params.put("orderId", orderId);
        return this.sendGetRequest(this.createURI(MegafonApiMethod.getPath(MegafonApiMethod.Method.GET_ORDER_ID, params)));
    }

    public JSONObject getInquiries(String inquiryId) {
        JSONObject fields = new JSONObject();
        fields.put("fields", (Object)"inquiryId,subscriber,customer,currentState");
        JSONObject pathParams = new JSONObject();
        pathParams.put("inquiryId", (Object)inquiryId);
        return this.sendGetRequest(this.createURI(MegafonApiMethod.getPath(MegafonApiMethod.Method.GET_INQUIRIES, pathParams)), fields);
    }

    public JSONObject getNextProductCharges(String msisdn) {
        JSONObject pathParameter = new JSONObject();
        pathParameter.put("msisdn", (Object)msisdn);
        return this.sendGetRequest(this.createURI(MegafonApiMethod.getPath(MegafonApiMethod.Method.GET_NEXT_PRODUCT_CHARGES, pathParameter)), null);
    }

    public int activateSim(int contractId, String msisdn) {
        String activateSimPrice = this.moduleSetup.get("megafon.activate.sim.price");
        BigDecimal activatePrice = Utils.parseBigDecimal((String)activateSimPrice, (BigDecimal)BigDecimal.ZERO);
        if (activatePrice.compareTo(BigDecimal.ZERO) <= 0) {
            throw new RuntimeException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0441\u0438\u043c-\u043a\u0430\u0440\u0442\u044b!");
        }
        log.info("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044e \u0441\u0438\u043c. MSISDN={}", (Object)msisdn);
        JSONObject queryParameter = new JSONObject();
        queryParameter.put("msisdn", (Object)msisdn);
        URI uri = this.createURI(MegafonApiMethod.getPath(MegafonApiMethod.Method.ACTIVATE_SIM, new JSONObject()) + this.requestParametersToString(queryParameter));
        JSONObject response = this.sendPostRequest(uri, new JSONObject());
        log.debug("Activate sim response => {}", (Object)response);
        int activ_status = response.optInt("activ_status", -1);
        if (activ_status == 1) {
            MegafonKassaApiClient kassaApiClient = new MegafonKassaApiClient(this.moduleId);
            log.debug("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0437\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044e. amount={}, msisdn={}", (Object)activatePrice, (Object)msisdn);
            int attempts = this.moduleSetup.getInt("kassa.check.attempts", 60);
            int attemptsDelay = this.moduleSetup.getInt("kassa.attempts.delay", 3000);
            for (int i = 0; i < attempts && !kassaApiClient.accountExists(msisdn); ++i) {
                try {
                    Thread.sleep(attemptsDelay);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            kassaApiClient.addPayment(contractId, msisdn, activatePrice, "\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0441\u0438\u043c-\u043a\u0430\u0440\u0442\u044b msisdn=" + msisdn);
            return activ_status;
        }
        if (activ_status == 2) {
            log.debug("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044e \u0421\u0418\u041c - \u041d\u043e\u043c\u0435\u0440 \u0431\u044b\u043b \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u0440\u0430\u043d\u0435\u0435. MSISDN={}, \u041e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438: {}", (Object)msisdn, (Object)response);
            return activ_status;
        }
        throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0441\u0438\u043c. MSISDN=" + msisdn + ", \u041e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438: " + String.valueOf(response));
    }

    public JSONObject getCustomersInfo(String msisdn) {
        JSONObject pathParameter = new JSONObject();
        pathParameter.put("msisdn", (Object)msisdn);
        URI uri = this.createURI(MegafonApiMethod.getPath(MegafonApiMethod.Method.GET_CUSTOMERS_INFO, pathParameter));
        return this.sendGetRequest(uri);
    }

    private JSONObject getRequestBody(JSONObject parameter) {
        JSONObject body = new JSONObject();
        JSONArray arr = new JSONArray();
        arr.put((Object)parameter);
        body.put("parameters", (Object)arr);
        return body;
    }

    private long getProductId(String msisdn, String productOfferingId) {
        long productId = 0L;
        JSONArray tariffs = this.getTariffInfo(msisdn);
        for (int i = 0; i < tariffs.length(); ++i) {
            JSONObject tariff = tariffs.optJSONObject(i);
            long productOfferingIdFromMegafon = tariff.optLong("productOfferingId");
            if (productOfferingIdFromMegafon != Utils.parseLong((String)productOfferingId)) continue;
            productId = tariff.optLong("productId");
            break;
        }
        if (productId <= 0L) {
            throw new RuntimeException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c productId \u0438\u0437 \u0442\u0430\u0440\u0438\u0444\u0430 \u043d\u0430 \u043d\u043e\u043c\u0435\u0440\u0435 = " + msisdn);
        }
        return productId;
    }

    public JSONObject sendPostRequest(URI uri, JSONObject body) {
        log.debug("Request to URI={}, BODY={}", (Object)uri.toString(), (Object)(body == null ? "" : body.toString()));
        String body0 = body != null && !body.isEmpty() ? body.toString() : "";
        return new JSONObject(this.sendRequest(this.requestBuilder(uri, "application/json").header("Authorization", "Bearer " + MegafonApiToken.getToken(this.moduleId)).POST(HttpRequest.BodyPublishers.ofString(body0)).build()));
    }

    public JSONObject sendGetRequest(URI uri) {
        return this.sendGetRequest(uri, null);
    }

    public JSONObject sendGetRequest(URI uri, JSONObject requestParameters) {
        if (requestParameters != null) {
            uri = URI.create(uri.toString() + this.requestParametersToString(requestParameters));
        }
        return new JSONObject(this.sendRequest(this.requestBuilder(uri, "application/x-www-form-urlencoded").header("Authorization", "Bearer " + MegafonApiToken.getToken(this.moduleId)).GET().build()));
    }

    public HttpRequest.Builder requestBuilder(URI uri, String contentType) {
        return HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", Utils.isBlankString((String)contentType) ? "application/json" : contentType);
    }

    public String sendRequest(HttpRequest request) {
        log.debug("Request to Megafon => method={}, URI={}", (Object)request.method(), (Object)request.uri().toString());
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            int statusCode = response.statusCode();
            String responseData = response.body();
            log.debug("Response => statusCode={}, method={}, body={}, headers={}", (Object)statusCode, (Object)request.method(), (Object)responseData, (Object)response.headers().toString());
            if (statusCode / 100 != 2) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435. \u041a\u043e\u0434:" + response.statusCode() + ", message:" + response.body());
            }
            return responseData;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private URI createURI(String path) {
        String url;
        String string = url = this.isTestWorkMode ? this.moduleSetup.get("megafon.url.test") : this.moduleSetup.get("megafon.api.url");
        if (Utils.isBlankString((String)url)) {
            throw new RuntimeException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0430\u0434\u0440\u0435\u0441\u0430 \u0434\u043b\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432");
        }
        return URI.create(url + path);
    }

    private String requestParametersToString(JSONObject parameters) {
        String params = "";
        if (parameters != null && !parameters.isEmpty()) {
            StringBuilder sb = new StringBuilder("?");
            for (String key : parameters.keySet()) {
                String value = parameters.optString(key);
                if (!Utils.notBlankString((String)value)) continue;
                sb.append(key).append("=").append(value).append("&");
            }
            params = sb.toString();
            if (params.length() > 1) {
                params = params.substring(0, params.length() - 1);
            }
        }
        return params;
    }

    private static final class MegafonSSLContext
    extends BGLogger {
        private static SSLContext sslContext;

        private MegafonSSLContext() {
        }

        private static SSLContext getSSLContext(ModuleSetup moduleSetup) {
            if (sslContext != null) {
                return sslContext;
            }
            String certPath = moduleSetup.get("megafon.kassa.cert.path", "");
            String certPassword = moduleSetup.get("megafon.kassa.cert.password", "");
            if (Utils.isBlankString((String)certPath)) {
                throw new RuntimeException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0443\u0442\u044c \u043a \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0443!");
            }
            if (Utils.isBlankString((String)certPassword)) {
                throw new RuntimeException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u043e\u043b\u044c \u043a \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0443!");
            }
            try {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                try (InputStream is = Files.newInputStream(Path.of(certPath, new String[0]), new OpenOption[0]);){
                    keyStore.load(is, certPassword.toCharArray());
                }
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, certPassword.toCharArray());
                TrustManager[] trustAllCertificates = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(keyManagerFactory.getKeyManagers(), trustAllCertificates, new SecureRandom());
                return sslContext;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

