/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.config.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.kernel.contract.config.common.bean.ContractModuleConfig;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstarctDaoConstant;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public abstract class AbstractContractConfig
extends AbstarctDaoConstant {
    protected static final String TABLE_CONTRACT_MODULE_CONFIG = "contract_module_config";
    protected static final String TABLE_CONTRACT_PLUGIN_CONFIG = "contract_plugin_config";
    private String table = null;
    private Connection con = null;
    private int configId = 0;

    protected AbstractContractConfig(String table, Connection con, int configId) {
        this.table = table;
        this.con = con;
        this.configId = configId;
        this.fields = new HashMap();
        this.fields.put("key", "key");
        this.fields.put("value", "value");
    }

    public String get(int contractId, String key) throws SQLException {
        return this.get(contractId, key, null);
    }

    public String get(int contractId, String key, String defaultValue) throws SQLException {
        return this.get(contractId, this.configId, key, defaultValue);
    }

    private String get(int contractId, int configId, String key, String defaultValue) throws SQLException {
        String value = defaultValue;
        if (contractId > 0 && key != null) {
            String query = "SELECT " + "value" + " FROM " + this.table + " WHERE " + "contract_id=? AND " + (this.table.equals(TABLE_CONTRACT_MODULE_CONFIG) ? "module" : "plugin") + "_id=? AND `key`=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                ps.setInt(index++, contractId);
                ps.setInt(index++, configId);
                ps.setString(index++, key);
                try (ResultSet resultSet = ps.executeQuery();){
                    while (resultSet.next()) {
                        value = resultSet.getString(1);
                    }
                }
            }
        }
        return value;
    }

    public void update(int contractId, String key, String value) throws SQLException {
        this.update(contractId, this.configId, key, value);
    }

    private void update(int contractId, int configId, String key, String value) throws SQLException {
        if (contractId > 0 && key != null && value != null) {
            String query = "INSERT INTO " + this.table + "(`contract_id`, `" + (this.table.equals(TABLE_CONTRACT_MODULE_CONFIG) ? "module" : "plugin") + "_id`, `key`, `value` )" + " VALUES " + "( ?, ?, ?, ? )" + " ON DUPLICATE KEY UPDATE " + "`value`=?";
            try (PreparedStatement psUpdate = this.con.prepareStatement(query);){
                int index = 1;
                psUpdate.setInt(index++, contractId);
                psUpdate.setInt(index++, configId);
                psUpdate.setString(index++, key);
                psUpdate.setString(index++, value);
                psUpdate.setString(index++, value);
                psUpdate.executeUpdate();
            }
        }
    }

    public void delete(int contractId, String key) throws SQLException {
        this.delete(contractId, this.configId, key);
    }

    private void delete(int contractId, int configId, String key) throws SQLException {
        if (contractId > 0 && key != null) {
            String query = "DELETE FROM " + this.table + " WHERE " + "contract_id=? AND " + (this.table.equals(TABLE_CONTRACT_MODULE_CONFIG) ? "`module" : "`plugin") + "_id`=? AND `key`=?";
            try (PreparedStatement psDelete = this.con.prepareStatement(query);){
                int index = 1;
                psDelete.setInt(index++, contractId);
                psDelete.setInt(index++, configId);
                psDelete.setString(index++, key);
                psDelete.executeUpdate();
            }
        }
    }

    public void deleteForContract(int contractId) throws SQLException {
        String query = "DELETE FROM " + this.table + " WHERE contract_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
        }
    }

    public void searchContractModuleConfig(SearchResult<ContractModuleConfig> searchResult, String contractTitle, List<String> keys) throws Exception {
        Page page = searchResult.getPage();
        String[] sort = searchResult.getSort();
        List<ContractModuleConfig> list = searchResult.getList();
        StringBuilder keysWhere = new StringBuilder();
        if (keys != null && !keys.isEmpty()) {
            keysWhere.append(" AND `key` IN ( ").append(keys.stream().map(a -> "?").collect(Collectors.joining(","))).append(" )");
        }
        StringBuilder contractTitleWhere = new StringBuilder();
        if (Utils.notBlankString(contractTitle)) {
            contractTitleWhere.append(" AND c.title LIKE ?");
        }
        String query = "SELECT " + "SQL_CALC_FOUND_ROWS " + " `contract_id`, `key`, `value`, c.title AS contractTitle" + " FROM " + this.table + " AS v" + " LEFT JOIN contract AS c ON c.id=v.contract_id" + " WHERE " + (this.table.equals(TABLE_CONTRACT_MODULE_CONFIG) ? "module" : "plugin") + "_id=?" + keysWhere.toString() + contractTitleWhere.toString() + this.getSQLOrder(sort, this.fields) + Page.toSqlLimit(page);
        try (PreparedStatement psDataSelect = this.con.prepareStatement(query);){
            int index = 1;
            psDataSelect.setInt(index++, this.configId);
            if (keys != null && !keys.isEmpty()) {
                for (String key : keys) {
                    psDataSelect.setString(index++, key);
                }
            }
            if (Utils.notBlankString(contractTitle)) {
                psDataSelect.setString(index++, "%" + contractTitle + "%");
            }
            try (ResultSet resultSet = psDataSelect.executeQuery();){
                while (resultSet.next()) {
                    ContractModuleConfig contractModuleConfig = new ContractModuleConfig().setContractId(resultSet.getInt("contract_id")).setContractTitle(resultSet.getString("contractTitle")).setKey(resultSet.getString("key")).setValue(resultSet.getString("value"));
                    list.add(contractModuleConfig);
                }
            }
            Page.setRecordCount(page, ServerUtils.foundRows((Connection)this.con));
        }
    }

    public List<String> getKeyList() throws SQLException {
        ArrayList<String> keyList = new ArrayList<String>();
        String query = "SELECT " + "DISTINCT " + "`key`" + " FROM " + this.table + " WHERE " + (this.table.equals(TABLE_CONTRACT_MODULE_CONFIG) ? "module" : "plugin") + "_id=?" + " ORDER BY " + "`key`";
        try (PreparedStatement psKeySelect = this.con.prepareStatement(query);){
            int index = 1;
            psKeySelect.setInt(index++, this.configId);
            try (ResultSet rs = psKeySelect.executeQuery();){
                while (rs.next()) {
                    keyList.add(rs.getString(1));
                }
            }
        }
        return keyList;
    }
}

