/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.groupaction.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.admin.groupaction.client.ContractGroupOperation;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.common.Utils;

public class AddContractLabelItem
extends ContractGroupOperation.ContractGroupOperationItem {
    private ContractLabelTree contractLabelTree;
    private final JRadioButton addLabelsOnContract = new JRadioButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c", true);
    private final JRadioButton removeLabelsFromContract = new JRadioButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c", false);

    public AddContractLabelItem() {
        super(new GridBagLayout());
    }

    @Override
    protected void jbInit() throws Exception {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.addLabelsOnContract, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        buttonPanel.add((Component)this.removeLabelsFromContract, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.addLabelsOnContract.addActionListener(e -> {
            this.addLabelsOnContract.setSelected(this.addLabelsOnContract.isSelected());
            this.removeLabelsFromContract.setSelected(!this.addLabelsOnContract.isSelected());
        });
        this.removeLabelsFromContract.addActionListener(e -> {
            this.removeLabelsFromContract.setSelected(this.removeLabelsFromContract.isSelected());
            this.addLabelsOnContract.setSelected(!this.removeLabelsFromContract.isSelected());
        });
        this.contractLabelTree = new ContractLabelTree(true, false, false);
        this.add((Component)buttonPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JScrollPane(this.contractLabelTree), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        SwingUtilities.invokeLater(() -> this.tryCall(() -> this.contractLabelTree.loadLabels(((ClientContext)this.getContext()).getWebService(ContractLabelService.class, 0))));
    }

    @Override
    protected boolean doItemOperation(String cids) {
        try {
            ContractLabelService contractLabelService = ((ClientContext)this.getContext()).getPort(ContractLabelService.class, 0);
            ArrayList<Integer> selectedLabels = new ArrayList<Integer>(this.contractLabelTree.getSelectedItems(true));
            if (Utils.notEmptyCollection(selectedLabels)) {
                for (Integer cid : Utils.toIntegerList(cids)) {
                    HashSet<Integer> labelsOfContract = new HashSet<Integer>(contractLabelService.getContractLabelIds(cid));
                    if (this.addLabelsOnContract.isSelected()) {
                        labelsOfContract.addAll(selectedLabels);
                    } else if (this.removeLabelsFromContract.isSelected()) {
                        selectedLabels.forEach(labelsOfContract::remove);
                    }
                    contractLabelService.setContractLabelIds(cid, new ArrayList<Integer>(labelsOfContract));
                }
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
            return false;
        }
        return true;
    }

    @Override
    protected String getOperationTitle() {
        return "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435/\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043c\u0435\u0442\u043e\u043a \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440";
    }
}

