/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.xml.JAXBUtils;
import ru.bitel.oss.systems.inventory.service.common.bean.Service;

public class Product
extends Id
implements Cloneable {
    private static final long serialVersionUID = 1L;
    public static final short STATE_NULL = -1000;
    public static final short STATE_REMOVED = -1;
    public static final short STATE_DISABLED = 0;
    public static final short STATE_ENABLED = 1;
    private int contractId;
    private int accountId;
    private int productSpecId;
    private String productSpecTitle;
    private Date timeFrom;
    private Date timeTo;
    private int userId;
    private int activationModeId;
    private BigDecimal activationPrice;
    private Date activationTime;
    private Date deactivationTime;
    private volatile String deviceProductId;
    private volatile short deviceState;
    private List<Service> serviceList;
    private String comment;
    private String description;
    private Date subscriptionTimeFrom;
    private Date subscriptionTimeTo;

    public Product clone() {
        try {
            Product result = (Product)super.clone();
            if (result.serviceList != null) {
                int size = result.serviceList.size();
                for (int i = 0; i < size; ++i) {
                    result.serviceList.set(i, result.serviceList.get(i).clone());
                }
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @XmlAttribute
    public int getAccountId() {
        return this.accountId;
    }

    @XmlAttribute
    public int getActivationModeId() {
        return this.activationModeId;
    }

    @XmlAttribute
    public BigDecimal getActivationPrice() {
        return this.activationPrice;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getActivationTime() {
        return this.activationTime;
    }

    public String getComment() {
        return this.comment;
    }

    @XmlAttribute
    public int getContractId() {
        return this.contractId;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getDeactivationTime() {
        return this.deactivationTime;
    }

    @XmlAttribute
    public String getDescription() {
        return this.description;
    }

    @XmlAttribute(name="devProductId")
    public String getDeviceProductId() {
        return this.deviceProductId;
    }

    @XmlAttribute(name="devState")
    public short getDeviceState() {
        return this.deviceState;
    }

    @XmlAttribute
    public int getProductSpecId() {
        return this.productSpecId;
    }

    @XmlAttribute
    public String getProductSpecTitle() {
        return this.productSpecTitle;
    }

    @XmlElementWrapper(name="serviceList")
    @XmlElements(value={@XmlElement(name="service")})
    public List<Service> getServiceList() {
        return this.serviceList;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getSubscriptionTimeFrom() {
        return this.subscriptionTimeFrom;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getSubscriptionTimeTo() {
        return this.subscriptionTimeTo;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getTimeFrom() {
        return this.timeFrom;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getTimeTo() {
        return this.timeTo;
    }

    @XmlAttribute
    public int getUserId() {
        return this.userId;
    }

    public Product setAccountId(int accountId) {
        this.accountId = accountId;
        return this;
    }

    public Product setActivationModeId(int activationMode) {
        this.activationModeId = activationMode;
        return this;
    }

    public Product setActivationPrice(BigDecimal activationCost) {
        this.activationPrice = activationCost;
        return this;
    }

    public Product setActivationTime(Date activationTime) {
        this.activationTime = activationTime;
        return this;
    }

    public Product setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Product setContractId(int contractId) {
        this.contractId = contractId;
        return this;
    }

    public Product setDeactivationTime(Date deactivationTime) {
        this.deactivationTime = deactivationTime;
        return this;
    }

    public Product setDescription(String description) {
        this.description = description;
        return this;
    }

    public Product setDeviceProductId(String deviceProductId) {
        this.deviceProductId = deviceProductId;
        return this;
    }

    public Product setDeviceState(short deviceState) {
        this.deviceState = deviceState;
        return this;
    }

    @Override
    public Product setId(int id) {
        super.setId(id);
        return this;
    }

    public Product setProductSpecId(int specId) {
        this.productSpecId = specId;
        return this;
    }

    public Product setProductSpecTitle(String specTitle) {
        this.productSpecTitle = specTitle;
        return this;
    }

    public Product setServiceList(List<Service> serviceList) {
        this.serviceList = serviceList;
        return this;
    }

    public Product setSubscriptionTimeFrom(Date subscriptionTimeFrom) {
        this.subscriptionTimeFrom = subscriptionTimeFrom;
        return this;
    }

    public Product setSubscriptionTimeTo(Date subscriptionTimeTo) {
        this.subscriptionTimeTo = subscriptionTimeTo;
        return this;
    }

    public Product setTimeFrom(Date timeFrom) {
        this.timeFrom = timeFrom;
        return this;
    }

    public Product setTimeTo(Date timeTo) {
        this.timeTo = timeTo;
        return this;
    }

    public Product setUserId(int userId) {
        this.userId = userId;
        return this;
    }

    @Override
    public String toString() {
        return "Product [cid-aid=" + this.contractId + "-" + this.accountId + ", productSpecId=" + this.productSpecId + ", period=" + TimeUtils.format(this.timeFrom, "dd.MM.yyyy HH:mm:ss") + "-" + TimeUtils.format(this.timeTo, "dd.MM.yyyy HH:mm:ss") + "/" + TimeUtils.format(this.subscriptionTimeTo, "dd.MM.yyyy HH:mm:ss") + ", activationModeId=" + this.activationModeId + ", activationTime=" + String.valueOf(this.activationTime) + ", deactivationTime=" + String.valueOf(this.deactivationTime) + ", deviceState=" + this.deviceState + ", serviceList=" + String.valueOf(this.serviceList) + "]";
    }
}

