/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.util.Ranger;

public final class RangeListMap<K, V, C extends Comparable<C>> {
    private final Map<K, List<V>> map;
    private final Ranger<V, C> ranger;

    public RangeListMap(Ranger<V, C> ranger) {
        this.map = new HashMap<K, List<V>>();
        this.ranger = ranger;
    }

    public RangeListMap(Ranger<V, C> ranger, int initialCapacity) {
        this.map = new HashMap<K, List<V>>(initialCapacity);
        this.ranger = ranger;
    }

    public void add(K key, V value) {
        List<V> list = this.map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            this.map.put(key, list);
        }
        list.add(value);
    }

    public List<V> remove(K key) {
        return this.map.remove(key);
    }

    public boolean remove(K key, V value) {
        List<V> list = this.map.get(key);
        if (list != null) {
            if (list.remove(value)) {
                if (list.size() == 0) {
                    this.map.remove(key);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public List<V> get(K key) {
        return this.map.get(key);
    }

    public V get(K key, C c) {
        return this.getFirst(key, c);
    }

    public V getFirst(K key, C c) {
        List<V> list = this.map.get(key);
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                V value = list.get(i);
                if (!RangeUtils.inRange(c, c, (Comparable)this.ranger.getMinValue(value), (Comparable)this.ranger.getMaxValue(value))) continue;
                return value;
            }
        }
        return null;
    }

    public V getLast(K key, C c) {
        List<V> list = this.map.get(key);
        if (list != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                V value = list.get(i);
                if (!RangeUtils.inRange(c, c, (Comparable)this.ranger.getMinValue(value), (Comparable)this.ranger.getMaxValue(value))) continue;
                return value;
            }
        }
        return null;
    }

    public V getFirstIntersects(K key, C c1, C c2) {
        List<V> list = this.map.get(key);
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                V value = list.get(i);
                if (!RangeUtils.intersects(c1, c2, (Comparable)this.ranger.getMinValue(value), (Comparable)this.ranger.getMaxValue(value))) continue;
                return value;
            }
        }
        return null;
    }

    public V getLastIntersects(K key, C c1, C c2) {
        List<V> list = this.map.get(key);
        if (list != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                V value = list.get(i);
                if (!RangeUtils.intersects(c1, c2, (Comparable)this.ranger.getMinValue(value), (Comparable)this.ranger.getMaxValue(value))) continue;
                return value;
            }
        }
        return null;
    }

    public V getFirstContains(K key, C c1, C c2) {
        List<V> list = this.map.get(key);
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                V value = list.get(i);
                if (!RangeUtils.inRange(c1, c2, (Comparable)this.ranger.getMinValue(value), (Comparable)this.ranger.getMaxValue(value))) continue;
                return value;
            }
        }
        return null;
    }

    public V getLastContains(K key, C c1, C c2) {
        List<V> list = this.map.get(key);
        if (list != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                V value = list.get(i);
                if (!RangeUtils.inRange(c1, c2, (Comparable)this.ranger.getMinValue(value), (Comparable)this.ranger.getMaxValue(value))) continue;
                return value;
            }
        }
        return null;
    }

    public void clear() {
        this.map.clear();
    }
}

