/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.apps.client;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.time.Duration;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.kernel.admin.apps.common.bean.AppInfo;
import ru.bitel.bgbilling.kernel.admin.common.service.AdminService;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.list.BGUList;

public class AppsMonitor
extends BGUTabPanel {
    public static final String TAB_ID = "appsMonitor";
    private BGDataSourceTableModel dataTableModel = new BGDataSourceTableModel("AppParameters");
    private BGUList<AppInfo.AppInfoItem> appsList = new BGUList();

    public AppsMonitor() {
        this(new ClientContext("kernel.admin.apps", 0, 0, ""));
    }

    public AppsMonitor(ClientContext clientContext) {
        super(clientContext, TAB_ID, "\u041c\u043e\u043d\u0438\u0442\u043e\u0440 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0439");
    }

    @Override
    protected void jbInit() {
        BGSplitPaneNoBorder splitPaneNoBorder = new BGSplitPaneNoBorder(1, this.getAppsListPanel(), (Component)this.getDataPanel(), 300L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPaneNoBorder, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addAncestorListener(new AncestorListener(){
            Timer timer = null;

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                this.timer = new Timer();
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        AppsMonitor.this.performAction("refresh");
                    }
                }, 0L, 30000L);
            }
        });
    }

    private JPanel getAppsListPanel() {
        this.appsList.setCellRenderer(new AppListCellRenderer());
        this.appsList.setSelectionMode(0);
        this.appsList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                this.tryCall(() -> {
                    AppInfo.AppInfoItem appInfoItem = (AppInfo.AppInfoItem)this.appsList.getSelectedValue();
                    if (appInfoItem == null) {
                        this.dataTableModel.deleteRows();
                    } else {
                        BGUTableParams tableParams = new BGUTableParams().addParam("appId", String.valueOf(appInfoItem.getAppId()));
                        this.dataTableModel.loadData(this.getKernelContext(), tableParams);
                    }
                });
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane(this.appsList), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getDataPanel() {
        BGUTable table = new BGUTable(this.dataTableModel);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0414\u0430\u043d\u043d\u044b\u0435:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane(table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 5, 5, 5), 0, 0));
        return panel;
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            List<AppInfo.AppInfoItem> appInfoItems = ((ClientContext)this.getContext()).getWebService(AdminService.class, 0).appInfoItemList();
            AppInfo.AppInfoItem appInfoItem = (AppInfo.AppInfoItem)this.appsList.getSelectedValue();
            this.appsList.setData(appInfoItems);
            if (appInfoItem != null) {
                for (int index = 0; index < appInfoItems.size(); ++index) {
                    if (appInfoItems.get(index).getAppId() != appInfoItem.getAppId()) continue;
                    this.appsList.setSelectedIndex(index);
                    break;
                }
            }
        });
    }

    public static class AppListCellRenderer
    implements ListCellRenderer<AppInfo.AppInfoItem> {
        @Override
        public Component getListCellRendererComponent(JList<? extends AppInfo.AppInfoItem> list, AppInfo.AppInfoItem value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel nameLabel = new JLabel(value.getAppName());
            nameLabel.setFont(new Font("SansSerif", 2, 20));
            JLabel idLabel = new JLabel("appId: " + String.valueOf(value.getAppId()));
            idLabel.setFont(new Font("SansSerif", 0, 12));
            Duration duration = Duration.ofMillis(value.getUptime());
            long days = duration.toDays();
            long hours = duration.minusDays(days).toHours();
            long minutes = duration.minusDays(days).minusHours(hours).toMinutes();
            JLabel uptimeLabel = new JLabel("Uptime: " + days + " \u0434\u043d. " + hours + " \u0447. " + minutes + " \u043c\u0438\u043d.");
            uptimeLabel.setFont(new Font("SansSerif", 0, 10));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            panel.add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 15, 0, 15), 0, 0));
            panel.add((Component)idLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 15, 0, 5), 0, 0));
            panel.add((Component)uptimeLabel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 13, 0, new Insets(2, 15, 3, 5), 0, 0));
            return panel;
        }
    }
}

